/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Version;

public class PluginImportLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    public Image getImage(Object element) {
        return PDEPlugin.getDefault().getLabelProvider().getImage(element);
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public void update(ViewerCell cell) {
        StyledString string = this.getStyledText(cell.getElement());
        cell.setText(string.getString());
        cell.setStyleRanges(string.getStyleRanges());
        cell.setImage(this.getImage(cell.getElement()));
        super.update(cell);
    }

    private StyledString getStyledText(Object element) {
        StyledString styledString = new StyledString();
        if (element instanceof IPluginModelBase) {
            IPluginModelBase plugin = (IPluginModelBase)element;
            String symbolicName = plugin.getBundleDescription().getSymbolicName();
            Version version = plugin.getBundleDescription().getVersion();
            styledString.append(symbolicName);
            styledString.append(' ');
            styledString.append('(', StyledString.QUALIFIER_STYLER);
            styledString.append(version.toString(), StyledString.QUALIFIER_STYLER);
            styledString.append(')', StyledString.QUALIFIER_STYLER);
            return styledString;
        }
        styledString.append(element.toString());
        return styledString;
    }
}

