/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.importexport.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.importexport.IUDetail;
import org.eclipse.equinox.internal.p2.importexport.P2ImportExport;
import org.eclipse.equinox.internal.p2.importexport.internal.Messages;
import org.eclipse.equinox.internal.p2.importexport.persistence.P2FParser;
import org.eclipse.equinox.internal.p2.importexport.persistence.P2FWriter;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportExportImpl
implements P2ImportExport {
    private static final String SCHEME_FILE = "file";
    public static final int IGNORE_LOCAL_REPOSITORY = 1;
    public static final int CANNOT_FIND_REPOSITORY = 2;
    private IProvisioningAgent agent = null;

    public void bind(IProvisioningAgent agt) {
        this.agent = agt;
    }

    public void unbind(IProvisioningAgent agt) {
        if (this.agent == agt) {
            this.agent = null;
        }
    }

    @Override
    public List<IUDetail> importP2F(InputStream input) throws IOException {
        P2FParser parser = new P2FParser(Platform.getBundle((String)"org.eclipse.equinox.p2.ui.importexport").getBundleContext(), "org.eclipse.equinox.p2.ui.importexport");
        parser.parse(input);
        return parser.getIUs();
    }

    @Override
    public IStatus exportP2F(OutputStream output, IInstallableUnit[] ius, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Replicator_ExportJobName, (int)1000);
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        URI[] uris = repoManager.getKnownRepositories(0);
        Arrays.sort(uris, new Comparator<URI>(){

            @Override
            public int compare(URI o1, URI o2) {
                String scheme2;
                String scheme1 = o1.getScheme();
                if (scheme1.equals(scheme2 = o2.getScheme())) {
                    return 0;
                }
                if (ImportExportImpl.SCHEME_FILE.equals(scheme1)) {
                    return 1;
                }
                if (ImportExportImpl.SCHEME_FILE.equals(scheme2)) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<IMetadataRepository> repos = new ArrayList<IMetadataRepository>(uris.length);
        URI[] uRIArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            try {
                IMetadataRepository repo = repoManager.loadRepository(uri, (IProgressMonitor)subMonitor.newChild(500 / uris.length, 7));
                repos.add(repo);
            }
            catch (ProvisionException provisionException) {}
            ++n2;
        }
        subMonitor.setWorkRemaining(500);
        ArrayList<IUDetail> features = new ArrayList<IUDetail>(ius.length);
        SubMonitor sub2 = subMonitor.newChild(450, 7);
        sub2.setWorkRemaining(ius.length * 100);
        MultiStatus queryRepoResult = new MultiStatus("org.eclipse.equinox.p2.ui.importexport", 0, null, null);
        IInstallableUnit[] iInstallableUnitArray = ius;
        int n3 = ius.length;
        int repo = 0;
        while (repo < n3) {
            IInstallableUnit iu = iInstallableUnitArray[repo];
            ArrayList<URI> referredRepos = new ArrayList<URI>(1);
            if (sub2.isCanceled()) {
                throw new OperationCanceledException();
            }
            SubMonitor sub3 = sub2.newChild(100);
            sub3.setWorkRemaining(repos.size() * 100);
            for (IMetadataRepository repo2 : repos) {
                if (SCHEME_FILE.equals(repo2.getLocation().getScheme()) && referredRepos.size() > 0) break;
                IQueryResult result = repo2.query(QueryUtil.createIUQuery((String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, null, true)), (IProgressMonitor)sub3.newChild(100));
                if (result.isEmpty()) continue;
                referredRepos.add(repo2.getLocation());
            }
            sub3.setWorkRemaining(1).worked(1);
            if (referredRepos.size() == 0) {
                queryRepoResult.add((IStatus)new Status(2, "org.eclipse.equinox.p2.ui.importexport", 2, NLS.bind((String)Messages.Replicator_NotFoundInRepository, (Object)iu.getProperty("org.eclipse.equinox.p2.name", Locale.getDefault().toString())), null));
            } else if (SCHEME_FILE.equals(((URI)referredRepos.get(0)).getScheme())) {
                queryRepoResult.add((IStatus)new Status(1, "org.eclipse.equinox.p2.ui.importexport", 1, NLS.bind((String)Messages.Replicator_InstallFromLocal, (Object)iu.getProperty("org.eclipse.equinox.p2.name", Locale.getDefault().toString())), null));
            } else {
                IUDetail feature = new IUDetail(iu, referredRepos);
                features.add(feature);
            }
            ++repo;
        }
        subMonitor.setWorkRemaining(50);
        IStatus status = this.exportP2F(output, features, (IProgressMonitor)subMonitor);
        if (status.isOK() && queryRepoResult.isOK()) {
            return status;
        }
        MultiStatus rt = new MultiStatus("org.eclipse.equinox.p2.ui.importexport", 0, new IStatus[]{queryRepoResult, status}, null, null);
        return rt;
    }

    @Override
    public IStatus exportP2F(OutputStream output, List<IUDetail> features, IProgressMonitor monitor) {
        SubMonitor sub;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.Replicator_SaveJobName, (int)100)).isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            P2FWriter writer = new P2FWriter(output, null);
            writer.write(features);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (UnsupportedEncodingException e) {
            Status status = new Status(4, "org.eclipse.equinox.p2.ui.importexport", e.getMessage(), (Throwable)e);
            return status;
        }
        finally {
            sub.worked(100);
        }
    }
}

