/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.javadocexport.ContributedJavadocWizardPage;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocSpecificsWizardPage;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocStandardWizardPage;
import org.eclipse.jdt.internal.ui.javadocexport.JavadocTreeWizardPage;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocWizard
extends Wizard
implements IExportWizard {
    private JavadocTreeWizardPage fTreeWizardPage;
    private JavadocSpecificsWizardPage fLastWizardPage;
    private JavadocStandardWizardPage fStandardDocletWizardPage;
    private ContributedJavadocWizardPage[] fContributedJavadocWizardPages;
    private IPath fDestination;
    private boolean fOpenInBrowser;
    private final String TREE_PAGE_DESC = "JavadocTreePage";
    private final String SPECIFICS_PAGE_DESC = "JavadocSpecificsPage";
    private final String STANDARD_PAGE_DESC = "JavadocStandardPage";
    private final int YES = 0;
    private final int YES_TO_ALL = 1;
    private final int NO = 2;
    private final int NO_TO_ALL = 3;
    private final String JAVADOC_ANT_INFORMATION_DIALOG = "javadocAntInformationDialog";
    private JavadocOptionsManager fStore;
    private IWorkspaceRoot fRoot;
    private IFile fXmlJavadocFile;
    private static final String ID_JAVADOC_PROCESS_TYPE = "org.eclipse.jdt.ui.javadocProcess";
    private static final String ENCODING_ARGUMENT_PREFIX = "-J-Dfile.encoding=";

    public static void openJavadocWizard(JavadocWizard wizard, Shell shell, IStructuredSelection selection) {
        wizard.init(PlatformUI.getWorkbench(), selection);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard){

            protected IDialogSettings getDialogBoundsSettings() {
                return JavaPlugin.getDefault().getDialogSettingsSection("JavadocWizardDialog");
            }
        };
        PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(100), converter.convertHeightInCharsToPixels(20));
        dialog.open();
    }

    public JavadocWizard() {
        this(null);
    }

    public JavadocWizard(IFile xmlJavadocFile) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_EXPORT_JAVADOC);
        this.setWindowTitle(JavadocExportMessages.JavadocWizard_javadocwizard_title);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.fRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fXmlJavadocFile = xmlJavadocFile;
    }

    public boolean performFinish() {
        int i;
        this.updateStore();
        IJavaProject[] checkedProjects = this.fTreeWizardPage.getCheckedProjects();
        this.fStore.updateDialogSettings(this.getDialogSettings(), checkedProjects);
        if (!new RefactoringSaveHelper(1).saveEditors(this.getShell())) {
            return false;
        }
        this.fDestination = Path.fromOSString((String)this.fStore.getDestination());
        this.fDestination.toFile().mkdirs();
        this.fOpenInBrowser = this.fStore.doOpenInBrowser();
        if (this.fStore.isFromStandard()) {
            try {
                URL newURL = this.fDestination.toFile().toURI().toURL();
                String newExternalForm = newURL.toExternalForm();
                ArrayList<IJavaProject> projs = new ArrayList<IJavaProject>();
                i = 0;
                while (i < checkedProjects.length) {
                    IJavaProject curr = checkedProjects[i];
                    URL currURL = JavaUI.getProjectJavadocLocation(curr);
                    if (currURL == null || !newExternalForm.equals(currURL.toExternalForm())) {
                        projs.add(curr);
                    }
                    ++i;
                }
                if (!projs.isEmpty()) {
                    this.setAllJavadocLocations(projs.toArray(new IJavaProject[projs.size()]), newURL);
                }
            }
            catch (MalformedURLException e) {
                JavaPlugin.log(e);
            }
        }
        if (this.fLastWizardPage.generateAnt()) {
            OptionalMessageDialog.open("javadocAntInformationDialog", this.getShell(), JavadocExportMessages.JavadocWizard_antInformationDialog_title, null, JavadocExportMessages.JavadocWizard_antInformationDialog_message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            try {
                Element javadocXMLElement = this.fStore.createXML(checkedProjects);
                if (javadocXMLElement != null) {
                    File file;
                    IFile[] files;
                    if (!this.fTreeWizardPage.getCustom()) {
                        int i2 = 0;
                        while (i2 < this.fContributedJavadocWizardPages.length) {
                            this.fContributedJavadocWizardPages[i2].updateAntScript(javadocXMLElement);
                            ++i2;
                        }
                    }
                    if ((files = this.fRoot.findFilesForLocationURI((file = this.fStore.writeXML(javadocXMLElement)).toURI())) != null) {
                        i = 0;
                        while (i < files.length) {
                            files[i].refreshLocal(1, null);
                            ++i;
                        }
                    }
                }
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, this.getShell(), JavadocExportMessages.JavadocWizard_error_writeANT_title, JavadocExportMessages.JavadocWizard_error_writeANT_message);
            }
        }
        return this.executeJavadocGeneration();
    }

    private void updateStore() {
        this.fTreeWizardPage.updateStore();
        if (!this.fTreeWizardPage.getCustom()) {
            this.fStandardDocletWizardPage.updateStore();
        }
        this.fLastWizardPage.updateStore();
    }

    public boolean performCancel() {
        this.updateStore();
        if (this.fXmlJavadocFile == null) {
            IJavaProject[] checkedProjects = this.fTreeWizardPage.getCheckedProjects();
            this.fStore.updateDialogSettings(this.getDialogSettings(), checkedProjects);
        }
        return super.performCancel();
    }

    private void setAllJavadocLocations(IJavaProject[] projects, URL newURL) {
        Shell shell = this.getShell();
        String[] buttonlabels = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL};
        int j = 0;
        while (j < projects.length) {
            IJavaProject iJavaProject = projects[j];
            String message = Messages.format(JavadocExportMessages.JavadocWizard_updatejavadoclocation_message, new String[]{BasicElementLabels.getJavaElementName(iJavaProject.getElementName()), BasicElementLabels.getPathLabel(this.fDestination, true)});
            MessageDialog dialog = new MessageDialog(shell, JavadocExportMessages.JavadocWizard_updatejavadocdialog_label, null, message, 3, buttonlabels, 1);
            switch (dialog.open()) {
                case 0: {
                    JavaUI.setProjectJavadocLocation(iJavaProject, newURL);
                    break;
                }
                case 1: {
                    int i = j;
                    while (i < projects.length) {
                        iJavaProject = projects[i];
                        JavaUI.setProjectJavadocLocation(iJavaProject, newURL);
                        ++j;
                        ++i;
                    }
                    break;
                }
                case 3: {
                    j = projects.length;
                    break;
                }
            }
            ++j;
        }
    }

    private boolean executeJavadocGeneration() {
        block14: {
            Process process = null;
            try {
                ArrayList<String> vmArgs = new ArrayList<String>();
                ArrayList<String> progArgs = new ArrayList<String>();
                IStatus status = this.fStore.getArgumentArray(vmArgs, progArgs);
                if (!status.isOK()) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)JavadocExportMessages.JavadocWizard_error_title, (String)JavadocExportMessages.JavadocWizard_warning_starting_message, (IStatus)status);
                }
                if (!this.fTreeWizardPage.getCustom()) {
                    int i = 0;
                    while (i < this.fContributedJavadocWizardPages.length) {
                        this.fContributedJavadocWizardPages[i].updateArguments(vmArgs, progArgs);
                        ++i;
                    }
                }
                File file = File.createTempFile("javadoc-arguments", ".tmp");
                vmArgs.add(String.valueOf('@') + file.getAbsolutePath());
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), JavadocWizard.getEncoding(vmArgs)));
                try {
                    int i = 0;
                    while (i < progArgs.size()) {
                        String curr = progArgs.get(i);
                        curr = this.checkForSpaces(curr);
                        writer.write(curr);
                        writer.write(32);
                        ++i;
                    }
                }
                finally {
                    writer.close();
                }
                String[] args = vmArgs.toArray(new String[vmArgs.size()]);
                process = Runtime.getRuntime().exec(args);
                if (process == null) break block14;
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < args.length) {
                    buf.append(args[i]);
                    buf.append(' ');
                    ++i;
                }
                try {
                    ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                    ILaunchConfigurationType lcType = launchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
                    String name = JavadocExportMessages.JavadocWizard_launchconfig_name;
                    ILaunchConfigurationWorkingCopy wc = lcType.newInstance(null, name);
                    wc.setAttribute("org.eclipse.debug.ui.private", true);
                    Launch newLaunch = new Launch((ILaunchConfiguration)wc, "run", null);
                    IProcess iprocess = DebugPlugin.newProcess((ILaunch)newLaunch, (Process)process, (String)JavadocExportMessages.JavadocWizard_javadocprocess_label);
                    iprocess.setAttribute(IProcess.ATTR_CMDLINE, buf.toString());
                    iprocess.setAttribute(IProcess.ATTR_PROCESS_TYPE, ID_JAVADOC_PROCESS_TYPE);
                    launchManager.addLaunch((ILaunch)newLaunch);
                    JavadocLaunchListener listener = new JavadocLaunchListener(this.getShell().getDisplay(), (ILaunch)newLaunch, file);
                    launchManager.addLaunchListener((ILaunchesListener)listener);
                    if (newLaunch.isTerminated()) {
                        listener.onTerminated();
                    }
                }
                catch (CoreException e) {
                    String title = JavadocExportMessages.JavadocWizard_error_title;
                    String message = JavadocExportMessages.JavadocWizard_launch_error_message;
                    ExceptionHandler.handle(e, this.getShell(), title, message);
                }
                return true;
            }
            catch (IOException e) {
                String title = JavadocExportMessages.JavadocWizard_error_title;
                String message = JavadocExportMessages.JavadocWizard_exec_error_message;
                Status status = new Status(4, "org.eclipse.jdt.ui", 4, e.getMessage(), (Throwable)e);
                ExceptionHandler.handle(new CoreException((IStatus)status), this.getShell(), title, message);
                return false;
            }
        }
        return false;
    }

    private static String getEncoding(ArrayList<String> vmArgs) {
        for (String argument : vmArgs) {
            if (argument.length() <= ENCODING_ARGUMENT_PREFIX.length() || !argument.startsWith(ENCODING_ARGUMENT_PREFIX)) continue;
            String encoding = argument.substring(ENCODING_ARGUMENT_PREFIX.length());
            if (!Charset.isSupported(encoding)) break;
            return encoding;
        }
        return System.getProperty("file.encoding");
    }

    private String checkForSpaces(String curr) {
        if (curr.indexOf(32) == -1) {
            return curr;
        }
        StringBuffer buf = new StringBuffer();
        buf.append('\'');
        int i = 0;
        while (i < curr.length()) {
            char ch = curr.charAt(i);
            if (ch == '\\' || ch == '\'') {
                buf.append('\\');
            }
            buf.append(ch);
            ++i;
        }
        buf.append('\'');
        return buf.toString();
    }

    public void addPages() {
        this.fContributedJavadocWizardPages = ContributedJavadocWizardPage.getContributedPages(this.fStore);
        this.fTreeWizardPage = new JavadocTreeWizardPage("JavadocTreePage", this.fStore);
        this.fLastWizardPage = new JavadocSpecificsWizardPage("JavadocSpecificsPage", this.fTreeWizardPage, this.fStore);
        this.fStandardDocletWizardPage = new JavadocStandardWizardPage("JavadocStandardPage", this.fTreeWizardPage, this.fStore);
        super.addPage((IWizardPage)this.fTreeWizardPage);
        super.addPage((IWizardPage)this.fStandardDocletWizardPage);
        int i = 0;
        while (i < this.fContributedJavadocWizardPages.length) {
            super.addPage((IWizardPage)this.fContributedJavadocWizardPages[i]);
            ++i;
        }
        super.addPage((IWizardPage)this.fLastWizardPage);
        this.fTreeWizardPage.init();
        this.fStandardDocletWizardPage.init();
        this.fLastWizardPage.init();
    }

    public void init(IWorkbench workbench, IStructuredSelection structuredSelection) {
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        List<IJavaElement> selected = Collections.EMPTY_LIST;
        if (window != null) {
            ISelection selection = window.getSelectionService().getSelection();
            if (selection instanceof IStructuredSelection) {
                selected = ((IStructuredSelection)selection).toList();
            } else {
                IJavaElement element = EditorUtility.getActiveEditorJavaInput();
                if (element != null) {
                    selected = Arrays.asList(element);
                }
            }
        }
        this.fStore = new JavadocOptionsManager(this.fXmlJavadocFile, this.getDialogSettings(), selected);
    }

    private void refresh(IPath path) {
        IContainer[] containers = this.fRoot.findContainersForLocationURI(path.toFile().toURI());
        try {
            int i = 0;
            while (i < containers.length) {
                containers[i].refreshLocal(2, null);
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
    }

    private void spawnInBrowser(Display display) {
        if (this.fOpenInBrowser) {
            try {
                IPath indexFile = this.fDestination.append("index.html");
                URL url = indexFile.toFile().toURI().toURL();
                OpenBrowserUtil.open(url, display);
            }
            catch (MalformedURLException e) {
                JavaPlugin.log(e);
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fTreeWizardPage && this.fTreeWizardPage.getCustom()) {
            return this.fLastWizardPage;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.fLastWizardPage && this.fTreeWizardPage.getCustom()) {
            return this.fTreeWizardPage;
        }
        return super.getPreviousPage(page);
    }

    private class JavadocLaunchListener
    implements ILaunchesListener2 {
        private Display fDisplay;
        private volatile ILaunch fLaunch;
        private File fFile;

        public JavadocLaunchListener(Display display, ILaunch launch, File file) {
            this.fDisplay = display;
            this.fLaunch = launch;
            this.fFile = file;
        }

        public void launchesTerminated(ILaunch[] launches) {
            int i = 0;
            while (i < launches.length) {
                if (launches[i] == this.fLaunch) {
                    this.onTerminated();
                    return;
                }
                ++i;
            }
        }

        public void onTerminated() {
            try {
                if (this.fLaunch != null) {
                    this.fFile.delete();
                    JavadocWizard.this.spawnInBrowser(this.fDisplay);
                    JavadocWizard.this.refresh(JavadocWizard.this.fDestination);
                    this.fLaunch = null;
                }
            }
            finally {
                DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }
    }
}

