/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class TaskConfigurationChecker {
    private List errors = new ArrayList();
    private final Task task;

    public TaskConfigurationChecker(Task task) {
        this.task = task;
    }

    public void assertConfig(boolean condition, String errormessage) {
        if (!condition) {
            this.errors.add(errormessage);
        }
    }

    public void fail(String errormessage) {
        this.errors.add(errormessage);
    }

    public void checkErrors() throws BuildException {
        if (!this.errors.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Configurationerror on <");
            sb.append(this.task.getTaskName());
            sb.append(">:");
            sb.append(System.getProperty("line.separator"));
            Iterator it = this.errors.iterator();
            while (it.hasNext()) {
                String msg = (String)it.next();
                sb.append("- ");
                sb.append(msg);
                sb.append(System.getProperty("line.separator"));
            }
            throw new BuildException(sb.toString(), this.task.getLocation());
        }
    }
}

