/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.internal.menus.ControlContributionRegistry;
import org.eclipse.ui.internal.menus.DynamicMenuContributionItem;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.services.ServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuAdditionCacheEntry {
    private static final String MAIN_TOOLBAR = "org.eclipse.ui.main.toolbar";
    private static final String TRIM_COMMAND1 = "org.eclipse.ui.trim.command1";
    private static final String TRIM_COMMAND2 = "org.eclipse.ui.trim.command2";
    private static final String TRIM_VERTICAL1 = "org.eclipse.ui.trim.vertical1";
    private static final String TRIM_VERTICAL2 = "org.eclipse.ui.trim.vertical2";
    private static final String TRIM_STATUS = "org.eclipse.ui.trim.status";
    private MApplication application;
    private IConfigurationElement configElement;
    private MenuLocationURI location;

    public MenuAdditionCacheEntry(MApplication application, IEclipseContext appContext, IConfigurationElement configElement, String attribute, String namespaceIdentifier) {
        this.application = application;
        assert (appContext.equals(this.application.getContext()));
        this.configElement = configElement;
        this.location = new MenuLocationURI(attribute);
    }

    private boolean inToolbar() {
        return this.location.getScheme().startsWith("toolbar");
    }

    public void mergeIntoModel(ArrayList<MMenuContribution> menuContributions, ArrayList<MToolBarContribution> toolBarContributions, ArrayList<MTrimContribution> trimContributions) {
        IConfigurationElement[] menus;
        if ("menu:help?after=additions".equals(this.location.toString()) && (menus = this.configElement.getChildren("menu")).length == 1 && "org.eclipse.update.ui.updateMenu".equals(MenuHelper.getId(menus[0]))) {
            return;
        }
        if (this.inToolbar()) {
            String path = this.location.getPath();
            if (path.equals(MAIN_TOOLBAR) || path.equals(TRIM_COMMAND1) || path.equals(TRIM_COMMAND2) || path.equals(TRIM_VERTICAL1) || path.equals(TRIM_VERTICAL2) || path.equals(TRIM_STATUS)) {
                this.processTrimChildren(trimContributions, toolBarContributions, this.configElement);
            } else {
                String query = this.location.getQuery();
                if (query == null || query.length() == 0) {
                    query = "after=additions";
                }
                this.processToolbarChildren(toolBarContributions, this.configElement, path, query);
            }
            return;
        }
        MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        String idContrib = MenuHelper.getId(this.configElement);
        if (idContrib != null && idContrib.length() > 0) {
            menuContribution.setElementId(idContrib);
        }
        if ("org.eclipse.ui.popup.any".equals(this.location.getPath())) {
            menuContribution.setParentId("popup");
        } else {
            menuContribution.setParentId(this.location.getPath());
        }
        String query = this.location.getQuery();
        if (query == null || query.length() == 0) {
            query = "after=additions";
        }
        menuContribution.setPositionInParent(query);
        menuContribution.getTags().add("scheme:" + this.location.getScheme());
        String filter = "menuContribution:menu";
        if ("popup".equals(this.location.getScheme())) {
            filter = "menuContribution:popup";
        }
        menuContribution.getTags().add(filter);
        menuContribution.setVisibleWhen(MenuHelper.getVisibleWhen(this.configElement));
        this.addMenuChildren((MElementContainer<MMenuElement>)menuContribution, this.configElement, filter);
        menuContributions.add(menuContribution);
        this.processMenuChildren(menuContributions, this.configElement, filter);
    }

    private void processMenuChildren(ArrayList<MMenuContribution> menuContributions, IConfigurationElement element, String filter) {
        IConfigurationElement[] menus = element.getChildren("menu");
        if (menus.length == 0) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = menus;
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement menu = iConfigurationElementArray[n2];
            MMenuContribution menuContribution = MenuFactoryImpl.eINSTANCE.createMenuContribution();
            String idContrib = MenuHelper.getId(menu);
            if (idContrib != null && idContrib.length() > 0) {
                menuContribution.setElementId(idContrib);
            }
            menuContribution.setParentId(idContrib);
            menuContribution.setPositionInParent("after=additions");
            menuContribution.getTags().add("scheme:" + this.location.getScheme());
            menuContribution.getTags().add(filter);
            menuContribution.setVisibleWhen(MenuHelper.getVisibleWhen(menu));
            this.addMenuChildren((MElementContainer<MMenuElement>)menuContribution, menu, filter);
            menuContributions.add(menuContribution);
            this.processMenuChildren(menuContributions, menu, filter);
            ++n2;
        }
    }

    private void addMenuChildren(MElementContainer<MMenuElement> container, IConfigurationElement parent, String filter) {
        IConfigurationElement[] items = parent.getChildren();
        int i = 0;
        while (i < items.length) {
            MMenuElement element;
            final IConfigurationElement child = items[i];
            String itemType = child.getName();
            String id = MenuHelper.getId(child);
            if ("command".equals(itemType)) {
                element = this.createMenuCommandAddition(child);
                container.getChildren().add(element);
            } else if ("separator".equals(itemType)) {
                element = this.createMenuSeparatorAddition(child);
                container.getChildren().add(element);
            } else if ("menu".equals(itemType)) {
                element = this.createMenuAddition(child, filter);
                container.getChildren().add(element);
            } else if ("toolbar".equals(itemType)) {
                System.out.println("Toolbar: " + id + " in " + this.location);
            } else if ("dynamic".equals(itemType)) {
                ContextFunction generator = new ContextFunction(){

                    public Object compute(IEclipseContext context) {
                        ServiceLocator sl = new ServiceLocator();
                        sl.setContext(context);
                        DynamicMenuContributionItem item = new DynamicMenuContributionItem(MenuHelper.getId(child), sl, child);
                        return item;
                    }
                };
                MRenderedMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createRenderedMenuItem();
                menuItem.setElementId(id);
                menuItem.setContributionItem((Object)generator);
                container.getChildren().add(menuItem);
            }
            ++i;
        }
    }

    private MMenuElement createMenuCommandAddition(IConfigurationElement commandAddition) {
        MHandledMenuItem item = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        item.setElementId(MenuHelper.getId(commandAddition));
        String commandId = MenuHelper.getCommandId(commandAddition);
        MCommand commandById = ContributionsAnalyzer.getCommandById((MApplication)this.application, (String)commandId);
        if (commandById == null) {
            commandById = CommandsFactoryImpl.eINSTANCE.createCommand();
            commandById.setElementId(commandId);
            commandById.setCommandName(commandId);
            this.application.getCommands().add(commandById);
        }
        item.setCommand(commandById);
        Map<String, String> parms = MenuHelper.getParameters(commandAddition);
        Iterator<Map.Entry<String, String>> iterator = parms.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> obj;
            Map.Entry<String, String> e = obj = iterator.next();
            MParameter parm = CommandsFactoryImpl.eINSTANCE.createParameter();
            parm.setName(e.getKey().toString());
            parm.setValue(e.getValue().toString());
            item.getParameters().add(parm);
        }
        String iconUrl = MenuHelper.getIconUrl(commandAddition, "icon");
        if (iconUrl == null) {
            ImageDescriptor descriptor;
            ICommandImageService commandImageService = (ICommandImageService)this.application.getContext().get(ICommandImageService.class);
            ImageDescriptor imageDescriptor = descriptor = commandImageService == null ? null : commandImageService.getImageDescriptor(item.getElementId());
            if (descriptor != null) {
                item.setIconURI(MenuHelper.getImageUrl(descriptor));
            }
        } else {
            item.setIconURI(iconUrl);
        }
        item.setLabel(MenuHelper.getLabel(commandAddition));
        item.setMnemonics(MenuHelper.getMnemonic(commandAddition));
        item.setTooltip(MenuHelper.getTooltip(commandAddition));
        item.setType(MenuHelper.getStyle(commandAddition));
        item.setVisibleWhen(MenuHelper.getVisibleWhen(commandAddition));
        return item;
    }

    private MMenuElement createMenuSeparatorAddition(IConfigurationElement sepAddition) {
        String name = MenuHelper.getName(sepAddition);
        MMenuSeparator element = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        element.setElementId(name);
        if (!MenuHelper.isSeparatorVisible(sepAddition)) {
            element.setVisible(false);
        }
        return element;
    }

    private MMenu createMenuAddition(IConfigurationElement menuAddition, String filter) {
        if (this.inToolbar()) {
            return null;
        }
        MMenu menu = MenuHelper.createMenuAddition(menuAddition);
        menu.getTags().add(filter);
        return menu;
    }

    private void processTrimChildren(ArrayList<MTrimContribution> trimContributions, ArrayList<MToolBarContribution> toolBarContributions, IConfigurationElement element) {
        IConfigurationElement[] toolbars = element.getChildren("toolbar");
        if (toolbars.length == 0) {
            return;
        }
        MTrimContribution trimContribution = MenuFactoryImpl.eINSTANCE.createTrimContribution();
        String idContrib = MenuHelper.getId(this.configElement);
        if (idContrib != null && idContrib.length() > 0) {
            trimContribution.setElementId(idContrib);
        }
        trimContribution.setParentId(this.location.getPath());
        String query = this.location.getQuery();
        if (query == null || query.length() == 0) {
            query = "after=additions";
        }
        trimContribution.setPositionInParent(query);
        trimContribution.getTags().add("scheme:" + this.location.getScheme());
        IConfigurationElement[] iConfigurationElementArray = toolbars;
        int n = toolbars.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement toolbar = iConfigurationElementArray[n2];
            MToolBar item = MenuFactoryImpl.eINSTANCE.createToolBar();
            item.setElementId(MenuHelper.getId(toolbar));
            this.processToolbarChildren(toolBarContributions, toolbar, item.getElementId(), "after=additions");
            trimContribution.getChildren().add(item);
            ++n2;
        }
        trimContributions.add(trimContribution);
    }

    private void processToolbarChildren(ArrayList<MToolBarContribution> contributions, IConfigurationElement toolbar, String parentId, String position) {
        MToolBarContribution toolBarContribution = MenuFactoryImpl.eINSTANCE.createToolBarContribution();
        String idContrib = MenuHelper.getId(toolbar);
        if (idContrib != null && idContrib.length() > 0) {
            toolBarContribution.setElementId(idContrib);
        }
        toolBarContribution.setParentId(parentId);
        toolBarContribution.setPositionInParent(position);
        toolBarContribution.getTags().add("scheme:" + this.location.getScheme());
        IConfigurationElement[] items = toolbar.getChildren();
        int i = 0;
        while (i < items.length) {
            MToolBarElement element;
            String itemType = items[i].getName();
            if ("command".equals(itemType)) {
                element = this.createToolBarCommandAddition(items[i]);
                toolBarContribution.getChildren().add(element);
            } else if ("separator".equals(itemType)) {
                element = this.createToolBarSeparatorAddition(items[i]);
                toolBarContribution.getChildren().add(element);
            } else if ("control".equals(itemType)) {
                element = this.createToolControlAddition(items[i]);
                toolBarContribution.getChildren().add(element);
            }
            ++i;
        }
        contributions.add(toolBarContribution);
    }

    private MToolBarElement createToolControlAddition(IConfigurationElement element) {
        String id = MenuHelper.getId(element);
        MToolControl control = MenuFactoryImpl.eINSTANCE.createToolControl();
        control.setElementId(id);
        control.setContributionURI("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.menus.CompatibilityWorkbenchWindowControlContribution");
        ControlContributionRegistry.add(id, element);
        return control;
    }

    private MToolBarElement createToolBarSeparatorAddition(IConfigurationElement sepAddition) {
        String name = MenuHelper.getName(sepAddition);
        MToolBarSeparator element = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
        element.setElementId(name);
        if (!MenuHelper.isSeparatorVisible(sepAddition)) {
            element.setToBeRendered(false);
        }
        return element;
    }

    private MToolBarElement createToolBarCommandAddition(IConfigurationElement commandAddition) {
        MHandledToolItem item = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
        item.setElementId(MenuHelper.getId(commandAddition));
        String commandId = MenuHelper.getCommandId(commandAddition);
        MCommand commandById = ContributionsAnalyzer.getCommandById((MApplication)this.application, (String)commandId);
        if (commandById == null) {
            commandById = CommandsFactoryImpl.eINSTANCE.createCommand();
            commandById.setElementId(commandId);
            commandById.setCommandName(commandId);
            this.application.getCommands().add(commandById);
        }
        item.setCommand(commandById);
        Map<String, String> parms = MenuHelper.getParameters(commandAddition);
        Iterator<Map.Entry<String, String>> iterator = parms.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> obj;
            Map.Entry<String, String> e = obj = iterator.next();
            MParameter parm = CommandsFactoryImpl.eINSTANCE.createParameter();
            parm.setName(e.getKey().toString());
            parm.setValue(e.getValue().toString());
            item.getParameters().add(parm);
        }
        String iconUrl = MenuHelper.getIconUrl(commandAddition, "icon");
        if (iconUrl == null) {
            ImageDescriptor descriptor;
            ICommandImageService commandImageService = (ICommandImageService)this.application.getContext().get(ICommandImageService.class);
            ImageDescriptor imageDescriptor = descriptor = commandImageService == null ? null : commandImageService.getImageDescriptor(item.getElementId());
            if (descriptor == null) {
                item.setLabel(MenuHelper.getLabel(commandAddition));
            } else {
                item.setIconURI(MenuHelper.getImageUrl(descriptor));
            }
        } else {
            item.setIconURI(iconUrl);
        }
        item.setTooltip(MenuHelper.getTooltip(commandAddition));
        item.setType(MenuHelper.getStyle(commandAddition));
        item.setVisibleWhen(MenuHelper.getVisibleWhen(commandAddition));
        return item;
    }
}

