/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.internal.corext.Corext;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.jdt.internal.corext.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.code.CallContext;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.InputFlowAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.util.NoCommentSourceRangeComputer;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringFileBuffers;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallInliner {
    private ICompilationUnit fCUnit;
    private ASTRewrite fRewrite;
    private ImportRewrite fImportRewrite;
    private ITextFileBuffer fBuffer;
    private SourceProvider fSourceProvider;
    private TypeEnvironment fTypeEnvironment;
    private BodyDeclaration fBodyDeclaration;
    private CodeScopeBuilder.Scope fRootScope;
    private int fNumberOfLocals;
    private ASTNode fInvocation;
    private int fInsertionIndex;
    private ListRewrite fListRewrite;
    private boolean fNeedsStatement;
    private ASTNode fTargetNode;
    private FlowContext fFlowContext;
    private FlowInfo fFlowInfo;
    private CodeScopeBuilder.Scope fInvocationScope;
    private boolean fFieldInitializer;
    private List<VariableDeclarationStatement> fLocals;
    private CallContext fContext;

    public CallInliner(ICompilationUnit unit, CompilationUnit targetAstRoot, SourceProvider provider) throws CoreException {
        this.fCUnit = unit;
        this.fBuffer = RefactoringFileBuffers.acquire(this.fCUnit);
        this.fSourceProvider = provider;
        this.fImportRewrite = StubUtility.createImportRewrite(targetAstRoot, true);
        this.fLocals = new ArrayList<VariableDeclarationStatement>(3);
        this.fRewrite = ASTRewrite.create((AST)targetAstRoot.getAST());
        this.fRewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)new NoCommentSourceRangeComputer());
        this.fTypeEnvironment = new TypeEnvironment();
    }

    public void dispose() {
        try {
            RefactoringFileBuffers.release(this.fCUnit);
        }
        catch (CoreException exception) {
            JavaPlugin.log(exception);
        }
    }

    public ImportRewrite getImportEdit() {
        return this.fImportRewrite;
    }

    public ASTNode getTargetNode() {
        return this.fTargetNode;
    }

    public void initialize(BodyDeclaration declaration) {
        this.fBodyDeclaration = declaration;
        this.fRootScope = CodeScopeBuilder.perform(declaration, (IBinding)this.fSourceProvider.getDeclaration().resolveBinding());
        this.fNumberOfLocals = 0;
        switch (declaration.getNodeType()) {
            case 28: 
            case 31: {
                this.fNumberOfLocals = LocalVariableIndex.perform(declaration);
            }
        }
    }

    public RefactoringStatus initialize(ASTNode invocation, int severity) {
        RefactoringStatus result = new RefactoringStatus();
        this.fInvocation = invocation;
        this.fLocals = new ArrayList<VariableDeclarationStatement>(3);
        this.checkMethodDeclaration(result, severity);
        if (result.getSeverity() >= severity) {
            return result;
        }
        this.initializeRewriteState();
        this.initializeTargetNode();
        this.flowAnalysis();
        this.fContext = new CallContext(this.fInvocation, this.fInvocationScope, this.fTargetNode.getNodeType(), this.fImportRewrite);
        try {
            this.computeRealArguments();
            this.computeReceiver();
        }
        catch (BadLocationException exception) {
            JavaPlugin.log(exception);
        }
        this.checkInvocationContext(result, severity);
        return result;
    }

    private void initializeRewriteState() {
        this.fFieldInitializer = false;
        ASTNode parent = this.fInvocation.getParent();
        do {
            if (parent instanceof FieldDeclaration) {
                this.fFieldInitializer = true;
                return;
            }
            if (!(parent instanceof Block)) continue;
            return;
        } while ((parent = parent.getParent()) != null);
    }

    private void initializeTargetNode() {
        ASTNode parent = this.fInvocation.getParent();
        int nodeType = parent.getNodeType();
        this.fTargetNode = nodeType == 21 || nodeType == 41 ? parent : this.fInvocation;
    }

    private void checkMethodDeclaration(RefactoringStatus result, int severity) {
        Expression receiver;
        MethodDeclaration methodDeclaration = this.fSourceProvider.getDeclaration();
        if (this.fInvocation.getNodeType() != 17 && methodDeclaration.isConstructor()) {
            result.addEntry(new RefactoringStatusEntry(severity, RefactoringCoreMessages.CallInliner_constructors, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.fInvocation)));
        }
        if (this.fSourceProvider.hasSuperMethodInvocation() && this.fInvocation.getNodeType() == 32 && (receiver = ((MethodInvocation)this.fInvocation).getExpression()) instanceof ThisExpression) {
            result.addEntry(new RefactoringStatusEntry(severity, RefactoringCoreMessages.CallInliner_super_into_this_expression, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.fInvocation)));
        }
    }

    private void checkInvocationContext(RefactoringStatus result, int severity) {
        if (this.fInvocation.getNodeType() == 32 && ((MethodInvocation)this.fInvocation).resolveTypeBinding() == null) {
            this.addEntry(result, RefactoringCoreMessages.CallInliner_receiver_type, 258, severity);
            return;
        }
        int nodeType = this.fTargetNode.getNodeType();
        if (nodeType == 21) {
            if (this.fSourceProvider.isExecutionFlowInterrupted()) {
                this.addEntry(result, RefactoringCoreMessages.CallInliner_execution_flow, 260, severity);
                return;
            }
        } else if (nodeType == 32) {
            boolean isFieldDeclaration;
            ASTNode parent = this.fTargetNode.getParent();
            if (CallInliner.isReturnStatement(parent)) {
                return;
            }
            if (this.fSourceProvider.isExecutionFlowInterrupted()) {
                this.addEntry(result, RefactoringCoreMessages.CallInliner_execution_flow, 260, severity);
                return;
            }
            if (CallInliner.isAssignment(parent) || CallInliner.isSingleDeclaration(parent)) {
                return;
            }
            boolean bl = isFieldDeclaration = ASTNodes.getParent(this.fInvocation, FieldDeclaration.class) != null;
            if (!this.fSourceProvider.isSimpleFunction()) {
                if (CallInliner.isMultiDeclarationFragment(parent)) {
                    this.addEntry(result, RefactoringCoreMessages.CallInliner_multiDeclaration, 261, severity);
                } else if (isFieldDeclaration) {
                    this.addEntry(result, RefactoringCoreMessages.CallInliner_field_initializer_simple, 256, severity);
                } else {
                    this.addEntry(result, RefactoringCoreMessages.CallInliner_simple_functions, 259, severity);
                }
                return;
            }
            if (isFieldDeclaration) {
                int argumentsCount = this.fContext.arguments.length;
                int i = 0;
                while (i < argumentsCount) {
                    ParameterData parameter = this.fSourceProvider.getParameterData(i);
                    if (parameter.isWrite()) {
                        this.addEntry(result, RefactoringCoreMessages.CallInliner_field_initialize_write_parameter, 256, severity);
                        return;
                    }
                    ++i;
                }
                if (this.fLocals.size() > 0) {
                    this.addEntry(result, RefactoringCoreMessages.CallInliner_field_initialize_new_local, 256, severity);
                    return;
                }
                VariableDeclarationFragment variable = (VariableDeclarationFragment)ASTNodes.getParent(this.fInvocation, 59);
                if (this.fSourceProvider.isVariableReferenced(variable.resolveBinding())) {
                    this.addEntry(result, RefactoringCoreMessages.CallInliner_field_initialize_self_reference, 256, severity);
                    return;
                }
            }
        }
    }

    private static boolean isAssignment(ASTNode node) {
        return node instanceof Assignment;
    }

    private static boolean isReturnStatement(ASTNode node) {
        return node instanceof ReturnStatement;
    }

    private static boolean isSingleDeclaration(ASTNode node) {
        int type = node.getNodeType();
        if (type == 44) {
            return true;
        }
        if (type == 59 && (node = node.getParent()).getNodeType() == 60) {
            VariableDeclarationStatement vs = (VariableDeclarationStatement)node;
            return vs.fragments().size() == 1;
        }
        return false;
    }

    private static boolean isMultiDeclarationFragment(ASTNode node) {
        int nodeType = node.getNodeType();
        if (nodeType == 59 && (node = node.getParent()).getNodeType() == 60) {
            VariableDeclarationStatement vs = (VariableDeclarationStatement)node;
            return vs.fragments().size() > 1;
        }
        return false;
    }

    private void addEntry(RefactoringStatus result, String message, int code, int severity) {
        result.addEntry(new RefactoringStatusEntry(severity, message, JavaStatusContext.create((ITypeRoot)this.fCUnit, this.fInvocation), Corext.getPluginId(), code, null));
    }

    private void flowAnalysis() {
        this.fInvocationScope = this.fRootScope.findScope(this.fTargetNode.getStartPosition(), this.fTargetNode.getLength());
        this.fInvocationScope.setCursor(this.fTargetNode.getStartPosition());
        this.fFlowContext = new FlowContext(0, this.fNumberOfLocals + 1);
        this.fFlowContext.setConsiderAccessMode(true);
        this.fFlowContext.setComputeMode(FlowContext.ARGUMENTS);
        Selection selection = Selection.createFromStartLength(this.fInvocation.getStartPosition(), this.fInvocation.getLength());
        switch (this.fBodyDeclaration.getNodeType()) {
            case 23: 
            case 28: 
            case 31: {
                this.fFlowInfo = new InputFlowAnalyzer(this.fFlowContext, selection, true).perform(this.fBodyDeclaration);
                break;
            }
            default: {
                Assert.isTrue((boolean)false, (String)"Should not happen");
            }
        }
    }

    public RefactoringStatus perform(TextEditGroup textEditGroup) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        String[] blocks = this.fSourceProvider.getCodeBlocks(this.fContext, this.fImportRewrite);
        if (!this.fFieldInitializer) {
            this.initializeInsertionPoint(this.fSourceProvider.getNumberOfStatements() + this.fLocals.size());
        }
        this.addNewLocals(textEditGroup);
        this.replaceCall(result, blocks, textEditGroup);
        return result;
    }

    public TextEdit getModifications() {
        return this.fRewrite.rewriteAST(this.fBuffer.getDocument(), this.fCUnit.getJavaProject().getOptions(true));
    }

    private void computeRealArguments() {
        List<Expression> arguments = Invocations.getArguments(this.fInvocation);
        Set<Expression> canNotInline = this.crossCheckArguments(arguments);
        boolean needsVarargBoxing = this.needsVarargBoxing(arguments);
        int varargIndex = this.fSourceProvider.getVarargIndex();
        AST ast = this.fInvocation.getAST();
        Expression[] realArguments = new Expression[needsVarargBoxing ? varargIndex + 1 : arguments.size()];
        int i = 0;
        while (i < (needsVarargBoxing ? varargIndex : arguments.size())) {
            ParameterData parameter;
            Expression expression = arguments.get(i);
            if (this.canInline(expression, parameter = this.fSourceProvider.getParameterData(i)) && !canNotInline.contains(expression)) {
                realArguments[i] = expression;
            } else {
                String name = this.fInvocationScope.createName(parameter.getName(), true);
                realArguments[i] = ast.newSimpleName(name);
                this.fLocals.add(this.createLocalDeclaration(parameter.getTypeBinding(), name, (Expression)this.fRewrite.createCopyTarget((ASTNode)expression)));
            }
            ++i;
        }
        if (needsVarargBoxing) {
            ParameterData parameter = this.fSourceProvider.getParameterData(varargIndex);
            String name = this.fInvocationScope.createName(parameter.getName(), true);
            realArguments[varargIndex] = ast.newSimpleName(name);
            Type type = this.fImportRewrite.addImport(parameter.getTypeBinding(), ast);
            VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
            fragment.setName(ast.newSimpleName(name));
            ArrayInitializer initializer = ast.newArrayInitializer();
            int i2 = varargIndex;
            while (i2 < arguments.size()) {
                initializer.expressions().add(this.fRewrite.createCopyTarget((ASTNode)arguments.get(i2)));
                ++i2;
            }
            fragment.setInitializer((Expression)initializer);
            VariableDeclarationStatement decl = ast.newVariableDeclarationStatement(fragment);
            decl.setType(type);
            this.fLocals.add(decl);
        }
        this.fContext.compilationUnit = this.fCUnit;
        this.fContext.arguments = realArguments;
    }

    private boolean needsVarargBoxing(List<Expression> arguments) {
        if (!this.fSourceProvider.isVarargs()) {
            return false;
        }
        int index = this.fSourceProvider.getVarargIndex();
        if (index >= arguments.size()) {
            return true;
        }
        if (index == arguments.size() - 1) {
            ITypeBinding argument = arguments.get(index).resolveTypeBinding();
            if (argument == null) {
                return false;
            }
            ITypeBinding parameter = this.fSourceProvider.getParameterData(index).getTypeBinding();
            return !this.fTypeEnvironment.create(argument).canAssignTo(this.fTypeEnvironment.create(parameter));
        }
        return true;
    }

    private void computeReceiver() throws BadLocationException {
        Expression receiver = Invocations.getExpression(this.fInvocation);
        if (receiver == null) {
            return;
        }
        boolean isName = receiver instanceof Name;
        if (isName) {
            this.fContext.receiverIsStatic = ((Name)receiver).resolveBinding() instanceof ITypeBinding;
        }
        if (ASTNodes.isLiteral(receiver) || isName || receiver instanceof ThisExpression) {
            this.fContext.receiver = this.fBuffer.getDocument().get(receiver.getStartPosition(), receiver.getLength());
            return;
        }
        switch (this.fSourceProvider.getReceiversToBeUpdated()) {
            case 0: {
                this.fLocals.add(this.createLocalDeclaration(receiver.resolveTypeBinding(), this.fInvocationScope.createName("r", true), (Expression)this.fRewrite.createCopyTarget((ASTNode)receiver)));
                return;
            }
            case 1: {
                this.fContext.receiver = this.fBuffer.getDocument().get(receiver.getStartPosition(), receiver.getLength());
                return;
            }
        }
        String local = this.fInvocationScope.createName("r", true);
        this.fLocals.add(this.createLocalDeclaration(receiver.resolveTypeBinding(), local, (Expression)this.fRewrite.createCopyTarget((ASTNode)receiver)));
        this.fContext.receiver = local;
    }

    private void addNewLocals(TextEditGroup textEditGroup) {
        if (this.fLocals.isEmpty()) {
            return;
        }
        for (ASTNode aSTNode : this.fLocals) {
            this.fListRewrite.insertAt(aSTNode, this.fInsertionIndex++, textEditGroup);
        }
    }

    private void replaceCall(RefactoringStatus status, String[] blocks, TextEditGroup textEditGroup) {
        if (blocks.length == 0 && this.fTargetNode != null) {
            if (this.fNeedsStatement) {
                this.fRewrite.replace(this.fTargetNode, (ASTNode)this.fTargetNode.getAST().newEmptyStatement(), textEditGroup);
            } else {
                this.fRewrite.remove(this.fTargetNode, textEditGroup);
            }
        } else {
            ASTNode node = null;
            int i = 0;
            while (i < blocks.length - 1) {
                node = this.fRewrite.createStringPlaceholder(blocks[i], 41);
                this.fListRewrite.insertAt(node, this.fInsertionIndex++, textEditGroup);
                ++i;
            }
            String block = blocks[blocks.length - 1];
            if (this.fContext.callMode == 21 && this.fSourceProvider.hasReturnValue()) {
                if (this.fSourceProvider.mustEvaluateReturnedExpression()) {
                    if (this.fSourceProvider.returnValueNeedsLocalVariable()) {
                        IMethodBinding invocation = Invocations.resolveBinding(this.fInvocation);
                        node = this.createLocalDeclaration(invocation.getReturnType(), this.fInvocationScope.createName(this.fSourceProvider.getMethodName(), true), (Expression)this.fRewrite.createStringPlaceholder(block, 32));
                    } else {
                        node = this.fRewrite.getAST().newExpressionStatement((Expression)this.fRewrite.createStringPlaceholder(block, 32));
                    }
                } else {
                    node = null;
                }
            } else if (this.fTargetNode instanceof Expression) {
                node = this.fRewrite.createStringPlaceholder(block, 32);
                if (this.needsExplicitCast(status)) {
                    ParenthesizedExpression parenthesized;
                    AST ast = node.getAST();
                    CastExpression castExpression = ast.newCastExpression();
                    Type returnType = this.fImportRewrite.addImport(this.fSourceProvider.getReturnType(), ast);
                    castExpression.setType(returnType);
                    if (NecessaryParenthesesChecker.needsParentheses(this.fSourceProvider.getReturnExpressions().get(0), (ASTNode)castExpression, (StructuralPropertyDescriptor)CastExpression.EXPRESSION_PROPERTY)) {
                        parenthesized = ast.newParenthesizedExpression();
                        parenthesized.setExpression((Expression)node);
                        node = parenthesized;
                    }
                    castExpression.setExpression((Expression)node);
                    node = castExpression;
                    if (NecessaryParenthesesChecker.needsParentheses((Expression)castExpression, this.fTargetNode.getParent(), this.fTargetNode.getLocationInParent())) {
                        parenthesized = ast.newParenthesizedExpression();
                        parenthesized.setExpression((Expression)node);
                        node = parenthesized;
                    }
                } else if (this.fSourceProvider.needsReturnedExpressionParenthesis(this.fTargetNode.getParent(), this.fTargetNode.getLocationInParent())) {
                    ParenthesizedExpression pExp = this.fTargetNode.getAST().newParenthesizedExpression();
                    pExp.setExpression((Expression)node);
                    node = pExp;
                }
            } else {
                node = this.fRewrite.createStringPlaceholder(block, 41);
            }
            if (node != null) {
                if (this.fTargetNode == null) {
                    this.fListRewrite.insertAt(node, this.fInsertionIndex++, textEditGroup);
                } else {
                    this.fRewrite.replace(this.fTargetNode, node, textEditGroup);
                }
            } else if (this.fTargetNode != null) {
                this.fRewrite.remove(this.fTargetNode, textEditGroup);
            }
        }
    }

    private boolean needsExplicitCast(RefactoringStatus status) {
        if (this.fSourceProvider.returnTypeMatchesReturnExpressions()) {
            return false;
        }
        List<Expression> returnExprs = this.fSourceProvider.getReturnExpressions();
        if (returnExprs.size() != 1) {
            return false;
        }
        if (this.fTargetNode.getLocationInParent() == MethodInvocation.ARGUMENTS_PROPERTY) {
            MethodInvocation methodInvocation = (MethodInvocation)this.fTargetNode.getParent();
            if (methodInvocation.getExpression() == this.fTargetNode) {
                return false;
            }
            IMethodBinding method = methodInvocation.resolveMethodBinding();
            if (method == null) {
                status.addError(RefactoringCoreMessages.CallInliner_cast_analysis_error, JavaStatusContext.create((ITypeRoot)this.fCUnit, (ASTNode)methodInvocation));
                return false;
            }
            ITypeBinding[] parameters = method.getParameterTypes();
            int argumentIndex = methodInvocation.arguments().indexOf(this.fInvocation);
            parameters[argumentIndex] = returnExprs.get(0).resolveTypeBinding();
            ITypeBinding type = ASTNodes.getReceiverTypeBinding(methodInvocation);
            AmbiguousMethodAnalyzer visitor = new AmbiguousMethodAnalyzer(this.fTypeEnvironment, method, this.fTypeEnvironment.create(parameters));
            if (!visitor.visit(type)) {
                return true;
            }
            if (type.isInterface()) {
                return !Bindings.visitInterfaces(type, visitor);
            }
            if (Modifier.isAbstract((int)type.getModifiers())) {
                return !Bindings.visitHierarchy(type, visitor);
            }
            return !Bindings.visitSuperclasses(type, visitor);
        }
        ITypeBinding explicitCast = ASTNodes.getExplicitCast(returnExprs.get(0), (Expression)this.fTargetNode);
        return explicitCast != null;
    }

    private VariableDeclarationStatement createLocalDeclaration(ITypeBinding type, String name, Expression initializer) {
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(this.fTargetNode, this.fImportRewrite);
        String typeName = this.fImportRewrite.addImport(type, (ImportRewrite.ImportRewriteContext)context);
        VariableDeclarationStatement decl = (VariableDeclarationStatement)ASTNodeFactory.newStatement(this.fInvocation.getAST(), String.valueOf(typeName) + " " + name + ";");
        ((VariableDeclarationFragment)decl.fragments().get(0)).setInitializer(initializer);
        return decl;
    }

    private Set<Expression> crossCheckArguments(List<Expression> arguments) {
        final HashSet assigned = new HashSet();
        final HashSet<Expression> result = new HashSet<Expression>();
        for (final Expression expression : arguments) {
            expression.accept(new ASTVisitor(){

                public boolean visit(Assignment node) {
                    IBinding binding;
                    Expression lhs = node.getLeftHandSide();
                    if (lhs instanceof Name && (binding = ((Name)lhs).resolveBinding()) instanceof IVariableBinding) {
                        assigned.add(binding);
                        result.add(expression);
                    }
                    return true;
                }
            });
        }
        for (final Expression expression : arguments) {
            if (result.contains(expression)) continue;
            expression.accept((ASTVisitor)new HierarchicalASTVisitor(){

                public boolean visit(Name node) {
                    IBinding binding = node.resolveBinding();
                    if (binding != null && assigned.contains(binding)) {
                        result.add(expression);
                    }
                    return false;
                }
            });
        }
        return result;
    }

    private boolean canInline(Expression actualParameter, ParameterData formalParameter) {
        InlineEvaluator evaluator = new InlineEvaluator(formalParameter);
        actualParameter.accept((ASTVisitor)evaluator);
        return evaluator.getResult();
    }

    private void initializeInsertionPoint(int nos) {
        this.fInsertionIndex = -1;
        this.fNeedsStatement = false;
        ASTNode parentStatement = this.fInvocation instanceof Statement ? this.fInvocation : ASTNodes.getParent(this.fInvocation, Statement.class);
        ASTNode container = parentStatement.getParent();
        int type = container.getNodeType();
        if (type == 8) {
            Block block = (Block)container;
            this.fListRewrite = this.fRewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
            this.fInsertionIndex = this.fListRewrite.getRewrittenList().indexOf(parentStatement);
        } else if (type == 50) {
            SwitchStatement switchStatement = (SwitchStatement)container;
            this.fListRewrite = this.fRewrite.getListRewrite((ASTNode)switchStatement, SwitchStatement.STATEMENTS_PROPERTY);
            this.fInsertionIndex = this.fListRewrite.getRewrittenList().indexOf(parentStatement);
        } else if (this.isControlStatement(container) || type == 30) {
            this.fNeedsStatement = true;
            if (nos > 1 || this.needsBlockAroundDanglingIf()) {
                Block block = this.fInvocation.getAST().newBlock();
                this.fInsertionIndex = 0;
                Statement currentStatement = null;
                switch (type) {
                    case 30: {
                        currentStatement = ((LabeledStatement)container).getBody();
                        break;
                    }
                    case 24: {
                        currentStatement = ((ForStatement)container).getBody();
                        break;
                    }
                    case 70: {
                        currentStatement = ((EnhancedForStatement)container).getBody();
                        break;
                    }
                    case 61: {
                        currentStatement = ((WhileStatement)container).getBody();
                        break;
                    }
                    case 19: {
                        currentStatement = ((DoStatement)container).getBody();
                        break;
                    }
                    case 25: {
                        IfStatement node = (IfStatement)container;
                        Statement thenPart = node.getThenStatement();
                        currentStatement = this.fTargetNode == thenPart || ASTNodes.isParent(this.fTargetNode, (ASTNode)thenPart) ? thenPart : node.getElseStatement();
                    }
                }
                Assert.isNotNull(currentStatement);
                this.fRewrite.replace((ASTNode)currentStatement, (ASTNode)block, null);
                this.fListRewrite = this.fRewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                if (currentStatement != this.fTargetNode) {
                    this.fListRewrite.insertLast(this.fRewrite.createCopyTarget((ASTNode)currentStatement), null);
                } else {
                    this.fTargetNode = null;
                }
            }
        }
    }

    private boolean needsBlockAroundDanglingIf() {
        return this.fTargetNode.getLocationInParent() == IfStatement.THEN_STATEMENT_PROPERTY && this.fTargetNode.getParent().getStructuralProperty((StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY) != null && this.fSourceProvider.isDangligIf();
    }

    private boolean isControlStatement(ASTNode node) {
        int type = node.getNodeType();
        return type == 25 || type == 24 || type == 70 || type == 61 || type == 19;
    }

    private static class AmbiguousMethodAnalyzer
    implements TypeBindingVisitor {
        private TypeEnvironment fTypeEnvironment;
        private TType[] fTypes;
        private IMethodBinding fOriginal;

        public AmbiguousMethodAnalyzer(TypeEnvironment typeEnvironment, IMethodBinding original, TType[] types) {
            this.fTypeEnvironment = typeEnvironment;
            this.fOriginal = original;
            this.fTypes = types;
        }

        public boolean visit(ITypeBinding node) {
            IMethodBinding[] methods = node.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                IMethodBinding candidate = methods[i];
                if (candidate != this.fOriginal && this.fOriginal.getName().equals(candidate.getName()) && this.canImplicitlyCall(candidate)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean canImplicitlyCall(IMethodBinding candidate) {
            ITypeBinding[] parameters = candidate.getParameterTypes();
            if (parameters.length != this.fTypes.length) {
                return false;
            }
            int i = 0;
            while (i < parameters.length) {
                if (!this.fTypes[i].canAssignTo(this.fTypeEnvironment.create(parameters[i]))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private class InlineEvaluator
    extends HierarchicalASTVisitor {
        private ParameterData fFormalArgument;
        private boolean fResult;

        public InlineEvaluator(ParameterData argument) {
            this.fFormalArgument = argument;
        }

        public boolean getResult() {
            return this.fResult;
        }

        private boolean setResult(boolean result) {
            this.fResult = result;
            return false;
        }

        public boolean visit(Expression node) {
            int accessMode = this.fFormalArgument.getSimplifiedAccessMode();
            if (accessMode == 8) {
                return this.setResult(false);
            }
            if (accessMode == 1) {
                return this.setResult(true);
            }
            if (ASTNodes.isLiteral(node)) {
                return this.setResult(true);
            }
            return this.setResult(this.fFormalArgument.getNumberOfAccesses() <= 1);
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding instanceof IVariableBinding) {
                int accessMode = this.fFormalArgument.getSimplifiedAccessMode();
                if (accessMode == 2 || accessMode == 1) {
                    return this.setResult(true);
                }
                IVariableBinding vb = (IVariableBinding)binding;
                if (vb.isField()) {
                    return this.setResult(false);
                }
                return this.setResult(CallInliner.this.fFlowInfo.hasAccessMode(CallInliner.this.fFlowContext, vb, 9));
            }
            return this.setResult(false);
        }

        public boolean visit(FieldAccess node) {
            return this.visit(node.getName());
        }

        public boolean visit(SuperFieldAccess node) {
            return this.visit(node.getName());
        }

        public boolean visit(ThisExpression node) {
            int accessMode = this.fFormalArgument.getSimplifiedAccessMode();
            if (accessMode == 2 || accessMode == 1) {
                return this.setResult(true);
            }
            return this.setResult(false);
        }
    }
}

