/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;

public final class NumericField
extends AbstractField {
    private final NumericTokenStream tokenStream;

    public NumericField(String name) {
        this(name, 4, Field.Store.NO, true);
    }

    public NumericField(String name, Field.Store store, boolean index) {
        this(name, 4, store, index);
    }

    public NumericField(String name, int precisionStep) {
        this(name, precisionStep, Field.Store.NO, true);
    }

    public NumericField(String name, int precisionStep, Field.Store store, boolean index) {
        super(name, store, index ? Field.Index.ANALYZED_NO_NORMS : Field.Index.NO, Field.TermVector.NO);
        this.setOmitTermFreqAndPositions(true);
        this.tokenStream = new NumericTokenStream(precisionStep);
    }

    public TokenStream tokenStreamValue() {
        return this.isIndexed() ? this.tokenStream : null;
    }

    public byte[] binaryValue() {
        return null;
    }

    public byte[] getBinaryValue(byte[] result) {
        return null;
    }

    public Reader readerValue() {
        return null;
    }

    public String stringValue() {
        return this.fieldsData == null ? null : this.fieldsData.toString();
    }

    public Number getNumericValue() {
        return (Number)this.fieldsData;
    }

    public NumericField setLongValue(long value) {
        this.tokenStream.setLongValue(value);
        this.fieldsData = new Long(value);
        return this;
    }

    public NumericField setIntValue(int value) {
        this.tokenStream.setIntValue(value);
        this.fieldsData = new Integer(value);
        return this;
    }

    public NumericField setDoubleValue(double value) {
        this.tokenStream.setDoubleValue(value);
        this.fieldsData = new Double(value);
        return this;
    }

    public NumericField setFloatValue(float value) {
        this.tokenStream.setFloatValue(value);
        this.fieldsData = new Float(value);
        return this;
    }
}

