/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FilterTextControl {
    private static ImageDescriptor fgClearIconDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/clear_co.gif");
    private static ImageDescriptor fgDisabledClearIconDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/dtool16/clear_co.gif");
    private static Boolean fgUseNativeSearchField;
    private Text fTextControl;
    private Control fClearButton;
    private Composite fComposite;

    private static boolean useNativeSearchField(Composite composite) {
        if (fgUseNativeSearchField == null) {
            fgUseNativeSearchField = Boolean.FALSE;
            Text testText = null;
            try {
                testText = new Text(composite, 384);
                fgUseNativeSearchField = new Boolean((testText.getStyle() & 0x100) != 0);
            }
            finally {
                if (testText != null) {
                    testText.dispose();
                }
            }
        }
        return fgUseNativeSearchField;
    }

    public FilterTextControl(Composite parent) {
        boolean nativeField = FilterTextControl.useNativeSearchField(parent);
        this.fComposite = new Composite(parent, nativeField ? 0 : 2048){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                Color color = enabled ? this.getDisplay().getSystemColor(25) : this.getParent().getBackground();
                this.setBackground(color);
                if (FilterTextControl.this.fClearButton != null) {
                    FilterTextControl.this.fClearButton.setBackground(color);
                }
            }
        };
        if (!nativeField) {
            this.fComposite.setBackground(parent.getDisplay().getSystemColor(25));
        }
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        this.fComposite.setLayout((Layout)filterLayout);
        this.fComposite.setFont(parent.getFont());
        this.createControls(this.fComposite);
        this.fComposite.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    private void createControls(Composite parent) {
        this.createTextControl(parent);
        this.createClearButton(parent);
        this.updateClearButtonVisibility(false);
    }

    private void createTextControl(Composite parent) {
        this.fTextControl = FilterTextControl.useNativeSearchField(parent) ? new Text(parent, 2436) : new Text(parent, 4);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        if ((this.fTextControl.getStyle() & 0x100) != 0) {
            gridData.horizontalSpan = 2;
        }
        this.fTextControl.setLayoutData((Object)gridData);
        this.fTextControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterTextControl.this.updateClearButtonVisibility(FilterTextControl.this.fTextControl.getText().length() != 0);
            }
        });
    }

    private void createClearButton(Composite parent) {
        if ((this.fTextControl.getStyle() & 0x100) == 0) {
            final Image inactiveImage = fgDisabledClearIconDescriptor.createImage();
            final Image activeImage = fgClearIconDescriptor.createImage();
            final Image pressedImage = new Image((Device)parent.getDisplay(), activeImage, 2);
            final Label clearButton = new Label(parent, 0);
            clearButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            clearButton.setImage(inactiveImage);
            clearButton.setBackground(parent.getDisplay().getSystemColor(25));
            clearButton.setToolTipText(PreferencesMessages.FilterTextControl_Clear);
            clearButton.addMouseListener((MouseListener)new MouseAdapter(){
                private MouseMoveListener fMoveListener;

                public void mouseDown(MouseEvent e) {
                    clearButton.setImage(pressedImage);
                    this.fMoveListener = new MouseMoveListener(){
                        private boolean fMouseInButton = true;

                        public void mouseMove(MouseEvent e1) {
                            boolean mouseInButton = this.isMouseInButton(e1);
                            if (mouseInButton != this.fMouseInButton) {
                                this.fMouseInButton = mouseInButton;
                                clearButton.setImage(mouseInButton ? pressedImage : inactiveImage);
                            }
                        }
                    };
                    clearButton.addMouseMoveListener(this.fMoveListener);
                }

                public void mouseUp(MouseEvent e) {
                    if (this.fMoveListener != null) {
                        clearButton.removeMouseMoveListener(this.fMoveListener);
                        this.fMoveListener = null;
                        boolean mouseInButton = this.isMouseInButton(e);
                        clearButton.setImage(mouseInButton ? activeImage : inactiveImage);
                        if (mouseInButton) {
                            FilterTextControl.this.fTextControl.setText("");
                            FilterTextControl.this.fTextControl.setFocus();
                        }
                    }
                }

                private boolean isMouseInButton(MouseEvent e) {
                    Point buttonSize = clearButton.getSize();
                    return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
                }
            });
            clearButton.addMouseTrackListener(new MouseTrackListener(){

                public void mouseEnter(MouseEvent e) {
                    clearButton.setImage(activeImage);
                }

                public void mouseExit(MouseEvent e) {
                    clearButton.setImage(inactiveImage);
                }

                public void mouseHover(MouseEvent e) {
                }
            });
            clearButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    inactiveImage.dispose();
                    activeImage.dispose();
                    pressedImage.dispose();
                }
            });
            clearButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = PreferencesMessages.FilterTextControl_ClearFilterField;
                }
            });
            clearButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

                public void getRole(AccessibleControlEvent e) {
                    e.detail = 43;
                }
            });
            this.fClearButton = clearButton;
        }
    }

    public Text getFilterControl() {
        return this.fTextControl;
    }

    public String getFilterString() {
        return this.fTextControl != null ? this.fTextControl.getText() : null;
    }

    private void updateClearButtonVisibility(boolean visible) {
        if (this.fClearButton != null) {
            this.fClearButton.setVisible(visible);
        }
    }
}

