/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.preferences.PDECompilersConfigurationBlock;
import org.eclipse.pde.internal.ui.preferences.ProjectSelectionDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class CompilersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String NO_LINK = "PropertyAndPreferencePage.nolink";
    private PDECompilersConfigurationBlock fBlock = null;
    private Link link = null;
    private Map fPageData = null;

    public CompilersPreferencePage() {
        this.setTitle(PDEUIMessages.CompilersPreferencePage_title);
    }

    protected Control createContents(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        this.link = new Link(comp, 0);
        this.link.setLayoutData((Object)new GridData(3, 2, true, false));
        this.link.setFont(comp.getFont());
        this.link.setText(PDEUIMessages.CompilersPreferencePage_configure_project_specific_settings);
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashSet<IJavaProject> set = new HashSet<IJavaProject>();
                try {
                    IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                    IProject project = null;
                    int i = 0;
                    while (i < projects.length) {
                        project = projects[i].getProject();
                        try {
                            if (project.hasNature("org.eclipse.pde.PluginNature") && CompilersPreferencePage.this.fBlock.hasProjectSpecificSettings(project)) {
                                set.add(projects[i]);
                            }
                        }
                        catch (CoreException coreException) {}
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {}
                ProjectSelectionDialog psd = new ProjectSelectionDialog(CompilersPreferencePage.this.getShell(), set);
                if (psd.open() == 0) {
                    HashMap<String, Boolean> data = new HashMap<String, Boolean>();
                    data.put(CompilersPreferencePage.NO_LINK, Boolean.TRUE);
                    PreferencesUtil.createPropertyDialogOn((Shell)CompilersPreferencePage.this.getShell(), (IAdaptable)((IJavaProject)psd.getFirstResult()).getProject(), (String)"org.eclipse.pde.internal.ui.properties.compilersPropertyPage", (String[])new String[]{"org.eclipse.pde.internal.ui.properties.compilersPropertyPage"}, data).open();
                }
            }
        });
        this.fBlock = new PDECompilersConfigurationBlock(null, (IWorkbenchPreferenceContainer)this.getContainer());
        this.fBlock.createControl(comp);
        this.applyData(this.fPageData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.pde.doc.user.compilers_preference_page");
        return comp;
    }

    public void dispose() {
        if (this.fBlock != null) {
            this.fBlock.dispose();
        }
        super.dispose();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performCancel() {
        this.fBlock.performCancel();
        return super.performCancel();
    }

    public boolean performOk() {
        this.fBlock.performOK();
        return super.performOk();
    }

    protected void performApply() {
        this.fBlock.performApply();
        super.performApply();
    }

    protected void performDefaults() {
        this.fBlock.performDefaults();
        super.performDefaults();
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            this.fPageData = (Map)data;
            if (this.link != null && this.fPageData.containsKey(NO_LINK)) {
                this.link.setVisible(!Boolean.TRUE.equals(((Map)data).get(NO_LINK)));
            }
        }
    }
}

