/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.buildpath.P2Utils;
import org.eclipse.jdt.junit.JUnitCore;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class BuildPathSupport {
    public static final JUnitPluginDescription JUNIT3_PLUGIN = new JUnitPluginDescription("org.junit", new VersionRange("[3.8.2,3.9)"), "junit.jar", "junit.jar", "org.junit.source", "source-bundle/", "org.eclipse.jdt.junit.junit3.javadoclocation");
    private static final JUnitPluginDescription JUNIT4_PLUGIN = new JUnitPluginDescription("org.junit", new VersionRange("[4.7.0,5.0.0)"), "junit.jar", "junit.jar", "org.junit.source", "source-bundle/", "org.eclipse.jdt.junit.junit4.javadoclocation");
    private static final JUnitPluginDescription HAMCREST_CORE_PLUGIN = new JUnitPluginDescription("org.hamcrest.core", new VersionRange("[1.1.0,2.0.0)"), null, "org.hamcrest.core_1.*.jar", "org.hamcrest.core.source", "source-bundle/", "org.eclipse.jdt.junit.junit4.hamcrest.core.javadoclocation");

    public static IClasspathEntry getJUnit3ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitCore.JUNIT3_CONTAINER_PATH);
    }

    public static IClasspathEntry getJUnit4ClasspathEntry() {
        return JavaCore.newContainerEntry((IPath)JUnitCore.JUNIT4_CONTAINER_PATH);
    }

    public static IClasspathEntry getJUnit3LibraryEntry() {
        return JUNIT3_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getJUnit4LibraryEntry() {
        return JUNIT4_PLUGIN.getLibraryEntry();
    }

    public static IClasspathEntry getHamcrestCoreLibraryEntry() {
        return HAMCREST_CORE_PLUGIN.getLibraryEntry();
    }

    public static class JUnitPluginDescription {
        private final String bundleId;
        private final VersionRange versionRange;
        private final String bundleRoot;
        private final String binaryImportedRoot;
        private final String sourceBundleId;
        private final String repositorySource;
        private final String javadocPreferenceKey;

        public JUnitPluginDescription(String bundleId, VersionRange versionRange, String bundleRoot, String binaryImportedRoot, String sourceBundleId, String repositorySource, String javadocPreferenceKey) {
            this.bundleId = bundleId;
            this.versionRange = versionRange;
            this.bundleRoot = bundleRoot;
            this.binaryImportedRoot = binaryImportedRoot;
            this.sourceBundleId = sourceBundleId;
            this.repositorySource = repositorySource;
            this.javadocPreferenceKey = javadocPreferenceKey;
        }

        public IPath getBundleLocation() {
            return P2Utils.getBundleLocationPath(P2Utils.findBundle(this.bundleId, this.versionRange, false));
        }

        public IPath getSourceBundleLocation() {
            return this.getSourceLocation(P2Utils.findBundle(this.bundleId, this.versionRange, false));
        }

        public IClasspathEntry getLibraryEntry() {
            BundleInfo bundleInfo = P2Utils.findBundle(this.bundleId, this.versionRange, false);
            IPath bundleLocation = P2Utils.getBundleLocationPath(bundleInfo);
            if (bundleLocation != null) {
                IPath bundleRootLocation = this.getLibraryLocation(bundleInfo, bundleLocation);
                IPath srcLocation = this.getSourceLocation(bundleInfo);
                IAccessRule[] accessRules = new IAccessRule[]{};
                String javadocLocation = Platform.getPreferencesService().getString("org.eclipse.jdt.junit.core", this.javadocPreferenceKey, "", null);
                IClasspathAttribute[] attributes = javadocLocation.length() == 0 ? new IClasspathAttribute[]{} : new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)javadocLocation)};
                return JavaCore.newLibraryEntry((IPath)bundleRootLocation, (IPath)srcLocation, null, (IAccessRule[])accessRules, (IClasspathAttribute[])attributes, (boolean)false);
            }
            return null;
        }

        private IPath getLibraryLocation(BundleInfo bundleInfo, IPath bundleLocation) {
            IPath bundleRootLocation = null;
            if (this.bundleRoot != null) {
                bundleRootLocation = this.getLocationIfExists(bundleInfo, this.bundleRoot);
            }
            if (bundleRootLocation == null && this.binaryImportedRoot != null) {
                bundleRootLocation = this.getLocationIfExists(bundleInfo, this.binaryImportedRoot);
            }
            if (bundleRootLocation == null) {
                bundleRootLocation = bundleLocation;
            }
            return bundleRootLocation;
        }

        private IPath getSourceLocation(BundleInfo bundleInfo) {
            IPath srcLocation = null;
            if (this.repositorySource != null) {
                srcLocation = this.getLocationIfExists(bundleInfo, this.repositorySource);
            }
            if (srcLocation == null) {
                BundleInfo sourceBundleInfo = P2Utils.findBundle(this.sourceBundleId, new Version(bundleInfo.getVersion()), true);
                if (sourceBundleInfo == null) {
                    sourceBundleInfo = P2Utils.findBundle(this.sourceBundleId, this.versionRange, true);
                }
                srcLocation = P2Utils.getBundleLocationPath(sourceBundleInfo);
            }
            return srcLocation;
        }

        private IPath getLocationIfExists(BundleInfo bundleInfo, String entryInBundle) {
            File bundleFile;
            Path srcLocation = null;
            IPath bundleLocationPath = P2Utils.getBundleLocationPath(bundleInfo);
            if (bundleLocationPath != null && (bundleFile = bundleLocationPath.toFile()).isDirectory()) {
                File[] files;
                File srcFile = null;
                int starIdx = entryInBundle.indexOf(42);
                if (starIdx != -1 && (files = bundleFile.listFiles(new FilenameFilter(this, entryInBundle, starIdx){
                    private String pre;
                    private String post;
                    final /* synthetic */ JUnitPluginDescription this$1;
                    {
                        this.this$1 = jUnitPluginDescription;
                        this.pre = string.substring(0, n);
                        this.post = string.substring(n + 1);
                    }

                    public boolean accept(File dir, String name) {
                        return name.startsWith(this.pre) && name.endsWith(this.post);
                    }
                })).length > 0) {
                    srcFile = files[0];
                }
                if (srcFile == null) {
                    srcFile = new File(bundleFile, entryInBundle);
                }
                if (srcFile.exists()) {
                    srcLocation = new Path(srcFile.getPath());
                    if (srcFile.isDirectory()) {
                        srcLocation = srcLocation.addTrailingSeparator();
                    }
                }
            }
            return srcLocation;
        }
    }
}

