/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.search.SkippedComponent;
import org.eclipse.pde.api.tools.internal.util.FileManager;
import org.eclipse.pde.api.tools.internal.util.FilteredElements;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.SinceTagVersion;
import org.eclipse.pde.api.tools.internal.util.TarEntry;
import org.eclipse.pde.api.tools.internal.util.TarException;
import org.eclipse.pde.api.tools.internal.util.TarFile;
import org.eclipse.pde.api.tools.internal.util.UtilMessages;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.osgi.framework.Version;
import org.w3c.dom.Element;

public final class Util {
    public static final String DOT_TGZ = ".tgz";
    public static final String DOT_TAR_GZ = ".tar.gz";
    public static final String DOT_JAR = ".jar";
    public static final String DOT_ZIP = ".zip";
    public static final char VERSION_SEPARATOR = '(';
    public static boolean DEBUG;
    public static final String EMPTY_STRING = "";
    public static final String DEFAULT_PACKAGE_NAME = "";
    public static final String MANIFEST_NAME = "MANIFEST.MF";
    public static final String DOT_CLASS_SUFFIX = ".class";
    public static final String DOT_JAVA_SUFFIX = ".java";
    private static final int DEFAULT_READING_SIZE = 8192;
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_RUNTIMEEXCEPTION = "java.lang.RuntimeException";
    public static final String LINE_DELIMITER;
    public static final String UNKNOWN_ELEMENT_KIND = "UNKNOWN_ELEMENT_KIND";
    public static final String UNKNOWN_FLAGS = "UNKNOWN_FLAGS";
    public static final String UNKNOWN_KIND = "UNKNOWN_KIND";
    public static final String UNKNOWN_VISIBILITY = "UNKNOWN_VISIBILITY";
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String REGULAR_EXPRESSION_START = "R:";
    private static int DELETE_MAX_TIME;
    private static boolean DELETE_DEBUG;
    private static int DELETE_MAX_WAIT;
    public static final IPath MANIFEST_PROJECT_RELATIVE_PATH;
    public static final String ORG_ECLIPSE_SWT = "org.eclipse.swt";
    public static final Comparator componentsorter;
    public static final Comparator filesorter;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        LINE_DELIMITER = System.getProperty("line.separator");
        DELETE_MAX_TIME = 0;
        DELETE_DEBUG = false;
        DELETE_MAX_WAIT = 10000;
        MANIFEST_PROJECT_RELATIVE_PATH = new Path("META-INF/MANIFEST.MF");
        String property = System.getProperty("DEBUG");
        DEBUG = property != null && property.equalsIgnoreCase("TRUE");
        componentsorter = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof IApiComponent && o2 instanceof IApiComponent) {
                    return ((IApiComponent)o1).getSymbolicName().compareTo(((IApiComponent)o2).getSymbolicName());
                }
                if (o1 instanceof SkippedComponent && o2 instanceof SkippedComponent) {
                    return ((SkippedComponent)o1).getComponentId().compareTo(((SkippedComponent)o2).getComponentId());
                }
                if (o1 instanceof String && o2 instanceof String) {
                    return ((String)o1).compareTo((String)o2);
                }
                return -1;
            }
        };
        filesorter = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof File && o2 instanceof File) {
                    return ((File)o1).getName().compareTo(((File)o2).getName());
                }
                return 0;
            }
        };
    }

    private static void abort(String message, Throwable exception) throws CoreException {
        Status status = new Status(4, "org.eclipse.pde.api.tools", message, exception);
        throw new CoreException((IStatus)status);
    }

    private static void appendProperty(StringBuffer buffer, String key, String value) {
        buffer.append(key);
        buffer.append('=');
        buffer.append(value);
        buffer.append('\n');
    }

    public static List collectAllDeltas(IDelta delta) {
        final ArrayList list = new ArrayList();
        delta.accept(new DeltaVisitor(){

            public void endVisit(IDelta localDelta) {
                if (localDelta.getChildren().length == 0) {
                    list.add(localDelta);
                }
                super.endVisit(localDelta);
            }
        });
        return list;
    }

    private static void collectAllFiles(File root, ArrayList collector, FileFilter fileFilter) {
        File[] files = root.listFiles(fileFilter);
        int i = 0;
        while (i < files.length) {
            File currentFile = files[i];
            if (currentFile.isDirectory()) {
                Util.collectAllFiles(currentFile, collector, fileFilter);
            } else {
                collector.add(currentFile);
            }
            ++i;
        }
    }

    public static IProject[] getApiProjects() {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> temp = new ArrayList<IProject>();
        IProject project = null;
        int i = 0;
        int max = allProjects.length;
        while (i < max) {
            project = allProjects[i];
            if (project.isAccessible()) {
                try {
                    if (project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature")) {
                        temp.add(project);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        IProject[] projects = null;
        if (temp.size() != 0) {
            projects = new IProject[temp.size()];
            temp.toArray(projects);
        }
        return projects;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean copy(File file, File newFile) {
        byte[] bytes;
        block31: {
            bytes = null;
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(file));
                bytes = Util.getInputStreamAsByteArray(inputStream, -1);
            }
            catch (FileNotFoundException e) {
                ApiPlugin.log(e);
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e2) {
                        ApiPlugin.log(e2);
                    }
                }
                break block31;
            }
            catch (IOException e) {
                try {
                    ApiPlugin.log(e);
                    break block31;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e3) {
                            ApiPlugin.log(e3);
                        }
                    }
                }
            }
            if (inputStream == null) break block31;
            try {
                inputStream.close();
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
        }
        if (bytes == null) return false;
        FilterOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(newFile));
            outputStream.write(bytes);
            ((BufferedOutputStream)outputStream).flush();
        }
        catch (FileNotFoundException e) {
            ApiPlugin.log(e);
            if (outputStream == null) return true;
            try {
                outputStream.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
        }
        catch (IOException e) {
            try {
                ApiPlugin.log(e);
                if (outputStream == null) return true;
            }
            catch (Throwable throwable) {
                if (outputStream == null) throw throwable;
                try {
                    outputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                outputStream.close();
                return true;
            }
            catch (IOException iOException) {}
            return true;
        }
        if (outputStream == null) return true;
        try {
            outputStream.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
    }

    public static File createEEFile(IVMInstall jre, String eeid) throws IOException {
        String string = Util.generateEEContents(jre, eeid);
        File eeFile = Util.createTempFile("eed", ".ee");
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(eeFile);
            outputStream.write(string.getBytes("UTF-8"));
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return eeFile;
    }

    public static boolean equalsOrNull(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static String generateEEContents(IVMInstall vm, String eeId) throws IOException {
        StringBuffer buffer = new StringBuffer();
        Util.appendProperty(buffer, "-Djava.home", vm.getInstallLocation().getCanonicalPath());
        StringBuffer paths = new StringBuffer();
        LibraryLocation[] libraryLocations = JavaRuntime.getLibraryLocations((IVMInstall)vm);
        int i = 0;
        while (i < libraryLocations.length) {
            LibraryLocation lib = libraryLocations[i];
            paths.append(lib.getSystemLibraryPath().toOSString());
            if (i < libraryLocations.length - 1) {
                paths.append(File.pathSeparatorChar);
            }
            ++i;
        }
        Util.appendProperty(buffer, "-Dee.bootclasspath", paths.toString());
        Util.appendProperty(buffer, "-Dee.class.library.level", eeId);
        return buffer.toString();
    }

    public static File[] getAllFiles(File root, FileFilter fileFilter) {
        ArrayList files = new ArrayList();
        if (root.isDirectory()) {
            Util.collectAllFiles(root, files, fileFilter);
            File[] result = new File[files.size()];
            files.toArray(result);
            return result;
        }
        return null;
    }

    public static Job getBuildJob(IProject[] projects) {
        Assert.isNotNull((Object)projects);
        BuildJob buildJob = new BuildJob(UtilMessages.Util_4, projects);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    public static Job getBuildJob(IProject[] projects, int buildKind) {
        Assert.isNotNull((Object)projects);
        BuildJob buildJob = new BuildJob(UtilMessages.Util_4, projects, buildKind);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    public static IApiTypeRoot getClassFile(IApiComponent[] components, String typeName) {
        if (components == null) {
            return null;
        }
        int i = 0;
        int max = components.length;
        while (i < max) {
            IApiComponent apiComponent = components[i];
            if (apiComponent != null) {
                try {
                    IApiTypeRoot classFile = apiComponent.findTypeRoot(typeName);
                    if (classFile != null) {
                        return classFile;
                    }
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
        return null;
    }

    public static String getDeltaElementType(IDelta delta) {
        return Util.getDeltaElementType(delta.getElementType());
    }

    public static String getSeverity(int severity) {
        switch (severity) {
            case 2: {
                return "ERROR";
            }
            case 0: {
                return "INFO";
            }
            case 1: {
                return "WARNING";
            }
        }
        return "UNKNOWN_SEVERITY";
    }

    public static int getDeltaElementTypeValue(String elementType) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> IDeltaClass = clazz;
        try {
            Field field = IDeltaClass.getField(elementType);
            return field.getInt(null);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return -1;
    }

    public static String getDeltaElementType(int elementType) {
        switch (elementType) {
            case 1: {
                return "ANNOTATION_ELEMENT_TYPE";
            }
            case 8: {
                return "INTERFACE_ELEMENT_TYPE";
            }
            case 6: {
                return "ENUM_ELEMENT_TYPE";
            }
            case 2: {
                return "API_COMPONENT_ELEMENT_TYPE";
            }
            case 3: {
                return "API_BASELINE_ELEMENT_TYPE";
            }
            case 5: {
                return "CONSTRUCTOR_ELEMENT_TYPE";
            }
            case 9: {
                return "METHOD_ELEMENT_TYPE";
            }
            case 7: {
                return "FIELD_ELEMENT_TYPE";
            }
            case 4: {
                return "CLASS_ELEMENT_TYPE";
            }
            case 10: {
                return "TYPE_PARAMETER_ELEMENT_TYPE";
            }
        }
        return UNKNOWN_ELEMENT_KIND;
    }

    public static String getDeltaFlagsName(int flags) {
        switch (flags) {
            case 1: {
                return "ABSTRACT_TO_NON_ABSTRACT";
            }
            case 2: {
                return "ANNOTATION_DEFAULT_VALUE";
            }
            case 3: {
                return "API_COMPONENT";
            }
            case 4: {
                return "ARRAY_TO_VARARGS";
            }
            case 5: {
                return "CHECKED_EXCEPTION";
            }
            case 6: {
                return "CLASS_BOUND";
            }
            case 7: {
                return "CLINIT";
            }
            case 8: {
                return "CONSTRUCTOR";
            }
            case 10: {
                return "CONTRACTED_SUPERINTERFACES_SET";
            }
            case 11: {
                return "DECREASE_ACCESS";
            }
            case 12: {
                return "ENUM_CONSTANT";
            }
            case 13: {
                return "EXECUTION_ENVIRONMENT";
            }
            case 15: {
                return "EXPANDED_SUPERINTERFACES_SET";
            }
            case 16: {
                return "FIELD";
            }
            case 17: {
                return "FIELD_MOVED_UP";
            }
            case 18: {
                return "FINAL_TO_NON_FINAL";
            }
            case 19: {
                return "FINAL_TO_NON_FINAL_NON_STATIC";
            }
            case 20: {
                return "FINAL_TO_NON_FINAL_STATIC_CONSTANT";
            }
            case 21: {
                return "FINAL_TO_NON_FINAL_STATIC_NON_CONSTANT";
            }
            case 22: {
                return "INCREASE_ACCESS";
            }
            case 23: {
                return "INTERFACE_BOUND";
            }
            case 25: {
                return "METHOD";
            }
            case 26: {
                return "METHOD_MOVED_UP";
            }
            case 27: {
                return "METHOD_WITH_DEFAULT_VALUE";
            }
            case 28: {
                return "METHOD_WITHOUT_DEFAULT_VALUE";
            }
            case 29: {
                return "NATIVE_TO_NON_NATIVE";
            }
            case 30: {
                return "NON_ABSTRACT_TO_ABSTRACT";
            }
            case 31: {
                return "NON_FINAL_TO_FINAL";
            }
            case 32: {
                return "NON_NATIVE_TO_NATIVE";
            }
            case 33: {
                return "NON_STATIC_TO_STATIC";
            }
            case 34: {
                return "NON_SYNCHRONIZED_TO_SYNCHRONIZED";
            }
            case 35: {
                return "NON_TRANSIENT_TO_TRANSIENT";
            }
            case 36: {
                return "OVERRIDEN_METHOD";
            }
            case 38: {
                return "STATIC_TO_NON_STATIC";
            }
            case 39: {
                return "SUPERCLASS";
            }
            case 40: {
                return "SYNCHRONIZED_TO_NON_SYNCHRONIZED";
            }
            case 41: {
                return "TYPE_CONVERSION";
            }
            case 45: {
                return "TRANSIENT_TO_NON_TRANSIENT";
            }
            case 46: {
                return "TYPE";
            }
            case 47: {
                return "TYPE_ARGUMENTS";
            }
            case 48: {
                return "TYPE_MEMBER";
            }
            case 49: {
                return "TYPE_PARAMETER";
            }
            case 50: {
                return "TYPE_PARAMETER_NAME";
            }
            case 51: {
                return "TYPE_PARAMETERS";
            }
            case 52: {
                return "TYPE_VISIBILITY";
            }
            case 53: {
                return "UNCHECKED_EXCEPTION";
            }
            case 54: {
                return "VALUE";
            }
            case 55: {
                return "VARARGS_TO_ARRAY";
            }
            case 37: {
                return "RESTRICTIONS";
            }
            case 56: {
                return "API_TYPE";
            }
            case 57: {
                return "NON_VOLATILE_TO_VOLATILE";
            }
            case 58: {
                return "VOLATILE_TO_NON_VOLATILE";
            }
            case 60: {
                return "MINOR_VERSION";
            }
            case 59: {
                return "MAJOR_VERSION";
            }
            case 61: {
                return "API_FIELD";
            }
            case 62: {
                return "API_METHOD";
            }
            case 63: {
                return "API_CONSTRUCTOR";
            }
            case 64: {
                return "API_ENUM_CONSTANT";
            }
            case 65: {
                return "API_METHOD_WITH_DEFAULT_VALUE";
            }
            case 66: {
                return "API_METHOD_WITHOUT_DEFAULT_VALUE";
            }
            case 68: {
                return "TYPE_ARGUMENT";
            }
            case 69: {
                return "SUPER_INTERFACE_WITH_METHODS";
            }
            case 71: {
                return "REEXPORTED_API_TYPE";
            }
            case 70: {
                return "REEXPORTED_TYPE";
            }
            case 67: {
                return "METHOD_MOVED_DOWN";
            }
            case 72: {
                return "DEPRECATION";
            }
        }
        return UNKNOWN_FLAGS;
    }

    public static String getDeltaKindName(IDelta delta) {
        return Util.getDeltaKindName(delta.getKind());
    }

    public static String getDeltaKindName(int kind) {
        switch (kind) {
            case 1: {
                return "ADDED";
            }
            case 2: {
                return "CHANGED";
            }
            case 3: {
                return "REMOVED";
            }
        }
        return UNKNOWN_KIND;
    }

    public static String getDeltaPrefererenceKey(int elementType, int kind, int flags) {
        StringBuffer buffer = new StringBuffer(Util.getDeltaElementType(elementType));
        buffer.append('_').append(Util.getDeltaKindName(kind));
        if (flags != -1) {
            buffer.append('_');
            switch (flags) {
                case 61: {
                    buffer.append(Util.getDeltaFlagsName(16));
                    break;
                }
                case 64: {
                    buffer.append(Util.getDeltaFlagsName(12));
                    break;
                }
                case 63: {
                    buffer.append(Util.getDeltaFlagsName(8));
                    break;
                }
                case 62: {
                    buffer.append(Util.getDeltaFlagsName(25));
                    break;
                }
                case 65: {
                    if (kind == 3) {
                        buffer.append(Util.getDeltaFlagsName(25));
                        break;
                    }
                    buffer.append(Util.getDeltaFlagsName(27));
                    break;
                }
                case 66: {
                    if (kind == 3) {
                        buffer.append(Util.getDeltaFlagsName(25));
                        break;
                    }
                    buffer.append(Util.getDeltaFlagsName(28));
                    break;
                }
                case 27: {
                    if (kind == 3) {
                        buffer.append(Util.getDeltaFlagsName(25));
                        break;
                    }
                    buffer.append(Util.getDeltaFlagsName(27));
                    break;
                }
                case 28: {
                    if (kind == 3) {
                        buffer.append(Util.getDeltaFlagsName(25));
                        break;
                    }
                    buffer.append(Util.getDeltaFlagsName(28));
                    break;
                }
                default: {
                    buffer.append(Util.getDeltaFlagsName(flags));
                }
            }
        }
        return String.valueOf(buffer);
    }

    public static String getDetail(IDelta delta) {
        StringBuffer buffer = new StringBuffer();
        switch (delta.getElementType()) {
            case 4: {
                buffer.append("class");
                break;
            }
            case 1: {
                buffer.append("annotation");
                break;
            }
            case 8: {
                buffer.append("interface");
                break;
            }
            case 2: {
                buffer.append("api component");
                break;
            }
            case 3: {
                buffer.append("api baseline");
                break;
            }
            case 9: {
                buffer.append("method");
                break;
            }
            case 5: {
                buffer.append("constructor");
                break;
            }
            case 6: {
                buffer.append("enum");
                break;
            }
            case 7: {
                buffer.append("field");
            }
        }
        buffer.append(' ');
        switch (delta.getKind()) {
            case 1: {
                buffer.append("added");
                break;
            }
            case 3: {
                buffer.append("removed");
                break;
            }
            case 2: {
                buffer.append("changed");
                break;
            }
            default: {
                buffer.append("unknown kind");
            }
        }
        buffer.append(' ').append(Util.getDeltaFlagsName(delta.getFlags())).append(' ').append(delta.getTypeName()).append("#").append(delta.getKey());
        return String.valueOf(buffer);
    }

    public static IDocument getDocument(ICompilationUnit cu) throws CoreException {
        IFile file;
        if (cu.getOwner() == null && (file = (IFile)cu.getResource()).exists()) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            IPath path = cu.getPath();
            bufferManager.connect(path, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            try {
                IDocument iDocument = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
                return iDocument;
            }
            finally {
                bufferManager.disconnect(path, LocationKind.IFILE, null);
            }
        }
        return new Document(cu.getSource());
    }

    public static Properties getEEProfile(String eeId) {
        InputStream stream;
        String profileName = String.valueOf(eeId) + ".profile";
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.pde.api.tools.internal.util.Util");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((stream = clazz.getResourceAsStream("profiles/" + profileName)) != null) {
            try {
                Properties profile = new Properties();
                profile.load(stream);
                Properties properties = profile;
                return properties;
            }
            catch (IOException e) {
                ApiPlugin.log(e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        return null;
    }

    public static final int getFragmentNumber(String version) {
        char[] charArray;
        int length;
        if (version == null) {
            throw new IllegalArgumentException("The given version should not be null");
        }
        int index = version.indexOf(32);
        if (index + 1 >= (length = (charArray = version.toCharArray()).length)) {
            return -1;
        }
        int counter = 1;
        int i = index + 1;
        while (i < length) {
            switch (charArray[i]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '.': {
                    ++counter;
                    break;
                }
                default: {
                    return -1;
                }
            }
            ++i;
        }
        return counter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IMember getIMember(IDelta delta, IJavaProject javaProject) {
        String typeName = delta.getTypeName();
        if (typeName == null) {
            return null;
        }
        IType type = null;
        try {
            type = javaProject.findType(typeName.replace('$', '.'));
        }
        catch (JavaModelException javaModelException) {}
        if (type == null) {
            return null;
        }
        String key = delta.getKey();
        switch (delta.getElementType()) {
            case 7: {
                IField field = type.getField(key);
                if (!field.exists()) return null;
                return field;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                switch (delta.getKind()) {
                    case 1: {
                        switch (delta.getFlags()) {
                            case 12: 
                            case 16: {
                                IField field = type.getField(key);
                                if (!field.exists()) return type;
                                return field;
                            }
                            case 8: 
                            case 25: 
                            case 27: 
                            case 28: {
                                return Util.getMethod(type, key);
                            }
                            case 48: {
                                IType type2 = type.getType(key);
                                if (!type2.exists()) return type;
                                return type2;
                            }
                        }
                        return type;
                    }
                    case 3: {
                        switch (delta.getFlags()) {
                            case 61: 
                            case 64: {
                                IField field = type.getField(key);
                                if (!field.exists()) return type;
                                return field;
                            }
                            case 62: 
                            case 63: 
                            case 65: 
                            case 66: {
                                return Util.getMethod(type, key);
                            }
                        }
                    }
                }
                return type;
            }
            case 5: 
            case 9: {
                return Util.getMethod(type, key);
            }
            case 2: {
                return type;
            }
        }
        return null;
    }

    public static void updateMonitor(IProgressMonitor monitor, int work) throws OperationCanceledException {
        if (monitor == null) {
            return;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.worked(work);
    }

    public static void updateMonitor(IProgressMonitor monitor) throws OperationCanceledException {
        Util.updateMonitor(monitor, 0);
    }

    private static IMember getMethod(IType type, String key) {
        int indexOfParen;
        boolean isGeneric = false;
        int indexOfTypeVariable = key.indexOf(60);
        int index = 0;
        if (indexOfTypeVariable == -1) {
            indexOfParen = key.indexOf(40);
            if (indexOfParen == -1) {
                return null;
            }
            index = indexOfParen;
        } else {
            indexOfParen = key.indexOf(40);
            if (indexOfParen == -1) {
                return null;
            }
            if (indexOfParen < indexOfTypeVariable) {
                index = indexOfParen;
            } else {
                index = indexOfTypeVariable;
                isGeneric = true;
            }
        }
        String selector = key.substring(0, index);
        String descriptor = key.substring(index, key.length());
        IMethod method = null;
        String signature = descriptor.replace('/', '.');
        String[] parameterTypes = null;
        if (isGeneric) {
            signature = signature.substring(signature.indexOf(40));
            parameterTypes = Signature.getParameterTypes((String)signature);
        } else {
            parameterTypes = Signature.getParameterTypes((String)signature);
        }
        try {
            method = type.getMethod(selector, parameterTypes);
        }
        catch (IllegalArgumentException e) {
            ApiPlugin.log(e);
        }
        if (method == null) {
            return null;
        }
        if (method.exists()) {
            return method;
        }
        if (selector.equals(type.getElementName()) && parameterTypes.length == 0) {
            return null;
        }
        IMethod[] methods = null;
        try {
            methods = type.getMethods();
        }
        catch (JavaModelException e) {
            ApiPlugin.log(e);
            ApiPlugin.log((IStatus)new Status(4, "org.eclipse.pde.api.tools", NLS.bind((String)UtilMessages.Util_6, (Object[])new String[]{selector, descriptor})));
            return null;
        }
        ArrayList<IMethod> list = new ArrayList<IMethod>();
        int i = 0;
        int max = methods.length;
        while (i < max) {
            IMethod method2 = methods[i];
            if (selector.equals(method2.getElementName())) {
                list.add(method2);
            }
            ++i;
        }
        switch (list.size()) {
            case 0: {
                ApiPlugin.log((IStatus)new Status(4, "org.eclipse.pde.api.tools", NLS.bind((String)UtilMessages.Util_6, (Object[])new String[]{selector, descriptor})));
                return null;
            }
            case 1: {
                return (IMember)list.get(0);
            }
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IMethod method2 = (IMethod)iterator.next();
            try {
                if (!Signatures.matchesSignatures(method2.getSignature(), signature)) continue;
                return method2;
            }
            catch (JavaModelException javaModelException) {}
        }
        ApiPlugin.log((IStatus)new Status(4, "org.eclipse.pde.api.tools", NLS.bind((String)UtilMessages.Util_6, (Object[])new String[]{selector, descriptor})));
        return null;
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        Charset charset = null;
        try {
            charset = Charset.forName(encoding);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            System.err.println("Illegal charset name : " + encoding);
            return null;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            System.err.println("Unsupported charset : " + encoding);
            return null;
        }
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] contents = Util.getInputStreamAsByteArray(stream, length);
        ByteBuffer byteBuffer = ByteBuffer.allocate(contents.length);
        byteBuffer.put(contents);
        byteBuffer.flip();
        CharBuffer charBuffer = charsetDecoder.decode(byteBuffer);
        charBuffer.compact();
        char[] array = charBuffer.array();
        int lengthToBe = charBuffer.position();
        if (array.length > lengthToBe) {
            char[] cArray = array;
            array = new char[lengthToBe];
            System.arraycopy(cArray, 0, array, 0, lengthToBe);
        }
        return array;
    }

    public static IResource getManifestFile(IProject currentProject) {
        return currentProject.findMember("META-INF/MANIFEST.MF");
    }

    public static boolean isApiProblemMarker(IMarker marker) {
        return marker.getAttribute("apiMarkerID", -1) > 0;
    }

    public static IReferenceTypeDescriptor getType(String fullyQualifiedName) {
        int index = fullyQualifiedName.lastIndexOf(46);
        String pkg = index == -1 ? "" : fullyQualifiedName.substring(0, index);
        String type = index == -1 ? fullyQualifiedName : fullyQualifiedName.substring(index + 1);
        return Factory.packageDescriptor(pkg).getType(type);
    }

    public static boolean isApiProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isJavaProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isApiProject(IJavaProject project) {
        return Util.isApiProject(project.getProject());
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isApiToolsComponent(IApiComponent apiComponent) {
        file = new File(apiComponent.getLocation());
        if (file.exists()) {
            if (file.isDirectory()) {
                apiDescription = new File(file, ".api_description");
                return apiDescription.exists();
            }
            zipFile = null;
            zipFile = new ZipFile(file);
            var4_4 = zipFile.getEntry(".api_description") != null;
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException v0) {}
            return var4_4;
            catch (ZipException v1) {
                ** try [egrp 2[TRYBLOCK] [6 : 88->89)] { 
lbl18:
                // 1 sources

                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException v2) {}
            }
            catch (IOException v3) {
                ** try [egrp 4[TRYBLOCK] [7 : 104->105)] { 
lbl-1000:
                // 3 sources

                {
                    catch (Throwable var3_5) {
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        }
                        catch (IOException v4) {}
                        throw var3_5;
                    }
                }
lbl34:
                // 1 sources

                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException v5) {}
            }
        }
        return false;
    }

    public static boolean isArchive(String fileName) {
        return Util.isZipJarFile(fileName) || Util.isTGZFile(fileName);
    }

    public static boolean isZipJarFile(String fileName) {
        String normalizedFileName = fileName.toLowerCase();
        return normalizedFileName.endsWith(DOT_ZIP) || normalizedFileName.endsWith(DOT_JAR);
    }

    public static boolean isTGZFile(String fileName) {
        String normalizedFileName = fileName.toLowerCase();
        return normalizedFileName.endsWith(DOT_TAR_GZ) || normalizedFileName.endsWith(DOT_TGZ);
    }

    public static boolean isClass(int accessFlags) {
        return (accessFlags & 0x6200) == 0;
    }

    public static boolean isClassFile(String fileName) {
        return fileName.toLowerCase().endsWith(DOT_CLASS_SUFFIX);
    }

    public static boolean isDefault(int accessFlags) {
        return (accessFlags & 7) == 0;
    }

    public static final boolean isDifferentVersion(String versionToBeChecked, String referenceVersion) {
        SinceTagVersion sinceTagVersion1 = null;
        SinceTagVersion sinceTagVersion2 = null;
        try {
            sinceTagVersion1 = new SinceTagVersion(versionToBeChecked);
            sinceTagVersion2 = new SinceTagVersion(referenceVersion);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        Version version1 = sinceTagVersion1.getVersion();
        Version version2 = sinceTagVersion2.getVersion();
        if (version1.getMajor() != version2.getMajor()) {
            return true;
        }
        if (version1.getMinor() != version2.getMinor()) {
            return true;
        }
        return version1.getMicro() != version2.getMicro();
    }

    public static boolean isJavaFileName(String fileName) {
        return fileName.toLowerCase().endsWith(DOT_JAVA_SUFFIX);
    }

    public static boolean isJavaLangObject(String name) {
        return name != null && name.equals(JAVA_LANG_OBJECT);
    }

    public static boolean isJavaLangRuntimeException(String name) {
        return name != null && name.equals(JAVA_LANG_RUNTIMEEXCEPTION);
    }

    public static boolean isVisible(int modifiers) {
        return Flags.isProtected((int)modifiers) || Flags.isPublic((int)modifiers);
    }

    public static boolean isBinaryProject(IProject project) {
        return WorkspaceModelManager.isBinaryProject((IProject)project);
    }

    public static org.w3c.dom.Document newDocument() throws CoreException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = dfactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Util.abort("Unable to create new XML document.", e);
        }
        org.w3c.dom.Document doc = docBuilder.newDocument();
        return doc;
    }

    /*
     * Exception decompiling
     */
    public static Element parseDocument(String document) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void saveFile(File file, String contents) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(contents);
            writer.flush();
        }
        catch (Throwable throwable) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String getFileContentAsString(File file) {
        String contents;
        block14: {
            contents = null;
            FileInputStream stream = null;
            try {
                try {
                    stream = new FileInputStream(file);
                    char[] array = Util.getInputStreamAsCharArray(stream, -1, "UTF-8");
                    contents = new String(array);
                }
                catch (IOException ioe) {
                    ApiPlugin.log(ioe);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return contents;
    }

    public static InputStream getInputStreamFromString(String string) {
        try {
            return new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            ApiPlugin.log(uee);
            return null;
        }
    }

    public static String serializeDocument(org.w3c.dom.Document document) throws CoreException {
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            return s.toString("UTF-8");
        }
        catch (TransformerException e) {
            Util.abort("Unable to serialize XML document.", e);
        }
        catch (IOException e) {
            Util.abort("Unable to serialize XML document.", e);
        }
        return null;
    }

    public static void unzip(String zipPath, String destDirPath) throws IOException {
        block18: {
            FileInputStream zipIn = new FileInputStream(zipPath);
            byte[] buf = new byte[8192];
            File destDir = new File(destDirPath);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(zipIn));
            FilterOutputStream outputStream = null;
            try {
                try {
                    ZipEntry zEntry;
                    while ((zEntry = zis.getNextEntry()) != null) {
                        if (zEntry.isDirectory()) {
                            new File(destDir, zEntry.getName()).mkdirs();
                            continue;
                        }
                        String filePath = zEntry.getName();
                        int lastSeparator = filePath.lastIndexOf("/");
                        String fileDir = "";
                        if (lastSeparator >= 0) {
                            fileDir = filePath.substring(0, lastSeparator);
                        }
                        new File(destDir, fileDir).mkdirs();
                        File outFile = new File(destDir, filePath);
                        outputStream = new BufferedOutputStream(new FileOutputStream(outFile));
                        int n = 0;
                        while ((n = zis.read(buf)) >= 0) {
                            ((BufferedOutputStream)outputStream).write(buf, 0, n);
                        }
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    try {
                        ((InputStream)zipIn).close();
                        zis.close();
                    }
                    catch (IOException iOException3) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)zipIn).close();
                    zis.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)zipIn).close();
                zis.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void guntar(String zipPath, String destDirPath) throws TarException, IOException {
        tarFile = new TarFile(zipPath);
        entries = tarFile.entries();
        buf = new byte[8192];
        ** GOTO lbl28
        {
            if (zEntry.getFileType() == 53) {
                new File(destDirPath, zEntry.getName()).mkdirs();
            } else {
                filePath = zEntry.getName();
                lastSeparator = filePath.lastIndexOf("/");
                fileDir = "";
                if (lastSeparator >= 0) {
                    fileDir = filePath.substring(0, lastSeparator);
                }
                new File(destDirPath, fileDir).mkdirs();
                outFile = new File(destDirPath, filePath);
                outputStream = new BufferedOutputStream(new FileOutputStream(outFile));
                n = 0;
                inputStream = tarFile.getInputStream(zEntry);
                stream = new BufferedInputStream(inputStream);
                while ((n = stream.read(buf)) >= 0) {
                    outputStream.write(buf, 0, n);
                }
                outputStream.close();
                stream.close();
            }
            do {
                if ((zEntry = (TarEntry)entries.nextElement()) != null) continue block0;
lbl28:
                // 2 sources

            } while (entries.hasMoreElements());
        }
    }

    public static File getEEDescriptionFile() {
        File fakeEEFile = null;
        PrintWriter writer = null;
        try {
            try {
                fakeEEFile = Util.createTempFile("eefile", ".ee");
                writer = new PrintWriter(new BufferedWriter(new FileWriter(fakeEEFile)));
                writer.print("-Djava.home=");
                writer.println(System.getProperty("java.home"));
                writer.print("-Dee.bootclasspath=");
                writer.println(Util.getJavaClassLibsAsString());
                writer.println("-Dee.language.level=1.6");
                writer.println("-Dee.class.library.level=JavaSE-1.6");
                writer.flush();
            }
            catch (IOException iOException) {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return fakeEEFile;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        file.deleteOnExit();
        FileManager.getManager().recordTempFileRoot(file.getCanonicalPath());
        return file;
    }

    public static String getJavaClassLibsAsString() {
        String[] libs = Util.getJavaClassLibs();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int max = libs.length;
        while (i < max) {
            if (i > 0) {
                buffer.append(File.pathSeparatorChar);
            }
            buffer.append(libs[i]);
            ++i;
        }
        return String.valueOf(buffer);
    }

    public static String[] getJavaClassLibs() {
        String bootclasspathProperty = System.getProperty("sun.boot.class.path");
        if (!(bootclasspathProperty != null && bootclasspathProperty.length() != 0 || (bootclasspathProperty = System.getProperty("vm.boot.class.path")) != null && bootclasspathProperty.length() != 0)) {
            bootclasspathProperty = System.getProperty("org.apache.harmony.boot.class.path");
        }
        String[] jars = null;
        if (bootclasspathProperty != null && bootclasspathProperty.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(bootclasspathProperty, File.pathSeparator);
            int size = tokenizer.countTokens();
            jars = new String[size];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                String fileName = Util.toNativePath(tokenizer.nextToken());
                if (!new File(fileName).exists()) continue;
                jars[i] = fileName;
                ++i;
            }
            if (size != i) {
                String[] stringArray = jars;
                jars = new String[i];
                System.arraycopy(stringArray, 0, jars, 0, i);
            }
        } else {
            String jreDir = System.getProperty("java.home");
            String osName = System.getProperty("os.name");
            if (jreDir == null) {
                return new String[0];
            }
            if (osName.startsWith("Mac")) {
                return new String[]{Util.toNativePath(String.valueOf(jreDir) + "/../Classes/classes.jar")};
            }
            String vmName = System.getProperty("java.vm.name");
            if ("J9".equals(vmName)) {
                return new String[]{Util.toNativePath(String.valueOf(jreDir) + "/lib/jclMax/classes.zip")};
            }
            String[] jarsNames = null;
            ArrayList paths = new ArrayList();
            if ("DRLVM".equals(vmName)) {
                FilenameFilter jarFilter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(Util.DOT_JAR) & !name.endsWith("-src.jar");
                    }
                };
                jarsNames = new File(String.valueOf(jreDir) + "/lib/boot/").list(jarFilter);
                Util.addJarEntries(String.valueOf(jreDir) + "/lib/boot/", jarsNames, paths);
            } else {
                jarsNames = new String[]{"/lib/vm.jar", "/lib/rt.jar", "/lib/core.jar", "/lib/security.jar", "/lib/xml.jar", "/lib/graphics.jar"};
                Util.addJarEntries(jreDir, jarsNames, paths);
            }
            jars = new String[paths.size()];
            paths.toArray(jars);
        }
        return jars;
    }

    public static String toNativePath(String path) {
        String nativePath = path.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        return nativePath.endsWith("/") || nativePath.endsWith("\\") ? nativePath.substring(0, nativePath.length() - 1) : nativePath;
    }

    private static void addJarEntries(String jreDir, String[] jarNames, ArrayList paths) {
        int i = 0;
        int max = jarNames.length;
        while (i < max) {
            String currentName = String.valueOf(jreDir) + jarNames[i];
            File f = new File(currentName);
            if (f.exists()) {
                paths.add(Util.toNativePath(currentName));
            }
            ++i;
        }
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            Util.flushDirectoryContent(file);
        }
        file.delete();
        if (Util.isFileDeleted(file)) {
            return true;
        }
        return Util.waitUntilFileDeleted(file);
    }

    public static void flushDirectoryContent(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        int max = files.length;
        while (i < max) {
            Util.delete(files[i]);
            ++i;
        }
    }

    private static boolean waitUntilFileDeleted(File file) {
        int count = 0;
        int delay = 10;
        int maxRetry = DELETE_MAX_WAIT / delay;
        int time = 0;
        while (count < maxRetry) {
            block8: {
                block7: {
                    ++count;
                    Thread.sleep(delay);
                    if ((time += delay) > DELETE_MAX_TIME) {
                        DELETE_MAX_TIME = time;
                    }
                    if (DELETE_DEBUG) {
                        System.out.print('.');
                    }
                    if (!file.exists() || !file.delete()) break block7;
                    return true;
                }
                if (!Util.isFileDeleted(file)) break block8;
                return true;
            }
            try {
                if (count < 10 || delay > 100) continue;
                count = 1;
                maxRetry = DELETE_MAX_WAIT / (delay *= 10);
                if (DELETE_MAX_WAIT % delay == 0) continue;
                ++maxRetry;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        System.err.println();
        System.err.println("\t!!! ERROR: " + file + " was never deleted even after having waited " + DELETE_MAX_TIME + "ms!!!");
        System.err.println();
        return false;
    }

    public static boolean isFileDeleted(File file) {
        return !file.exists() && Util.getParentChildFile(file) == null;
    }

    private static File getParentChildFile(File file) {
        int length;
        File parent = file.getParentFile();
        if (parent == null || !parent.exists()) {
            return null;
        }
        File[] files = parent.listFiles();
        int n = length = files == null ? 0 : files.length;
        if (length > 0) {
            int i = 0;
            while (i < length) {
                if (files[i] == file) {
                    return files[i];
                }
                if (files[i].equals(file)) {
                    return files[i];
                }
                if (files[i].getPath().equals(file.getPath())) {
                    return files[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static Set convertAsSet(String[] values) {
        HashSet<String> set = new HashSet<String>();
        if (values != null && values.length != 0) {
            int i = 0;
            int max = values.length;
            while (i < max) {
                set.add(values[i]);
                ++i;
            }
        }
        return set;
    }

    public static String getDeltaComponentVersionsId(IApiComponent component) {
        StringBuffer buffer = new StringBuffer(component.getSymbolicName());
        String version = component.getVersion();
        if (version != null) {
            buffer.append('(');
            try {
                Version version2 = new Version(version);
                buffer.append(version2.getMajor()).append('.').append(version2.getMinor()).append('.').append(version2.getMicro());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                buffer.append(version);
            }
            buffer.append(')');
        }
        return String.valueOf(buffer);
    }

    public static String getComponentVersionsId(IApiComponent component) {
        StringBuffer buffer = new StringBuffer(component.getSymbolicName());
        String version = component.getVersion();
        if (version != null) {
            buffer.append('_');
            try {
                Version version2 = new Version(version);
                buffer.append(version2.getMajor()).append('.').append(version2.getMinor()).append('.').append(version2.getMicro());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                buffer.append(version);
            }
        }
        return String.valueOf(buffer);
    }

    public static String getDescriptorName(IApiType descriptor) {
        String typeName = descriptor.getName();
        int index = typeName.lastIndexOf(36);
        if (index != -1) {
            return typeName.replace('$', '.');
        }
        return typeName;
    }

    public static String getDeltaArgumentString(IDelta delta) {
        String[] arguments = delta.getArguments();
        switch (delta.getFlags()) {
            case 46: 
            case 48: {
                return arguments[0];
            }
            case 8: 
            case 12: 
            case 16: 
            case 25: 
            case 27: 
            case 28: {
                return arguments[1];
            }
            case 22: {
                switch (delta.getElementType()) {
                    case 5: 
                    case 7: 
                    case 9: {
                        return arguments[1];
                    }
                }
                return arguments[0];
            }
        }
        return "";
    }

    public static String getApiElementType(int type) {
        switch (type) {
            case 3: {
                return "API_TYPE_CONTAINER";
            }
            case 7: {
                return "API_TYPE_ROOT";
            }
            case 4: {
                return "BASELINE";
            }
            case 1: {
                return "COMPONENT";
            }
            case 5: {
                return "FIELD";
            }
            case 6: {
                return "METHOD";
            }
            case 2: {
                return "TYPE";
            }
        }
        return "UNKNOWN";
    }

    public static boolean isConstructor(String referenceMemberName) {
        return Arrays.equals(ConstantPool.Init, referenceMemberName.toCharArray());
    }

    public static boolean isManifest(IPath path) {
        return MANIFEST_PROJECT_RELATIVE_PATH.equals((Object)path);
    }

    public static void touchCorrespondingResource(IProject project, IResource resource, String typeName) {
        if (typeName != null && typeName != "!global!") {
            if (Util.isManifest(resource.getProjectRelativePath())) {
                try {
                    IResource cuResource;
                    ICompilationUnit compilationUnit;
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IType findType = javaProject.findType(typeName);
                    if (findType != null && (compilationUnit = findType.getCompilationUnit()) != null && (cuResource = compilationUnit.getResource()) != null) {
                        cuResource.touch(null);
                    }
                }
                catch (JavaModelException e) {
                    ApiPlugin.log(e);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            } else {
                try {
                    resource.touch(null);
                }
                catch (CoreException e) {
                    ApiPlugin.log(e);
                }
            }
        }
    }

    public static String getTypeNameFromMarker(IMarker marker) {
        return marker.getAttribute("problemTypeName", null);
    }

    public static IApiComponent[] getReexportedComponents(IApiComponent component) {
        block6: {
            ArrayList<IApiComponent> reexportedComponents;
            block7: {
                IRequiredComponentDescription[] requiredComponents = component.getRequiredComponents();
                int length = requiredComponents.length;
                if (length == 0) break block6;
                reexportedComponents = null;
                IApiBaseline baseline = component.getBaseline();
                int i = 0;
                while (i < length) {
                    String id;
                    IApiComponent reexportedComponent;
                    IRequiredComponentDescription description = requiredComponents[i];
                    if (description.isExported() && (reexportedComponent = baseline.getApiComponent(id = description.getId())) != null) {
                        if (reexportedComponents == null) {
                            reexportedComponents = new ArrayList<IApiComponent>();
                        }
                        reexportedComponents.add(reexportedComponent);
                    }
                    ++i;
                }
                if (reexportedComponents != null && reexportedComponents.size() != 0) break block7;
                return null;
            }
            try {
                return reexportedComponents.toArray(new IApiComponent[reexportedComponents.size()]);
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
        return null;
    }

    public static IResource getResource(IProject project, IType type) {
        try {
            IResource resource;
            ICompilationUnit unit;
            if (type != null && (unit = type.getCompilationUnit()) != null && (resource = unit.getCorrespondingResource()) != null && resource.exists()) {
                return resource;
            }
        }
        catch (JavaModelException e) {
            ApiPlugin.log(e);
        }
        return Util.getManifestFile(project);
    }

    /*
     * Unable to fully structure code
     */
    public static FilteredElements initializeRegexFilterList(String location, IApiBaseline baseline, boolean debug) {
        block36: {
            excludedElements = new FilteredElements();
            if (location != null && (file = new File(location)).exists()) {
                block35: {
                    stream = null;
                    contents = null;
                    try {
                        stream = new BufferedInputStream(new FileInputStream(file));
                        contents = Util.getInputStreamAsCharArray(stream, -1, "ISO-8859-1");
                    }
                    catch (FileNotFoundException v0) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException v1) {}
                        }
                        break block35;
                    }
                    catch (IOException v2) {
                        try {
                            ** if (stream == null) goto lbl-1000
                        }
                        catch (Throwable var7_7) {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException v4) {}
                            }
                            throw var7_7;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                stream.close();
                            }
                            catch (IOException v3) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block35;
                        }
                    }
                    if (stream == null) break block35;
                    try {
                        stream.close();
                    }
                    catch (IOException v5) {}
                }
                if (contents != null) {
                    reader = new LineNumberReader(new StringReader(new String(contents)));
                    line = null;
                    try {
                        while ((line = reader.readLine().trim()) != null) {
                            if (line.startsWith("#") || line.length() == 0) continue;
                            if (line.startsWith("R:")) {
                                if (baseline == null) continue;
                                Util.collectRegexIds(line, excludedElements, baseline.getApiComponents(), debug);
                                continue;
                            }
                            excludedElements.addExactMatch(line);
                        }
                    }
                    catch (IOException v6) {
                        try {
                            reader.close();
                        }
                        catch (IOException v7) {}
                        break block36;
                    }
                    catch (Exception v8) {
                        try {}
                        catch (Throwable var9_10) {
                            try {
                                reader.close();
                            }
                            catch (IOException v9) {}
                            throw var9_10;
                        }
                        try {
                            reader.close();
                        }
                        catch (IOException v10) {}
                        break block36;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException v11) {}
                }
            }
        }
        return excludedElements;
    }

    public static void collectRegexIds(String line, FilteredElements excludedElements, IApiComponent[] components, boolean debug) throws Exception {
        if (line.startsWith(REGULAR_EXPRESSION_START)) {
            String componentname = line;
            componentname = componentname.substring(2);
            Pattern pattern = null;
            try {
                if (debug) {
                    System.out.println("Pattern to match : " + componentname);
                }
                pattern = Pattern.compile(componentname);
                String componentid = null;
                int j = 0;
                int max2 = components.length;
                while (j < max2) {
                    componentid = components[j].getSymbolicName();
                    if (debug) {
                        System.out.println("component id : " + componentid);
                    }
                    if (pattern.matcher(componentid).matches()) {
                        if (debug) {
                            System.out.println(String.valueOf(componentid) + " matched the pattern " + componentname);
                        }
                        excludedElements.addPartialMatch(componentid);
                    } else if (debug) {
                        System.out.println(String.valueOf(componentid) + " didn't match the pattern " + componentname);
                    }
                    ++j;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new Exception(NLS.bind((String)UtilMessages.comparison_invalidRegularExpression, (Object)componentname));
            }
        }
    }

    public static boolean isAPI(int visibility, IApiType typeDescriptor) {
        int access = typeDescriptor.getModifiers();
        return VisibilityModifiers.isAPI(visibility) && (Flags.isPublic((int)access) || Flags.isProtected((int)access));
    }

    public static String deepToString(Object[] array) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            buffer.append(array[i].toString());
            if (i < array.length - 1) {
                buffer.append(',');
            }
            ++i;
        }
        return buffer.toString();
    }

    private static final class BuildJob
    extends Job {
        private final IProject[] fProjects;
        private int fBuildType;

        BuildJob(String name, IProject[] projects) {
            this(name, projects, 6);
        }

        BuildJob(String name, IProject[] projects, int buildType) {
            super(name);
            this.fProjects = projects;
            this.fBuildType = buildType;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }

        public boolean isCoveredBy(BuildJob other) {
            if (other.fProjects == null) {
                return true;
            }
            if (this.fProjects != null) {
                int i = 0;
                int max = this.fProjects.length;
                while (i < max) {
                    if (!other.contains(this.fProjects[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public boolean contains(IProject project) {
            if (project == null) {
                return false;
            }
            int i = 0;
            int max = this.fProjects.length;
            while (i < max) {
                if (project.equals((Object)this.fProjects[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.cancelBuild(ResourcesPlugin.FAMILY_MANUAL_BUILD);
            }
            try {
                try {
                    if (this.fProjects != null) {
                        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)UtilMessages.Util_0, (int)this.fProjects.length);
                        int i = 0;
                        int max = this.fProjects.length;
                        while (i < max) {
                            IProject currentProject = this.fProjects[i];
                            if (this.fBuildType == 6) {
                                BuildState.setLastBuiltState(currentProject, null);
                            }
                            localmonitor.subTask(NLS.bind((String)UtilMessages.Util_5, (Object)currentProject.getName()));
                            if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                                currentProject.touch(null);
                            } else {
                                currentProject.build(10, (IProgressMonitor)localmonitor.newChild(1));
                            }
                            ++i;
                        }
                    }
                }
                catch (CoreException e) {
                    Status status = new Status(e.getStatus().getSeverity(), "org.eclipse.pde.api.tools", 120, UtilMessages.Util_builder_errorMessage, (Throwable)e);
                    monitor.done();
                    return status;
                }
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        private void cancelBuild(Object jobfamily) {
            Job[] buildJobs = Job.getJobManager().find(jobfamily);
            int i = 0;
            while (i < buildJobs.length) {
                BuildJob job;
                Job curr = buildJobs[i];
                if (curr != this && curr instanceof BuildJob && (job = (BuildJob)curr).isCoveredBy(this)) {
                    curr.cancel();
                }
                ++i;
            }
        }
    }
}

