/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public class Path
extends Resource {
    public NSBezierPath handle;
    boolean closed = true;

    public Path(Device device) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle = NSBezierPath.bezierPath();
            if (this.handle == null) {
                SWT.error(2);
            }
            this.handle.retain();
            this.handle.moveToPoint(new NSPoint());
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Path(Device device, Path path, float flatness) {
        super(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (path == null) {
                SWT.error(4);
            }
            if (path.isDisposed()) {
                SWT.error(5);
            }
            if ((flatness = Math.max(0.0f, flatness)) == 0.0f) {
                this.handle = new NSBezierPath(path.handle.copy().id);
            } else {
                float defaultFlatness = NSBezierPath.defaultFlatness();
                NSBezierPath.setDefaultFlatness(flatness);
                this.handle = path.handle.bezierPathByFlatteningPath();
                this.handle.retain();
                NSBezierPath.setDefaultFlatness(defaultFlatness);
            }
            if (this.handle == null) {
                SWT.error(2);
            }
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Path(Device device, PathData data) {
        this(device);
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (data == null) {
                SWT.error(4);
            }
            this.init(data);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void addArc(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.translateXBy(x + width / 2.0f, y + height / 2.0f);
            transform.scaleXBy(width / 2.0f, height / 2.0f);
            NSBezierPath path = NSBezierPath.bezierPath();
            NSPoint center = new NSPoint();
            float sAngle = -startAngle;
            float eAngle = -(startAngle + arcAngle);
            path.appendBezierPathWithArcWithCenter(center, 1.0f, sAngle, eAngle, arcAngle > 0.0f);
            path.transformUsingAffineTransform(transform);
            this.appendBezierPath(path);
            this.closed = Math.abs(arcAngle) >= 360.0f;
            if (this.closed) {
                this.handle.closePath();
            }
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    void appendBezierPath(NSBezierPath path) {
        int count = path.elementCount();
        int points = OS.malloc(3 * NSPoint.sizeof);
        if (points == 0) {
            SWT.error(2);
        }
        NSPoint pt1 = new NSPoint();
        NSPoint pt2 = new NSPoint();
        NSPoint pt3 = new NSPoint();
        int i = 0;
        while (i < count) {
            int element = path.elementAtIndex(i, points);
            switch (element) {
                case 0: {
                    OS.memmove(pt1, points, NSPoint.sizeof);
                    if (this.closed) {
                        this.handle.moveToPoint(pt1);
                        break;
                    }
                    this.handle.lineToPoint(pt1);
                    break;
                }
                case 1: {
                    OS.memmove(pt1, points, NSPoint.sizeof);
                    this.handle.lineToPoint(pt1);
                    this.closed = false;
                    break;
                }
                case 2: {
                    OS.memmove(pt1, points, NSPoint.sizeof);
                    OS.memmove(pt2, points + NSPoint.sizeof, NSPoint.sizeof);
                    OS.memmove(pt3, points + NSPoint.sizeof + NSPoint.sizeof, NSPoint.sizeof);
                    this.handle.curveToPoint(pt3, pt1, pt2);
                    this.closed = false;
                    break;
                }
                case 3: {
                    this.handle.closePath();
                    this.closed = true;
                }
            }
            ++i;
        }
        OS.free(points);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.appendBezierPath(path.handle);
            this.closed = path.closed;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void addRectangle(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSRect rect = new NSRect();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.appendBezierPathWithRect(rect);
            this.closed = true;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void addString(String string, float x, float y, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.closed = true;
            NSString str = NSString.stringWith(string);
            NSTextStorage textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            NSLayoutManager layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            NSTextContainer textContainer = (NSTextContainer)new NSTextContainer().alloc();
            NSSize size = new NSSize();
            size.width = 5000000.0f;
            size.height = 5000000.0f;
            textContainer.initWithContainerSize(size);
            textStorage.addLayoutManager(layoutManager);
            layoutManager.addTextContainer(textContainer);
            NSRange range = new NSRange();
            range.length = str.length();
            NSMutableAttributedString attrStr = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
            attrStr.id = attrStr.initWithString((NSString)str).id;
            attrStr.beginEditing();
            attrStr.addAttribute(OS.NSFontAttributeName, font.handle, range);
            font.addTraits(attrStr, range);
            attrStr.endEditing();
            textStorage.setAttributedString(attrStr);
            attrStr.release();
            range = layoutManager.glyphRangeForTextContainer(textContainer);
            if (range.length != 0) {
                int glyphs = OS.malloc(4 * range.length * 2);
                layoutManager.getGlyphs(glyphs, range);
                NSBezierPath path = NSBezierPath.bezierPath();
                NSPoint point = new NSPoint();
                path.moveToPoint(point);
                path.appendBezierPathWithGlyphs(glyphs, range.length, font.handle);
                NSAffineTransform transform = NSAffineTransform.transform();
                transform.scaleXBy(1.0f, -1.0f);
                float baseline = layoutManager.defaultBaselineOffsetForFont(font.handle);
                transform.translateXBy(x, -(y + baseline));
                path.transformUsingAffineTransform(transform);
                OS.free(glyphs);
                this.handle.appendBezierPath(path);
            }
            textContainer.release();
            layoutManager.release();
            textStorage.release();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.handle.closePath();
            this.closed = true;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public boolean contains(float x, float y, GC gc, boolean outline) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (outline) {
                int pixel = OS.malloc(4);
                if (pixel == 0) {
                    SWT.error(2);
                }
                int[] buffer = new int[]{-1};
                OS.memmove(pixel, buffer, 4);
                int colorspace = OS.CGColorSpaceCreateDeviceRGB();
                int context = OS.CGBitmapContextCreate(pixel, 1, 1, 8, 4, colorspace, 6);
                OS.CGColorSpaceRelease(colorspace);
                if (context == 0) {
                    OS.free(pixel);
                    SWT.error(2);
                }
                GCData data = gc.data;
                int capStyle = 0;
                switch (data.lineCap) {
                    case 2: {
                        capStyle = 1;
                        break;
                    }
                    case 1: {
                        capStyle = 0;
                        break;
                    }
                    case 3: {
                        capStyle = 2;
                    }
                }
                OS.CGContextSetLineCap(context, capStyle);
                int joinStyle = 0;
                switch (data.lineJoin) {
                    case 1: {
                        joinStyle = 0;
                        break;
                    }
                    case 2: {
                        joinStyle = 1;
                        break;
                    }
                    case 3: {
                        joinStyle = 2;
                    }
                }
                OS.CGContextSetLineJoin(context, joinStyle);
                OS.CGContextSetLineWidth(context, data.lineWidth);
                OS.CGContextTranslateCTM(context, -x + 0.5f, -y + 0.5f);
                int path = GC.createCGPathRef(this.handle);
                OS.CGContextAddPath(context, path);
                OS.CGPathRelease(path);
                OS.CGContextStrokePath(context);
                OS.CGContextRelease(context);
                OS.memmove(buffer, pixel, 4);
                OS.free(pixel);
                boolean bl = buffer[0] != -1;
                return bl;
            }
            NSPoint point = new NSPoint();
            point.x = x;
            point.y = y;
            boolean bl = this.handle.containsPoint(point);
            return bl;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void cubicTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint pt = new NSPoint();
            pt.x = x;
            pt.y = y;
            NSPoint ct1 = new NSPoint();
            ct1.x = cx1;
            ct1.y = cy1;
            NSPoint ct2 = new NSPoint();
            ct2.x = cx2;
            ct2.y = cy2;
            this.handle.curveToPoint(pt, ct1, ct2);
            this.closed = false;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    void destroy() {
        this.handle.release();
        this.handle = null;
    }

    public void getBounds(float[] bounds) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        if (bounds.length < 4) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSRect rect = this.handle.controlPointBounds();
            bounds[0] = rect.x;
            bounds[1] = rect.y;
            bounds[2] = rect.width;
            bounds[3] = rect.height;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void getCurrentPoint(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint pt = this.handle.currentPoint();
            point[0] = pt.x;
            point[1] = pt.y;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int count = this.handle.elementCount();
            int pointCount = 0;
            int typeCount = 0;
            byte[] types = new byte[count];
            float[] pointArray = new float[count * 6];
            int points = OS.malloc(3 * NSPoint.sizeof);
            if (points == 0) {
                SWT.error(2);
            }
            NSPoint pt = new NSPoint();
            int i = 0;
            while (i < count) {
                int element = this.handle.elementAtIndex(i, points);
                switch (element) {
                    case 0: {
                        types[typeCount++] = 1;
                        OS.memmove(pt, points, NSPoint.sizeof);
                        pointArray[pointCount++] = pt.x;
                        pointArray[pointCount++] = pt.y;
                        break;
                    }
                    case 1: {
                        types[typeCount++] = 2;
                        OS.memmove(pt, points, NSPoint.sizeof);
                        pointArray[pointCount++] = pt.x;
                        pointArray[pointCount++] = pt.y;
                        break;
                    }
                    case 2: {
                        types[typeCount++] = 4;
                        OS.memmove(pt, points, NSPoint.sizeof);
                        pointArray[pointCount++] = pt.x;
                        pointArray[pointCount++] = pt.y;
                        OS.memmove(pt, points + NSPoint.sizeof, NSPoint.sizeof);
                        pointArray[pointCount++] = pt.x;
                        pointArray[pointCount++] = pt.y;
                        OS.memmove(pt, points + NSPoint.sizeof + NSPoint.sizeof, NSPoint.sizeof);
                        pointArray[pointCount++] = pt.x;
                        pointArray[pointCount++] = pt.y;
                        break;
                    }
                    case 3: {
                        types[typeCount++] = 5;
                    }
                }
                ++i;
            }
            OS.free(points);
            if (pointCount != pointArray.length) {
                float[] temp = new float[pointCount];
                System.arraycopy(pointArray, 0, temp, 0, pointCount);
                pointArray = temp;
            }
            PathData data = new PathData();
            data.types = types;
            data.points = pointArray;
            PathData pathData = data;
            return pathData;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    void init(PathData data) {
        byte[] types = data.types;
        float[] points = data.points;
        int i = 0;
        int j = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: {
                    this.moveTo(points[j++], points[j++]);
                    break;
                }
                case 2: {
                    this.lineTo(points[j++], points[j++]);
                    break;
                }
                case 4: {
                    this.cubicTo(points[j++], points[j++], points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 3: {
                    this.quadTo(points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 5: {
                    this.close();
                    break;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
            ++i;
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public void lineTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint pt = new NSPoint();
            pt.x = x;
            pt.y = y;
            this.handle.lineToPoint(pt);
            this.closed = false;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void moveTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint pt = new NSPoint();
            pt.x = x;
            pt.y = y;
            this.handle.moveToPoint(pt);
            this.closed = true;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void quadTo(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSPoint current = this.handle.isEmpty() ? new NSPoint() : this.handle.currentPoint();
            NSPoint ct1 = new NSPoint();
            ct1.x = current.x + 2.0f * (cx - current.x) / 3.0f;
            ct1.y = current.y + 2.0f * (cy - current.y) / 3.0f;
            NSPoint ct2 = new NSPoint();
            ct2.x = ct1.x + (x - current.x) / 3.0f;
            ct2.y = ct1.y + (y - current.y) / 3.0f;
            NSPoint pt = new NSPoint();
            pt.x = x;
            pt.y = y;
            this.handle.curveToPoint(pt, ct1, ct2);
            this.closed = false;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

