/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSComboBox;
import org.eclipse.swt.internal.cocoa.NSComboBoxCell;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableString;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTComboBox;
import org.eclipse.swt.internal.cocoa.SWTPopUpButton;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    String text;
    int textLimit = LIMIT;
    boolean receivingFocus;
    boolean ignoreSetObject;
    boolean ignoreSelection;
    NSRange selectionRange;
    boolean listVisible;
    static final int VISIBLE_COUNT = 5;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        NSAttributedString str = this.createString(string);
        if ((this.style & 8) != 0) {
            NSPopUpButton widget = (NSPopUpButton)this.view;
            int selection = widget.indexOfSelectedItem();
            NSMenu nsMenu = widget.menu();
            NSMenuItem nsItem = (NSMenuItem)new NSMenuItem().alloc();
            NSString empty = NSString.string();
            nsItem.initWithTitle(empty, 0, empty);
            nsItem.setAttributedTitle(str);
            nsMenu.addItem(nsItem);
            nsItem.release();
            if (selection == -1) {
                widget.selectItemAtIndex(-1);
            }
        } else {
            ((NSComboBox)this.view).addItemWithObjectValue(str);
        }
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (index < 0 || index > count) {
            this.error(6);
        }
        NSAttributedString str = this.createString(string);
        if ((this.style & 8) != 0) {
            NSPopUpButton widget = (NSPopUpButton)this.view;
            int selection = widget.indexOfSelectedItem();
            NSMenu nsMenu = widget.menu();
            NSMenuItem nsItem = (NSMenuItem)new NSMenuItem().alloc();
            NSString empty = NSString.string();
            nsItem.initWithTitle(empty, 0, empty);
            nsItem.setAttributedTitle(str);
            nsMenu.insertItem(nsItem, index);
            nsItem.release();
            if (selection == -1) {
                widget.selectItemAtIndex(-1);
            }
        } else {
            ((NSComboBox)this.view).insertItemWithObjectValue(str, index);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    boolean becomeFirstResponder(int id2, int sel) {
        this.receivingFocus = true;
        boolean result = super.becomeFirstResponder(id2, sel);
        this.receivingFocus = false;
        return result;
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Combo.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            Point selection = this.getSelection();
            selection.y = selection.x;
            this.setSelection(selection);
        }
    }

    void setObjectValue(int id2, int sel, int arg0) {
        super.setObjectValue(id2, sel, this.ignoreSetObject ? arg0 : this.createString((String)this.text).id);
    }

    void comboBoxSelectionDidChange(int id2, int sel, int notification) {
        NSComboBox widget = (NSComboBox)this.view;
        int tableSelection = widget.indexOfSelectedItem();
        widget.selectItemAtIndex(tableSelection);
        NSAttributedString attStr = new NSAttributedString(widget.itemObjectValueAtIndex(tableSelection));
        NSString nsString = attStr.string();
        if (nsString != null) {
            this.setText(nsString.getString(), true);
        }
        if (!this.ignoreSelection) {
            this.sendSelectionEvent(13, null, this.display.trackingControl != this);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        NSControl widget = (NSControl)this.view;
        NSCell viewCell = widget.cell();
        NSSize size = viewCell.cellSize();
        width = (int)Math.ceil(size.width);
        height = (int)Math.ceil(size.height);
        if ((this.style & 8) == 0) {
            this.ignoreSetObject = true;
            NSComboBoxCell cell = new NSComboBoxCell(viewCell.id);
            NSArray array = cell.objectValues();
            int length = array.count();
            if (length > 0) {
                cell = new NSComboBoxCell(cell.copy());
                int i = 0;
                while (i < length) {
                    NSAttributedString attStr = new NSAttributedString(array.objectAtIndex(i));
                    cell.setAttributedStringValue(attStr);
                    size = cell.cellSize();
                    width = Math.max(width, (int)Math.ceil(size.width));
                    ++i;
                }
                cell.release();
            }
            this.ignoreSetObject = false;
        }
        if (hHint != -1 && ((this.style & 8) != 0 || hHint < height)) {
            height = hHint;
        }
        if (wHint != -1) {
            width = wHint;
        }
        return new Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        Point selection = this.getSelection();
        if (selection.x == selection.y) {
            return;
        }
        this.copyToClipboard(this.getText(selection.x, selection.y));
    }

    void createHandle() {
        if ((this.style & 8) != 0) {
            NSPopUpButton widget = (NSPopUpButton)new SWTPopUpButton().alloc();
            widget.initWithFrame(new NSRect(), false);
            widget.menu().setAutoenablesItems(false);
            widget.setTarget(widget);
            widget.setAction(OS.sel_sendSelection);
            widget.menu().setDelegate(widget);
            this.view = widget;
        } else {
            NSComboBox widget = (NSComboBox)new SWTComboBox().alloc();
            widget.init();
            widget.setDelegate(widget);
            this.view = widget;
        }
    }

    NSAttributedString createString(String string) {
        NSAttributedString attribStr = this.createString(string, null, this.foreground, 16384, false, true, false);
        attribStr.autorelease();
        return attribStr;
    }

    void createWidget() {
        this.text = "";
        super.createWidget();
        if ((this.style & 8) == 0) {
            NSComboBox widget = (NSComboBox)this.view;
            NSScreen screen = widget.window().screen();
            NSRect rect = screen != null ? screen.frame() : NSScreen.mainScreen().frame();
            int visibleCount = Math.max(5, (int)(rect.height / 3.0f / widget.itemHeight()));
            widget.setNumberOfVisibleItems(visibleCount);
        }
    }

    void comboBoxWillDismiss(int id2, int sel, int notification) {
        this.listVisible = false;
    }

    void comboBoxWillPopUp(int id2, int sel, int notification) {
        this.listVisible = true;
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point selection = this.getSelection();
        if (selection.x == selection.y) {
            return;
        }
        int start = selection.x;
        int end = selection.y;
        String text = this.getText();
        String leftText = text.substring(0, start);
        String rightText = text.substring(end, text.length());
        String oldText = text.substring(start, end);
        String newText = "";
        if ((this.hooks(25) || this.filters(25)) && (newText = this.verifyText(newText, start, end, null)) == null) {
            return;
        }
        char[] buffer = new char[oldText.length()];
        oldText.getChars(0, buffer.length, buffer, 0);
        this.copyToClipboard(buffer);
        this.setText(String.valueOf(leftText) + newText + rightText, false);
        this.setSelection(new Point(start += newText.length(), start));
        this.sendEvent(24);
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        if ((this.style & 8) != 0) {
            return this.display.popUpButtonFont;
        }
        return this.display.comboBoxFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(((NSControl)this.view).cell());
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
        if (index == this.getSelectionIndex()) {
            if ((this.style & 8) != 0) {
                ((NSPopUpButton)this.view).selectItem(null);
                this.sendEvent(24);
            } else {
                ((NSComboBox)this.view).deselectItemAtIndex(index);
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).selectItem(null);
            this.sendEvent(24);
        } else {
            NSComboBox widget = (NSComboBox)this.view;
            int index = widget.indexOfSelectedItem();
            if (index != -1) {
                widget.deselectItemAtIndex(index);
            }
        }
    }

    boolean dragDetect(int x, int y, boolean filter, boolean[] consume) {
        if ((this.style & 8) == 0) {
            NSText fieldEditor = ((NSControl)this.view).currentEditor();
            if (fieldEditor != null) {
                NSRange selectedRange = fieldEditor.selectedRange();
                if (selectedRange.length > 0) {
                    NSTextView feAsTextView = new NSTextView(fieldEditor);
                    NSPoint textViewMouse = new NSPoint();
                    textViewMouse.x = x;
                    textViewMouse.y = y;
                    int charPosition = feAsTextView.characterIndexForInsertionAtPoint(textViewMouse);
                    if (charPosition != Integer.MAX_VALUE && charPosition >= selectedRange.location && charPosition < selectedRange.location + selectedRange.length && super.dragDetect(x, y, filter, consume)) {
                        if (consume != null) {
                            consume[0] = true;
                        }
                        return true;
                    }
                }
            }
            return false;
        }
        return super.dragDetect(x, y, filter, consume);
    }

    int getCharCount() {
        NSString str = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).titleOfSelectedItem() : new NSCell(((NSComboBox)this.view).cell()).title();
        if (str == null) {
            return 0;
        }
        return str.length();
    }

    public String getItem(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        NSString str = null;
        if ((this.style & 8) != 0) {
            str = ((NSPopUpButton)this.view).itemTitleAtIndex(index);
        } else {
            NSAttributedString attString = new NSAttributedString(((NSComboBox)this.view).itemObjectValueAtIndex(index));
            if (attString != null) {
                str = attString.string();
            }
        }
        if (str == null) {
            this.error(8);
        }
        return str.getString();
    }

    public int getItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return ((NSPopUpButton)this.view).numberOfItems();
        }
        return ((NSComboBox)this.view).numberOfItems();
    }

    public int getItemHeight() {
        this.checkWidget();
        return 26;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.getItem(i);
            ++i;
        }
        return result;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.listVisible;
    }

    String getNameText() {
        return this.getText();
    }

    int getMininumHeight() {
        return this.getTextHeight();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, this.getCharCount());
        }
        if (this.selectionRange == null) {
            NSString str = new NSTextFieldCell(((NSTextField)this.view).cell()).title();
            return new Point(str.length(), str.length());
        }
        return new Point(this.selectionRange.location, this.selectionRange.location + this.selectionRange.length);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return ((NSPopUpButton)this.view).indexOfSelectedItem();
        }
        return ((NSComboBox)this.view).indexOfSelectedItem();
    }

    public String getText() {
        this.checkWidget();
        return new String(this.getText(0, -1));
    }

    char[] getText(int start, int end) {
        NSString str = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).titleOfSelectedItem() : new NSCell(((NSComboBox)this.view).cell()).title();
        if (str == null) {
            return new char[0];
        }
        NSRange range = new NSRange();
        range.location = start;
        if (end == -1) {
            int length = str.length();
            range.length = length - start;
        } else {
            range.length = end - start;
        }
        char[] buffer = new char[range.length];
        str.getCharacters(buffer, range);
        return buffer;
    }

    public int getTextHeight() {
        this.checkWidget();
        NSCell cell = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).cell() : ((NSComboBox)this.view).cell();
        return (int)cell.cellSize().height;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return this.getItemCount();
        }
        return ((NSComboBox)this.view).numberOfVisibleItems();
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (start < 0 || start >= count) {
            return -1;
        }
        int i = start;
        while (i < count) {
            if (string.equals(this.getItem(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    boolean isEventView(int id2) {
        return true;
    }

    void menuWillOpen(int id2, int sel, int menu) {
        this.listVisible = true;
    }

    void menuDidClose(int id2, int sel, int menu) {
        this.listVisible = false;
    }

    void mouseDown(int id2, int sel, int theEvent) {
        NSView viewCopy = this.view;
        viewCopy.retain();
        super.mouseDown(id2, sel, theEvent);
        viewCopy.release();
    }

    public void paste() {
        int charCount;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point selection = this.getSelection();
        int start = selection.x;
        int end = selection.y;
        String text = this.getText();
        String leftText = text.substring(0, start);
        String rightText = text.substring(end, text.length());
        String newText = this.getClipboardText();
        if (newText == null) {
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (newText = this.verifyText(newText, start, end, null)) == null) {
            return;
        }
        if (this.textLimit != LIMIT && (charCount = text.length()) - (end - start) + newText.length() > this.textLimit) {
            newText = newText.substring(0, this.textLimit - charCount + (end - start));
        }
        this.setText(String.valueOf(leftText) + newText + rightText, false);
        this.setSelection(new Point(start += newText.length(), start));
        this.sendEvent(24);
    }

    void register() {
        super.register();
        this.display.addWidget(((NSControl)this.view).cell(), this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if ((this.style & 8) == 0) {
            ((NSControl)this.view).abortEditing();
        }
        this.text = null;
        this.selectionRange = null;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index == -1) {
            this.error(6);
        }
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).removeItemAtIndex(index);
        } else {
            ((NSComboBox)this.view).removeItemAtIndex(index);
        }
    }

    public void remove(int start, int end) {
        int newEnd;
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int i = newEnd = Math.min(end, count - 1);
        while (i >= start) {
            this.remove(i);
            --i;
        }
    }

    public void remove(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        this.ignoreSelection = true;
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).removeAllItems();
        } else {
            this.setText("", true);
            ((NSComboBox)this.view).removeAllItems();
        }
        this.ignoreSelection = false;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void select(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        this.ignoreSelection = true;
        if (index >= 0 && index < count) {
            if ((this.style & 8) != 0) {
                ((NSPopUpButton)this.view).selectItemAtIndex(index);
                this.sendEvent(24);
            } else {
                NSComboBox widget = (NSComboBox)this.view;
                widget.deselectItemAtIndex(index);
                widget.selectItemAtIndex(index);
            }
        }
        this.ignoreSelection = false;
    }

    void sendSelection() {
        this.sendEvent(24);
        if (!this.ignoreSelection) {
            this.sendSelectionEvent(13);
        }
    }

    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        boolean result = super.sendKeyEvent(nsEvent, type);
        if (!result) {
            return result;
        }
        int stateMask = 0;
        int modifierFlags = nsEvent.modifierFlags();
        if ((modifierFlags & 0x80000) != 0) {
            stateMask |= 0x10000;
        }
        if ((modifierFlags & 0x20000) != 0) {
            stateMask |= 0x20000;
        }
        if ((modifierFlags & 0x40000) != 0) {
            stateMask |= 0x40000;
        }
        if ((modifierFlags & 0x100000) != 0) {
            stateMask |= 0x400000;
        }
        if (type != 1) {
            return result;
        }
        short keyCode = nsEvent.keyCode();
        if (stateMask == 0x400000) {
            switch (keyCode) {
                case 7: {
                    this.cut();
                    return false;
                }
                case 8: {
                    this.copy();
                    return false;
                }
                case 9: {
                    this.paste();
                    return false;
                }
                case 0: {
                    if ((this.style & 8) != 0) break;
                    ((NSComboBox)this.view).selectText(null);
                    return false;
                }
            }
        }
        switch (keyCode) {
            case 36: 
            case 76: {
                this.sendSelectionEvent(14);
            }
        }
        return result;
    }

    void setBackgroundColor(NSColor nsColor) {
        if ((this.style & 8) == 0) {
            ((NSTextField)this.view).setBackgroundColor(nsColor);
        }
    }

    void setBackgroundImage(NSImage image) {
    }

    void setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        if ((this.style & 8) == 0) {
            NSControl widget = (NSControl)this.view;
            NSSize size = widget.cell().cellSize();
            height = Math.min(height, (int)Math.ceil(size.height));
        }
        super.setBounds(x, y, width, height, move, resize);
    }

    void setFont(NSFont font) {
        super.setFont(font);
        this.updateItems();
    }

    void setForeground(float[] color) {
        super.setForeground(color);
        this.updateItems();
        if ((this.style & 8) == 0) {
            NSColor nsColor = color == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(color[0], color[1], color[2], 1.0f);
            ((NSTextField)this.view).setTextColor(nsColor);
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        int selection = this.getSelectionIndex();
        NSAttributedString str = this.createString(string);
        this.ignoreSelection = true;
        if ((this.style & 8) != 0) {
            NSMenuItem nsItem = ((NSPopUpButton)this.view).itemAtIndex(index);
            nsItem.setAttributedTitle(str);
            if (string.length() == 0) {
                nsItem.setTitle(NSString.string());
            }
        } else {
            NSComboBox widget = (NSComboBox)this.view;
            widget.insertItemWithObjectValue(str, index);
            widget.removeItemAtIndex(index + 1);
        }
        if (selection != -1) {
            this.select(selection);
        }
        this.ignoreSelection = false;
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                this.error(5);
            }
            ++i;
        }
        this.removeAll();
        if (items.length == 0) {
            return;
        }
        this.ignoreSelection = true;
        i = 0;
        while (i < items.length) {
            NSAttributedString str = this.createString(items[i]);
            if ((this.style & 8) != 0) {
                NSMenu nsMenu = ((NSPopUpButton)this.view).menu();
                NSMenuItem nsItem = (NSMenuItem)new NSMenuItem().alloc();
                NSString empty = NSString.string();
                nsItem.initWithTitle(empty, 0, empty);
                nsItem.setAttributedTitle(str);
                nsMenu.addItem(nsItem);
                nsItem.release();
                ((NSPopUpButton)this.view).selectItemAtIndex(-1);
            } else {
                ((NSComboBox)this.view).addItemWithObjectValue(str);
            }
            ++i;
        }
        this.ignoreSelection = false;
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).setPullsDown(visible);
        }
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    void setOrientation() {
        int direction = (this.style & 0x4000000) != 0 ? 1 : 0;
        ((NSControl)this.view).setBaseWritingDirection(direction);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        if ((this.style & 8) == 0) {
            NSComboBox widget = (NSComboBox)this.view;
            NSString str = new NSCell(widget.cell()).title();
            int length = str.length();
            int start = Math.min(Math.max(Math.min(selection.x, selection.y), 0), length);
            int end = Math.min(Math.max(Math.max(selection.x, selection.y), 0), length);
            this.selectionRange = new NSRange();
            this.selectionRange.location = start;
            this.selectionRange.length = end - start;
            NSText fieldEditor = widget.currentEditor();
            if (fieldEditor != null) {
                fieldEditor.setSelectedRange(this.selectionRange);
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.setText(string, true);
    }

    void setText(String string, boolean notify) {
        if (notify && (this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index != -1 && index != this.getSelectionIndex()) {
                this.select(index);
                if (notify) {
                    this.sendEvent(24);
                }
            }
        } else {
            char[] buffer = new char[Math.min(string.length(), this.textLimit)];
            string.getChars(0, buffer.length, buffer, 0);
            this.text = new String(buffer, 0, buffer.length);
            ((NSComboBox)this.view).cell().setAttributedStringValue(this.createString(this.text));
            if (notify) {
                this.sendEvent(24);
            }
        }
        this.selectionRange = null;
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        this.textLimit = limit;
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        if ((this.style & 8) == 0) {
            ((NSComboBox)this.view).setNumberOfVisibleItems(count);
        }
    }

    boolean shouldChangeTextInRange_replacementString(int id2, int sel, int affectedCharRange, int replacementString) {
        NSRange range = new NSRange();
        OS.memmove(range, affectedCharRange, NSRange.sizeof);
        boolean result = this.callSuperBoolean(id2, sel, range, replacementString);
        if (this.hooks(25)) {
            String newText;
            String string = new NSString(replacementString).getString();
            NSEvent currentEvent = this.display.application.currentEvent();
            int type = currentEvent.type();
            if (type != 10 && type != 11) {
                currentEvent = null;
            }
            if ((newText = this.verifyText(string, range.location, range.location + range.length, currentEvent)) == null) {
                return false;
            }
            if (!string.equals(newText)) {
                int charCount;
                int length = newText.length();
                Point selection = this.getSelection();
                if (this.textLimit != LIMIT && (charCount = this.getCharCount()) - (selection.y - selection.x) + length > this.textLimit) {
                    length = this.textLimit - charCount + (selection.y - selection.x);
                }
                char[] buffer = new char[length];
                newText.getChars(0, buffer.length, buffer, 0);
                NSString nsstring = NSString.stringWithCharacters(buffer, buffer.length);
                NSText fieldEditor = ((NSTextField)this.view).currentEditor();
                fieldEditor.replaceCharactersInRange(fieldEditor.selectedRange(), nsstring);
                this.text = fieldEditor.string().getString();
                this.sendEvent(24);
                result = false;
            }
        }
        if (result) {
            char[] chars = new char[this.text.length()];
            this.text.getChars(0, chars.length, chars, 0);
            NSMutableString mutable = (NSMutableString)NSMutableString.stringWithCharacters(chars, chars.length);
            mutable.replaceCharactersInRange(range, new NSString(replacementString));
            this.text = mutable.getString();
            this.selectionRange = null;
        }
        return result;
    }

    void textViewDidChangeSelection(int id2, int sel, int aNotification) {
        NSNotification notification = new NSNotification(aNotification);
        NSText editor = new NSText(notification.object().id);
        this.selectionRange = editor.selectedRange();
    }

    void textDidChange(int id2, int sel, int aNotification) {
        super.textDidChange(id2, sel, aNotification);
        this.postEvent(24);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(int id2, int sel, int aTextView, int oldSelectedCharRange, int newSelectedCharRange) {
        if (this.receivingFocus && this.selectionRange != null) {
            return this.selectionRange;
        }
        NSRange result = new NSRange();
        OS.memmove(result, newSelectedCharRange, NSRange.sizeof);
        return result;
    }

    void updateItems() {
        if ((this.style & 8) != 0) {
            NSPopUpButton widget = (NSPopUpButton)this.view;
            int count = widget.numberOfItems();
            int i = 0;
            while (i < count) {
                NSMenuItem item = new NSMenuItem(widget.itemAtIndex(i));
                NSAttributedString attStr = item.attributedTitle();
                String string = attStr.string().getString();
                item.setAttributedTitle(this.createString(string));
                ++i;
            }
        } else {
            NSComboBox widget = (NSComboBox)this.view;
            int count = widget.numberOfItems();
            int i = 0;
            while (i < count) {
                NSAttributedString attStr = new NSAttributedString(widget.itemObjectValueAtIndex(i));
                String string = attStr.string().getString();
                widget.insertItemWithObjectValue(this.createString(string), i);
                widget.removeItemAtIndex(i + 1);
                ++i;
            }
            widget.cell().setAttributedStringValue(this.createString(this.text));
        }
    }

    String verifyText(String string, int start, int end, NSEvent keyEvent) {
        Event event = new Event();
        if (keyEvent != null) {
            this.setKeyState(event, 3, keyEvent);
        }
        event.text = string;
        event.start = start;
        event.end = end;
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

