/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.history;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class RevisionAnnotationController {
    private ISelectionProvider fRulerSelectionProvider;
    private ISelectionProvider fHistoryListSelectionProvider;
    private ISelectionChangedListener rulerListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            Revision selected = null;
            if (selection instanceof IStructuredSelection) {
                selected = (Revision)((IStructuredSelection)selection).getFirstElement();
            }
            if (selected == null) {
                return;
            }
            RevisionAnnotationController.this.revisionSelected(selected);
        }
    };
    private ISelectionChangedListener historyListListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object first;
            IStructuredSelection ss;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (first = ss.getFirstElement()) != null) {
                RevisionAnnotationController.this.historyEntrySelected(first);
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static AbstractDecoratedTextEditor openEditor(IWorkbenchPage page, IFile file) throws PartInitException {
        AbstractDecoratedTextEditor te;
        if (file == null) {
            return null;
        }
        FileEditorInput input = new FileEditorInput(file);
        IEditorPart[] openEditors = RevisionAnnotationController.findOpenEditorsForFile(page, input);
        if (openEditors.length > 0 && (te = RevisionAnnotationController.findTextEditor(page, openEditors, (IEditorInput)input)) != null) {
            return te;
        }
        try {
            AbstractDecoratedTextEditor te2;
            IEditorPart part;
            IEditorDescriptor descrptr = IDE.getEditorDescriptor((IFile)file);
            if (descrptr.isInternal() && openEditors.length == 0) {
                part = page.openEditor((IEditorInput)input, IDE.getEditorDescriptor((IFile)file).getId(), true, 1);
                te2 = RevisionAnnotationController.findTextEditorPart(page, part, (IEditorInput)input);
                if (te2 != null) {
                    return te2;
                }
                page.closeEditor(part, false);
            }
            if ((te2 = RevisionAnnotationController.findTextEditorPart(page, part = page.openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor", true, 3), (IEditorInput)input)) != null) {
                return te2;
            }
        }
        catch (PartInitException partInitException) {}
        return null;
    }

    public static AbstractDecoratedTextEditor openEditor(IWorkbenchPage page, Object fileRevision, IStorage storage) throws PartInitException {
        String id = RevisionAnnotationController.getEditorId(storage);
        ITextEditor editor = RevisionAnnotationController.getEditor(id, fileRevision, storage);
        if (editor instanceof AbstractDecoratedTextEditor) {
            return (AbstractDecoratedTextEditor)editor;
        }
        return null;
    }

    private static ITextEditor getEditor(String id, Object fileRevision, IStorage storage) throws PartInitException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart part = page.openEditor((IEditorInput)new FileRevisionEditorInput(fileRevision, storage), id);
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        page.closeEditor(part, false);
        part = page.openEditor((IEditorInput)new FileRevisionEditorInput(fileRevision, storage), "org.eclipse.ui.DefaultTextEditor");
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        throw new PartInitException(TeamUIMessages.RevisionAnnotationController_0);
    }

    private static String getEditorId(IStorage storage) {
        String id;
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(storage.getName());
        if (descriptor == null || !descriptor.isInternal()) {
            id = "org.eclipse.ui.DefaultTextEditor";
        } else {
            try {
                id = Utils.isTextEditor(descriptor) ? descriptor.getId() : "org.eclipse.ui.DefaultTextEditor";
            }
            catch (CoreException coreException) {
                id = "org.eclipse.ui.DefaultTextEditor";
            }
        }
        return id;
    }

    private static AbstractDecoratedTextEditor findOpenTextEditorForFile(IWorkbenchPage page, IFile file) {
        if (file == null) {
            return null;
        }
        FileEditorInput input = new FileEditorInput(file);
        IEditorPart[] editors = RevisionAnnotationController.findOpenEditorsForFile(page, input);
        return RevisionAnnotationController.findTextEditor(page, editors, (IEditorInput)input);
    }

    private static AbstractDecoratedTextEditor findTextEditor(IWorkbenchPage page, IEditorPart[] editors, IEditorInput input) {
        int i = 0;
        while (i < editors.length) {
            IEditorPart editor = editors[i];
            AbstractDecoratedTextEditor te = RevisionAnnotationController.findTextEditorPart(page, editor, input);
            if (te != null) {
                return te;
            }
            ++i;
        }
        return null;
    }

    private static AbstractDecoratedTextEditor findTextEditorPart(IWorkbenchPage page, IEditorPart editor, IEditorInput input) {
        if (editor instanceof AbstractDecoratedTextEditor) {
            return (AbstractDecoratedTextEditor)editor;
        }
        if (editor instanceof MultiPageEditorPart) {
            MultiPageEditorPart mpep = (MultiPageEditorPart)editor;
            IEditorPart[] parts = mpep.findEditors(input);
            int i = 0;
            while (i < parts.length) {
                IEditorPart editorPart = parts[i];
                if (editorPart instanceof AbstractDecoratedTextEditor) {
                    page.activate((IWorkbenchPart)mpep);
                    mpep.setActiveEditor(editorPart);
                    return (AbstractDecoratedTextEditor)editorPart;
                }
                ++i;
            }
        }
        return null;
    }

    private static IEditorPart[] findOpenEditorsForFile(IWorkbenchPage page, FileEditorInput input) {
        IEditorReference[] references = page.findEditors((IEditorInput)input, null, 1);
        ArrayList<IEditorPart> editors = new ArrayList<IEditorPart>();
        int i = 0;
        while (i < references.length) {
            IEditorReference reference = references[i];
            IEditorPart editor = reference.getEditor(false);
            editors.add(editor);
            ++i;
        }
        return editors.toArray(new IEditorPart[editors.size()]);
    }

    private static AbstractDecoratedTextEditor findOpenTextEditorFor(IWorkbenchPage page, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            return RevisionAnnotationController.findOpenTextEditorForFile(page, file);
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IEditorReference[] references = window.getActivePage().getEditorReferences();
        int i = 0;
        while (i < references.length) {
            IEditorReference reference = references[i];
            try {
                IEditorPart editor;
                if (object.equals(reference.getEditorInput()) && (editor = reference.getEditor(false)) instanceof AbstractDecoratedTextEditor) {
                    return (AbstractDecoratedTextEditor)editor;
                }
            }
            catch (PartInitException partInitException) {}
            ++i;
        }
        return null;
    }

    private static IRevisionRulerColumnExtension findEditorRevisonRulerColumn(IWorkbenchPage page, Object object) {
        IRevisionRulerColumn column;
        AbstractDecoratedTextEditor editor = RevisionAnnotationController.findOpenTextEditorFor(page, object);
        if (editor == null) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.revisions.IRevisionRulerColumn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((column = (IRevisionRulerColumn)editor.getAdapter((Class)clazz)) instanceof IRevisionRulerColumnExtension) {
            if (column.getControl() != null && column.getControl().isDisposed()) {
                return null;
            }
            return (IRevisionRulerColumnExtension)column;
        }
        return null;
    }

    private RevisionAnnotationController(IRevisionRulerColumnExtension revisionRuler, ISelectionProvider historyList) {
        this.fHistoryListSelectionProvider = historyList;
        if (revisionRuler == null) {
            this.fRulerSelectionProvider = null;
            return;
        }
        this.fRulerSelectionProvider = revisionRuler.getRevisionSelectionProvider();
        this.fRulerSelectionProvider.addSelectionChangedListener(this.rulerListener);
        this.fHistoryListSelectionProvider.addSelectionChangedListener(this.historyListListener);
        ((IRevisionRulerColumn)revisionRuler).getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RevisionAnnotationController.this.dispose();
            }
        });
    }

    public RevisionAnnotationController(IWorkbenchPage page, IFile file, ISelectionProvider historyList) {
        this(RevisionAnnotationController.findEditorRevisonRulerColumn(page, file), historyList);
    }

    public RevisionAnnotationController(IWorkbenchPage page, IStorageEditorInput editorInput, ISelectionProvider historyList) {
        this(RevisionAnnotationController.findEditorRevisonRulerColumn(page, editorInput), historyList);
    }

    public void dispose() {
        if (this.fRulerSelectionProvider != null) {
            this.fRulerSelectionProvider.removeSelectionChangedListener(this.rulerListener);
            this.fHistoryListSelectionProvider.removeSelectionChangedListener(this.historyListListener);
            this.rulerListener = null;
            this.fRulerSelectionProvider = null;
            this.historyListListener = null;
            this.fHistoryListSelectionProvider = null;
        }
    }

    protected void revisionSelected(Revision selected) {
        Object entry = this.getHistoryEntry(selected);
        if (entry != null) {
            StructuredSelection selection = new StructuredSelection(entry);
            if (this.fHistoryListSelectionProvider instanceof Viewer) {
                Viewer v = (Viewer)this.fHistoryListSelectionProvider;
                v.setSelection((ISelection)selection, true);
            } else if (this.fHistoryListSelectionProvider != null) {
                this.fHistoryListSelectionProvider.setSelection((ISelection)selection);
            }
        }
    }

    protected abstract Object getHistoryEntry(Revision var1);

    void historyEntrySelected(Object historyEntry) {
        String id = this.getRevisionId(historyEntry);
        if (id != null && this.fRulerSelectionProvider != null) {
            this.fRulerSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)id));
        }
    }

    protected String getRevisionId(Object historyEntry) {
        IResourceVariant variant;
        IFileRevision revision;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.team.core.history.IFileRevision");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((revision = (IFileRevision)Utils.getAdapter(historyEntry, clazz)) != null) {
            return revision.getContentIdentifier();
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.team.core.variants.IResourceVariant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((variant = (IResourceVariant)Utils.getAdapter(historyEntry, clazz2)) != null) {
            return variant.getContentIdentifier();
        }
        return null;
    }
}

