/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.operations.Activator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.SynchronizeOperation;
import org.eclipse.equinox.p2.operations.UninstallOperation;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationFactory {
    static /* synthetic */ Class class$0;

    private IProvisioningAgent getAgent() {
        Collection ref = null;
        try {
            BundleContext bundleContext = Activator.getContext();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.p2.core.IProvisioningAgent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ref = bundleContext.getServiceReferences(clazz, new StringBuffer("(agent.current=").append(Boolean.TRUE.toString()).append(')').toString());
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (ref == null || ref.size() == 0) {
            throw new IllegalStateException("p2 is not configured properly. No provisioning agent could be found.");
        }
        IProvisioningAgent agent = (IProvisioningAgent)Activator.getContext().getService((ServiceReference)ref.iterator().next());
        Activator.getContext().ungetService((ServiceReference)ref.iterator().next());
        return agent;
    }

    private Collection<IInstallableUnit> gatherIUs(ProvisioningContext context, Collection<IVersionedId> ius, IProgressMonitor monitor) {
        ArrayList<IInstallableUnit> unitsToInstall = new ArrayList<IInstallableUnit>(ius.size());
        for (IVersionedId versionedId : ius) {
            if (ius instanceof IInstallableUnit) {
                unitsToInstall.add((IInstallableUnit)versionedId);
                continue;
            }
            IQuery installableUnits = QueryUtil.createIUQuery((String)versionedId.getId(), (Version)versionedId.getVersion());
            IQueryResult matches = context.getMetadata(monitor).query(installableUnits, monitor);
            Iterator iuIt = matches.iterator();
            unitsToInstall.add((IInstallableUnit)iuIt.next());
            if (!iuIt.hasNext()) continue;
            System.out.println("Log the fact that we have a problem");
        }
        return unitsToInstall;
    }

    private ProvisioningContext createProvisioningContext(Collection<URI> repos, IProvisioningAgent agent) {
        ProvisioningContext ctx = new ProvisioningContext(agent);
        if (repos != null) {
            ctx.setMetadataRepositories(repos.toArray(new URI[repos.size()]));
            ctx.setArtifactRepositories(repos.toArray(new URI[repos.size()]));
        }
        return ctx;
    }

    public InstallOperation createInstallOperation(Collection<IVersionedId> toInstall, Collection<URI> repos, IProgressMonitor monitor) throws ProvisionException {
        Assert.isNotNull(toInstall);
        IProvisioningAgent agent = this.getAgent();
        ProvisioningContext ctx = this.createProvisioningContext(repos, agent);
        InstallOperation resultingOperation = new InstallOperation(new ProvisioningSession(agent), this.gatherIUs(ctx, toInstall, monitor));
        resultingOperation.setProvisioningContext(ctx);
        resultingOperation.setProfileId("_SELF_");
        return resultingOperation;
    }

    public UninstallOperation createUninstallOperation(Collection<IVersionedId> toUninstall, Collection<URI> repos, IProgressMonitor monitor) throws ProvisionException {
        Assert.isNotNull(toUninstall);
        IProvisioningAgent agent = this.getAgent();
        ProvisioningContext ctx = this.createProvisioningContext(repos, agent);
        UninstallOperation resultingOperation = new UninstallOperation(new ProvisioningSession(agent), this.gatherIUs(ctx, toUninstall, monitor));
        resultingOperation.setProvisioningContext(ctx);
        resultingOperation.setProfileId("_SELF_");
        return resultingOperation;
    }

    public IQueryResult<IInstallableUnit> listInstalledElements(boolean rootsOnly, IProgressMonitor monitor) {
        IProfileRegistry registry = (IProfileRegistry)this.getAgent().getService(IProfileRegistry.SERVICE_NAME);
        IProfile profile = registry.getProfile("_SELF_");
        if (rootsOnly) {
            return profile.query((IQuery)new UserVisibleRootQuery(), monitor);
        }
        return profile.query(QueryUtil.ALL_UNITS, monitor);
    }

    public UpdateOperation createUpdateOperation(Collection<IVersionedId> toUpdate, Collection<URI> repos, IProgressMonitor monitor) throws ProvisionException {
        IProvisioningAgent agent = this.getAgent();
        ProvisioningContext ctx = this.createProvisioningContext(repos, agent);
        UpdateOperation resultingOperation = new UpdateOperation(new ProvisioningSession(agent), toUpdate == null ? null : this.gatherIUs(ctx, toUpdate, monitor));
        resultingOperation.setProvisioningContext(ctx);
        resultingOperation.setProfileId("_SELF_");
        return resultingOperation;
    }

    public SynchronizeOperation createSynchronizeOperation(Collection<IVersionedId> toInstall, Collection<URI> repos, IProgressMonitor monitor) throws ProvisionException {
        IProvisioningAgent agent = this.getAgent();
        ProvisioningContext ctx = this.createProvisioningContext(repos, agent);
        Set iusToInstall = toInstall == null ? ctx.getMetadata(monitor).query(QueryUtil.createIUGroupQuery(), monitor).toUnmodifiableSet() : this.gatherIUs(ctx, toInstall, monitor);
        SynchronizeOperation resultingOperation = new SynchronizeOperation(new ProvisioningSession(agent), iusToInstall);
        resultingOperation.setProvisioningContext(ctx);
        resultingOperation.setProfileId("_SELF_");
        return resultingOperation;
    }
}

