/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.breakpoints;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class AddExceptionTypeDialogExtension
extends TypeSelectionExtension {
    private Button fCaughtButton;
    private Button fUncaughtButton;
    private boolean fCaught = false;
    private boolean fUncaught = false;

    public AddExceptionTypeDialogExtension(boolean caught, boolean uncaught) {
        this.fCaught = caught;
        this.fUncaught = uncaught;
    }

    public Control createContentArea(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)768);
        this.fCaughtButton = SWTFactory.createCheckButton((Composite)comp, (String)BreakpointMessages.AddExceptionDialog_15, null, (boolean)this.fCaught, (int)1);
        this.fCaughtButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AddExceptionTypeDialogExtension.this.fCaught = AddExceptionTypeDialogExtension.this.fCaughtButton.getSelection();
            }
        });
        this.fUncaughtButton = SWTFactory.createCheckButton((Composite)comp, (String)BreakpointMessages.AddExceptionDialog_16, null, (boolean)this.fUncaught, (int)1);
        this.fUncaughtButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AddExceptionTypeDialogExtension.this.fUncaught = AddExceptionTypeDialogExtension.this.fUncaughtButton.getSelection();
            }
        });
        return comp;
    }

    public ISelectionStatusValidator getSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1) {
                    try {
                        IType type = (IType)selection[0];
                        ITypeHierarchy hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                        IType curr = type;
                        while (curr != null) {
                            if ("java.lang.Throwable".equals(curr.getFullyQualifiedName('.'))) {
                                return Status.OK_STATUS;
                            }
                            curr = hierarchy.getSuperclass(curr);
                        }
                    }
                    catch (JavaModelException e) {
                        JDIDebugUIPlugin.log(e);
                        return Status.CANCEL_STATUS;
                    }
                }
                return new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), BreakpointMessages.AddExceptionDialog_13);
            }
        };
    }

    public boolean shouldHandleCaughtExceptions() {
        return this.fCaught;
    }

    public boolean shouldHandleUncaughtExceptions() {
        return this.fUncaught;
    }
}

