/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.actions;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.WizardActionGroup;
import org.osgi.framework.Bundle;

public class PortingActionProvider
extends CommonActionProvider {
    private static final String COMMON_NAVIGATOR_IMPORT_MENU = "common.import.menu";
    private static final String COMMON_NAVIGATOR_EXPORT_MENU = "common.export.menu";
    private ImportResourcesAction importAction;
    private ExportResourcesAction exportAction;
    private WizardActionGroup importWizardActionGroup;
    private WizardActionGroup exportWizardActionGroup;
    private boolean disposed = false;
    private boolean contribute = false;

    public void init(ICommonActionExtensionSite anExtensionSite) {
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        if (anExtensionSite.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            IWorkbenchWindow window = ((ICommonViewerWorkbenchSite)anExtensionSite.getViewSite()).getWorkbenchWindow();
            this.importAction = new ImportResourcesAction(window);
            this.exportAction = new ExportResourcesAction(window);
            this.importWizardActionGroup = new WizardActionGroup(window, PlatformUI.getWorkbench().getImportWizardRegistry(), "import", anExtensionSite.getContentService());
            this.exportWizardActionGroup = new WizardActionGroup(window, PlatformUI.getWorkbench().getExportWizardRegistry(), "export", anExtensionSite.getContentService());
            this.contribute = true;
        }
    }

    public void dispose() {
        if (!this.contribute) {
            return;
        }
        this.importWizardActionGroup.dispose();
        this.exportWizardActionGroup.dispose();
        this.importAction = null;
        this.exportAction = null;
        this.disposed = true;
    }

    public void fillContextMenu(IMenuManager aMenu) {
        if (!this.contribute) {
            return;
        }
        Assert.isTrue((!this.disposed ? 1 : 0) != 0);
        ISelection selection = this.getContext().getSelection();
        if (!(selection instanceof IStructuredSelection) || ((IStructuredSelection)selection).size() > 1) {
            this.addSimplePortingMenus(aMenu);
        } else {
            this.addImportMenu(aMenu);
            this.addExportMenu(aMenu);
        }
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        URL url = FileLocator.find((Bundle)WorkbenchNavigatorPlugin.getDefault().getBundle(), (IPath)new Path(String.valueOf(iconPath) + relativePath), (Map)Collections.EMPTY_MAP);
        if (url == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    private void addSimplePortingMenus(IMenuManager aMenu) {
        aMenu.appendToGroup("group.port", (IAction)this.importAction);
        aMenu.appendToGroup("group.port", (IAction)this.exportAction);
    }

    private void addImportMenu(IMenuManager aMenu) {
        this.importWizardActionGroup.setContext(this.getContext());
        if (this.importWizardActionGroup.getWizardActionIds().length == 0) {
            aMenu.appendToGroup("group.port", (IAction)this.importAction);
            return;
        }
        MenuManager submenu = new MenuManager(WorkbenchNavigatorMessages.PortingActionProvider_ImportResourcesMenu_label, COMMON_NAVIGATOR_IMPORT_MENU);
        this.importWizardActionGroup.fillContextMenu((IMenuManager)submenu);
        submenu.add((IContributionItem)new Separator("additions"));
        submenu.add((IContributionItem)new Separator());
        submenu.add((IAction)this.importAction);
        aMenu.appendToGroup("group.port", (IContributionItem)submenu);
    }

    private void addExportMenu(IMenuManager aMenu) {
        this.exportWizardActionGroup.setContext(this.getContext());
        if (this.exportWizardActionGroup.getWizardActionIds().length == 0) {
            aMenu.appendToGroup("group.port", (IAction)this.exportAction);
            return;
        }
        MenuManager submenu = new MenuManager(WorkbenchNavigatorMessages.PortingActionProvider_ExportResourcesMenu_label, COMMON_NAVIGATOR_EXPORT_MENU);
        this.exportWizardActionGroup.fillContextMenu((IMenuManager)submenu);
        submenu.add((IContributionItem)new Separator("additions"));
        submenu.add((IContributionItem)new Separator());
        submenu.add((IAction)this.exportAction);
        aMenu.appendToGroup("group.port", (IContributionItem)submenu);
    }
}

