/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.util.FileUtils;
import org.eclipse.ant.internal.launching.AntLaunch;
import org.eclipse.ant.internal.launching.AntLaunchingUtil;
import org.eclipse.ant.internal.launching.LinkDescriptor;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.ExternalHyperlink;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;

public class TaskLinkManager {
    private static Map fFileNameToIFile = new HashMap();

    private TaskLinkManager() {
    }

    private static IHyperlink createHyperlink(LinkDescriptor linkDescriptor) {
        String fileName = linkDescriptor.getFileName();
        int lineNumber = linkDescriptor.getLineNumber();
        IHyperlink taskLink = null;
        if (lineNumber == -1) {
            taskLink = AntUtil.getLocationLink(fileName, null);
        } else {
            IFile file = (IFile)fFileNameToIFile.get(fileName);
            if (file == null) {
                File javaIOFile;
                file = AntLaunchingUtil.getFileForLocation((String)fileName, null);
                if (file != null) {
                    fFileNameToIFile.put(fileName, file);
                    taskLink = new FileLink(file, null, -1, -1, lineNumber);
                } else if (fileName != null && (javaIOFile = FileUtils.getFileUtils().resolveFile(null, fileName)).exists()) {
                    taskLink = new ExternalHyperlink(javaIOFile, lineNumber);
                }
            } else {
                taskLink = new FileLink(file, null, -1, -1, lineNumber);
            }
        }
        return taskLink;
    }

    private static boolean addLink(IConsole console, IRegion lineRegion, LinkDescriptor descriptor) {
        try {
            String text = console.getDocument().get(lineRegion.getOffset(), lineRegion.getLength());
            if (text.trim().equals(descriptor.getLine())) {
                int offset = lineRegion.getOffset() + descriptor.getOffset();
                IHyperlink link = TaskLinkManager.createHyperlink(descriptor);
                if (link != null) {
                    console.addLink(link, offset, descriptor.getLength());
                }
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public static synchronized void processNewLine(IConsole console, IRegion newLine) {
        AntLaunch launch = (AntLaunch)console.getProcess().getLaunch();
        List links = launch.getLinkDescriptors();
        if (TaskLinkManager.linkBuildFileMessage(console, newLine)) {
            return;
        }
        if (links == null || links.isEmpty()) {
            return;
        }
        Iterator i = links.iterator();
        while (i.hasNext()) {
            LinkDescriptor descriptor = (LinkDescriptor)i.next();
            if (!TaskLinkManager.addLink(console, newLine, descriptor)) continue;
            launch.removeLinkDescriptor(descriptor);
            return;
        }
    }

    public static void dispose(IProcess process) {
        AntLaunch launch = (AntLaunch)process.getLaunch();
        launch.clearLinkDescriptors();
    }

    private static boolean linkBuildFileMessage(IConsole console, IRegion region) {
        String fileName;
        IFile file;
        String message = "";
        int offset = region.getOffset();
        try {
            message = console.getDocument().get(offset, region.getLength());
        }
        catch (BadLocationException badLocationException) {}
        if (message.startsWith("Buildfile:") && (file = AntUtil.getFileForLocation(fileName = message.substring(10).trim(), null)) != null) {
            FileLink link = new FileLink(file, null, -1, -1, -1);
            console.addLink((IConsoleHyperlink)link, offset + 11, fileName.length());
            return true;
        }
        return false;
    }
}

