/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.contexts.DebugModelContextBindingManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener4;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewContextService
implements IDebugContextListener,
IPerspectiveListener4,
Preferences.IPropertyChangeListener,
IContextManagerListener {
    private Map fPerspectiveToActiveContext = new HashMap();
    private Map fPerspectiveToActivatedContexts = new HashMap();
    private Map fContextIdsToBindings;
    private Set fEnabledPerspectives = new HashSet();
    private boolean fIgnoreChanges = false;
    private IWorkbenchWindow fWindow;
    private IContextService fContextService;
    private IDebugContextService fDebugContextService;
    private IPerspectiveDescriptor fActivePerspective;
    public static final String DEBUG_CONTEXT = "org.eclipse.debug.ui.debugging";
    private static final String ID_CONTEXT_VIEW_BINDINGS = "contextViewBindings";
    private static final String ELEM_CONTEXT_VIEW_BINDING = "contextViewBinding";
    private static final String ELEM_PERSPECTIVE = "perspective";
    private static final String ATTR_CONTEXT_ID = "contextId";
    private static final String ATTR_VIEW_ID = "viewId";
    private static final String ATTR_AUTO_OPEN = "autoOpen";
    private static final String ATTR_AUTO_CLOSE = "autoClose";
    private static final String ATTR_PERSPECTIVE_ID = "perspectiveId";
    private static final String XML_ELEMENT_VIEW_BINDINGS = "viewBindings";
    private static final String XML_ELEMENT_PERSPECTIVE = "perspective";
    private static final String XML_ELEMENT_VIEW = "view";
    private static final String XML_ATTR_ID = "id";
    private static final String XML_ATTR_USER_ACTION = "userAction";
    private static final String XML_VALUE_OPENED = "opened";
    private static final String XML_VALUE_CLOSED = "closed";
    private static Set fgBaseDebugViewIds = null;
    private static String[] EMPTY_IDS;
    static /* synthetic */ Class class$0;

    static {
        fgBaseDebugViewIds = new HashSet();
        fgBaseDebugViewIds.add("org.eclipse.debug.ui.DebugView");
        fgBaseDebugViewIds.add("org.eclipse.debug.ui.VariableView");
        fgBaseDebugViewIds.add("org.eclipse.debug.ui.BreakpointView");
        fgBaseDebugViewIds.add("org.eclipse.ui.console.ConsoleView");
        EMPTY_IDS = new String[0];
    }

    private IDebugContextService getDebugContextService() {
        return this.fDebugContextService;
    }

    ViewContextService(IWorkbenchWindow window) {
        IWorkbenchPage page;
        this.fWindow = window;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fContextService = (IContextService)iWorkbench.getAdapter((Class)clazz);
        this.fDebugContextService = DebugUITools.getDebugContextManager().getContextService(this.fWindow);
        this.loadContextToViewExtensions();
        this.applyUserViewBindings();
        this.loadPerspectives();
        window.addPerspectiveListener((IPerspectiveListener)this);
        this.getDebugContextService().addDebugContextListener(this);
        DebugUIPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.fContextService.addContextManagerListener((IContextManagerListener)this);
        if (this.fWindow != null && (page = this.fWindow.getActivePage()) != null) {
            this.fActivePerspective = page.getPerspective();
        }
    }

    public void dispose() {
        this.fWindow.removePerspectiveListener((IPerspectiveListener)this);
        this.fWindow = null;
        this.getDebugContextService().removeDebugContextListener(this);
        DebugUIPlugin.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.fContextService.removeContextManagerListener((IContextManagerListener)this);
        this.fActivePerspective = null;
    }

    private void loadContextToViewExtensions() {
        this.fContextIdsToBindings = new HashMap();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), ID_CONTEXT_VIEW_BINDINGS);
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement element = configurationElements[i];
            if (ELEM_CONTEXT_VIEW_BINDING.equals(element.getName())) {
                String viewId = element.getAttribute(ATTR_VIEW_ID);
                String contextId = element.getAttribute(ATTR_CONTEXT_ID);
                if (contextId != null && viewId != null) {
                    ViewBinding info = new ViewBinding(element);
                    DebugContextViewBindings bindings = (DebugContextViewBindings)this.fContextIdsToBindings.get(contextId);
                    if (bindings == null) {
                        bindings = new DebugContextViewBindings(contextId);
                        this.fContextIdsToBindings.put(contextId, bindings);
                    }
                    bindings.addBinding(info);
                }
            }
            ++i;
        }
        this.linkParentContexts();
    }

    private void applyUserViewBindings() {
        String xml = DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.user_view_bindings");
        if (xml.length() > 0) {
            try {
                Element root = DebugPlugin.parseDocument((String)xml);
                NodeList list = root.getChildNodes();
                int length = list.getLength();
                int i = 0;
                while (i < length) {
                    Element entry;
                    Node node = list.item(i);
                    short type = node.getNodeType();
                    if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(XML_ELEMENT_VIEW)) {
                        String id = entry.getAttribute(XML_ATTR_ID);
                        Iterator bindings = this.fContextIdsToBindings.values().iterator();
                        while (bindings.hasNext()) {
                            DebugContextViewBindings binding = (DebugContextViewBindings)bindings.next();
                            binding.applyUserSettings(id, entry);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    private void loadPerspectives() {
        String preference = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.manage_view_perspectives");
        this.fEnabledPerspectives = "DEFAULT".equals(preference) ? ViewContextService.getDefaultEnabledPerspectives() : ViewContextService.parseList(preference);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (!this.fIgnoreChanges) {
            if ("org.eclipse.debug.ui.manage_view_perspectives".equals(event.getProperty())) {
                this.loadPerspectives();
            } else if ("org.eclipse.debug.ui.user_view_bindings".equals(event.getProperty())) {
                this.loadContextToViewExtensions();
                this.applyUserViewBindings();
                this.fPerspectiveToActivatedContexts.clear();
                ISelection selection = this.getDebugContextService().getActiveContext();
                this.contextActivated(selection);
            }
        }
    }

    private boolean isEnabledPerspective() {
        IPerspectiveDescriptor perspective = this.getActivePerspective();
        if (perspective != null) {
            return this.fEnabledPerspectives.contains(perspective.getId());
        }
        return false;
    }

    private IPerspectiveDescriptor getActivePerspective() {
        if (this.fWindow == null) {
            return null;
        }
        return this.fActivePerspective;
    }

    public static Set parseList(String listString) {
        HashSet<String> list = new HashSet<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list;
    }

    public static Set getDefaultEnabledPerspectives() {
        HashSet<String> perspectives = new HashSet<String>(4);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), ID_CONTEXT_VIEW_BINDINGS);
        IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configurationElements.length) {
            String perspectiveId;
            IConfigurationElement element = configurationElements[i];
            if ("perspective".equals(element.getName()) && (perspectiveId = element.getAttribute(ATTR_PERSPECTIVE_ID)) != null) {
                perspectives.add(perspectiveId);
            }
            ++i;
        }
        return perspectives;
    }

    public void contextActivated(ISelection selection) {
        if (this.isEnabledPerspective() && selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator iterator = ss.iterator();
            while (iterator.hasNext()) {
                ILaunchConfiguration launchConfiguration;
                Object target = iterator.next();
                ILaunch launch = DebugModelContextBindingManager.getLaunch(target);
                if (launch == null || launch.isTerminated() || (launchConfiguration = launch.getLaunchConfiguration()) == null) continue;
                try {
                    List workbenchContexts;
                    ILaunchConfigurationType type = launchConfiguration.getType();
                    if (!this.fContextService.getActiveContextIds().contains(String.valueOf(type.getIdentifier()) + ".internal." + this.getActivePerspective().getId()) || (workbenchContexts = DebugModelContextBindingManager.getDefault().getWorkbenchContextsForDebugContext(target)).isEmpty()) continue;
                    Iterator contexts = workbenchContexts.iterator();
                    while (contexts.hasNext()) {
                        String contextId = (String)contexts.next();
                        if (!this.isActivated(contextId)) {
                            this.activateChain(contextId, this.getActivePerspective());
                        }
                        if (contexts.hasNext() || this.isActiveContext(contextId)) continue;
                        this.activateChain(contextId, this.getActivePerspective());
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
    }

    private boolean isActiveContext(String contextId) {
        IPerspectiveDescriptor activePerspective = this.getActivePerspective();
        if (activePerspective != null) {
            String activeId = (String)this.fPerspectiveToActiveContext.get(activePerspective);
            return contextId.equals(activeId);
        }
        return false;
    }

    private boolean isActivated(String contextId) {
        Set contexts;
        IPerspectiveDescriptor activePerspective = this.getActivePerspective();
        if (activePerspective != null && (contexts = (Set)this.fPerspectiveToActivatedContexts.get(activePerspective)) != null) {
            return contexts.contains(contextId);
        }
        return false;
    }

    private void addActivated(String contextId) {
        IPerspectiveDescriptor activePerspective = this.getActivePerspective();
        if (activePerspective != null) {
            HashSet<String> contexts = (HashSet<String>)this.fPerspectiveToActivatedContexts.get(activePerspective);
            if (contexts == null) {
                contexts = new HashSet<String>();
                this.fPerspectiveToActivatedContexts.put(activePerspective, contexts);
            }
            contexts.add(contextId);
        }
    }

    private void removeActivated(String contextId) {
        Set contexts;
        IPerspectiveDescriptor activePerspective = this.getActivePerspective();
        if (activePerspective != null && (contexts = (Set)this.fPerspectiveToActivatedContexts.get(activePerspective)) != null) {
            contexts.remove(contextId);
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    private void clean(IPerspectiveDescriptor perspective) {
        Set contexts = (Set)this.fPerspectiveToActivatedContexts.remove(perspective);
        this.fPerspectiveToActiveContext.remove(perspective);
        if (contexts != null) {
            Iterator iterator = contexts.iterator();
            while (iterator.hasNext()) {
                String id = (String)iterator.next();
                this.deactivate(id, perspective);
            }
        }
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        Set activatedContexts;
        if (!this.fIgnoreChanges && page.getWorkbenchWindow().equals(this.fWindow) && partRef != null && ("viewShow" == changeId || "viewHide" == changeId) && (activatedContexts = (Set)this.fPerspectiveToActivatedContexts.get(perspective)) != null) {
            Iterator iterator = activatedContexts.iterator();
            while (iterator.hasNext()) {
                DebugContextViewBindings bindings = (DebugContextViewBindings)this.fContextIdsToBindings.get(iterator.next());
                if (bindings == null) continue;
                bindings.setViewOpened("viewShow" == changeId, partRef.getId());
            }
        }
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (page.getWorkbenchWindow().equals(this.fWindow)) {
            this.fActivePerspective = perspective;
            ISelection activeContext = this.getDebugContextService().getActiveContext();
            if (activeContext != null) {
                this.contextActivated(activeContext);
            }
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    private void activateChain(String contextId, IPerspectiveDescriptor perspective) {
        DebugContextViewBindings bindings;
        if (this.fWindow == null) {
            return;
        }
        IWorkbenchPage page = this.fWindow.getActivePage();
        if (page != null && (bindings = (DebugContextViewBindings)this.fContextIdsToBindings.get(contextId)) != null) {
            bindings.activateChain(page, perspective);
        }
    }

    private void linkParentContexts() {
        Iterator iterator = this.fContextIdsToBindings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String contextId = (String)entry.getKey();
            DebugContextViewBindings bindings = (DebugContextViewBindings)entry.getValue();
            if (bindings.getId().equals(DEBUG_CONTEXT)) continue;
            Context context = this.fContextService.getContext(contextId);
            try {
                bindings.setParentId(context.getParentId());
            }
            catch (NotDefinedException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    private void setActive(IPerspectiveDescriptor perspective, String contextId) {
        if (contextId == null) {
            this.fPerspectiveToActiveContext.remove(perspective);
        } else {
            this.fPerspectiveToActiveContext.put(perspective, contextId);
        }
    }

    public void contextManagerChanged(ContextManagerEvent event) {
        if (event.isActiveContextsChanged() && this.getActivePerspective() != null) {
            Set disabledContexts = this.getDisabledContexts(event);
            if (!disabledContexts.isEmpty()) {
                Iterator contexts = disabledContexts.iterator();
                while (contexts.hasNext()) {
                    String contextId = (String)contexts.next();
                    if (!this.isViewConetxt(contextId) || !this.isActivated(contextId)) continue;
                    this.deactivate(contextId, this.getActivePerspective());
                }
            }
            this.contextActivated(DebugUITools.getDebugContextManager().getContextService(this.fWindow).getActiveContext());
        }
    }

    private void deactivate(String contextId, IPerspectiveDescriptor perspective) {
        DebugContextViewBindings bindings;
        if (this.fWindow == null) {
            return;
        }
        IWorkbenchPage page = this.fWindow.getActivePage();
        if (page != null && (bindings = (DebugContextViewBindings)this.fContextIdsToBindings.get(contextId)) != null) {
            bindings.deactivate(page, perspective);
        }
    }

    private Set getDisabledContexts(ContextManagerEvent event) {
        HashSet prev = new HashSet(event.getPreviouslyActiveContextIds());
        Set activeContextIds = event.getContextManager().getActiveContextIds();
        if (activeContextIds != null) {
            prev.removeAll(activeContextIds);
        }
        return prev;
    }

    private boolean isViewConetxt(String id) {
        return this.fContextIdsToBindings.containsKey(id);
    }

    private void saveViewBindings() {
        try {
            try {
                Document document = DebugPlugin.newDocument();
                Element root = document.createElement(XML_ELEMENT_VIEW_BINDINGS);
                document.appendChild(root);
                HashSet done = new HashSet();
                Iterator bindings = this.fContextIdsToBindings.values().iterator();
                while (bindings.hasNext()) {
                    DebugContextViewBindings binding = (DebugContextViewBindings)bindings.next();
                    binding.saveBindings(document, root, done);
                }
                String prefValue = "";
                if (root.hasChildNodes()) {
                    prefValue = DebugPlugin.serializeDocument((Document)document);
                }
                this.fIgnoreChanges = true;
                DebugUITools.getPreferenceStore().setValue("org.eclipse.debug.ui.user_view_bindings", prefValue);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
                this.fIgnoreChanges = false;
            }
        }
        finally {
            this.fIgnoreChanges = false;
        }
    }

    public String[] getEnabledPerspectives() {
        return this.fEnabledPerspectives.toArray(new String[this.fEnabledPerspectives.size()]);
    }

    public void showViewQuiet(String viewId) {
        if (this.fWindow == null) {
            return;
        }
        IWorkbenchPage page = this.fWindow.getActivePage();
        if (page != null) {
            try {
                try {
                    this.fIgnoreChanges = true;
                    IViewPart part = page.showView(viewId, null, 2);
                    if (!page.isPartVisible((IWorkbenchPart)part)) {
                        page.bringToTop((IWorkbenchPart)part);
                    }
                }
                catch (PartInitException e) {
                    DebugUIPlugin.log(e);
                    this.fIgnoreChanges = false;
                }
            }
            finally {
                this.fIgnoreChanges = false;
            }
        }
    }

    public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (page.getWorkbenchWindow().equals(this.fWindow)) {
            this.fActivePerspective = null;
            this.clean(perspective);
        }
    }

    static /* synthetic */ String[] access$0() {
        return EMPTY_IDS;
    }

    private class DebugContextViewBindings {
        private String fId;
        private String[] fViewBindingIds = ViewContextService.access$0();
        private String[] fAllViewBindingIds = null;
        private Map fAllViewIdToBindings = new HashMap();
        private String[] fAllConetxtIds = null;
        private String fParentId;

        public DebugContextViewBindings(String id) {
            this.fId = id;
        }

        public String getId() {
            return this.fId;
        }

        public void addBinding(ViewBinding binding) {
            String[] newBindings = new String[this.fViewBindingIds.length + 1];
            System.arraycopy(this.fViewBindingIds, 0, newBindings, 0, this.fViewBindingIds.length);
            newBindings[this.fViewBindingIds.length] = binding.getViewId();
            this.fAllViewIdToBindings.put(binding.getViewId(), binding);
            this.fViewBindingIds = newBindings;
        }

        protected void setParentId(String id) {
            this.fParentId = id;
        }

        public DebugContextViewBindings getParentContext() {
            if (this.fParentId == null) {
                return null;
            }
            return (DebugContextViewBindings)ViewContextService.this.fContextIdsToBindings.get(this.fParentId);
        }

        public void activateChain(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            this.initializeChain();
            this.doActivation(page, perspective, this.fAllViewBindingIds, this.fAllConetxtIds);
        }

        private void doActivation(IWorkbenchPage page, IPerspectiveDescriptor perspective, String[] viewIds, String[] contextIds) {
            ViewBinding binding;
            String viewId;
            int i = 0;
            while (i < contextIds.length) {
                ViewContextService.this.addActivated(contextIds[i]);
                ++i;
            }
            ViewContextService.this.setActive(perspective, this.getId());
            i = 0;
            while (i < viewIds.length) {
                viewId = viewIds[i];
                binding = (ViewBinding)this.fAllViewIdToBindings.get(viewId);
                binding.activated(page, perspective);
                ++i;
            }
            i = 0;
            while (i < viewIds.length) {
                viewId = viewIds[i];
                binding = (ViewBinding)this.fAllViewIdToBindings.get(viewId);
                binding.checkZOrder(page, this.fAllViewBindingIds);
                ++i;
            }
        }

        private synchronized void initializeChain() {
            if (this.fAllViewBindingIds == null) {
                ArrayList<String> orderedIds = new ArrayList<String>();
                ArrayList<DebugContextViewBindings> contexts = new ArrayList<DebugContextViewBindings>();
                DebugContextViewBindings context = this;
                while (context != null) {
                    contexts.add(0, context);
                    context = context.getParentContext();
                }
                Iterator iterator = contexts.iterator();
                this.fAllConetxtIds = new String[contexts.size()];
                int pos = 0;
                while (iterator.hasNext()) {
                    DebugContextViewBindings bindings = (DebugContextViewBindings)iterator.next();
                    this.fAllConetxtIds[pos] = bindings.getId();
                    ++pos;
                    int i = 0;
                    while (i < bindings.fViewBindingIds.length) {
                        String viewId = bindings.fViewBindingIds[i];
                        if (bindings == this) {
                            orderedIds.add(viewId);
                        }
                        if (!this.fAllViewIdToBindings.containsKey(viewId)) {
                            orderedIds.add(viewId);
                            this.fAllViewIdToBindings.put(viewId, bindings.fAllViewIdToBindings.get(viewId));
                        }
                        ++i;
                    }
                }
                this.fAllViewBindingIds = orderedIds.toArray(new String[orderedIds.size()]);
            }
        }

        public void deactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            ViewContextService.this.removeActivated(this.getId());
            if (ViewContextService.this.isActiveContext(this.getId())) {
                ViewContextService.this.setActive(page.getPerspective(), null);
            }
            int i = 0;
            while (i < this.fViewBindingIds.length) {
                String viewId = this.fViewBindingIds[i];
                ViewBinding binding = (ViewBinding)this.fAllViewIdToBindings.get(viewId);
                binding.deactivated(page, perspective);
                ++i;
            }
        }

        public void setViewOpened(boolean opened, String viewId) {
            this.initializeChain();
            ViewBinding binding = (ViewBinding)this.fAllViewIdToBindings.get(viewId);
            if (binding != null) {
                if (opened) {
                    binding.userOpened();
                } else {
                    binding.userClosed();
                }
            }
        }

        public void applyUserSettings(String viewId, Element viewElement) {
            this.initializeChain();
            ViewBinding binding = (ViewBinding)this.fAllViewIdToBindings.get(viewId);
            if (binding != null) {
                binding.applyUserSettings(viewElement);
            }
        }

        public void saveBindings(Document document, Element root, Set alreadyDone) {
            int i = 0;
            while (i < this.fViewBindingIds.length) {
                String viewId = this.fViewBindingIds[i];
                if (!alreadyDone.contains(viewId)) {
                    alreadyDone.add(viewId);
                    ViewBinding binding = (ViewBinding)this.fAllViewIdToBindings.get(viewId);
                    binding.saveBindings(document, root);
                }
                ++i;
            }
        }
    }

    private class ViewBinding {
        private IConfigurationElement fElement;
        private Set fUserOpened = new HashSet();
        private Set fUserClosed = new HashSet();
        private Set fAutoOpened = new HashSet();

        public ViewBinding(IConfigurationElement element) {
            this.fElement = element;
        }

        public String getViewId() {
            return this.fElement.getAttribute(ViewContextService.ATTR_VIEW_ID);
        }

        public boolean isAutoOpen() {
            String autoopen = this.fElement.getAttribute(ViewContextService.ATTR_AUTO_OPEN);
            return autoopen == null || "true".equals(autoopen);
        }

        public boolean isAutoClose() {
            String autoclose = this.fElement.getAttribute(ViewContextService.ATTR_AUTO_CLOSE);
            return autoclose == null || "true".equals(autoclose);
        }

        public boolean isUserOpened(IPerspectiveDescriptor perspective) {
            return this.fUserOpened.contains(perspective.getId());
        }

        public boolean isUserClosed(IPerspectiveDescriptor perspective) {
            return this.fUserClosed.contains(ViewContextService.this.getActivePerspective().getId());
        }

        public boolean isDefault(IPerspectiveDescriptor perspective) {
            String id = perspective.getId();
            if ("org.eclipse.debug.ui.DebugPerspective".equals(id)) {
                return fgBaseDebugViewIds.contains(this.getViewId());
            }
            return false;
        }

        protected void userOpened() {
            if (this.isTrackingViews()) {
                String id = ViewContextService.this.getActivePerspective().getId();
                this.fAutoOpened.remove(id);
                this.fUserOpened.add(id);
                this.fUserClosed.remove(id);
                ViewContextService.this.saveViewBindings();
            }
        }

        protected void userClosed() {
            if (this.isTrackingViews()) {
                String id = ViewContextService.this.getActivePerspective().getId();
                this.fAutoOpened.remove(id);
                this.fUserClosed.add(id);
                this.fUserOpened.remove(id);
                ViewContextService.this.saveViewBindings();
            }
        }

        protected boolean isTrackingViews() {
            return DebugUITools.getPreferenceStore().getBoolean("org.eclipse.debug.ui.track_views");
        }

        public void activated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (!this.isUserClosed(perspective) && this.isAutoOpen()) {
                try {
                    try {
                        ViewContextService.this.fIgnoreChanges = true;
                        if (page.findViewReference(this.getViewId()) == null) {
                            this.fAutoOpened.add(perspective.getId());
                        }
                        page.showView(this.getViewId(), null, 3);
                    }
                    catch (PartInitException e) {
                        DebugUIPlugin.log(e);
                        ViewContextService.this.fIgnoreChanges = false;
                    }
                }
                finally {
                    ViewContextService.this.fIgnoreChanges = false;
                }
            }
        }

        public void checkZOrder(IWorkbenchPage page, String[] relevantViews) {
            IViewPart[] viewStack;
            IViewPart part = page.findView(this.getViewId());
            if (part != null && (viewStack = page.getViewStack(part)) != null && viewStack.length > 0) {
                String top = viewStack[0].getSite().getId();
                int i = 0;
                while (i < relevantViews.length) {
                    if (relevantViews[i].equals(top)) {
                        return;
                    }
                    ++i;
                }
                try {
                    ViewContextService.this.fIgnoreChanges = true;
                    page.bringToTop((IWorkbenchPart)part);
                }
                finally {
                    ViewContextService.this.fIgnoreChanges = false;
                }
            }
        }

        public void deactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            IViewReference reference;
            if (!this.isUserOpened(perspective) && this.fAutoOpened.remove(perspective.getId()) && this.isAutoClose() && !this.isDefault(perspective) && (reference = page.findViewReference(this.getViewId())) != null) {
                try {
                    ViewContextService.this.fIgnoreChanges = true;
                    page.hideView(reference);
                }
                finally {
                    ViewContextService.this.fIgnoreChanges = false;
                }
            }
        }

        public void saveBindings(Document document, Element root) {
            Element viewElement = document.createElement(ViewContextService.XML_ELEMENT_VIEW);
            viewElement.setAttribute(ViewContextService.XML_ATTR_ID, this.getViewId());
            this.appendPerspectives(document, viewElement, this.fUserOpened, ViewContextService.XML_VALUE_OPENED);
            this.appendPerspectives(document, viewElement, this.fUserClosed, ViewContextService.XML_VALUE_CLOSED);
            if (viewElement.hasChildNodes()) {
                root.appendChild(viewElement);
            }
        }

        private void appendPerspectives(Document document, Element parent, Set perpectives, String xmlValue) {
            String[] ids = perpectives.toArray(new String[perpectives.size()]);
            int i = 0;
            while (i < ids.length) {
                String id = ids[i];
                Element element = document.createElement("perspective");
                element.setAttribute(ViewContextService.XML_ATTR_ID, id);
                element.setAttribute(ViewContextService.XML_ATTR_USER_ACTION, xmlValue);
                parent.appendChild(element);
                ++i;
            }
        }

        public void applyUserSettings(Element viewElement) {
            NodeList list = viewElement.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase("perspective")) {
                    String id = entry.getAttribute(ViewContextService.XML_ATTR_ID);
                    String setting = entry.getAttribute(ViewContextService.XML_ATTR_USER_ACTION);
                    if (id != null) {
                        if (ViewContextService.XML_VALUE_CLOSED.equals(setting)) {
                            this.fUserClosed.add(id);
                        } else if (ViewContextService.XML_VALUE_OPENED.equals(setting)) {
                            this.fUserOpened.add(id);
                        }
                    }
                }
                ++i;
            }
        }
    }
}

