/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.ISimpleCSCommandKeyListener;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.NewCommandKeyEvent;

public class SimpleCSCommandManager {
    private ListenerList fListeners = null;
    private static SimpleCSCommandManager fPinstance;
    private Map fCommandMap = Collections.synchronizedMap(new HashMap());
    private boolean fBlockEvents = false;

    private SimpleCSCommandManager() {
    }

    public void setBlockEvents(boolean block) {
        this.fBlockEvents = block;
    }

    public boolean getBlockEvents() {
        return this.fBlockEvents;
    }

    public static SimpleCSCommandManager Instance() {
        if (fPinstance == null) {
            fPinstance = new SimpleCSCommandManager();
        }
        return fPinstance;
    }

    public synchronized boolean put(String key, String value) {
        if (this.fCommandMap.containsKey(key)) {
            String presentValue = (String)this.fCommandMap.get(key);
            if (presentValue == null && value == null) {
                return false;
            }
            if (presentValue != null && presentValue.equals(value)) {
                return false;
            }
        }
        this.fCommandMap.put(key, value);
        this.fireNewCommandKeyEvent(key, value);
        return true;
    }

    public String get(String key) {
        return (String)this.fCommandMap.get(key);
    }

    public boolean hasKey(String key) {
        return this.fCommandMap.containsKey(key);
    }

    public Set getKeys() {
        return this.fCommandMap.keySet();
    }

    public int getSize() {
        return this.fCommandMap.size();
    }

    public void addCommandKeyListener(ISimpleCSCommandKeyListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
    }

    public void removeCommandKeyListener(ISimpleCSCommandKeyListener listener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove((Object)listener);
    }

    private void fireNewCommandKeyEvent(String key, String value) {
        if (this.fBlockEvents || this.fListeners == null || this.fListeners.size() == 0) {
            return;
        }
        NewCommandKeyEvent event = new NewCommandKeyEvent(this, key, value);
        Object[] listenerList = this.fListeners.getListeners();
        int i = 0;
        while (i < this.fListeners.size()) {
            ISimpleCSCommandKeyListener listener = (ISimpleCSCommandKeyListener)listenerList[i];
            listener.newCommandKey(event);
            ++i;
        }
    }
}

