/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureInstallHandler;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureAdvancedPage;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class HandlerSection
extends PDESection {
    private FormEntry fLibraryText;
    private FormEntry fHandlerText;

    public HandlerSection(FeatureAdvancedPage page, Composite parent) {
        super(page, parent, 128);
        this.getSection().setText(PDEUIMessages.FeatureEditor_HandlerSection_title);
        this.getSection().setDescription(PDEUIMessages.FeatureEditor_HandlerSection_desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void commit(boolean onSave) {
        this.fLibraryText.commit();
        this.fHandlerText.commit();
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        section.setLayoutData((Object)data);
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        container.setLayoutData((Object)new GridData(768));
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        final IFeature feature = model.getFeature();
        this.fLibraryText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_HandlerSection_library, null, false);
        this.fLibraryText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    HandlerSection.this.setLibrary(feature, text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fHandlerText = new FormEntry(container, toolkit, PDEUIMessages.FeatureEditor_HandlerSection_handler, null, false);
        this.fHandlerText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    HandlerSection.this.setHandler(feature, text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private void setLibrary(IFeature feature, String value) throws CoreException {
        IFeatureInstallHandler handler = this.getHandler(feature);
        handler.setLibrary(value);
    }

    private void setHandler(IFeature feature, String value) throws CoreException {
        IFeatureInstallHandler handler = this.getHandler(feature);
        handler.setHandlerName(value);
    }

    private IFeatureInstallHandler getHandler(IFeature feature) throws CoreException {
        IFeatureInstallHandler handler = feature.getInstallHandler();
        if (handler == null) {
            handler = feature.getModel().getFactory().createInstallHandler();
            feature.setInstallHandler(handler);
        }
        return handler;
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        if (!model.isEditable()) {
            this.fLibraryText.getText().setEditable(false);
            this.fHandlerText.getText().setEditable(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        }
    }

    public void setFocus() {
        if (this.fLibraryText != null) {
            this.fLibraryText.getText().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, Object value) {
        if (value != null) {
            formText.setValue(value.toString(), true);
        } else {
            formText.setValue(null, true);
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IFeatureInstallHandler handler = feature.getInstallHandler();
        if (handler != null) {
            this.setIfDefined(this.fLibraryText, handler.getLibrary());
            this.setIfDefined(this.fHandlerText, handler.getHandlerName());
        }
        super.refresh();
    }

    public void cancelEdit() {
        this.fLibraryText.cancelEdit();
        this.fHandlerText.cancelEdit();
        super.cancelEdit();
    }
}

