/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import com.ibm.icu.util.Calendar;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryFilter;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.ui.PlatformUI;

public class CVSHistoryFilterDialog
extends TrayDialog {
    private CVSHistoryFilter historyFilter;
    private Button orRadio;
    private Button andRadio;
    private Text author;
    private Text comment;
    private DateTime fromDate;
    private DateTime toDate;

    public CVSHistoryFilterDialog(Shell shell) {
        super(shell);
        this.setHelpAvailable(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CVSUIMessages.HistoryFilterDialog_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.team.cvs.ui.history_filter_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        topLevel.setLayout((Layout)layout);
        Label label = new Label(topLevel, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(CVSUIMessages.HistoryFilterDialog_showMatching);
        this.andRadio = new Button(topLevel, 16);
        this.andRadio.setText(CVSUIMessages.HistoryFilterDialog_matchingAll);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.andRadio.setLayoutData((Object)data);
        this.andRadio.setSelection(true);
        this.orRadio = new Button(topLevel, 16);
        this.orRadio.setText(CVSUIMessages.HistoryFilterDialog_matchingAny);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.orRadio.setLayoutData((Object)data);
        label = new Label(topLevel, 0);
        label.setText(CVSUIMessages.HistoryFilterDialog_author);
        this.author = new Text(topLevel, 2048);
        this.author.setLayoutData((Object)new GridData(768));
        label = new Label(topLevel, 0);
        label.setText(CVSUIMessages.HistoryFilterDialog_comment);
        this.comment = new Text(topLevel, 2048);
        this.comment.setLayoutData((Object)new GridData(768));
        label = new Label(topLevel, 0);
        label.setText(CVSUIMessages.HistoryFilterDialog_fromDate);
        this.fromDate = new DateTime(topLevel, 2080);
        label = new Label(topLevel, 0);
        label.setText(CVSUIMessages.HistoryFilterDialog_toDate);
        this.toDate = new DateTime(topLevel, 2080);
        this.initializeValues();
        Dialog.applyDialogFont((Control)parent);
        return topLevel;
    }

    void initializeValues() {
        if (this.historyFilter == null) {
            return;
        }
        if (this.historyFilter.author != null) {
            this.author.setText(this.historyFilter.author);
        }
        if (this.historyFilter.comment != null) {
            this.comment.setText(this.historyFilter.comment);
        }
        this.orRadio.setSelection(this.historyFilter.isOr);
        this.andRadio.setSelection(!this.historyFilter.isOr);
        Calendar calendar = Calendar.getInstance();
        if (this.historyFilter.fromDate != null) {
            calendar.setTime(this.historyFilter.fromDate);
            this.fromDate.setDay(calendar.get(5));
            this.fromDate.setMonth(calendar.get(2));
            this.fromDate.setYear(calendar.get(1));
        }
        if (this.historyFilter.toDate != null) {
            calendar.setTime(this.historyFilter.toDate);
            this.toDate.setDay(calendar.get(5));
            this.toDate.setMonth(calendar.get(2));
            this.toDate.setYear(calendar.get(1));
        }
    }

    protected void buttonPressed(int buttonId) {
        if (1 == buttonId) {
            super.buttonPressed(buttonId);
            return;
        }
        Date fromDate = this.getFromDate();
        Date toDate = this.getToDate();
        this.historyFilter = new CVSHistoryFilter(this.author.getText(), this.comment.getText(), fromDate, toDate, this.orRadio.getSelection());
        super.buttonPressed(buttonId);
    }

    private Calendar getCalendar(DateTime dateWidget) {
        Calendar calendar = Calendar.getInstance();
        if (this.isFutureDate(dateWidget, calendar)) {
            return null;
        }
        calendar.set(1, dateWidget.getYear());
        calendar.set(2, dateWidget.getMonth());
        calendar.set(5, dateWidget.getDay());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar;
    }

    private boolean isFutureDate(DateTime dateWidget, Calendar calendar) {
        if (calendar.get(1) < dateWidget.getYear()) {
            return true;
        }
        if (calendar.get(1) == dateWidget.getYear()) {
            if (calendar.get(2) < dateWidget.getMonth()) {
                return true;
            }
            if (calendar.get(2) == dateWidget.getMonth() && calendar.get(5) <= dateWidget.getDay()) {
                return true;
            }
        }
        return false;
    }

    private Date getFromDate() {
        Calendar calendar = this.getCalendar(this.fromDate);
        if (calendar == null) {
            return null;
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    private Date getToDate() {
        Calendar calendar = this.getCalendar(this.toDate);
        if (calendar == null) {
            return null;
        }
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public CVSHistoryFilter getFilter() {
        return this.historyFilter;
    }

    public void setFilter(CVSHistoryFilter filter) {
        this.historyFilter = filter;
    }
}

