/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.dotnet;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.dotnet.NetCommand;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;

public class Ildasm
extends Task {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File sourceFile;
    private File destFile;
    private boolean progressBar = false;
    private String encoding;
    private boolean bytes = false;
    private boolean linenumbers = false;
    private boolean rawExceptionHandling = false;
    private boolean showSource = false;
    private boolean quoteallnames = false;
    private boolean header = false;
    private boolean assembler = true;
    private boolean metadata = false;
    private String visibility;
    private String item;
    private String executable = "ildasm";
    private File resourceDir;

    public void setResourceDir(File resourceDir) {
        this.resourceDir = resourceDir;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void setEncoding(EncodingTypes encoding) {
        this.encoding = encoding.getValue();
    }

    public void setAssembler(boolean assembler) {
        this.assembler = assembler;
    }

    public void setBytes(boolean bytes) {
        this.bytes = bytes;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public void setItem(String item) {
        this.item = item;
    }

    public void setLinenumbers(boolean linenumbers) {
        this.linenumbers = linenumbers;
    }

    public void setMetadata(boolean metadata) {
        this.metadata = metadata;
    }

    public void setProgressBar(boolean progressBar) {
        this.progressBar = progressBar;
    }

    public void setQuoteallnames(boolean quoteallnames) {
        this.quoteallnames = quoteallnames;
    }

    public void setRawExceptionHandling(boolean rawExceptionHandling) {
        this.rawExceptionHandling = rawExceptionHandling;
    }

    public void setShowSource(boolean showSource) {
        this.showSource = showSource;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setSrcFile(File sourceFile) {
        this.setSourceFile(sourceFile);
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    private void validate() {
        if (this.sourceFile == null || !this.sourceFile.exists() || !this.sourceFile.isFile()) {
            throw new BuildException("invalid source");
        }
        if (this.destFile == null || this.destFile.isDirectory()) {
            throw new BuildException("invalid dest");
        }
        if (!(this.resourceDir == null || this.resourceDir.exists() && this.resourceDir.isDirectory())) {
            throw new BuildException("invalid resource directory");
        }
    }

    private boolean isDisassemblyNeeded() {
        long destTime;
        if (!this.destFile.exists()) {
            this.log("Destination file does not exist: a build is required", 3);
            return true;
        }
        long sourceTime = this.sourceFile.lastModified();
        if (sourceTime > (destTime = this.destFile.lastModified()) + FILE_UTILS.getFileTimestampGranularity()) {
            this.log("Source file is newer than the dest file: a rebuild is required", 3);
            return true;
        }
        this.log("The .il file is up to date", 3);
        return false;
    }

    public void execute() throws BuildException {
        this.log("This task is deprecated and will be removed in a future version\nof Ant.  It is now part of the .NET Antlib:\nhttp://ant.apache.org/antlibs/dotnet/index.html", 1);
        this.validate();
        if (!this.isDisassemblyNeeded()) {
            return;
        }
        NetCommand command = new NetCommand(this, "ildasm", this.executable);
        command.setFailOnError(true);
        command.addArgument("/text");
        command.addArgument("/out=" + this.destFile.toString());
        if (!this.progressBar) {
            command.addArgument("/nobar");
        }
        if (this.linenumbers) {
            command.addArgument("/linenum");
        }
        if (this.showSource) {
            command.addArgument("/source");
        }
        if (this.quoteallnames) {
            command.addArgument("/quoteallnames");
        }
        if (this.header) {
            command.addArgument("/header");
        }
        if (!this.assembler) {
            command.addArgument("/noil");
        }
        if (this.metadata) {
            command.addArgument("/tokens");
        }
        command.addArgument("/item:", this.item);
        if (this.rawExceptionHandling) {
            command.addArgument("/raweh");
        }
        command.addArgument(EncodingTypes.getEncodingOption(this.encoding));
        if (this.bytes) {
            command.addArgument("/bytes");
        }
        command.addArgument("/vis:", this.visibility);
        command.addArgument(this.sourceFile.getAbsolutePath());
        File execDir = this.resourceDir;
        if (execDir == null) {
            execDir = this.destFile.getParentFile();
        }
        command.setDirectory(execDir);
        try {
            command.runCommand();
        }
        catch (BuildException e) {
            if (this.destFile.exists()) {
                this.log("Deleting destination file as it may be corrupt");
                this.destFile.delete();
            }
            throw e;
        }
    }

    public static class EncodingTypes
    extends EnumeratedAttribute {
        public static final String UNICODE = "unicode";
        public static final String UTF8 = "utf8";
        public static final String ASCII = "ascii";

        public String[] getValues() {
            return new String[]{ASCII, UTF8, UNICODE};
        }

        public static String getEncodingOption(String enumValue) {
            if (UNICODE.equals(enumValue)) {
                return "/unicode";
            }
            if (UTF8.equals(enumValue)) {
                return "/utf8";
            }
            return null;
        }
    }

    public static class VisibilityOptions
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"pub", "pri", "fam", "asm", "faa", "foa", "psc"};
        }
    }
}

