/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.ProjectHelperRepository;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.UnknownElement;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.core.AntClassLoader;
import org.eclipse.ant.internal.core.AntCoreUtil;
import org.eclipse.ant.internal.core.AntSecurityManager;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.editor.DecayCodeCompletionDataStructuresThread;
import org.eclipse.ant.internal.ui.editor.outline.AntEditorMarkerUpdater;
import org.eclipse.ant.internal.ui.model.AntAntNode;
import org.eclipse.ant.internal.ui.model.AntCommentNode;
import org.eclipse.ant.internal.ui.model.AntDTDNode;
import org.eclipse.ant.internal.ui.model.AntDefiningTaskNode;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntImportNode;
import org.eclipse.ant.internal.ui.model.AntModelChangeEvent;
import org.eclipse.ant.internal.ui.model.AntModelCore;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntModelProblem;
import org.eclipse.ant.internal.ui.model.AntModelProject;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntPropertyNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.ant.internal.ui.model.IProblem;
import org.eclipse.ant.internal.ui.model.IProblemRequestor;
import org.eclipse.ant.internal.ui.model.LocationProvider;
import org.eclipse.ant.internal.ui.preferences.AntEditorPreferenceConstants;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ISynchronizable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;

public class AntModel
implements IAntModel {
    private static ClassLoader fgClassLoader;
    private static int fgInstanceCount;
    private static Object loaderLock;
    private IDocument fDocument;
    private IProblemRequestor fProblemRequestor;
    private LocationProvider fLocationProvider;
    private AntProjectNode fProjectNode;
    private AntTargetNode fCurrentTargetNode;
    private AntElementNode fLastNode;
    private AntElementNode fNodeBeingResolved;
    private int fNodeBeingResolvedIndex = -1;
    private Map fEntityNameToPath;
    private Stack fStillOpenElements = new Stack();
    private Map fTaskToNode = new HashMap();
    private List fTaskNodes = new ArrayList();
    private final Object fDirtyLock = new Object();
    private boolean fIsDirty = true;
    private File fEditedFile = null;
    private ClassLoader fLocalClassLoader = null;
    private boolean fHasLexicalInfo = true;
    private boolean fHasPositionInfo = true;
    private boolean fHasTaskInfo = true;
    private IDocumentListener fListener;
    private AntEditorMarkerUpdater fMarkerUpdater = null;
    private List fNonStructuralNodes = new ArrayList(1);
    private Preferences.IPropertyChangeListener fCorePropertyChangeListener;
    private Preferences.IPropertyChangeListener fUIPropertyChangeListener;
    private Map fProperties = null;
    private List fPropertyFiles = null;
    private Map fDefinersToText;
    private Map fPreviousDefinersToText;
    private Map fDefinerNodeIdentifierToDefinedTasks;
    private Map fTaskNameToDefiningNode;
    private Map fCurrentNodeIdentifiers;
    private boolean fReportingProblemsCurrent = false;
    private boolean fDoNotReportProblems = false;
    private boolean fShouldReconcile = true;
    private HashMap fNamespacePrefixMappings;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        fgInstanceCount = 0;
        loaderLock = new Object();
    }

    public AntModel(IDocument document, IProblemRequestor problemRequestor, LocationProvider locationProvider) {
        this.init(document, problemRequestor, locationProvider);
        this.fMarkerUpdater = new AntEditorMarkerUpdater();
        this.fMarkerUpdater.setModel(this);
        this.fCorePropertyChangeListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                if (event.getProperty().equals("classpath_changed") && (Boolean)event.getNewValue() == Boolean.TRUE) {
                    AntModel.this.reconcileForPropertyChange(true);
                }
            }
        };
        AntCorePlugin.getPlugin().getPluginPreferences().addPropertyChangeListener(this.fCorePropertyChangeListener);
        this.fUIPropertyChangeListener = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("problem")) {
                    AntUIPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(AntModel.this.fUIPropertyChangeListener);
                    AntModel.this.reconcileForPropertyChange(false);
                    AntUIPlugin.getDefault().getPluginPreferences().setToDefault("problem");
                    AntUIPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(AntModel.this.fUIPropertyChangeListener);
                } else if (property.equals("content_assist_userDefinedTasks")) {
                    AntModel.this.reconcileForPropertyChange(false);
                } else if (property.equals(AntEditorPreferenceConstants.BUILDFILE_NAMES_TO_IGNORE) || property.equals(AntEditorPreferenceConstants.BUILDFILE_IGNORE_ALL)) {
                    AntModel.this.fReportingProblemsCurrent = false;
                    AntModel.this.reconcileForPropertyChange(false);
                }
            }
        };
        AntUIPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.fUIPropertyChangeListener);
    }

    public AntModel(IDocument document, IProblemRequestor problemRequestor, LocationProvider locationProvider, boolean resolveLexicalInfo, boolean resolvePositionInfo, boolean resolveTaskInfo) {
        this.init(document, problemRequestor, locationProvider);
        this.fHasLexicalInfo = resolveLexicalInfo;
        this.fHasPositionInfo = resolvePositionInfo;
        this.fHasTaskInfo = resolveTaskInfo;
    }

    private void init(IDocument document, IProblemRequestor problemRequestor, LocationProvider locationProvider) {
        this.fDocument = document;
        this.fProblemRequestor = problemRequestor;
        this.fLocationProvider = locationProvider;
        if (fgInstanceCount == 0) {
            AntDefiningTaskNode.setJavaClassPath();
            AntModelCore.getDefault().startBreakpointListening();
        }
        ++fgInstanceCount;
        DecayCodeCompletionDataStructuresThread.cancel();
        org.eclipse.ant.internal.ui.editor.utils.ProjectHelper helper = this.getProjectHelper();
        if (helper == null) {
            ProjectHelperRepository projectHelperRepository = ProjectHelperRepository.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ant.internal.ui.editor.utils.ProjectHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            projectHelperRepository.registerProjectHelper((Class)clazz);
        }
    }

    org.eclipse.ant.internal.ui.editor.utils.ProjectHelper getProjectHelper() {
        Iterator helpers = ProjectHelperRepository.getInstance().getHelpers();
        while (helpers.hasNext()) {
            ProjectHelper helper = (ProjectHelper)helpers.next();
            if (!(helper instanceof org.eclipse.ant.internal.ui.editor.utils.ProjectHelper)) continue;
            return (org.eclipse.ant.internal.ui.editor.utils.ProjectHelper)helper;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.getLockObject();
        synchronized (object) {
            if (this.fDocument != null && this.fListener != null) {
                this.fDocument.removeDocumentListener(this.fListener);
            }
            this.fDocument = null;
            this.fLocationProvider = null;
            org.eclipse.ant.internal.ui.editor.utils.ProjectHelper.setAntModel(null);
        }
        if (this.fCorePropertyChangeListener != null) {
            AntCorePlugin.getPlugin().getPluginPreferences().removePropertyChangeListener(this.fCorePropertyChangeListener);
        }
        if (this.fUIPropertyChangeListener != null) {
            AntUIPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.fUIPropertyChangeListener);
        }
        if (--fgInstanceCount == 0) {
            fgClassLoader = null;
            DecayCodeCompletionDataStructuresThread.getDefault().start();
            AntModelCore.getDefault().stopBreakpointListening();
            this.cleanup();
        }
    }

    private Object getLockObject() {
        Object lock;
        if (this.fDocument instanceof ISynchronizable && (lock = ((ISynchronizable)this.fDocument).getLockObject()) != null) {
            return lock;
        }
        return this;
    }

    private void cleanup() {
        AntProjectNode projectNode = this.getProjectNode();
        if (projectNode != null) {
            Project project = projectNode.getProject();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ant.internal.ui.model.AntModel$Small");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IntrospectionHelper.getHelper((Project)project, (Class)clazz);
            projectNode.getProject().fireBuildFinished(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile() {
        Object object = this.fDirtyLock;
        synchronized (object) {
            if (!this.fShouldReconcile || !this.fIsDirty) {
                return;
            }
            this.fIsDirty = false;
        }
        object = this.getLockObject();
        synchronized (object) {
            if (this.fLocationProvider == null) {
                return;
            }
            if (this.fDocument == null) {
                this.fProjectNode = null;
            } else {
                this.reset();
                this.parseDocument(this.fDocument);
                this.reconcileTaskAndTypes();
            }
            AntModelCore.getDefault().notifyAntModelListeners(new AntModelChangeEvent(this));
        }
    }

    private void reset() {
        this.fCurrentTargetNode = null;
        this.fStillOpenElements = new Stack();
        this.fTaskToNode = new HashMap();
        this.fTaskNodes = new ArrayList();
        this.fNodeBeingResolved = null;
        this.fNodeBeingResolvedIndex = -1;
        this.fLastNode = null;
        this.fCurrentNodeIdentifiers = null;
        this.fNamespacePrefixMappings = null;
        this.fNonStructuralNodes = new ArrayList(1);
        if (this.fDefinersToText != null) {
            this.fPreviousDefinersToText = new HashMap(this.fDefinersToText);
            this.fDefinersToText = null;
        }
    }

    private void parseDocument(IDocument input) {
        block24: {
            boolean parsed = true;
            if (input.getLength() == 0) {
                this.fProjectNode = null;
                parsed = false;
                return;
            }
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader parsingClassLoader = this.getClassLoader(originalClassLoader);
            Thread.currentThread().setContextClassLoader(parsingClassLoader);
            AntModelProject project = null;
            try {
                try {
                    org.eclipse.ant.internal.ui.editor.utils.ProjectHelper projectHelper = null;
                    String textToParse = input.get();
                    if (this.fProjectNode == null || !this.fProjectNode.hasChildren()) {
                        this.fProjectNode = null;
                        project = new AntModelProject();
                        projectHelper = this.prepareForFullParse(project, parsingClassLoader);
                    } else {
                        project = this.fProjectNode.getProject();
                        projectHelper = (org.eclipse.ant.internal.ui.editor.utils.ProjectHelper)((Object)project.getReference("ant.projectHelper"));
                        projectHelper.setBuildFile(this.getEditedFile());
                        this.prepareForFullIncremental();
                    }
                    this.beginReporting();
                    Hashtable references = project.getReferences();
                    references.remove("ant.parsing.context");
                    org.eclipse.ant.internal.ui.editor.utils.ProjectHelper.setAntModel(this);
                    projectHelper.parse(project, textToParse);
                }
                catch (BuildException e) {
                    this.handleBuildException(e, null);
                    if (!parsed) break block24;
                    SecurityManager origSM = System.getSecurityManager();
                    this.processAntHome(true);
                    try {
                        try {
                            System.setSecurityManager((SecurityManager)new AntSecurityManager(origSM, Thread.currentThread(), false));
                            this.resolveBuildfile();
                            this.endReporting();
                        }
                        catch (AntSecurityException antSecurityException) {
                            Thread.currentThread().setContextClassLoader(originalClassLoader);
                            this.getClassLoader(null);
                            System.setSecurityManager(origSM);
                            project.fireBuildFinished(null);
                        }
                        break block24;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(originalClassLoader);
                        this.getClassLoader(null);
                        System.setSecurityManager(origSM);
                        project.fireBuildFinished(null);
                    }
                }
            }
            catch (Throwable throwable) {
                block26: {
                    if (parsed) {
                        SecurityManager origSM = System.getSecurityManager();
                        this.processAntHome(true);
                        try {
                            try {
                                System.setSecurityManager((SecurityManager)new AntSecurityManager(origSM, Thread.currentThread(), false));
                                this.resolveBuildfile();
                                this.endReporting();
                            }
                            catch (AntSecurityException antSecurityException) {
                                Thread.currentThread().setContextClassLoader(originalClassLoader);
                                this.getClassLoader(null);
                                System.setSecurityManager(origSM);
                                project.fireBuildFinished(null);
                                break block26;
                            }
                        }
                        catch (Throwable throwable2) {
                            Thread.currentThread().setContextClassLoader(originalClassLoader);
                            this.getClassLoader(null);
                            System.setSecurityManager(origSM);
                            project.fireBuildFinished(null);
                            throw throwable2;
                        }
                        Thread.currentThread().setContextClassLoader(originalClassLoader);
                        this.getClassLoader(null);
                        System.setSecurityManager(origSM);
                        project.fireBuildFinished(null);
                    }
                }
                throw throwable;
            }
            if (parsed) {
                SecurityManager origSM = System.getSecurityManager();
                this.processAntHome(true);
                try {
                    try {
                        System.setSecurityManager((SecurityManager)new AntSecurityManager(origSM, Thread.currentThread(), false));
                        this.resolveBuildfile();
                        this.endReporting();
                    }
                    catch (AntSecurityException antSecurityException) {
                        Thread.currentThread().setContextClassLoader(originalClassLoader);
                        this.getClassLoader(null);
                        System.setSecurityManager(origSM);
                        project.fireBuildFinished(null);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                    this.getClassLoader(null);
                    System.setSecurityManager(origSM);
                    project.fireBuildFinished(null);
                }
            }
        }
    }

    private org.eclipse.ant.internal.ui.editor.utils.ProjectHelper prepareForFullParse(Project project, ClassLoader parsingClassLoader) {
        this.initializeProject(project, parsingClassLoader);
        File file = this.getEditedFile();
        String filePath = "";
        if (file != null) {
            filePath = file.getAbsolutePath();
        }
        project.setUserProperty("ant.file", filePath);
        project.setUserProperty("ant.version", Main.getAntVersion());
        org.eclipse.ant.internal.ui.editor.utils.ProjectHelper projectHelper = this.getProjectHelper();
        org.eclipse.ant.internal.ui.editor.utils.ProjectHelper.setAntModel(this);
        projectHelper.setBuildFile(file);
        project.addReference("ant.projectHelper", (Object)projectHelper);
        return projectHelper;
    }

    private void prepareForFullIncremental() {
        this.fProjectNode.reset();
        this.fTaskToNode = new HashMap();
        this.fTaskNodes = new ArrayList();
    }

    private void initializeProject(Project project, ClassLoader loader) {
        this.processAntHome(false);
        project.init();
        this.setProperties(project);
        this.setTasks(project, loader);
        this.setTypes(project, loader);
    }

    private void setTasks(Project project, ClassLoader loader) {
        List tasks = AntCorePlugin.getPlugin().getPreferences().getTasks();
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            AntTypeDefinition def = new AntTypeDefinition();
            def.setName(task.getTaskName());
            def.setClassName(task.getClassName());
            def.setClassLoader(loader);
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.apache.tools.ant.Task");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            def.setAdaptToClass((Class)clazz);
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.apache.tools.ant.TaskAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            def.setAdapterClass((Class)clazz2);
            ComponentHelper.getComponentHelper((Project)project).addDataTypeDefinition(def);
        }
    }

    private void setTypes(Project project, ClassLoader loader) {
        List types = AntCorePlugin.getPlugin().getPreferences().getTypes();
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            AntTypeDefinition def = new AntTypeDefinition();
            def.setName(type.getTypeName());
            def.setClassName(type.getClassName());
            def.setClassLoader(loader);
            ComponentHelper.getComponentHelper((Project)project).addDataTypeDefinition(def);
        }
    }

    private void setProperties(Project project) {
        this.setBuiltInProperties(project);
        this.setExtraProperties(project);
        this.setGlobalProperties(project);
        this.loadExtraPropertyFiles(project);
        this.loadPropertyFiles(project);
    }

    private void setExtraProperties(Project project) {
        if (this.fProperties != null) {
            Pattern pattern = Pattern.compile("\\$\\{.*_prompt.*\\}");
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            Iterator iter = this.fProperties.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                String value = (String)this.fProperties.get(name);
                if (!pattern.matcher(value).find()) {
                    try {
                        value = manager.performStringSubstitution(value);
                    }
                    catch (CoreException coreException) {}
                }
                if (value == null) continue;
                project.setUserProperty(name, value);
            }
        }
    }

    private void loadExtraPropertyFiles(Project project) {
        if (this.fPropertyFiles != null) {
            try {
                List allProperties = AntCoreUtil.loadPropertyFiles((List)this.fPropertyFiles, (String)project.getUserProperty("basedir"), (String)this.getEditedFile().getAbsolutePath());
                this.setPropertiesFromFiles(project, allProperties);
            }
            catch (IOException e1) {
                AntUIPlugin.log(e1);
            }
        }
    }

    private void loadPropertyFiles(Project project) {
        List<String> fileNames = Arrays.asList(AntCorePlugin.getPlugin().getPreferences().getCustomPropertyFiles());
        try {
            List allProperties = AntCoreUtil.loadPropertyFiles(fileNames, (String)project.getUserProperty("basedir"), (String)this.getEditedFile().getAbsolutePath());
            this.setPropertiesFromFiles(project, allProperties);
        }
        catch (IOException e1) {
            AntUIPlugin.log(e1);
        }
    }

    private void setPropertiesFromFiles(Project project, List allProperties) {
        Iterator iter = allProperties.iterator();
        while (iter.hasNext()) {
            Properties props = (Properties)iter.next();
            Enumeration<?> propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                if (project.getUserProperty(name) != null) continue;
                project.setUserProperty(name, props.getProperty(name));
            }
        }
    }

    private void setBuiltInProperties(Project project) {
        project.setUserProperty("ant.file", this.getEditedFile().getAbsolutePath());
        project.setUserProperty("ant.version", Main.getAntVersion());
    }

    private void processAntHome(boolean finished) {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        String antHome = prefs.getAntHome();
        if (finished || antHome == null) {
            System.getProperties().remove("ant.home");
            System.getProperties().remove("ant.library.dir");
        } else {
            System.setProperty("ant.home", antHome);
            File antLibDir = new File(antHome, "lib");
            System.setProperty("ant.library.dir", antLibDir.getAbsolutePath());
        }
    }

    private void setGlobalProperties(Project project) {
        List properties = AntCorePlugin.getPlugin().getPreferences().getProperties();
        if (properties != null) {
            Iterator iter = properties.iterator();
            while (iter.hasNext()) {
                Property property = (Property)iter.next();
                String value = property.getValue(true);
                if (value == null) continue;
                project.setUserProperty(property.getName(), value);
            }
        }
    }

    private void resolveBuildfile() {
        ArrayList nodeCopy = new ArrayList(this.fTaskNodes);
        Iterator iter = nodeCopy.iterator();
        while (iter.hasNext()) {
            AntTaskNode node = (AntTaskNode)iter.next();
            this.fNodeBeingResolved = node;
            this.fNodeBeingResolvedIndex = -1;
            if (!node.configure(false)) continue;
            this.resolveBuildfile();
        }
        this.fNodeBeingResolved = null;
        this.fNodeBeingResolvedIndex = -1;
        this.checkTargets();
    }

    private void checkTargets() {
        if (this.fProjectNode == null || this.doNotReportProblems()) {
            return;
        }
        String defaultTargetName = this.fProjectNode.getDefaultTargetName();
        if (defaultTargetName != null && this.fProjectNode.getProject().getTargets().get(defaultTargetName) == null) {
            String message = MessageFormat.format((String)AntModelMessages.AntModel_43, (Object[])new String[]{defaultTargetName});
            IProblem problem = this.createProblem(message, this.fProjectNode.getOffset(), this.fProjectNode.getSelectionLength(), 1);
            this.acceptProblem(problem);
            this.markHierarchy(this.fProjectNode, 1, message);
        }
        if (!this.fProjectNode.hasChildren()) {
            return;
        }
        List children = this.fProjectNode.getChildNodes();
        Iterator iter = children.iterator();
        boolean checkCircularDependencies = true;
        while (iter.hasNext()) {
            AntElementNode node;
            AntElementNode originalNode = node = (AntElementNode)iter.next();
            if (!(node instanceof AntTargetNode)) continue;
            if (checkCircularDependencies) {
                checkCircularDependencies = false;
                this.checkCircularDependencies(node);
            }
            this.checkMissingDependencies(node, originalNode);
        }
    }

    private void checkMissingDependencies(AntElementNode node, AntElementNode originalNode) {
        String missing = ((AntTargetNode)node).checkDependencies();
        if (missing != null) {
            String message = MessageFormat.format((String)AntModelMessages.AntModel_44, (Object[])new String[]{missing});
            AntElementNode importNode = node.getImportNode();
            if (importNode != null) {
                node = importNode;
            }
            IProblem problem = this.createProblem(message, node.getOffset(), node.getSelectionLength(), 1);
            this.acceptProblem(problem);
            this.markHierarchy(originalNode, 1, message);
        }
    }

    private boolean doNotReportProblems() {
        if (this.fReportingProblemsCurrent) {
            return this.fDoNotReportProblems;
        }
        this.fReportingProblemsCurrent = true;
        this.fDoNotReportProblems = false;
        if (AntUIPlugin.getDefault().getCombinedPreferenceStore().getBoolean(AntEditorPreferenceConstants.BUILDFILE_IGNORE_ALL)) {
            this.fDoNotReportProblems = true;
            return this.fDoNotReportProblems;
        }
        String buildFileNames = AntUIPlugin.getDefault().getCombinedPreferenceStore().getString(AntEditorPreferenceConstants.BUILDFILE_NAMES_TO_IGNORE);
        if (buildFileNames.length() > 0) {
            String[] names = AntUtil.parseString(buildFileNames, ",");
            String editedFileName = this.getEditedFile().getName();
            int i = 0;
            while (i < names.length) {
                String string = names[i];
                if (string.trim().equals(editedFileName)) {
                    this.fDoNotReportProblems = true;
                    return this.fDoNotReportProblems;
                }
                ++i;
            }
        }
        return this.fDoNotReportProblems;
    }

    private void checkCircularDependencies(AntElementNode node) {
        block3: {
            Target target = ((AntTargetNode)node).getTarget();
            String name = target.getName();
            if (name == null) {
                return;
            }
            try {
                target.getProject().topoSort(name, target.getProject().getTargets());
            }
            catch (BuildException be) {
                String message = be.getMessage();
                if (!message.startsWith("Circular")) break block3;
                IProblem problem = this.createProblem(message, node.getProjectNode().getOffset(), node.getProjectNode().getSelectionLength(), 1);
                this.acceptProblem(problem);
                this.markHierarchy(node.getProjectNode(), 1, message);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleBuildException(BuildException e, AntElementNode node, int severity) {
        try {
            if (node != null) {
                this.markHierarchy(node, severity, e.getMessage());
            }
            Location location = e.getLocation();
            int line = 0;
            int originalOffset = 0;
            int nonWhitespaceOffset = 0;
            int length = 0;
            if (location == Location.UNKNOWN_LOCATION && node != null) {
                if (node.getImportNode() != null) {
                    node = node.getImportNode();
                }
                nonWhitespaceOffset = node.getOffset();
                length = node.getLength();
            } else {
                line = location.getLineNumber();
                if (line == 0) {
                    AntProjectNode projectNode = this.getProjectNode();
                    if (projectNode == null) return;
                    length = projectNode.getSelectionLength();
                    nonWhitespaceOffset = projectNode.getOffset();
                    if (severity == 1) {
                        projectNode.setProblemSeverity(-1);
                        projectNode.setProblemMessage(null);
                    }
                } else if (node == null) {
                    nonWhitespaceOffset = originalOffset = this.getOffset(line, 1);
                    try {
                        nonWhitespaceOffset = this.getNonWhitespaceOffset(line, 1);
                    }
                    catch (BadLocationException badLocationException) {}
                    length = this.getLastCharColumn(line) - (nonWhitespaceOffset - originalOffset);
                } else {
                    if (node.getImportNode() != null) {
                        node = node.getImportNode();
                    }
                    nonWhitespaceOffset = node.getOffset();
                    length = node.getLength();
                }
            }
            this.notifyProblemRequestor((Exception)((Object)e), nonWhitespaceOffset, length, severity);
            return;
        }
        catch (BadLocationException badLocationException) {}
    }

    public void handleBuildException(BuildException e, AntElementNode node) {
        this.handleBuildException(e, node, 1);
    }

    public File getEditedFile() {
        if (this.fLocationProvider != null && this.fEditedFile == null) {
            this.fEditedFile = this.fLocationProvider.getLocation().toFile();
        }
        return this.fEditedFile;
    }

    /*
     * Unable to fully structure code
     */
    private void markHierarchy(AntElementNode openElement, int severity, String message) {
        if (!this.doNotReportProblems()) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            openElement.setProblemSeverity(severity);
            openElement.setProblemMessage(message);
            openElement = openElement.getParentNode();
lbl6:
            // 2 sources

            ** while (openElement != null)
        }
lbl7:
        // 1 sources

    }

    public LocationProvider getLocationProvider() {
        return this.fLocationProvider;
    }

    public void addTarget(Target newTarget, int line, int column) {
        AntTargetNode targetNode = new AntTargetNode(newTarget);
        this.fProjectNode.addChildNode(targetNode);
        this.fCurrentTargetNode = targetNode;
        this.fStillOpenElements.push(targetNode);
        if (this.fNodeBeingResolved instanceof AntImportNode) {
            targetNode.setImportNode(this.fNodeBeingResolved);
            targetNode.setExternal(true);
            targetNode.setFilePath(newTarget.getLocation().getFileName());
        } else {
            String targetFileName = newTarget.getLocation().getFileName();
            boolean external = this.isNodeExternal(targetFileName);
            targetNode.setExternal(external);
            if (external) {
                targetNode.setFilePath(targetFileName);
            }
        }
        this.computeOffset(targetNode, line, column);
    }

    public void addProject(Project project, int line, int column) {
        this.fProjectNode = new AntProjectNode((AntModelProject)project, this);
        this.fStillOpenElements.push(this.fProjectNode);
        this.computeOffset(this.fProjectNode, line, column);
    }

    public void addDTD(String name, int line, int column) {
        AntDTDNode node = new AntDTDNode(name);
        this.fStillOpenElements.push(node);
        int offset = -1;
        try {
            if (column <= 0) {
                offset = this.getOffset(line, 0);
                int lastCharColumn = this.getLastCharColumn(line);
                offset = this.computeOffsetUsingPrefix(line, offset, "<!DOCTYPE", lastCharColumn);
            } else {
                offset = this.getOffset(line, column);
            }
        }
        catch (BadLocationException e) {
            AntUIPlugin.log(e);
        }
        node.setOffset(offset);
        this.fNonStructuralNodes.add(node);
    }

    public void addTask(org.apache.tools.ant.Task newTask, org.apache.tools.ant.Task parentTask, Attributes attributes, int line, int column) {
        Target owningTarget;
        String name;
        if (!(this.canGetTaskInfo() || (name = (owningTarget = newTask.getOwningTarget()).getName()) != null && name.length() == 0)) {
            return;
        }
        AntTaskNode taskNode = null;
        if (parentTask == null) {
            taskNode = this.newTaskNode(newTask, attributes);
            if (this.fCurrentTargetNode == null) {
                this.fProjectNode.addChildNode(taskNode);
            } else {
                this.fCurrentTargetNode.addChildNode(taskNode);
            }
        } else {
            taskNode = this.newNotWellKnownTaskNode(newTask, attributes);
            AntTaskNode parentNode = (AntTaskNode)this.fTaskToNode.get(parentTask);
            parentNode.addChildNode(taskNode);
        }
        this.fTaskToNode.put(newTask, taskNode);
        this.fStillOpenElements.push(taskNode);
        this.computeOffset(taskNode, line, column);
        if (this.fNodeBeingResolved instanceof AntImportNode) {
            taskNode.setImportNode(this.fNodeBeingResolved);
            if (this.fNodeBeingResolvedIndex == -1) {
                this.fNodeBeingResolvedIndex = this.fTaskNodes.indexOf(this.fNodeBeingResolved);
            }
            ++this.fNodeBeingResolvedIndex;
            this.fTaskNodes.add(this.fNodeBeingResolvedIndex, taskNode);
        } else {
            this.fTaskNodes.add(taskNode);
        }
    }

    public void addEntity(String entityName, String entityPath) {
        if (this.fEntityNameToPath == null) {
            this.fEntityNameToPath = new HashMap();
        }
        this.fEntityNameToPath.put(entityName, entityPath);
    }

    private AntTaskNode newTaskNode(org.apache.tools.ant.Task newTask, Attributes attributes) {
        AntTaskNode newNode = null;
        String taskName = newTask.getTaskName();
        if (newTask instanceof UnknownElement) {
            taskName = ((UnknownElement)newTask).getTag();
        }
        if (this.isPropertySettingTask(taskName)) {
            newNode = new AntPropertyNode(newTask, attributes);
        } else if (taskName.equalsIgnoreCase("import")) {
            newNode = new AntImportNode(newTask, attributes);
        } else if (taskName.equalsIgnoreCase("macrodef") || taskName.equalsIgnoreCase("presetdef") || taskName.equalsIgnoreCase("typedef") || taskName.equalsIgnoreCase("taskdef")) {
            newNode = new AntDefiningTaskNode(newTask, attributes);
        } else if (taskName.equalsIgnoreCase("antcall")) {
            newNode = new AntTaskNode(newTask, this.generateLabel(taskName, attributes, "target"));
        } else if (taskName.equalsIgnoreCase("mkdir")) {
            newNode = new AntTaskNode(newTask, this.generateLabel(taskName, attributes, "dir"));
        } else if (taskName.equalsIgnoreCase("copy")) {
            newNode = new AntTaskNode(newTask, this.generateLabel(taskName, attributes, "destfile"));
        } else if (taskName.equalsIgnoreCase("tar") || taskName.equalsIgnoreCase("jar") || taskName.equalsIgnoreCase("war") || taskName.equalsIgnoreCase("zip")) {
            newNode = new AntTaskNode(newTask, this.generateLabel(newTask.getTaskName(), attributes, "destfile"));
        } else if (taskName.equalsIgnoreCase("untar") || taskName.equalsIgnoreCase("unjar") || taskName.equalsIgnoreCase("unwar") || taskName.equalsIgnoreCase("gunzip") || taskName.equalsIgnoreCase("bunzip2") || taskName.equalsIgnoreCase("unzip")) {
            newNode = new AntTaskNode(newTask, this.generateLabel(newTask.getTaskName(), attributes, "src"));
        } else if (taskName.equalsIgnoreCase("gzip") || taskName.equalsIgnoreCase("bzip2")) {
            newNode = new AntTaskNode(newTask, this.generateLabel(newTask.getTaskName(), attributes, "zipfile"));
        } else if (taskName.equalsIgnoreCase("exec")) {
            String label = "exec ";
            String command = attributes.getValue("command");
            if (command != null) {
                label = String.valueOf(label) + command;
            }
            if ((command = attributes.getValue("executable")) != null) {
                label = String.valueOf(label) + command;
            }
            newNode = new AntTaskNode(newTask, label);
        } else if (taskName.equalsIgnoreCase("ant")) {
            newNode = new AntAntNode(newTask, attributes);
        } else if (taskName.equalsIgnoreCase("delete")) {
            String label = "delete ";
            String file = attributes.getValue("file");
            if (file != null) {
                label = String.valueOf(label) + file;
            } else {
                file = attributes.getValue("dir");
                if (file != null) {
                    label = String.valueOf(label) + file;
                }
            }
            newNode = new AntTaskNode(newTask, label);
        } else {
            newNode = this.newNotWellKnownTaskNode(newTask, attributes);
        }
        this.setExternalInformation(newTask, newNode);
        return newNode;
    }

    private boolean isPropertySettingTask(String taskName) {
        return taskName.equalsIgnoreCase("property") || taskName.equalsIgnoreCase("available") || taskName.equalsIgnoreCase("basename") || taskName.equalsIgnoreCase("condition") || taskName.equalsIgnoreCase("dirname") || taskName.equalsIgnoreCase("loadfile") || taskName.equalsIgnoreCase("pathconvert") || taskName.equalsIgnoreCase("uptodate") || taskName.equalsIgnoreCase("xmlproperty") || taskName.equalsIgnoreCase("loadproperties");
    }

    private boolean isNodeExternal(String fileName) {
        File taskFile = new File(fileName);
        return !taskFile.equals(this.getEditedFile());
    }

    private AntTaskNode newNotWellKnownTaskNode(org.apache.tools.ant.Task newTask, Attributes attributes) {
        String name;
        String taskName;
        AntTaskNode newNode = new AntTaskNode(newTask);
        String id = attributes.getValue("id");
        if (id != null) {
            newNode.setId(id);
        }
        if (("attribute".equals(taskName = newTask.getTaskName()) || "element".equals(taskName)) && (name = attributes.getValue("name")) != null) {
            newNode.setBaseLabel(name);
        }
        this.setExternalInformation(newTask, newNode);
        return newNode;
    }

    private void setExternalInformation(org.apache.tools.ant.Task newTask, AntTaskNode newNode) {
        String taskFileName = newTask.getLocation().getFileName();
        boolean external = this.isNodeExternal(taskFileName);
        newNode.setExternal(external);
        if (external) {
            newNode.setFilePath(taskFileName);
        }
    }

    private String generateLabel(String taskName, Attributes attributes, String attributeName) {
        StringBuffer label = new StringBuffer(taskName);
        String srcFile = attributes.getValue(attributeName);
        if (srcFile != null) {
            label.append(' ');
            label.append(srcFile);
        }
        return label.toString();
    }

    private void computeLength(AntElementNode element, int line, int column) {
        if (element.isExternal()) {
            element.setExternalInfo(line, column);
            return;
        }
        try {
            int offset;
            if (column <= 0) {
                column = this.getLastCharColumn(line);
                String lineText = this.fDocument.get(this.fDocument.getLineOffset(line - 1), column);
                StringBuffer searchString = new StringBuffer("</");
                searchString.append(element.getName());
                searchString.append('>');
                int index = lineText.indexOf(searchString.toString());
                index = index == -1 ? ((index = lineText.indexOf("/>")) == -1 ? column : (index += 3)) : index + searchString.length() + 1;
                offset = this.getOffset(line, index);
            } else {
                offset = this.getOffset(line, column);
            }
            int length = offset - element.getOffset();
            element.setLength(length);
        }
        catch (BadLocationException badLocationException) {}
    }

    private void computeOffset(AntElementNode element, int line, int column) {
        if (!this.canGetPositionInfo()) {
            return;
        }
        if (element.isExternal()) {
            element.setExternalInfo(line - 1, column);
            return;
        }
        try {
            String prefix = "<" + element.getName();
            int offset = this.computeOffset(line, column, prefix);
            element.setOffset(offset + 1);
            element.setSelectionLength(element.getName().length());
        }
        catch (BadLocationException badLocationException) {}
    }

    private int computeOffset(int line, int column, String prefix) throws BadLocationException {
        int offset;
        if (column <= 0) {
            offset = this.getOffset(line, 0);
            int lastCharColumn = this.getLastCharColumn(line);
            offset = this.computeOffsetUsingPrefix(line, offset, prefix, lastCharColumn);
        } else {
            offset = this.getOffset(line, --column);
            offset = this.computeOffsetUsingPrefix(line, offset, prefix, column);
        }
        return offset;
    }

    private int computeOffsetUsingPrefix(int line, int offset, String prefix, int column) throws BadLocationException {
        String lineText = this.fDocument.get(this.fDocument.getLineOffset(line - 1), column);
        int lastIndex = lineText.indexOf(prefix);
        if (lastIndex <= -1) {
            return this.computeOffsetUsingPrefix(line - 1, offset, prefix, this.getLastCharColumn(line - 1));
        }
        offset = this.getOffset(line, lastIndex + 1);
        return offset;
    }

    public int getOffset(int line, int column) throws BadLocationException {
        return this.fDocument.getLineOffset(line - 1) + column - 1;
    }

    private int getNonWhitespaceOffset(int line, int column) throws BadLocationException {
        int offset = this.fDocument.getLineOffset(line - 1) + column - 1;
        while (Character.isWhitespace(this.fDocument.getChar(offset))) {
            ++offset;
        }
        return offset;
    }

    public int getLine(int offset) {
        try {
            return this.fDocument.getLineOfOffset(offset) + 1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private int getLastCharColumn(int line) throws BadLocationException {
        String lineDelimiter = this.fDocument.getLineDelimiter(line - 1);
        int lineDelimiterLength = lineDelimiter != null ? lineDelimiter.length() : 0;
        return this.fDocument.getLineLength(line - 1) - lineDelimiterLength;
    }

    public void setCurrentElementLength(int lineNumber, int column) {
        this.fLastNode = (AntElementNode)this.fStillOpenElements.pop();
        if (this.fLastNode == this.fCurrentTargetNode) {
            this.fCurrentTargetNode = null;
        }
        if (this.canGetPositionInfo()) {
            this.computeLength(this.fLastNode, lineNumber, column);
        }
    }

    private void acceptProblem(IProblem problem) {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.acceptProblem(problem);
        }
        if (this.fMarkerUpdater != null) {
            this.fMarkerUpdater.acceptProblem(problem);
        }
    }

    public IFile getFile() {
        IPath location = this.fLocationProvider.getLocation();
        if (location == null) {
            return null;
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(location);
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }

    private void beginReporting() {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.beginReporting();
        }
        if (this.fMarkerUpdater != null) {
            this.fMarkerUpdater.beginReporting();
        }
    }

    private void endReporting() {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.endReporting();
        }
    }

    private IProblem createProblem(Exception exception, int offset, int length, int severity) {
        return this.createProblem(exception.getMessage(), offset, length, severity);
    }

    private IProblem createProblem(String message, int offset, int length, int severity) {
        return new AntModelProblem(message, severity, offset, length, this.getLine(offset));
    }

    private void notifyProblemRequestor(Exception exception, AntElementNode element, int severity) {
        if (this.doNotReportProblems()) {
            return;
        }
        AntElementNode importNode = element.getImportNode();
        if (importNode != null) {
            element = importNode;
        }
        IProblem problem = this.createProblem(exception, element.getOffset(), element.getLength(), severity);
        this.acceptProblem(problem);
        element.associatedProblem(problem);
    }

    private void notifyProblemRequestor(Exception exception, int offset, int length, int severity) {
        if (this.doNotReportProblems()) {
            return;
        }
        if (this.fProblemRequestor != null) {
            IProblem problem = this.createProblem(exception, offset, length, severity);
            this.acceptProblem(problem);
        }
    }

    public void warning(Exception exception) {
        this.handleError(exception, 0);
    }

    public void error(Exception exception) {
        this.handleError(exception, 1);
    }

    public void errorFromElementText(Exception exception, int start, int count) {
        AntElementNode node = this.fLastNode;
        if (node == null && !this.fStillOpenElements.empty()) {
            node = (AntElementNode)this.fStillOpenElements.peek();
        }
        if (node == null) {
            return;
        }
        this.computeEndLocationForErrorNode(node, start, count);
        this.notifyProblemRequestor(exception, start, count, 1);
        this.markHierarchy(this.fLastNode, 1, exception.getMessage());
    }

    public void errorFromElement(Exception exception, AntElementNode node, int lineNumber, int column) {
        if (node == null) {
            node = !this.fStillOpenElements.empty() ? (AntElementNode)this.fStillOpenElements.peek() : this.fLastNode;
        }
        this.computeEndLocationForErrorNode(node, lineNumber, column);
        this.notifyProblemRequestor(exception, node, 1);
        this.markHierarchy(node, 1, exception.getMessage());
    }

    private AntElementNode createProblemElement(SAXParseException exception) {
        int lineNumber = exception.getLineNumber();
        StringBuffer message = new StringBuffer(exception.getMessage());
        if (lineNumber != -1) {
            message.append(String.valueOf(AntModelMessages.AntModel_1) + lineNumber);
        }
        AntElementNode errorNode = new AntElementNode(message.toString());
        errorNode.setFilePath(exception.getSystemId());
        errorNode.setProblemSeverity(1);
        errorNode.setProblemMessage(exception.getMessage());
        this.computeErrorLocation(errorNode, exception);
        return errorNode;
    }

    private void computeErrorLocation(AntElementNode element, SAXParseException exception) {
        if (element.isExternal()) {
            return;
        }
        int line = exception.getLineNumber();
        int startColumn = exception.getColumnNumber();
        this.computeEndLocationForErrorNode(element, line, startColumn);
    }

    private void computeEndLocationForErrorNode(AntElementNode element, int line, int startColumn) {
        try {
            int endColumn;
            if (line <= 0) {
                line = 1;
            }
            if (startColumn <= 0) {
                startColumn = element.getOffset() > -1 ? element.getOffset() + 1 : 1;
                endColumn = this.getLastCharColumn(line) + 1;
            } else {
                if (startColumn > 1) {
                    --startColumn;
                }
                endColumn = startColumn;
                if (startColumn <= this.getLastCharColumn(line)) {
                    ++endColumn;
                }
            }
            int correction = 0;
            if (element.getOffset() == -1) {
                int originalOffset;
                int nonWhitespaceOffset = originalOffset = this.getOffset(line, startColumn);
                try {
                    nonWhitespaceOffset = this.getNonWhitespaceOffset(line, startColumn);
                }
                catch (BadLocationException badLocationException) {}
                element.setOffset(nonWhitespaceOffset);
                correction = nonWhitespaceOffset - originalOffset;
            }
            if (endColumn - startColumn == 0) {
                int offset = this.getOffset(line, startColumn);
                element.setLength(offset - element.getOffset() - correction);
            } else {
                element.setLength(endColumn - startColumn - correction);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void handleError(Exception exception, int severity) {
        AntElementNode node = null;
        if (this.fStillOpenElements.isEmpty()) {
            if (exception instanceof SAXParseException) {
                node = this.createProblemElement((SAXParseException)exception);
            }
        } else {
            node = (AntElementNode)this.fStillOpenElements.peek();
        }
        if (node == null) {
            return;
        }
        this.markHierarchy(node, severity, exception.getMessage());
        if (exception instanceof SAXParseException) {
            SAXParseException parseException = (SAXParseException)exception;
            if (node.getOffset() == -1) {
                this.computeEndLocationForErrorNode(node, parseException.getLineNumber() - 1, parseException.getColumnNumber());
            } else {
                int lineNumber = parseException.getLineNumber();
                int columnNumber = parseException.getColumnNumber();
                if (columnNumber == -1) {
                    columnNumber = 1;
                }
                try {
                    AntElementNode childNode = node.getNode(this.getNonWhitespaceOffset(lineNumber, columnNumber) + 1);
                    if (childNode != null && childNode != node) {
                        node = childNode;
                        node.setProblemSeverity(severity);
                        node.setProblemMessage(exception.getMessage());
                    } else {
                        node = this.createProblemElement(parseException);
                    }
                }
                catch (BadLocationException badLocationException) {
                    node = this.createProblemElement(parseException);
                }
            }
        }
        this.notifyProblemRequestor(exception, node, severity);
        if (node != null) {
            while (node.getParentNode() != null) {
                AntElementNode parentNode = node.getParentNode();
                if (parentNode.getLength() == -1) {
                    parentNode.setLength(node.getOffset() - parentNode.getOffset() + node.getLength());
                }
                node = parentNode;
            }
        }
    }

    public void fatalError(Exception exception) {
        this.handleError(exception, 2);
    }

    public AntElementNode getOpenElement() {
        if (this.fStillOpenElements.isEmpty()) {
            return null;
        }
        return (AntElementNode)this.fStillOpenElements.peek();
    }

    public String getEntityName(String path) {
        if (this.fEntityNameToPath != null) {
            Iterator itr = this.fEntityNameToPath.keySet().iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                String entityPath = (String)this.fEntityNameToPath.get(name);
                if (!entityPath.equals(path)) continue;
                return name;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getClassLoader(ClassLoader contextClassLoader) {
        Object object = loaderLock;
        synchronized (object) {
            if (this.fLocalClassLoader != null) {
                ((AntClassLoader)this.fLocalClassLoader).setPluginContextClassloader(contextClassLoader);
                return this.fLocalClassLoader;
            }
            if (fgClassLoader == null) {
                fgClassLoader = AntCorePlugin.getPlugin().getNewClassLoader(true);
            }
            if (fgClassLoader instanceof AntClassLoader) {
                ((AntClassLoader)fgClassLoader).setPluginContextClassloader(contextClassLoader);
            }
            return fgClassLoader;
        }
    }

    public String getTargetDescription(String targetName) {
        AntTargetNode target = this.getTargetNode(targetName);
        if (target != null) {
            return target.getTarget().getDescription();
        }
        return null;
    }

    public AntTargetNode getTargetNode(String targetName) {
        AntProjectNode projectNode = this.getProjectNode();
        if (projectNode == null) {
            return null;
        }
        if (projectNode.hasChildren()) {
            List possibleTargets = projectNode.getChildNodes();
            Iterator iter = possibleTargets.iterator();
            while (iter.hasNext()) {
                AntTargetNode targetNode;
                AntElementNode node = (AntElementNode)iter.next();
                if (!(node instanceof AntTargetNode) || !targetName.equalsIgnoreCase((targetNode = (AntTargetNode)node).getTarget().getName())) continue;
                return targetNode;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AntProjectNode getProjectNode(boolean doReconcile) {
        if (doReconcile) {
            Object object = this.getLockObject();
            synchronized (object) {
                this.reconcile();
            }
        }
        return this.fProjectNode;
    }

    public AntProjectNode getProjectNode() {
        return this.getProjectNode(true);
    }

    public AntElementNode getNode(int offset, boolean waitForReconcile) {
        if (this.getProjectNode(waitForReconcile) != null) {
            return this.getProjectNode(waitForReconcile).getNode(offset);
        }
        return null;
    }

    private void reconcileTaskAndTypes() {
        if (this.fCurrentNodeIdentifiers == null || this.fDefinerNodeIdentifierToDefinedTasks == null) {
            return;
        }
        Iterator iter = this.fDefinerNodeIdentifierToDefinedTasks.keySet().iterator();
        ComponentHelper helper = ComponentHelper.getComponentHelper((Project)this.fProjectNode.getProject());
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (this.fCurrentNodeIdentifiers.get(key) != null) continue;
            this.removeDefinerTasks(key, helper.getAntTypeTable());
        }
    }

    protected void removeDefinerTasks(String definerIdentifier, Hashtable typeTable) {
        if (this.fDefinerNodeIdentifierToDefinedTasks == null) {
            return;
        }
        List tasks = (List)this.fDefinerNodeIdentifierToDefinedTasks.get(definerIdentifier);
        if (tasks == null) {
            return;
        }
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            typeTable.remove(iterator.next());
        }
    }

    public void addComment(int lineNumber, int columnNumber, int length) {
        AntCommentNode commentNode = new AntCommentNode();
        int offset = -1;
        try {
            offset = this.computeOffset(lineNumber, columnNumber, "-->");
        }
        catch (BadLocationException badLocationException) {
            commentNode.setExternal(true);
            commentNode.setExternalInfo(lineNumber, columnNumber);
            offset = length - 1;
        }
        commentNode.setOffset(offset - length);
        commentNode.setLength(length);
        this.fNonStructuralNodes.add(commentNode);
    }

    public boolean canGetTaskInfo() {
        return this.fHasTaskInfo;
    }

    public boolean canGetLexicalInfo() {
        return this.fHasLexicalInfo;
    }

    public void setClassLoader(URLClassLoader loader) {
        AntDefiningTaskNode.setJavaClassPath(loader.getURLs());
        this.fLocalClassLoader = loader;
    }

    public boolean canGetPositionInfo() {
        return this.fHasPositionInfo;
    }

    public String getPath(String text, int offset) {
        String path;
        if (this.fEntityNameToPath != null && (path = (String)this.fEntityNameToPath.get(text)) != null) {
            return path;
        }
        AntElementNode node = this.getNode(offset, true);
        if (node != null) {
            return node.getReferencedElement(offset);
        }
        return null;
    }

    public String getText(int offset, int length) {
        try {
            return this.fDocument.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private AntElementNode findPropertyNode(String text, List children) {
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            AntElementNode found;
            AntElementNode element = (AntElementNode)iter.next();
            if (element instanceof AntPropertyNode) {
                if (((AntPropertyNode)element).getProperty(text) == null) continue;
                return element;
            }
            if (!element.hasChildren() || (found = this.findPropertyNode(text, element.getChildNodes())) == null) continue;
            return found;
        }
        return null;
    }

    public AntElementNode getPropertyNode(String text) {
        AntProjectNode node = this.getProjectNode();
        if (node == null || !node.hasChildren()) {
            return null;
        }
        return this.findPropertyNode(text, node.getChildNodes());
    }

    public List getNonStructuralNodes() {
        return this.fNonStructuralNodes;
    }

    public void updateForInitialReconcile() {
        this.fMarkerUpdater.updateMarkers();
        this.fShouldReconcile = AntUIPlugin.getDefault().getPreferenceStore().getBoolean("editor_reconcile");
    }

    public void updateMarkers() {
        boolean temp = this.fShouldReconcile;
        try {
            this.fShouldReconcile = true;
            this.reconcile();
            this.fMarkerUpdater.updateMarkers();
        }
        finally {
            this.fShouldReconcile = temp;
        }
    }

    public AntElementNode getReferenceNode(String text) {
        Object reference = this.getReferenceObject(text);
        if (reference == null) {
            return null;
        }
        Set nodes = this.fTaskToNode.keySet();
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            UnknownElement element;
            RuntimeConfigurable wrapper;
            Hashtable attributes;
            String id;
            Object original = iter.next();
            Object object = original;
            if (!(object instanceof UnknownElement) || !text.equals(id = (String)(attributes = (wrapper = (element = (UnknownElement)object).getWrapper()).getAttributeMap()).get("id"))) continue;
            return (AntElementNode)this.fTaskToNode.get(original);
        }
        return null;
    }

    public Object getReferenceObject(String refId) {
        AntProjectNode projectNode = this.getProjectNode();
        if (projectNode == null) {
            return null;
        }
        try {
            Project project = projectNode.getProject();
            Object ref = project.getReference(refId);
            return ref;
        }
        catch (BuildException be) {
            this.handleBuildException(be, null);
            return null;
        }
    }

    public String getPropertyValue(String propertyName) {
        AntProjectNode projectNode = this.getProjectNode();
        if (projectNode == null) {
            return null;
        }
        return projectNode.getProject().getProperty(propertyName);
    }

    public void install() {
        this.fListener = new IDocumentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentAboutToBeChanged(DocumentEvent event) {
                Object object = AntModel.this.fDirtyLock;
                synchronized (object) {
                    AntModel.this.fIsDirty = true;
                }
            }

            public void documentChanged(DocumentEvent event) {
            }
        };
        this.fDocument.addDocumentListener(this.fListener);
    }

    private void reconcileForPropertyChange(boolean classpathChanged) {
        if (classpathChanged) {
            this.fProjectNode = null;
            fgClassLoader = null;
            AntDefiningTaskNode.setJavaClassPath();
            org.eclipse.ant.internal.ui.editor.utils.ProjectHelper.reset();
        }
        this.fIsDirty = true;
        this.reconcile();
        AntModelCore.getDefault().notifyAntModelListeners(new AntModelChangeEvent(this, true));
        this.fMarkerUpdater.updateMarkers();
    }

    public void setProperties(Map properties) {
        this.fProperties = properties;
    }

    public void setPropertyFiles(String[] propertyFiles) {
        if (propertyFiles != null) {
            this.fPropertyFiles = Arrays.asList(propertyFiles);
        }
    }

    public void setDefiningTaskNodeText(AntDefiningTaskNode node) {
        if (this.fDefinersToText == null) {
            this.fDefinersToText = new HashMap();
            this.fCurrentNodeIdentifiers = new HashMap();
        }
        String nodeIdentifier = node.getIdentifier();
        String nodeText = null;
        if (this.fPreviousDefinersToText != null) {
            nodeText = (String)this.fPreviousDefinersToText.get(nodeIdentifier);
        }
        String newNodeText = this.getText(node.getOffset(), node.getLength());
        if (nodeText != null && nodeText.equals(newNodeText)) {
            node.setNeedsToBeConfigured(false);
            List tasks = (List)this.fDefinerNodeIdentifierToDefinedTasks.get(nodeIdentifier);
            if (tasks != null) {
                Iterator iter = tasks.iterator();
                while (iter.hasNext()) {
                    String taskName = (String)iter.next();
                    this.fTaskNameToDefiningNode.put(taskName, node);
                }
            }
        }
        if (newNodeText != null) {
            this.fDefinersToText.put(nodeIdentifier, newNodeText);
        }
        this.fCurrentNodeIdentifiers.put(nodeIdentifier, nodeIdentifier);
    }

    protected void removeDefiningTaskNodeInfo(AntDefiningTaskNode node) {
        String identifier = node.getIdentifier();
        if (identifier != null && this.fCurrentNodeIdentifiers != null) {
            this.fCurrentNodeIdentifiers.remove(identifier);
            this.fDefinersToText.remove(identifier);
        }
    }

    protected void addDefinedTasks(List newTasks, AntDefiningTaskNode node) {
        String identifier;
        if (this.fTaskNameToDefiningNode == null) {
            this.fTaskNameToDefiningNode = new HashMap();
            this.fDefinerNodeIdentifierToDefinedTasks = new HashMap();
        }
        if ((identifier = node.getIdentifier()) == null) {
            return;
        }
        if (newTasks.isEmpty() && this.fCurrentNodeIdentifiers != null) {
            this.fCurrentNodeIdentifiers.remove(identifier);
        }
        this.fDefinerNodeIdentifierToDefinedTasks.put(identifier, newTasks);
        Iterator iter = newTasks.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.fTaskNameToDefiningNode.put(name, node);
        }
    }

    public AntDefiningTaskNode getDefininingTaskNode(String nodeName) {
        if (this.fTaskNameToDefiningNode != null) {
            AntDefiningTaskNode node = (AntDefiningTaskNode)this.fTaskNameToDefiningNode.get(nodeName);
            if (node == null) {
                nodeName = this.getNamespaceCorrectName(nodeName);
                node = (AntDefiningTaskNode)this.fTaskNameToDefiningNode.get(nodeName);
            }
            return node;
        }
        return null;
    }

    public String getNamespaceCorrectName(String nodeName) {
        String prefix = ProjectHelper.extractUriFromComponentName((String)nodeName);
        String uri = this.getPrefixMapping(prefix);
        nodeName = ProjectHelper.genComponentName((String)uri, (String)ProjectHelper.extractNameFromComponentName((String)nodeName));
        return nodeName;
    }

    public String getUserNamespaceCorrectName(String nodeName) {
        String prefix = ProjectHelper.extractUriFromComponentName((String)nodeName);
        if (prefix.length() > 0) {
            String uri = this.getUserPrefixMapping(prefix);
            nodeName = ProjectHelper.genComponentName((String)uri, (String)ProjectHelper.extractNameFromComponentName((String)nodeName));
        }
        return nodeName;
    }

    public AntTaskNode getMacroDefAttributeNode(String macroDefAttributeName) {
        if (this.fTaskNameToDefiningNode == null) {
            return null;
        }
        Iterator iter = this.fTaskNameToDefiningNode.values().iterator();
        while (iter.hasNext()) {
            AntDefiningTaskNode definingNode = (AntDefiningTaskNode)iter.next();
            List attributes = definingNode.getChildNodes();
            if (attributes == null) continue;
            Iterator attributeItr = attributes.iterator();
            while (attributeItr.hasNext()) {
                AntTaskNode attributeNode = (AntTaskNode)attributeItr.next();
                if (!macroDefAttributeName.equals(attributeNode.getLabel())) continue;
                return attributeNode;
            }
        }
        return null;
    }

    public void setShouldReconcile(boolean shouldReconcile) {
        this.fShouldReconcile = shouldReconcile;
        if (this.fShouldReconcile) {
            this.reconcile();
        }
    }

    public void addPrefixMapping(String prefix, String uri) {
        if (this.fNamespacePrefixMappings == null) {
            this.fNamespacePrefixMappings = new HashMap();
        }
        this.fNamespacePrefixMappings.put(prefix, uri);
    }

    private String getPrefixMapping(String prefix) {
        if (this.fNamespacePrefixMappings != null) {
            return (String)this.fNamespacePrefixMappings.get(prefix);
        }
        return null;
    }

    private String getUserPrefixMapping(String prefix) {
        if (this.fNamespacePrefixMappings != null) {
            Set entrySet = this.fNamespacePrefixMappings.entrySet();
            Iterator entries = entrySet.iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (!entry.getValue().equals(prefix)) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    class Small {
        Small() {
        }
    }
}

