/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.FieldReferenceMatch;
import org.eclipse.jdt.core.search.LocalVariableDeclarationMatch;
import org.eclipse.jdt.core.search.LocalVariableReferenceMatch;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.ui.search.JavaElementMatch;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class NewSearchResultCollector
extends SearchRequestor {
    private AbstractTextSearchResult fSearch;
    private boolean fIgnorePotentials;

    public NewSearchResultCollector(AbstractTextSearchResult search, boolean ignorePotentials) {
        this.fSearch = search;
        this.fIgnorePotentials = ignorePotentials;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        IJavaElement enclosingElement = (IJavaElement)match.getElement();
        if (enclosingElement != null) {
            if (this.fIgnorePotentials && match.getAccuracy() == 1) {
                return;
            }
            boolean isWriteAccess = false;
            boolean isReadAccess = false;
            if (match instanceof FieldReferenceMatch) {
                FieldReferenceMatch fieldRef = (FieldReferenceMatch)match;
                isWriteAccess = fieldRef.isWriteAccess();
                isReadAccess = fieldRef.isReadAccess();
            } else if (match instanceof FieldDeclarationMatch) {
                isWriteAccess = true;
            } else if (match instanceof LocalVariableReferenceMatch) {
                LocalVariableReferenceMatch localVarRef = (LocalVariableReferenceMatch)match;
                isWriteAccess = localVarRef.isWriteAccess();
                isReadAccess = localVarRef.isReadAccess();
            } else if (match instanceof LocalVariableDeclarationMatch) {
                isWriteAccess = true;
            }
            boolean isSuperInvocation = false;
            if (match instanceof MethodReferenceMatch) {
                MethodReferenceMatch methodRef = (MethodReferenceMatch)match;
                isSuperInvocation = methodRef.isSuperInvocation();
            }
            this.fSearch.addMatch((Match)new JavaElementMatch(enclosingElement, match.getRule(), match.getOffset(), match.getLength(), match.getAccuracy(), isReadAccess, isWriteAccess, match.isInsideDocComment(), isSuperInvocation));
        }
    }

    public void beginReporting() {
    }

    public void endReporting() {
    }

    public void enterParticipant(SearchParticipant participant) {
    }

    public void exitParticipant(SearchParticipant participant) {
    }
}

