/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    int delegate;
    int webViewHandle;
    int webView;
    int windowBoundsHandler;
    int preferences;
    boolean loadingText;
    boolean hasNewFocusElement;
    boolean untrustedText;
    String lastHoveredLinkURL;
    String lastNavigateURL;
    String html;
    int identifier;
    int resourceCount;
    int lastMouseMoveX;
    int lastMouseMoveY;
    String url = "";
    org.eclipse.swt.graphics.Point location;
    org.eclipse.swt.graphics.Point size;
    boolean statusBar = true;
    boolean toolBar = true;
    boolean ignoreDispose;
    static boolean Initialized;
    static Callback Callback3;
    static Callback Callback7;
    static final int MIN_SIZE = 16;
    static final int MAX_PROGRESS = 100;
    static final String WebElementLinkURLKey = "WebElementLinkURL";
    static final String AGENT_STRING = "Safari/412.0";
    static final String URI_FILEROOT = "file:///";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String URI_APPLEWEBDATA = "applewebdata://";
    static final String ABOUT_BLANK = "about:blank";
    static final String HEADER_SETCOOKIE = "Set-Cookie";
    static final String POST = "POST";
    static final String USER_AGENT = "user-agent";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String BROWSER_WINDOW = "org.eclipse.swt.browser.Browser.Window";
    static final String WEBKIT_EVENTS_FIX_KEY = "org.eclipse.swt.internal.webKitEventsFix";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";
    static final String DOMEVENT_FOCUSIN = "DOMFocusIn";
    static final String DOMEVENT_FOCUSOUT = "DOMFocusOut";

    static {
        Cocoa.WebInitForCarbon();
        NativeClearSessions = new Runnable(){

            public void run() {
                int storage = Cocoa.objc_msgSend(Cocoa.C_NSHTTPCookieStorage, Cocoa.S_sharedHTTPCookieStorage);
                int cookies = Cocoa.objc_msgSend(storage, Cocoa.S_cookies);
                int count = Cocoa.objc_msgSend(cookies, Cocoa.S_count);
                int i = 0;
                while (i < count) {
                    boolean isSession;
                    int cookie = Cocoa.objc_msgSend(cookies, Cocoa.S_objectAtIndex, i);
                    boolean bl = isSession = Cocoa.objc_msgSend(cookie, Cocoa.S_isSessionOnly) != 0;
                    if (isSession) {
                        Cocoa.objc_msgSend(storage, Cocoa.S_deleteCookie, cookie);
                    }
                    ++i;
                }
            }
        };
        NativeGetCookie = new Runnable(){

            public void run() {
                int storage = Cocoa.objc_msgSend(Cocoa.C_NSHTTPCookieStorage, Cocoa.S_sharedHTTPCookieStorage);
                int urlString = WebKit.createNSString(CookieUrl);
                int url = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, urlString);
                OS.CFRelease(urlString);
                int cookies = Cocoa.objc_msgSend(storage, Cocoa.S_cookiesForURL, url);
                int count = Cocoa.objc_msgSend(cookies, Cocoa.S_count);
                if (count == 0) {
                    return;
                }
                int name = WebKit.createNSString(CookieName);
                int i = 0;
                while (i < count) {
                    int current = Cocoa.objc_msgSend(cookies, Cocoa.S_objectAtIndex, i);
                    int currentName = Cocoa.objc_msgSend(current, Cocoa.S_name);
                    if (Cocoa.objc_msgSend(currentName, Cocoa.S_compare, name) == 0) {
                        int value = Cocoa.objc_msgSend(current, Cocoa.S_value);
                        int length = OS.CFStringGetLength(value);
                        char[] buffer = new char[length];
                        CFRange range = new CFRange();
                        range.length = length;
                        OS.CFStringGetCharacters(value, range, buffer);
                        CookieValue = new String(buffer);
                        OS.CFRelease(name);
                        return;
                    }
                    ++i;
                }
                OS.CFRelease(name);
            }
        };
        NativeSetCookie = new Runnable(){

            public void run() {
                int urlString = WebKit.createNSString(CookieUrl);
                int url = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, urlString);
                OS.CFRelease(urlString);
                int value = WebKit.createNSString(CookieValue);
                int key = WebKit.createNSString(WebKit.HEADER_SETCOOKIE);
                int headers = Cocoa.objc_msgSend(Cocoa.C_NSMutableDictionary, Cocoa.S_dictionaryWithCapacity, 1);
                Cocoa.objc_msgSend(headers, Cocoa.S_setValue, value, key);
                OS.CFRelease(key);
                OS.CFRelease(value);
                int cookies = Cocoa.objc_msgSend(Cocoa.C_NSHTTPCookie, Cocoa.S_cookiesWithResponseHeaderFields, headers, url);
                if (Cocoa.objc_msgSend(cookies, Cocoa.S_count) == 0) {
                    return;
                }
                int cookie = Cocoa.objc_msgSend(cookies, Cocoa.S_objectAtIndex, 0);
                int storage = Cocoa.objc_msgSend(Cocoa.C_NSHTTPCookieStorage, Cocoa.S_sharedHTTPCookieStorage);
                Cocoa.objc_msgSend(storage, Cocoa.S_setCookie, cookie);
                CookieResult = true;
            }
        };
        if (NativePendingCookies != null) {
            WebKit.SetPendingCookies(NativePendingCookies);
        }
        NativePendingCookies = null;
    }

    WebKit() {
    }

    public void create(Composite parent, int style) {
        int callback7Address;
        int callback3Address;
        if (OS.VERSION < 4144) {
            this.browser.dispose();
            SWT.error(2);
        }
        int[] outControl = new int[1];
        if (OS.VERSION >= 4176) {
            this.webView = Cocoa.objc_msgSend(Cocoa.objc_msgSend(Cocoa.C_WebView, Cocoa.S_alloc), Cocoa.S_initWithFrame_frameName_groupName, new NSRect(), 0, 0);
            if (this.webView != 0) {
                Cocoa.HICocoaViewCreate(this.webView, 0, outControl);
                this.webViewHandle = outControl[0];
                Cocoa.objc_msgSend(this.webView, Cocoa.S_release);
            }
        } else {
            Cocoa.HIWebViewCreate(outControl);
            this.webViewHandle = outControl[0];
            if (this.webViewHandle != 0) {
                this.webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
            }
        }
        if (this.webViewHandle == 0) {
            this.browser.dispose();
            SWT.error(2);
        }
        Display display = this.browser.getDisplay();
        display.setData(ADD_WIDGET_KEY, new Object[]{new Integer(this.webViewHandle), this.browser});
        if (OS.VERSION >= 4160) {
            this.browser.setData(WEBKIT_EVENTS_FIX_KEY);
        }
        if (display.getData(BROWSER_WINDOW) == null) {
            Rect bounds = new Rect();
            OS.SetRect(bounds, (short)0, (short)0, (short)1, (short)1);
            final int[] outWindow = new int[1];
            OS.CreateNewWindow(14, 0, bounds, outWindow);
            OS.ShowWindow(outWindow[0]);
            OS.HIObjectSetAccessibilityIgnored(outWindow[0], true);
            display.disposeExec(new Runnable(){

                public void run() {
                    if (outWindow[0] != 0) {
                        OS.DisposeWindow(outWindow[0]);
                    }
                    outWindow[0] = 0;
                }
            });
            display.setData(BROWSER_WINDOW, outWindow);
        }
        int window = OS.GetControlOwner(this.browser.handle);
        int[] contentView = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(window), OS.kHIViewWindowContentID(), contentView);
        OS.HIViewAddSubview(contentView[0], this.webViewHandle);
        OS.HIViewChangeFeatures(this.webViewHandle, 0x2000000, 0);
        OS.HIViewSetVisible(this.webViewHandle, true);
        if (this.browser.getShell().isVisible()) {
            int[] showEvent = new int[1];
            OS.CreateEvent(0, 2003398244, 24, 0.0, 1, showEvent);
            OS.SetEventParameter(showEvent[0], 0x2D2D2D2D, 2003398244, 4, new int[]{OS.GetControlOwner(this.browser.handle)});
            OS.SendEventToEventTarget(showEvent[0], OS.GetWindowEventTarget(window));
            if (showEvent[0] != 0) {
                OS.ReleaseEvent(showEvent[0]);
            }
        }
        final int notificationCenter = Cocoa.objc_msgSend(Cocoa.C_NSNotificationCenter, Cocoa.S_defaultCenter);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 12: {
                        if (WebKit.this.ignoreDispose) {
                            WebKit.this.ignoreDispose = false;
                            break;
                        }
                        WebKit.this.ignoreDispose = true;
                        WebKit.this.browser.notifyListeners(e.type, e);
                        e.type = 0;
                        if (!WebKit.this.browser.isClosing && !WebKit.this.browser.isDisposed()) {
                            WebKit.this.close(false);
                        }
                        OS.RemoveEventHandler(WebKit.this.windowBoundsHandler);
                        WebKit.this.windowBoundsHandler = 0;
                        Object[] objectArray = new Object[2];
                        objectArray[0] = new Integer(WebKit.this.webViewHandle);
                        e.display.setData(WebKit.ADD_WIDGET_KEY, objectArray);
                        Cocoa.objc_msgSend(WebKit.this.webView, Cocoa.S_setFrameLoadDelegate, 0);
                        Cocoa.objc_msgSend(WebKit.this.webView, Cocoa.S_setResourceLoadDelegate, 0);
                        Cocoa.objc_msgSend(WebKit.this.webView, Cocoa.S_setUIDelegate, 0);
                        Cocoa.objc_msgSend(WebKit.this.webView, Cocoa.S_setPolicyDelegate, 0);
                        Cocoa.objc_msgSend(WebKit.this.webView, Cocoa.S_setDownloadDelegate, 0);
                        Cocoa.objc_msgSend(notificationCenter, Cocoa.S_removeObserver, WebKit.this.delegate);
                        Cocoa.objc_msgSend(WebKit.this.delegate, Cocoa.S_release);
                        OS.DisposeControl(WebKit.this.webViewHandle);
                        WebKit.this.webViewHandle = 0;
                        WebKit.this.webView = 0;
                        WebKit.this.html = null;
                        WebKit.this.lastNavigateURL = null;
                        WebKit.this.lastHoveredLinkURL = null;
                        Enumeration elements = WebKit.this.functions.elements();
                        while (elements.hasMoreElements()) {
                            ((BrowserFunction)elements.nextElement()).dispose(false);
                        }
                        WebKit.this.functions = null;
                        if (WebKit.this.preferences != 0) {
                            Cocoa.objc_msgSend(WebKit.this.preferences, Cocoa.S_release);
                        }
                        WebKit.this.preferences = 0;
                        break;
                    }
                    case 15: {
                        WebKit.this.hasNewFocusElement = true;
                        OS.SetKeyboardFocus(OS.GetControlOwner(WebKit.this.browser.handle), WebKit.this.webViewHandle, (short)-1);
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(1, listener);
        if (Callback3 == null) {
            Callback3 = new Callback(this.getClass(), "eventProc3", 3);
        }
        if ((callback3Address = Callback3.getAddress()) == 0) {
            SWT.error(3);
        }
        int[] mask = new int[]{1801812322, 1, 1668183148, 4, 1668183148, 17, 1668183148, 11, 1952807028, 2};
        OS.InstallEventHandler(OS.GetControlEventTarget(this.webViewHandle), callback3Address, mask.length / 2, mask, this.webViewHandle, null);
        int[] mask1 = new int[]{1668183148, 154, 1668183148, 157, 1668183148, 159};
        OS.InstallEventHandler(OS.GetControlEventTarget(this.browser.handle), callback3Address, mask1.length / 2, mask1, this.browser.handle, null);
        int[] mask2 = new int[]{2003398244, 27};
        int[] outRef = new int[1];
        OS.InstallEventHandler(OS.GetWindowEventTarget(window), callback3Address, mask2.length / 2, mask2, this.browser.handle, outRef);
        this.windowBoundsHandler = outRef[0];
        if (Callback7 == null) {
            Callback7 = new Callback(this.getClass(), "eventProc7", 7);
        }
        if ((callback7Address = Callback7.getAddress()) == 0) {
            SWT.error(3);
        }
        this.delegate = Cocoa.objc_msgSend(Cocoa.C_WebKitDelegate, Cocoa.S_alloc);
        this.delegate = Cocoa.objc_msgSend(this.delegate, Cocoa.S_initWithProc, callback7Address, this.webViewHandle);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setFrameLoadDelegate, this.delegate);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setResourceLoadDelegate, this.delegate);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setUIDelegate, this.delegate);
        Cocoa.objc_msgSend(notificationCenter, Cocoa.S_addObserver_selector_name_object, this.delegate, Cocoa.S_handleNotification, 0, this.webView);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setPolicyDelegate, this.delegate);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setDownloadDelegate, this.delegate);
        int sHandle = WebKit.createNSString(AGENT_STRING);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setApplicationNameForUserAgent, sHandle);
        OS.CFRelease(sHandle);
        if (OS.VERSION < 4176 && display.getActiveShell() == this.browser.getShell()) {
            Cocoa.objc_msgSend(Cocoa.objc_msgSend(this.webView, Cocoa.S_window), Cocoa.S_makeKeyWindow);
        }
        if (!Initialized) {
            Initialized = true;
            int preferences = Cocoa.objc_msgSend(Cocoa.C_WebPreferences, Cocoa.S_standardPreferences);
            Cocoa.objc_msgSend(preferences, Cocoa.S_setJavaEnabled, 0);
        }
    }

    static int eventProc3(int nextHandler, int theEvent, int userData) {
        Widget widget = Display.getCurrent().findWidget(userData);
        if (widget instanceof Browser) {
            return ((WebKit)((Browser)widget).webBrowser).handleCallback(nextHandler, theEvent);
        }
        return -9874;
    }

    static int eventProc7(int webview, int userData, int selector, int arg0, int arg1, int arg2, int arg3) {
        Widget widget = Display.getCurrent().findWidget(userData);
        if (widget instanceof Browser) {
            return ((WebKit)((Browser)widget).webBrowser).handleCallback(selector, arg0, arg1, arg2, arg3);
        }
        return 0;
    }

    static int createNSString(String string) {
        int length = string.length();
        char[] buffer = new char[length];
        string.getChars(0, length, buffer, 0);
        return OS.CFStringCreateWithCharacters(0, buffer, length);
    }

    static String getString(int ptr) {
        int length = OS.CFStringGetLength(ptr);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(ptr, range, buffer);
        return new String(buffer);
    }

    public boolean back() {
        this.html = null;
        return Cocoa.objc_msgSend(this.webView, Cocoa.S_goBack) != 0;
    }

    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean showPrompters) {
        if (!this.jsEnabled) {
            return true;
        }
        String functionName = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuffer buffer = new StringBuffer("function ");
        buffer.append(functionName);
        buffer.append("(win) {\n");
        buffer.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (showPrompters) {
            buffer.append("if (str != null) { ");
            buffer.append("var result = window.external.callRunBeforeUnloadConfirmPanelWithMessage(str);");
            buffer.append("if (!result) return false;}");
        }
        buffer.append("} catch (e) {}}");
        buffer.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        buffer.append(functionName);
        buffer.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        buffer.append("\n};");
        this.execute(buffer.toString());
        Boolean result = (Boolean)this.evaluate("return " + functionName + "(window);");
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean execute(String script) {
        int frame = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        int context = Cocoa.objc_msgSend(frame, Cocoa.S_globalContext);
        byte[] bytes = null;
        try {
            bytes = (String.valueOf(script) + '\u0000').getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = (String.valueOf(script) + '\u0000').getBytes();
        }
        int scriptString = OS.JSStringCreateWithUTF8CString(bytes);
        try {
            bytes = (String.valueOf(this.getUrl()) + '\u0000').getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = (String.valueOf(this.getUrl()) + '\u0000').getBytes();
        }
        int urlString = OS.JSStringCreateWithUTF8CString(bytes);
        int result = OS.JSEvaluateScript(context, scriptString, 0, urlString, 0, null);
        OS.JSStringRelease(urlString);
        OS.JSStringRelease(scriptString);
        return result != 0;
    }

    public boolean forward() {
        this.html = null;
        return Cocoa.objc_msgSend(this.webView, Cocoa.S_goForward) != 0;
    }

    public String getBrowserType() {
        return "webkit";
    }

    public String getText() {
        int mainFrame = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        int dataSource = Cocoa.objc_msgSend(mainFrame, Cocoa.S_dataSource);
        if (dataSource == 0) {
            return "";
        }
        int representation = Cocoa.objc_msgSend(dataSource, Cocoa.S_representation);
        if (representation == 0) {
            return "";
        }
        int source = Cocoa.objc_msgSend(representation, Cocoa.S_documentSource);
        if (source == 0) {
            return "";
        }
        int length = OS.CFStringGetLength(source);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(source, range, buffer);
        return new String(buffer);
    }

    public String getUrl() {
        if (this.url.length() == 0) {
            return ABOUT_BLANK;
        }
        return this.url;
    }

    int handleCallback(int nextHandler, int theEvent) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (OS.GetEventClass(theEvent)) {
            case 1668183148: {
                switch (eventKind) {
                    case 17: {
                        OS.SetEventParameter(theEvent, 1668047203, 1668047203, 4, new int[]{3});
                        return 0;
                    }
                    case 11: {
                        return 0;
                    }
                    case 4: {
                        if (this.browser.isVisible()) break;
                        return 0;
                    }
                    case 159: {
                        int window = OS.GetControlOwner(this.browser.handle);
                        int[] contentView = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(window), OS.kHIViewWindowContentID(), contentView);
                        OS.HIViewAddSubview(contentView[0], this.webViewHandle);
                        OS.RemoveEventHandler(this.windowBoundsHandler);
                        int[] mask2 = new int[]{2003398244, 27};
                        int[] outRef = new int[1];
                        OS.InstallEventHandler(OS.GetWindowEventTarget(window), Callback3.getAddress(), mask2.length / 2, mask2, this.browser.handle, outRef);
                        this.windowBoundsHandler = outRef[0];
                        break;
                    }
                    case 154: 
                    case 157: {
                        CGRect bounds = new CGRect();
                        if (!this.browser.isVisible()) {
                            bounds.y = -16.0f;
                            bounds.x = -16.0f;
                            bounds.height = 16.0f;
                            bounds.width = 16.0f;
                            OS.HIViewSetFrame(this.webViewHandle, bounds);
                            break;
                        }
                        OS.HIViewGetBounds(this.browser.handle, bounds);
                        int[] contentView = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.browser.handle)), OS.kHIViewWindowContentID(), contentView);
                        OS.HIViewConvertRect(bounds, this.browser.handle, contentView[0]);
                        if (bounds.width <= 16.0f) {
                            bounds.width = 16.0f;
                        }
                        if (bounds.height <= 16.0f) {
                            bounds.height = 16.0f;
                        }
                        OS.HIViewSetFrame(this.webViewHandle, bounds);
                    }
                }
            }
            case 2003398244: {
                switch (eventKind) {
                    case 27: {
                        if (!this.browser.isVisible()) break;
                        CGRect oldBounds = new CGRect();
                        OS.GetEventParameter(theEvent, 1869767540, 1751741027, null, 16, null, oldBounds);
                        CGRect bounds = new CGRect();
                        OS.GetEventParameter(theEvent, 1668440948, 1751741027, null, 16, null, bounds);
                        if (oldBounds.height == bounds.height) break;
                        OS.HIViewGetBounds(this.browser.handle, bounds);
                        int[] contentView = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.browser.handle)), OS.kHIViewWindowContentID(), contentView);
                        OS.HIViewConvertRect(bounds, this.browser.handle, contentView[0]);
                        if (bounds.width <= 16.0f) {
                            bounds.width = 16.0f;
                        }
                        if (bounds.height <= 16.0f) {
                            bounds.height = 16.0f;
                        }
                        bounds.x += 1.0f;
                        OS.HIViewSetFrame(this.webViewHandle, bounds);
                        bounds.x -= 1.0f;
                        OS.HIViewSetFrame(this.webViewHandle, bounds);
                    }
                }
            }
            case 1801812322: {
                switch (eventKind) {
                    case 1: {
                        int[] length = new int[1];
                        int status = OS.GetEventParameter(theEvent, 1802858089, 1970567284, null, 4, length, null);
                        if (status == 0 && length[0] != 0) {
                            int[] modifiers = new int[1];
                            OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                            char[] chars = new char[1];
                            OS.GetEventParameter(theEvent, 1802858089, 1970567284, null, 2, null, chars);
                            if ((modifiers[0] & 0x100) != 0) {
                                switch (chars[0]) {
                                    case 'v': {
                                        Cocoa.objc_msgSend(this.webView, Cocoa.S_paste);
                                        return 0;
                                    }
                                    case 'c': {
                                        Cocoa.objc_msgSend(this.webView, Cocoa.S_copy);
                                        return 0;
                                    }
                                    case 'x': {
                                        Cocoa.objc_msgSend(this.webView, Cocoa.S_cut);
                                        return 0;
                                    }
                                }
                            }
                        }
                        int handle = this.webViewHandle;
                        int root = OS.HIViewGetSuperview(this.webViewHandle);
                        OS.CFRetain(handle);
                        OS.CFRetain(root);
                        int result = OS.CallNextEventHandler(nextHandler, theEvent);
                        OS.CFRelease(handle);
                        OS.CFRelease(root);
                        return result;
                    }
                }
            }
            case 1952807028: {
                switch (eventKind) {
                    default: 
                }
            }
        }
        return -9874;
    }

    int handleCallback(int selector, int arg0, int arg1, int arg2, int arg3) {
        int ret = 0;
        switch (selector) {
            case 1: {
                this.didFailProvisionalLoadWithError(arg0, arg1);
                break;
            }
            case 2: {
                this.didFinishLoadForFrame(arg0);
                break;
            }
            case 3: {
                this.didReceiveTitle(arg0, arg1);
                break;
            }
            case 4: {
                this.didStartProvisionalLoadForFrame(arg0);
                break;
            }
            case 5: {
                this.didFinishLoadingFromDataSource(arg0, arg1);
                break;
            }
            case 6: {
                this.didFailLoadingWithError(arg0, arg1, arg2);
                break;
            }
            case 7: {
                ret = this.identifierForInitialRequest(arg0, arg1);
                break;
            }
            case 8: {
                ret = this.willSendRequest(arg0, arg1, arg2, arg3);
                break;
            }
            case 9: {
                this.handleNotification(arg0);
                break;
            }
            case 10: {
                this.didCommitLoadForFrame(arg0);
                break;
            }
            case 11: {
                ret = this.createWebViewWithRequest(arg0);
                break;
            }
            case 12: {
                this.webViewShow(arg0);
                break;
            }
            case 13: {
                this.setFrame(arg0);
                break;
            }
            case 14: {
                this.webViewClose();
                break;
            }
            case 15: {
                ret = this.contextMenuItemsForElement(arg0, arg1);
                break;
            }
            case 16: {
                this.setStatusBarVisible(arg0);
                break;
            }
            case 17: {
                this.setResizable(arg0);
                break;
            }
            case 18: {
                this.setToolbarsVisible(arg0);
                break;
            }
            case 19: {
                this.decidePolicyForMIMEType(arg0, arg1, arg2, arg3);
                break;
            }
            case 20: {
                this.decidePolicyForNavigationAction(arg0, arg1, arg2, arg3);
                break;
            }
            case 21: {
                this.decidePolicyForNewWindowAction(arg0, arg1, arg2, arg3);
                break;
            }
            case 22: {
                this.unableToImplementPolicyWithError(arg0, arg1);
                break;
            }
            case 23: {
                this.setStatusText(arg0);
                break;
            }
            case 24: {
                this.webViewFocus();
                break;
            }
            case 25: {
                this.webViewUnfocus();
                break;
            }
            case 26: {
                this.runJavaScriptAlertPanelWithMessage(arg0);
                break;
            }
            case 27: {
                ret = this.runJavaScriptConfirmPanelWithMessage(arg0);
                break;
            }
            case 28: {
                this.runOpenPanelForFileButtonWithResultListener(arg0);
                break;
            }
            case 29: {
                this.decideDestinationWithSuggestedFilename(arg0, arg1);
                break;
            }
            case 30: {
                this.mouseDidMoveOverElement(arg0, arg1);
                break;
            }
            case 31: {
                this.didChangeLocationWithinPageForFrame(arg0);
                break;
            }
            case 32: {
                this.handleEvent(arg0);
                break;
            }
            case 33: {
                this.windowScriptObjectAvailable(arg0);
                break;
            }
            case 34: {
                ret = this.callJava(arg0, arg1, arg2);
                break;
            }
            case 35: {
                this.didReceiveAuthenticationChallengefromDataSource(arg0, arg1, arg2);
                break;
            }
            case 36: {
                ret = this.runBeforeUnloadConfirmPanelWithMessage(arg0, arg1);
                break;
            }
            case 37: {
                ret = this.callRunBeforeUnloadConfirmPanelWithMessage(arg0, arg1);
                break;
            }
            case 38: {
                this.createPanelDidEnd(arg0, arg1, arg2);
            }
        }
        return ret;
    }

    public boolean isBackEnabled() {
        return Cocoa.objc_msgSend(this.webView, Cocoa.S_canGoBack) != 0;
    }

    public boolean isForwardEnabled() {
        return Cocoa.objc_msgSend(this.webView, Cocoa.S_canGoForward) != 0;
    }

    public void refresh() {
        this.html = null;
        Cocoa.objc_msgSend(this.webView, Cocoa.S_reload, 0);
    }

    public boolean setText(String html, boolean trusted) {
        boolean blankLoading = this.html != null;
        this.html = html;
        boolean bl = this.untrustedText = !trusted;
        if (blankLoading) {
            return true;
        }
        int str = WebKit.createNSString(ABOUT_BLANK);
        int inURL = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, str);
        OS.CFRelease(str);
        int request = Cocoa.objc_msgSend(Cocoa.C_NSURLRequest, Cocoa.S_requestWithURL, inURL);
        int mainFrame = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        Cocoa.objc_msgSend(mainFrame, Cocoa.S_loadRequest, request);
        return true;
    }

    public boolean setUrl(String url, String postData, String[] headers) {
        this.html = null;
        if (url.indexOf(47) == 0) {
            url = PROTOCOL_FILE + url;
        } else if (url.indexOf(58) == -1) {
            url = PROTOCOL_HTTP + url;
        }
        int inURL = 0;
        int str = WebKit.createNSString(url);
        if (str != 0) {
            char[] unescapedChars = new char[]{'%', '#'};
            int unescapedStr = OS.CFStringCreateWithCharacters(0, unescapedChars, unescapedChars.length);
            int escapedStr = OS.CFURLCreateStringByAddingPercentEscapes(0, str, unescapedStr, 0, 0x8000100);
            if (escapedStr != 0) {
                inURL = OS.CFURLCreateWithString(0, escapedStr, 0);
                OS.CFRelease(escapedStr);
            }
            if (unescapedStr != 0) {
                OS.CFRelease(unescapedStr);
            }
            OS.CFRelease(str);
        }
        if (inURL == 0) {
            return false;
        }
        int request = Cocoa.objc_msgSend(Cocoa.C_NSMutableURLRequest, Cocoa.S_requestWithURL, inURL);
        OS.CFRelease(inURL);
        if (postData != null) {
            int post = WebKit.createNSString(POST);
            Cocoa.objc_msgSend(request, Cocoa.S_setHTTPMethod, post);
            OS.CFRelease(post);
            byte[] bytes = postData.getBytes();
            int data = Cocoa.objc_msgSend(Cocoa.C_NSData, Cocoa.S_dataWithBytes, bytes, bytes.length);
            Cocoa.objc_msgSend(request, Cocoa.S_setHTTPBody, data);
        }
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                int index;
                String current = headers[i];
                if (current != null && (index = current.indexOf(58)) != -1) {
                    String key = current.substring(0, index).trim();
                    String value = current.substring(index + 1).trim();
                    if (key.length() > 0 && value.length() > 0) {
                        if (key.equalsIgnoreCase(USER_AGENT)) {
                            int string = WebKit.createNSString(value);
                            Cocoa.objc_msgSend(this.webView, Cocoa.S_setCustomUserAgent, string);
                            OS.CFRelease(string);
                        } else {
                            int keyString = WebKit.createNSString(key);
                            int valueString = WebKit.createNSString(value);
                            Cocoa.objc_msgSend(request, Cocoa.S_setValueForHTTPHeaderField, valueString, keyString);
                            OS.CFRelease(valueString);
                            OS.CFRelease(keyString);
                        }
                    }
                }
                ++i;
            }
        }
        int mainFrame = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        Cocoa.objc_msgSend(mainFrame, Cocoa.S_loadRequest, request);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setCustomUserAgent, 0);
        return true;
    }

    public void stop() {
        this.html = null;
        Cocoa.objc_msgSend(this.webView, Cocoa.S_stopLoading, 0);
    }

    boolean translateMnemonics() {
        return false;
    }

    void didChangeLocationWithinPageForFrame(int frame) {
        int i;
        boolean top;
        int dataSource = Cocoa.objc_msgSend(frame, Cocoa.S_dataSource);
        int request = Cocoa.objc_msgSend(dataSource, Cocoa.S_request);
        int url = Cocoa.objc_msgSend(request, Cocoa.S_URL);
        int s = Cocoa.objc_msgSend(url, Cocoa.S_absoluteString);
        int length = OS.CFStringGetLength(s);
        if (length == 0) {
            return;
        }
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(s, range, buffer);
        String url2 = new String(buffer);
        if (url2.equals(URI_FILEROOT)) {
            url2 = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url2.startsWith(URI_FILEROOT) && url2.charAt(length) == '#') {
                url2 = ABOUT_BLANK + url2.substring(length);
            }
        }
        Display display = this.browser.getDisplay();
        boolean bl = top = frame == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        if (top) {
            StatusTextEvent statusText = new StatusTextEvent(this.browser);
            statusText.display = display;
            statusText.widget = this.browser;
            statusText.text = url2;
            i = 0;
            while (i < this.statusTextListeners.length) {
                this.statusTextListeners[i].changed(statusText);
                ++i;
            }
        }
        LocationEvent location = new LocationEvent(this.browser);
        location.display = display;
        location.widget = this.browser;
        location.location = url2;
        location.top = top;
        i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changed(location);
            ++i;
        }
    }

    void didFailProvisionalLoadWithError(int error, int frame) {
        int description;
        int keyString;
        int errorCode;
        if (frame == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame)) {
            this.identifier = 0;
        }
        if (-1000 < (errorCode = Cocoa.objc_msgSend(error, Cocoa.S_code))) {
            return;
        }
        int failingURL = 0;
        int info = Cocoa.objc_msgSend(error, Cocoa.S_userInfo);
        if (info != 0) {
            keyString = WebKit.createNSString("NSErrorFailingURLKey");
            failingURL = Cocoa.objc_msgSend(info, Cocoa.S_valueForKey, keyString);
            OS.CFRelease(keyString);
        }
        if (failingURL != 0 && -1204 <= errorCode && errorCode <= -1200) {
            keyString = WebKit.createNSString("NSErrorPeerCertificateChainKey");
            int certificates = Cocoa.objc_msgSend(info, Cocoa.S_objectForKey, keyString);
            OS.CFRelease(keyString);
            int[] policySearch = new int[1];
            int[] policyRef = new int[1];
            int[] trustRef = new int[1];
            boolean success = false;
            int result = OS.SecPolicySearchCreate(3, 0, 0, policySearch);
            if (result == 0 && policySearch[0] != 0 && (result = OS.SecPolicySearchCopyNext(policySearch[0], policyRef)) == 0 && policyRef[0] != 0 && (result = OS.SecTrustCreateWithCertificates(certificates, policyRef[0], trustRef)) == 0 && trustRef[0] != 0) {
                int panel = Cocoa.objc_msgSend(Cocoa.C_SFCertificateTrustPanel, Cocoa.S_sharedCertificateTrustPanel);
                String failingUrlString = WebKit.getString(Cocoa.objc_msgSend(failingURL, Cocoa.S_absoluteString));
                String message = Compatibility.getMessage("SWT_InvalidCert_Message", new Object[]{failingUrlString});
                int nsString = WebKit.createNSString(Compatibility.getMessage("SWT_Cancel"));
                Cocoa.objc_msgSend(panel, Cocoa.S_setAlternateButtonTitle, nsString);
                OS.CFRelease(nsString);
                Cocoa.objc_msgSend(panel, Cocoa.S_setShowsHelp, 1);
                Cocoa.objc_msgSend(failingURL, Cocoa.S_retain);
                int window = Cocoa.objc_msgSend(this.webView, Cocoa.S_window);
                nsString = WebKit.createNSString(message);
                Cocoa.objc_msgSend(panel, Cocoa.S_beginSheetForWindow, window, this.delegate, Cocoa.S_createPanelDidEnd, failingURL, trustRef[0], nsString);
                OS.CFRelease(nsString);
                success = true;
            }
            if (trustRef[0] != 0) {
                OS.CFRelease(trustRef[0]);
            }
            if (policyRef[0] != 0) {
                OS.CFRelease(policyRef[0]);
            }
            if (policySearch[0] != 0) {
                OS.CFRelease(policySearch[0]);
            }
            if (success) {
                return;
            }
        }
        if ((description = Cocoa.objc_msgSend(error, Cocoa.S_localizedDescription)) != 0) {
            String descriptionString = WebKit.getString(description);
            String message = failingURL != 0 ? String.valueOf(WebKit.getString(Cocoa.objc_msgSend(failingURL, Cocoa.S_absoluteString))) + "\n\n" : "";
            message = String.valueOf(message) + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{descriptionString});
            MessageBox messageBox = new MessageBox(this.browser.getShell(), 33);
            messageBox.setMessage(message);
            messageBox.open();
        }
    }

    void createPanelDidEnd(int sheet, int returnCode, int contextInfo) {
        Cocoa.objc_msgSend(contextInfo, Cocoa.S_autorelease);
        if (returnCode != 1) {
            return;
        }
        int method = Cocoa.class_getClassMethod(Cocoa.C_NSURLRequest, Cocoa.S_setAllowsAnyHTTPSCertificate);
        if (method != 0) {
            int host = Cocoa.objc_msgSend(contextInfo, Cocoa.S_host);
            int urlString = Cocoa.objc_msgSend(contextInfo, Cocoa.S_absoluteString);
            Cocoa.objc_msgSend(Cocoa.C_NSURLRequest, Cocoa.S_setAllowsAnyHTTPSCertificate, 1, host);
            this.setUrl(WebKit.getString(urlString), null, null);
        }
    }

    void didFinishLoadForFrame(int frame) {
        if (frame == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame)) {
            if (this.html != null && this.getUrl().startsWith(ABOUT_BLANK)) {
                this.loadingText = true;
                int htmlString = WebKit.createNSString(this.html);
                int urlString = this.untrustedText ? WebKit.createNSString(ABOUT_BLANK) : WebKit.createNSString(URI_FILEROOT);
                int url = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, urlString);
                int mainFrame = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
                Cocoa.objc_msgSend(mainFrame, Cocoa.S_loadHTMLStringBaseURL, htmlString, url);
                OS.CFRelease(urlString);
                OS.CFRelease(htmlString);
                this.html = null;
            }
            if (!this.loadingText) {
                int title;
                Display display = this.browser.getDisplay();
                int dataSource = Cocoa.objc_msgSend(frame, Cocoa.S_dataSource);
                if (dataSource != 0 && (title = Cocoa.objc_msgSend(dataSource, Cocoa.S_pageTitle)) == 0) {
                    TitleEvent newEvent = new TitleEvent(this.browser);
                    newEvent.display = display;
                    newEvent.widget = this.browser;
                    newEvent.title = this.getUrl();
                    int i = 0;
                    while (i < this.titleListeners.length) {
                        this.titleListeners[i].changed(newEvent);
                        ++i;
                    }
                    if (this.browser.isDisposed()) {
                        return;
                    }
                }
                ProgressEvent progress = new ProgressEvent(this.browser);
                progress.display = display;
                progress.widget = this.browser;
                progress.current = 100;
                progress.total = 100;
                int i = 0;
                while (i < this.progressListeners.length) {
                    this.progressListeners[i].completed(progress);
                    ++i;
                }
            }
            this.loadingText = false;
            if (this.browser.isDisposed()) {
                return;
            }
            this.identifier = 0;
        }
    }

    void hookDOMFocusListeners(int frame) {
        if (4160 > OS.VERSION || OS.VERSION >= 4176) {
            return;
        }
        int document = Cocoa.objc_msgSend(frame, Cocoa.S_DOMDocument);
        if (document == 0) {
            return;
        }
        int ptr = WebKit.createNSString(DOMEVENT_FOCUSIN);
        Cocoa.objc_msgSend(document, Cocoa.S_addEventListener, ptr, this.delegate, 0);
        OS.CFRelease(ptr);
        ptr = WebKit.createNSString(DOMEVENT_FOCUSOUT);
        Cocoa.objc_msgSend(document, Cocoa.S_addEventListener, ptr, this.delegate, 0);
        OS.CFRelease(ptr);
    }

    void hookDOMKeyListeners(int frame) {
        if (OS.VERSION < 4160) {
            return;
        }
        int document = Cocoa.objc_msgSend(frame, Cocoa.S_DOMDocument);
        if (document == 0) {
            return;
        }
        int ptr = WebKit.createNSString(DOMEVENT_KEYDOWN);
        Cocoa.objc_msgSend(document, Cocoa.S_addEventListener, ptr, this.delegate, 0);
        OS.CFRelease(ptr);
        ptr = WebKit.createNSString(DOMEVENT_KEYUP);
        Cocoa.objc_msgSend(document, Cocoa.S_addEventListener, ptr, this.delegate, 0);
        OS.CFRelease(ptr);
    }

    void hookDOMMouseListeners(int frame) {
        if (OS.VERSION < 4160) {
            return;
        }
        int document = Cocoa.objc_msgSend(frame, Cocoa.S_DOMDocument);
        if (document == 0) {
            return;
        }
        int ptr = WebKit.createNSString(DOMEVENT_MOUSEDOWN);
        Cocoa.objc_msgSend(document, Cocoa.S_addEventListener, ptr, this.delegate, 0);
        OS.CFRelease(ptr);
        ptr = WebKit.createNSString(DOMEVENT_MOUSEUP);
        Cocoa.objc_msgSend(document, Cocoa.S_addEventListener, ptr, this.delegate, 0);
        OS.CFRelease(ptr);
        ptr = WebKit.createNSString(DOMEVENT_MOUSEMOVE);
        Cocoa.objc_msgSend(document, Cocoa.S_addEventListener, ptr, this.delegate, 0);
        OS.CFRelease(ptr);
        ptr = WebKit.createNSString(DOMEVENT_MOUSEWHEEL);
        Cocoa.objc_msgSend(document, Cocoa.S_addEventListener, ptr, this.delegate, 0);
        OS.CFRelease(ptr);
    }

    void didReceiveTitle(int title, int frame) {
        if (frame == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame)) {
            int length = OS.CFStringGetLength(title);
            char[] buffer = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters(title, range, buffer);
            String newTitle = new String(buffer);
            TitleEvent newEvent = new TitleEvent(this.browser);
            newEvent.display = this.browser.getDisplay();
            newEvent.widget = this.browser;
            newEvent.title = newTitle;
            int i = 0;
            while (i < this.titleListeners.length) {
                this.titleListeners[i].changed(newEvent);
                ++i;
            }
        }
    }

    void didStartProvisionalLoadForFrame(int frame) {
    }

    void didCommitLoadForFrame(int frame) {
        boolean top;
        int dataSource = Cocoa.objc_msgSend(frame, Cocoa.S_dataSource);
        int request = Cocoa.objc_msgSend(dataSource, Cocoa.S_request);
        int url = Cocoa.objc_msgSend(request, Cocoa.S_URL);
        int s = Cocoa.objc_msgSend(url, Cocoa.S_absoluteString);
        int length = OS.CFStringGetLength(s);
        if (length == 0) {
            return;
        }
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(s, range, buffer);
        String url2 = new String(buffer);
        if (url2.equals(URI_FILEROOT)) {
            url2 = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url2.startsWith(URI_FILEROOT) && url2.charAt(length) == '#') {
                url2 = ABOUT_BLANK + url2.substring(length);
            }
        }
        Display display = this.browser.getDisplay();
        boolean bl = top = frame == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        if (top) {
            this.resourceCount = 0;
            this.url = url2;
            if (url2.startsWith(ABOUT_BLANK) && this.html != null) {
                return;
            }
            Enumeration elements = this.functions.elements();
            while (elements.hasMoreElements()) {
                BrowserFunction function = (BrowserFunction)elements.nextElement();
                this.execute(function.functionString);
            }
            ProgressEvent progress = new ProgressEvent(this.browser);
            progress.display = display;
            progress.widget = this.browser;
            progress.current = 1;
            progress.total = 100;
            int i = 0;
            while (i < this.progressListeners.length) {
                this.progressListeners[i].changed(progress);
                ++i;
            }
            if (this.browser.isDisposed()) {
                return;
            }
            StatusTextEvent statusText = new StatusTextEvent(this.browser);
            statusText.display = display;
            statusText.widget = this.browser;
            statusText.text = url2;
            int i2 = 0;
            while (i2 < this.statusTextListeners.length) {
                this.statusTextListeners[i2].changed(statusText);
                ++i2;
            }
            if (this.browser.isDisposed()) {
                return;
            }
            this.hookDOMKeyListeners(frame);
        }
        this.hookDOMFocusListeners(frame);
        this.hookDOMMouseListeners(frame);
        LocationEvent location = new LocationEvent(this.browser);
        location.display = display;
        location.widget = this.browser;
        location.location = url2;
        location.top = top;
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changed(location);
            ++i;
        }
    }

    void windowScriptObjectAvailable(int windowScriptObject) {
        int str = WebKit.createNSString("external");
        if (str != 0) {
            Cocoa.objc_msgSend(windowScriptObject, Cocoa.S_setValue, this.delegate, str);
            OS.CFRelease(str);
        }
    }

    void didFinishLoadingFromDataSource(int identifier, int dataSource) {
    }

    void didFailLoadingWithError(int identifier, int error, int dataSource) {
    }

    void didReceiveAuthenticationChallengefromDataSource(int identifier, int challenge, int dataSource) {
        int handler;
        int method;
        int cls;
        int count = Cocoa.objc_msgSend(challenge, Cocoa.S_previousFailureCount);
        if (count < 3) {
            int i = 0;
            while (i < this.authenticationListeners.length) {
                AuthenticationEvent event = new AuthenticationEvent(this.browser);
                event.location = this.lastNavigateURL;
                this.authenticationListeners[i].authenticate(event);
                if (!event.doit) {
                    int challengeSender = Cocoa.objc_msgSend(challenge, Cocoa.S_sender);
                    Cocoa.objc_msgSend(challengeSender, Cocoa.S_cancelAuthenticationChallenge, challenge);
                    return;
                }
                if (event.user != null && event.password != null) {
                    int challengeSender = Cocoa.objc_msgSend(challenge, Cocoa.S_sender);
                    int user = WebKit.createNSString(event.user);
                    int password = WebKit.createNSString(event.password);
                    int credential = Cocoa.objc_msgSend(Cocoa.C_NSURLCredential, Cocoa.S_credentialWithUser, user, password, 1);
                    Cocoa.objc_msgSend(challengeSender, Cocoa.S_useCredential, credential, challenge);
                    OS.CFRelease(password);
                    OS.CFRelease(user);
                    return;
                }
                ++i;
            }
        }
        if ((cls = Cocoa.C_WebPanelAuthenticationHandler) != 0 && (method = Cocoa.class_getClassMethod(cls, Cocoa.S_sharedHandler)) != 0 && (handler = Cocoa.objc_msgSend(cls, Cocoa.S_sharedHandler)) != 0) {
            int window = Cocoa.objc_msgSend(this.webView, Cocoa.S_window);
            Cocoa.objc_msgSend(handler, Cocoa.S_startAuthentication, challenge, window);
            return;
        }
        String[] userReturn = new String[1];
        String[] passwordReturn = new String[1];
        int proposedCredential = Cocoa.objc_msgSend(challenge, Cocoa.S_proposedCredential);
        if (proposedCredential != 0) {
            boolean hasPassword;
            int user = Cocoa.objc_msgSend(proposedCredential, Cocoa.S_user);
            userReturn[0] = WebKit.getString(user);
            boolean bl = hasPassword = Cocoa.objc_msgSend(proposedCredential, Cocoa.S_hasPassword) != 0;
            if (hasPassword) {
                int password = Cocoa.objc_msgSend(proposedCredential, Cocoa.S_password);
                passwordReturn[0] = WebKit.getString(password);
            }
        }
        int space = Cocoa.objc_msgSend(challenge, Cocoa.S_protectionSpace);
        int host = Cocoa.objc_msgSend(space, Cocoa.S_host);
        String hostString = String.valueOf(WebKit.getString(host)) + ':';
        int port = Cocoa.objc_msgSend(space, Cocoa.S_port);
        hostString = String.valueOf(hostString) + port;
        int realm = Cocoa.objc_msgSend(space, Cocoa.S_realm);
        String realmString = WebKit.getString(realm);
        boolean result = this.showAuthenticationDialog(userReturn, passwordReturn, hostString, realmString);
        int challengeSender = Cocoa.objc_msgSend(challenge, Cocoa.S_sender);
        if (!result) {
            Cocoa.objc_msgSend(challengeSender, Cocoa.S_cancelAuthenticationChallenge, challenge);
            return;
        }
        int user = WebKit.createNSString(userReturn[0]);
        int password = WebKit.createNSString(passwordReturn[0]);
        int credential = Cocoa.objc_msgSend(Cocoa.C_NSURLCredential, Cocoa.S_credentialWithUser, user, password, 1);
        Cocoa.objc_msgSend(challengeSender, Cocoa.S_useCredential, credential, challenge);
        OS.CFRelease(password);
        OS.CFRelease(user);
    }

    boolean showAuthenticationDialog(final String[] user, final String[] password, String host, String realm) {
        final Shell shell = new Shell(this.browser.getShell());
        shell.setLayout(new GridLayout());
        String title = SWT.getMessage("SWT_Authentication_Required");
        shell.setText(title);
        Label label = new Label(shell, 64);
        label.setText(Compatibility.getMessage("SWT_Enter_Username_and_Password", new String[]{realm, host}));
        GridData data = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int maxWidth = monitor.getBounds().width * 2 / 3;
        int width = label.computeSize((int)-1, (int)-1).x;
        data.widthHint = Math.min(width, maxWidth);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        label.setLayoutData(data);
        Label userLabel = new Label(shell, 0);
        userLabel.setText(SWT.getMessage("SWT_Username"));
        final Text userText = new Text(shell, 2048);
        if (user[0] != null) {
            userText.setText(user[0]);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        userText.setLayoutData(data);
        Label passwordLabel = new Label(shell, 0);
        passwordLabel.setText(SWT.getMessage("SWT_Password"));
        final Text passwordText = new Text(shell, 0x400800);
        if (password[0] != null) {
            passwordText.setText(password[0]);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        passwordText.setLayoutData(data);
        final boolean[] result = new boolean[1];
        final Button[] buttons = new Button[2];
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                user[0] = userText.getText();
                password[0] = passwordText.getText();
                result[0] = event.widget == buttons[1];
                shell.close();
            }
        };
        Composite composite = new Composite(shell, 0);
        data = new GridData();
        data.horizontalAlignment = 3;
        composite.setLayoutData(data);
        composite.setLayout(new GridLayout(2, true));
        buttons[0] = new Button(composite, 8);
        buttons[0].setText(SWT.getMessage("SWT_Cancel"));
        buttons[0].setLayoutData(new GridData(768));
        buttons[0].addListener(13, listener);
        buttons[1] = new Button(composite, 8);
        buttons[1].setText(SWT.getMessage("SWT_OK"));
        buttons[1].setLayoutData(new GridData(768));
        buttons[1].addListener(13, listener);
        shell.setDefaultButton(buttons[1]);
        shell.pack();
        shell.open();
        Display display = this.browser.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return result[0];
    }

    int identifierForInitialRequest(int request, int dataSource) {
        int frame;
        Display display = this.browser.getDisplay();
        ProgressEvent progress = new ProgressEvent(this.browser);
        progress.display = display;
        progress.widget = this.browser;
        progress.current = this.resourceCount;
        progress.total = Math.max(this.resourceCount, 100);
        int i = 0;
        while (i < this.progressListeners.length) {
            this.progressListeners[i].changed(progress);
            ++i;
        }
        if (this.browser.isDisposed()) {
            return 0;
        }
        int identifier = Cocoa.objc_msgSend(Cocoa.C_NSNumber, Cocoa.S_numberWithInt, this.resourceCount++);
        if (this.identifier == 0 && (frame = Cocoa.objc_msgSend(dataSource, Cocoa.S_webFrame)) == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame)) {
            this.identifier = identifier;
        }
        return identifier;
    }

    int willSendRequest(int identifier, int request, int redirectResponse, int dataSource) {
        boolean isFileURL;
        int url = Cocoa.objc_msgSend(request, Cocoa.S_URL);
        boolean bl = isFileURL = Cocoa.objc_msgSend(url, Cocoa.S_isFileURL) != 0;
        if (isFileURL) {
            int newRequest = Cocoa.objc_msgSend(request, Cocoa.S_mutableCopy);
            Cocoa.objc_msgSend(newRequest, Cocoa.S_autorelease);
            Cocoa.objc_msgSend(newRequest, Cocoa.S_setCachePolicy, 1);
            return newRequest;
        }
        return request;
    }

    void handleNotification(int notification) {
    }

    int createWebViewWithRequest(int request) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.required = true;
        if (this.openWindowListeners != null) {
            int i = 0;
            while (i < this.openWindowListeners.length) {
                this.openWindowListeners[i].open(newEvent);
                ++i;
            }
        }
        int webView = 0;
        Widget browser = null;
        if (newEvent.browser != null && newEvent.browser.webBrowser instanceof WebKit) {
            browser = newEvent.browser;
        }
        if (browser != null && !browser.isDisposed()) {
            webView = ((WebKit)((Browser)browser).webBrowser).webView;
            if (request != 0) {
                int mainFrame = Cocoa.objc_msgSend(webView, Cocoa.S_mainFrame);
                Cocoa.objc_msgSend(mainFrame, Cocoa.S_loadRequest, request);
            }
        }
        return webView;
    }

    void webViewShow(int sender) {
        Shell parent = this.browser.getShell();
        org.eclipse.swt.graphics.Point pt = parent.getSize();
        parent.setSize(pt.x + 1, pt.y);
        parent.setSize(pt.x, pt.y);
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        if (this.location != null) {
            newEvent.location = this.location;
        }
        if (this.size != null) {
            newEvent.size = this.size;
        }
        newEvent.addressBar = this.toolBar;
        newEvent.menuBar = true;
        newEvent.statusBar = this.statusBar;
        newEvent.toolBar = this.toolBar;
        int i = 0;
        while (i < this.visibilityWindowListeners.length) {
            this.visibilityWindowListeners[i].show(newEvent);
            ++i;
        }
        this.location = null;
        this.size = null;
    }

    void setFrame(int frame) {
        float[] dest = new float[4];
        OS.memmove(dest, frame, 16);
        Rectangle bounds = this.browser.getDisplay().getBounds();
        this.location = new org.eclipse.swt.graphics.Point((int)dest[0], bounds.height - (int)dest[1] - (int)dest[3]);
        this.size = new org.eclipse.swt.graphics.Point((int)dest[2], (int)dest[3]);
    }

    void webViewFocus() {
    }

    void webViewUnfocus() {
    }

    int callRunBeforeUnloadConfirmPanelWithMessage(int messageID, int arg) {
        int result = this.runBeforeUnloadConfirmPanelWithMessage(messageID, 0);
        return Cocoa.objc_msgSend(Cocoa.C_NSNumber, Cocoa.S_numberWithBool, result);
    }

    int runBeforeUnloadConfirmPanelWithMessage(int message, int frame) {
        StringBuffer text = new StringBuffer(Compatibility.getMessage("SWT_OnBeforeUnload_Message1"));
        text.append("\n\n");
        int length = OS.CFStringGetLength(message);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(message, range, buffer);
        text.append(new String(buffer));
        text.append("\n\n");
        text.append(Compatibility.getMessage("SWT_OnBeforeUnload_Message2"));
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 292);
        messageBox.setMessage(text.toString());
        return messageBox.open() == 32 ? 1 : 0;
    }

    void runJavaScriptAlertPanelWithMessage(int message) {
        int length = OS.CFStringGetLength(message);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(message, range, buffer);
        String text = new String(buffer);
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 40);
        messageBox.setText("Javascript");
        messageBox.setMessage(text);
        messageBox.open();
    }

    int runJavaScriptConfirmPanelWithMessage(int message) {
        int length = OS.CFStringGetLength(message);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(message, range, buffer);
        String text = new String(buffer);
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 292);
        messageBox.setText("Javascript");
        messageBox.setMessage(text);
        return messageBox.open() == 32 ? 1 : 0;
    }

    void runOpenPanelForFileButtonWithResultListener(int resultListener) {
        FileDialog dialog = new FileDialog(this.browser.getShell(), 0);
        String result = dialog.open();
        if (result == null) {
            Cocoa.objc_msgSend(resultListener, Cocoa.S_cancel);
            return;
        }
        int filename = WebKit.createNSString(result);
        Cocoa.objc_msgSend(resultListener, Cocoa.S_chooseFilename, filename);
        OS.CFRelease(filename);
    }

    void webViewClose() {
        Shell parent = this.browser.getShell();
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            this.closeWindowListeners[i].close(newEvent);
            ++i;
        }
        this.browser.dispose();
        if (parent.isDisposed()) {
            return;
        }
        org.eclipse.swt.graphics.Point pt = parent.getSize();
        parent.setSize(pt.x + 1, pt.y);
        parent.setSize(pt.x, pt.y);
    }

    int contextMenuItemsForElement(int element, int defaultMenuItems) {
        Point pt = new Point();
        OS.GetGlobalMouse(pt);
        Event event = new Event();
        event.x = pt.h;
        event.y = pt.v;
        this.browser.notifyListeners(35, event);
        if (!event.doit || this.browser.isDisposed()) {
            return 0;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (event.x != pt.h || event.y != pt.v) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0;
        }
        return defaultMenuItems;
    }

    void setStatusBarVisible(int visible) {
        this.statusBar = visible != 0;
    }

    void setStatusText(int text) {
        int length = OS.CFStringGetLength(text);
        if (length == 0) {
            return;
        }
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(text, range, buffer);
        StatusTextEvent statusText = new StatusTextEvent(this.browser);
        statusText.display = this.browser.getDisplay();
        statusText.widget = this.browser;
        statusText.text = new String(buffer);
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(statusText);
            ++i;
        }
    }

    void setResizable(int visible) {
    }

    void setToolbarsVisible(int visible) {
        this.toolBar = visible != 0;
    }

    void mouseDidMoveOverElement(int elementInformation, int modifierFlags) {
        String urlString;
        if (elementInformation == 0) {
            return;
        }
        if (!this.browser.isEnabled()) {
            return;
        }
        int key = WebKit.createNSString(WebElementLinkURLKey);
        int value = Cocoa.objc_msgSend(elementInformation, Cocoa.S_valueForKey, key);
        OS.CFRelease(key);
        if (value == 0) {
            if (this.lastHoveredLinkURL == null) {
                return;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusText = new StatusTextEvent(this.browser);
            statusText.display = this.browser.getDisplay();
            statusText.widget = this.browser;
            statusText.text = "";
            int i = 0;
            while (i < this.statusTextListeners.length) {
                this.statusTextListeners[i].changed(statusText);
                ++i;
            }
            return;
        }
        int stringPtr = Cocoa.objc_msgSend(value, Cocoa.S_absoluteString);
        int length = OS.CFStringGetLength(stringPtr);
        if (length == 0) {
            urlString = "";
        } else {
            char[] chars = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters(stringPtr, range, chars);
            urlString = new String(chars);
        }
        if (urlString.equals(this.lastHoveredLinkURL)) {
            return;
        }
        this.lastHoveredLinkURL = urlString;
        StatusTextEvent statusText = new StatusTextEvent(this.browser);
        statusText.display = this.browser.getDisplay();
        statusText.widget = this.browser;
        statusText.text = urlString;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(statusText);
            ++i;
        }
    }

    void decidePolicyForMIMEType(int type, int request, int frame, int listener) {
        boolean canShow = Cocoa.objc_msgSend(Cocoa.C_WebView, Cocoa.S_canShowMIMEType, type) != 0;
        Cocoa.objc_msgSend(listener, canShow ? Cocoa.S_use : Cocoa.S_download);
    }

    void decidePolicyForNavigationAction(int actionInformation, int request, int frame, int listener) {
        boolean isFileURL;
        int url = Cocoa.objc_msgSend(request, Cocoa.S_URL);
        if (this.loadingText) {
            Cocoa.objc_msgSend(listener, Cocoa.S_use);
            return;
        }
        if (url == 0) {
            Cocoa.objc_msgSend(listener, Cocoa.S_ignore);
            return;
        }
        boolean bl = isFileURL = Cocoa.objc_msgSend(url, Cocoa.S_isFileURL) != 0;
        if (isFileURL && this.getUrl().startsWith(ABOUT_BLANK) && this.untrustedText) {
            Cocoa.objc_msgSend(listener, Cocoa.S_ignore);
            return;
        }
        int s = Cocoa.objc_msgSend(url, Cocoa.S_absoluteString);
        int length = OS.CFStringGetLength(s);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(s, range, buffer);
        String url2 = new String(buffer);
        if (url2.equals(URI_FILEROOT)) {
            url2 = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url2.startsWith(URI_FILEROOT) && url2.charAt(length) == '#') {
                url2 = ABOUT_BLANK + url2.substring(length);
            }
        }
        if (url2.startsWith(URI_APPLEWEBDATA)) {
            Cocoa.objc_msgSend(listener, Cocoa.S_use);
        } else {
            LocationEvent newEvent = new LocationEvent(this.browser);
            newEvent.display = this.browser.getDisplay();
            newEvent.widget = this.browser;
            newEvent.location = url2;
            newEvent.doit = true;
            if (this.locationListeners != null) {
                int i = 0;
                while (i < this.locationListeners.length) {
                    this.locationListeners[i].changing(newEvent);
                    ++i;
                }
            }
            if (newEvent.doit) {
                if (this.jsEnabledChanged) {
                    this.jsEnabledChanged = false;
                    if (this.preferences == 0) {
                        this.preferences = Cocoa.objc_msgSend(Cocoa.C_WebPreferences, Cocoa.S_alloc);
                        Cocoa.objc_msgSend(this.preferences, Cocoa.S_init);
                        Cocoa.objc_msgSend(this.webView, Cocoa.S_setPreferences, this.preferences);
                    }
                    Cocoa.objc_msgSend(this.preferences, Cocoa.S_setJavaScriptEnabled, this.jsEnabled ? 1 : 0);
                }
                this.lastNavigateURL = url2;
            }
            Cocoa.objc_msgSend(listener, newEvent.doit ? Cocoa.S_use : Cocoa.S_ignore);
        }
    }

    void decidePolicyForNewWindowAction(int actionInformation, int request, int frameName, int listener) {
        Cocoa.objc_msgSend(listener, Cocoa.S_use);
    }

    void unableToImplementPolicyWithError(int error, int frame) {
    }

    void decideDestinationWithSuggestedFilename(int download, int filename) {
        int length = OS.CFStringGetLength(filename);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(filename, range, buffer);
        String name = new String(buffer);
        String path = null;
        if (OS.VERSION >= 4181) {
            int array = Cocoa.NSSearchPathForDirectoriesInDomains(12, 65535, true);
            int count = Cocoa.objc_msgSend(array, Cocoa.S_count);
            if (count == 0 && (count = Cocoa.objc_msgSend(array = Cocoa.NSSearchPathForDirectoriesInDomains(15, 65535, true), Cocoa.S_count)) == 0 && (count = Cocoa.objc_msgSend(array = Cocoa.NSSearchPathForDirectoriesInDomains(9, 65535, true), Cocoa.S_count)) == 0) {
                Cocoa.objc_msgSend(download, Cocoa.S_cancel);
                return;
            }
            int string = Cocoa.objc_msgSend(array, Cocoa.S_objectAtIndex, 0);
            length = OS.CFStringGetLength(string);
            buffer = new char[length];
            range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters(string, range, buffer);
            path = String.valueOf(new String(buffer)) + '/' + name;
        } else {
            FileDialog dialog = new FileDialog(this.browser.getShell(), 8192);
            dialog.setText(SWT.getMessage("SWT_FileDownload"));
            dialog.setFileName(name);
            path = dialog.open();
        }
        if (path == null) {
            Cocoa.objc_msgSend(download, Cocoa.S_cancel);
            return;
        }
        int result = WebKit.createNSString(path);
        Cocoa.objc_msgSend(download, Cocoa.S_setDestinationAllowOverwrite, result, 1);
        OS.CFRelease(result);
    }

    void handleEvent(int evt) {
        int button;
        boolean meta;
        if (!this.browser.isEnabled()) {
            return;
        }
        int type = Cocoa.objc_msgSend(evt, Cocoa.S_type);
        int length = OS.CFStringGetLength(type);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(type, range, buffer);
        String typeString = new String(buffer);
        if (typeString.equals(DOMEVENT_FOCUSIN)) {
            this.hasNewFocusElement = true;
            return;
        }
        if (typeString.equals(DOMEVENT_FOCUSOUT)) {
            this.hasNewFocusElement = false;
            return;
        }
        boolean ctrl = Cocoa.objc_msgSend(evt, Cocoa.S_ctrlKey) != 0;
        boolean shift = Cocoa.objc_msgSend(evt, Cocoa.S_shiftKey) != 0;
        boolean alt = Cocoa.objc_msgSend(evt, Cocoa.S_altKey) != 0;
        boolean bl = meta = Cocoa.objc_msgSend(evt, Cocoa.S_metaKey) != 0;
        if (DOMEVENT_KEYDOWN.equals(typeString) || DOMEVENT_KEYUP.equals(typeString)) {
            boolean doit;
            int keyCode = Cocoa.objc_msgSend(evt, Cocoa.S_keyCode);
            int charCode = Cocoa.objc_msgSend(evt, Cocoa.S_charCode);
            Event keyEvent = new Event();
            keyEvent.widget = this.browser;
            keyEvent.type = DOMEVENT_KEYDOWN.equals(typeString) ? 1 : 2;
            keyEvent.keyCode = this.translateKey(keyCode);
            keyEvent.character = keyEvent.keyCode == 127 ? (char)127 : (char)charCode;
            keyEvent.stateMask = (alt ? 65536 : 0) | (ctrl ? 262144 : 0) | (shift ? 131072 : 0) | (meta ? 0x400000 : 0);
            if (keyEvent.type == 1) {
                doit = this.sendKeyEvent(keyEvent);
            } else {
                this.browser.notifyListeners(keyEvent.type, keyEvent);
                doit = keyEvent.doit;
            }
            if (this.browser.isDisposed()) {
                Cocoa.objc_msgSend(evt, Cocoa.S_preventDefault);
                return;
            }
            if (doit && OS.VERSION < 4176 && keyEvent.keyCode == 9 && (keyEvent.stateMask & 0x20000) != 0) {
                doit = false;
            }
            if (!doit) {
                Cocoa.objc_msgSend(evt, Cocoa.S_preventDefault);
            } else if (!this.hasNewFocusElement && keyEvent.keyCode == 9 && DOMEVENT_KEYUP.equals(typeString)) {
                this.hasNewFocusElement = false;
            }
            return;
        }
        int screenX = Cocoa.objc_msgSend(evt, Cocoa.S_screenX);
        int screenY = Cocoa.objc_msgSend(evt, Cocoa.S_screenY);
        org.eclipse.swt.graphics.Point position = new org.eclipse.swt.graphics.Point(screenX, screenY);
        position = this.browser.getDisplay().map(null, (Control)this.browser, position);
        int detail = Cocoa.objc_msgSend(evt, Cocoa.S_detail);
        Event mouseEvent = new Event();
        mouseEvent.widget = this.browser;
        mouseEvent.x = position.x;
        mouseEvent.y = position.y;
        mouseEvent.stateMask = (alt ? 65536 : 0) | (ctrl ? 262144 : 0) | (shift ? 131072 : 0) | (meta ? 0x400000 : 0);
        if (DOMEVENT_MOUSEDOWN.equals(typeString)) {
            mouseEvent.type = 3;
            button = Cocoa.objc_msgSend(evt, Cocoa.S_button);
            mouseEvent.button = button + 1;
            mouseEvent.count = detail;
        } else if (DOMEVENT_MOUSEUP.equals(typeString)) {
            mouseEvent.type = 4;
            button = Cocoa.objc_msgSend(evt, Cocoa.S_button);
            mouseEvent.button = button + 1;
            mouseEvent.count = detail;
            switch (mouseEvent.button) {
                case 1: {
                    mouseEvent.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    mouseEvent.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    mouseEvent.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    mouseEvent.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    mouseEvent.stateMask |= 0x2000000;
                }
            }
        } else if (DOMEVENT_MOUSEMOVE.equals(typeString)) {
            if (mouseEvent.x == this.lastMouseMoveX && mouseEvent.y == this.lastMouseMoveY) {
                return;
            }
            mouseEvent.type = 5;
            this.lastMouseMoveX = mouseEvent.x;
            this.lastMouseMoveY = mouseEvent.y;
        } else if (DOMEVENT_MOUSEWHEEL.equals(typeString)) {
            mouseEvent.type = 37;
            int delta = Cocoa.objc_msgSend(evt, Cocoa.S_wheelDelta);
            mouseEvent.count = delta / 120;
        }
        this.browser.notifyListeners(mouseEvent.type, mouseEvent);
        if (this.browser.isDisposed()) {
            return;
        }
        if (detail == 2 && DOMEVENT_MOUSEDOWN.equals(typeString)) {
            button = Cocoa.objc_msgSend(evt, Cocoa.S_button);
            mouseEvent = new Event();
            mouseEvent.widget = this.browser;
            mouseEvent.x = position.x;
            mouseEvent.y = position.y;
            mouseEvent.stateMask = (alt ? 65536 : 0) | (ctrl ? 262144 : 0) | (shift ? 131072 : 0) | (meta ? 0x400000 : 0);
            mouseEvent.type = 8;
            mouseEvent.button = button + 1;
            mouseEvent.count = detail;
            this.browser.notifyListeners(mouseEvent.type, mouseEvent);
        }
    }

    Object convertToJava(int value) {
        if (Cocoa.objc_msgSend(value, Cocoa.S_isKindOfClass, Cocoa.C_NSString) != 0) {
            int length = Cocoa.objc_msgSend(value, Cocoa.S_length);
            char[] buffer = new char[length];
            Cocoa.objc_msgSend(value, Cocoa.S_getCharacters_, buffer);
            return new String(buffer);
        }
        if (Cocoa.objc_msgSend(value, Cocoa.S_isKindOfClass, Cocoa.C_NSNumber) != 0) {
            int ptr = Cocoa.objc_msgSend(value, Cocoa.S_objCType);
            byte[] type = new byte[1];
            OS.memmove(type, ptr, 1);
            if (type[0] == 99 || type[0] == 66) {
                int result = Cocoa.objc_msgSend(value, Cocoa.S_boolValue);
                return new Boolean(result != 0);
            }
            if ("islqISLQfd".indexOf(type[0]) != -1) {
                double result = Cocoa.objc_msgSend_fpret(value, Cocoa.S_doubleValue);
                return new Double(result);
            }
        }
        if (Cocoa.objc_msgSend(value, Cocoa.S_isKindOfClass, Cocoa.C_WebScriptObject) != 0) {
            int str = WebKit.createNSString("length");
            int numberValue = Cocoa.objc_msgSend(value, Cocoa.S_valueForKey, str);
            OS.CFRelease(str);
            int length = Cocoa.objc_msgSend(numberValue, Cocoa.S_intValue);
            Object[] arguments = new Object[length];
            int i = 0;
            while (i < length) {
                int current = Cocoa.objc_msgSend(value, Cocoa.S_webScriptValueAtIndex, i);
                if (current != 0) {
                    arguments[i] = this.convertToJava(current);
                }
                ++i;
            }
            return arguments;
        }
        if (Cocoa.objc_msgSend(value, Cocoa.S_isKindOfClass, Cocoa.C_WebUndefined) != 0) {
            return null;
        }
        SWT.error(5);
        return null;
    }

    int convertToJS(Object value) {
        if (value == null) {
            return Cocoa.objc_msgSend(Cocoa.C_WebUndefined, Cocoa.S_undefined);
        }
        if (value instanceof String) {
            return WebKit.createNSString((String)value);
        }
        if (value instanceof Boolean) {
            int booleanValue = (Boolean)value != false ? 1 : 0;
            return Cocoa.objc_msgSend(Cocoa.C_NSNumber, Cocoa.S_numberWithBool, booleanValue);
        }
        if (value instanceof Number) {
            double doubleValue = ((Number)value).doubleValue();
            return Cocoa.objc_msgSend(Cocoa.C_NSNumber, Cocoa.S_numberWithDouble, doubleValue);
        }
        if (value instanceof Object[]) {
            Object[] arrayValue = (Object[])value;
            int length = arrayValue.length;
            int array = Cocoa.objc_msgSend(Cocoa.C_NSMutableArray, Cocoa.S_arrayWithCapacity, length);
            int i = 0;
            while (i < length) {
                Object currentObject = arrayValue[i];
                int jsObject = this.convertToJS(currentObject);
                Cocoa.objc_msgSend(array, Cocoa.S_addObject, jsObject);
                ++i;
            }
            return array;
        }
        SWT.error(51);
        return 0;
    }

    int callJava(int index, int args, int arg1) {
        int functionIndex;
        Integer key;
        BrowserFunction function;
        Object returnValue = null;
        if (Cocoa.objc_msgSend(index, Cocoa.S_isKindOfClass, Cocoa.C_NSNumber) != 0 && (function = (BrowserFunction)this.functions.get(key = new Integer(functionIndex = Cocoa.objc_msgSend(index, Cocoa.S_intValue)))) != null) {
            try {
                Object temp = this.convertToJava(args);
                if (temp instanceof Object[]) {
                    Object[] arguments = (Object[])temp;
                    try {
                        returnValue = function.function(arguments);
                    }
                    catch (Exception e) {
                        returnValue = WebBrowser.CreateErrorString(e.getLocalizedMessage());
                    }
                }
            }
            catch (IllegalArgumentException e) {
                if (function.isEvaluate) {
                    function.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                }
                returnValue = WebBrowser.CreateErrorString(e.getLocalizedMessage());
            }
        }
        try {
            return this.convertToJS(returnValue);
        }
        catch (SWTException e) {
            return this.convertToJS(WebBrowser.CreateErrorString(e.getLocalizedMessage()));
        }
    }
}

