/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.DOMDocument;
import org.eclipse.swt.internal.cocoa.DOMKeyboardEvent;
import org.eclipse.swt.internal.cocoa.DOMMouseEvent;
import org.eclipse.swt.internal.cocoa.DOMWheelEvent;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSError;
import org.eclipse.swt.internal.cocoa.NSHTTPCookie;
import org.eclipse.swt.internal.cocoa.NSHTTPCookieStorage;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableURLRequest;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintOperation;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSURLAuthenticationChallenge;
import org.eclipse.swt.internal.cocoa.NSURLCredential;
import org.eclipse.swt.internal.cocoa.NSURLDownload;
import org.eclipse.swt.internal.cocoa.NSURLProtectionSpace;
import org.eclipse.swt.internal.cocoa.NSURLRequest;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SFCertificateTrustPanel;
import org.eclipse.swt.internal.cocoa.SWTWebViewDelegate;
import org.eclipse.swt.internal.cocoa.WebDataSource;
import org.eclipse.swt.internal.cocoa.WebDocumentRepresentation;
import org.eclipse.swt.internal.cocoa.WebFrame;
import org.eclipse.swt.internal.cocoa.WebFrameView;
import org.eclipse.swt.internal.cocoa.WebOpenPanelResultListener;
import org.eclipse.swt.internal.cocoa.WebPolicyDecisionListener;
import org.eclipse.swt.internal.cocoa.WebPreferences;
import org.eclipse.swt.internal.cocoa.WebScriptObject;
import org.eclipse.swt.internal.cocoa.WebView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    WebView webView;
    WebPreferences preferences;
    SWTWebViewDelegate delegate;
    boolean loadingText;
    boolean untrustedText;
    String lastHoveredLinkURL;
    String lastNavigateURL;
    String html;
    int identifier;
    int resourceCount;
    String url = "";
    Point location;
    Point size;
    boolean statusBar = true;
    boolean toolBar = true;
    boolean ignoreDispose;
    int lastMouseMoveX;
    int lastMouseMoveY;
    static int delegateClass;
    static boolean Initialized;
    static Callback Callback3;
    static Callback Callback4;
    static Callback Callback5;
    static Callback Callback6;
    static Callback Callback7;
    static final int MIN_SIZE = 16;
    static final int MAX_PROGRESS = 100;
    static final String WebElementLinkURLKey = "WebElementLinkURL";
    static final String AGENT_STRING = "Safari/522.0";
    static final String URI_FILEROOT = "file:///";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String ABOUT_BLANK = "about:blank";
    static final String HEADER_SETCOOKIE = "Set-Cookie";
    static final String POST = "POST";
    static final String USER_AGENT = "user-agent";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String WEBKIT_EVENTS_FIX_KEY = "org.eclipse.swt.internal.webKitEventsFix";
    static final byte[] SWT_OBJECT;
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";

    static {
        byte[] byArray = new byte[11];
        byArray[0] = 83;
        byArray[1] = 87;
        byArray[2] = 84;
        byArray[3] = 95;
        byArray[4] = 79;
        byArray[5] = 66;
        byArray[6] = 74;
        byArray[7] = 69;
        byArray[8] = 67;
        byArray[9] = 84;
        SWT_OBJECT = byArray;
        NativeClearSessions = new Runnable(){

            public void run() {
                NSHTTPCookieStorage storage = NSHTTPCookieStorage.sharedHTTPCookieStorage();
                NSArray cookies = storage.cookies();
                int count = cookies.count();
                int i = 0;
                while (i < count) {
                    NSHTTPCookie cookie = new NSHTTPCookie(cookies.objectAtIndex(i));
                    if (cookie.isSessionOnly()) {
                        storage.deleteCookie(cookie);
                    }
                    ++i;
                }
            }
        };
        NativeGetCookie = new Runnable(){

            public void run() {
                NSURL url;
                NSHTTPCookieStorage storage = NSHTTPCookieStorage.sharedHTTPCookieStorage();
                NSArray cookies = storage.cookiesForURL(url = NSURL.URLWithString(NSString.stringWith(CookieUrl)));
                int count = cookies.count();
                if (count == 0) {
                    return;
                }
                NSString name = NSString.stringWith(CookieName);
                int i = 0;
                while (i < count) {
                    NSHTTPCookie current = new NSHTTPCookie(cookies.objectAtIndex(i));
                    if (current.name().compare(name) == 0) {
                        CookieValue = current.value().getString();
                        return;
                    }
                    ++i;
                }
            }
        };
        NativeSetCookie = new Runnable(){

            public void run() {
                NSURL url = NSURL.URLWithString(NSString.stringWith(CookieUrl));
                NSMutableDictionary headers = NSMutableDictionary.dictionaryWithCapacity(1);
                headers.setValue(NSString.stringWith(CookieValue), NSString.stringWith(WebKit.HEADER_SETCOOKIE));
                NSArray cookies = NSHTTPCookie.cookiesWithResponseHeaderFields(headers, url);
                if (cookies.count() == 0) {
                    return;
                }
                NSHTTPCookieStorage storage = NSHTTPCookieStorage.sharedHTTPCookieStorage();
                NSHTTPCookie cookie = new NSHTTPCookie(cookies.objectAtIndex(0));
                storage.setCookie(cookie);
                CookieResult = true;
            }
        };
        if (NativePendingCookies != null) {
            WebKit.SetPendingCookies(NativePendingCookies);
        }
        NativePendingCookies = null;
    }

    WebKit() {
    }

    public void create(Composite parent, int style) {
        if (delegateClass == 0) {
            int setFrameProc;
            int proc7;
            int proc6;
            int proc5;
            int proc4;
            Class<?> webKitClass = this.getClass();
            Callback3 = new Callback(webKitClass, "browserProc", 3);
            int proc3 = Callback3.getAddress();
            if (proc3 == 0) {
                SWT.error(3);
            }
            if ((proc4 = (Callback4 = new Callback(webKitClass, "browserProc", 4)).getAddress()) == 0) {
                SWT.error(3);
            }
            if ((proc5 = (Callback5 = new Callback(webKitClass, "browserProc", 5)).getAddress()) == 0) {
                SWT.error(3);
            }
            if ((proc6 = (Callback6 = new Callback(webKitClass, "browserProc", 6)).getAddress()) == 0) {
                SWT.error(3);
            }
            if ((proc7 = (Callback7 = new Callback(webKitClass, "browserProc", 7)).getAddress()) == 0) {
                SWT.error(3);
            }
            if ((setFrameProc = OS.CALLBACK_webView_setFrame_(proc4)) == 0) {
                SWT.error(3);
            }
            String className = "SWTWebViewDelegate";
            byte[] byArray = new byte[2];
            byArray[0] = 42;
            byte[] types = byArray;
            int size = C.PTR_SIZEOF;
            int align = C.PTR_SIZEOF == 4 ? 2 : 3;
            delegateClass = OS.objc_allocateClassPair(OS.class_NSObject, className, 0);
            OS.class_addIvar(delegateClass, SWT_OBJECT, size, (byte)align, types);
            OS.class_addMethod(delegateClass, OS.sel_webView_didChangeLocationWithinPageForFrame_, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didFailProvisionalLoadWithError_forFrame_, proc5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didFinishLoadForFrame_, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didReceiveTitle_forFrame_, proc5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didStartProvisionalLoadForFrame_, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_didCommitLoadForFrame_, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_resource_didFinishLoadingFromDataSource_, proc5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_resource_didReceiveAuthenticationChallenge_fromDataSource_, proc6, "@:@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_resource_didFailLoadingWithError_fromDataSource_, proc6, "@:@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_identifierForInitialRequest_fromDataSource_, proc5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_resource_willSendRequest_redirectResponse_fromDataSource_, proc7, "@:@@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_createWebViewWithRequest_, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webViewShow_, proc3, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webViewClose_, proc3, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webView_contextMenuItemsForElement_defaultMenuItems_, proc5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_setStatusBarVisible_, proc4, "@:@B");
            OS.class_addMethod(delegateClass, OS.sel_webView_setResizable_, proc4, "@:@B");
            OS.class_addMethod(delegateClass, OS.sel_webView_setToolbarsVisible_, proc4, "@:@B");
            OS.class_addMethod(delegateClass, OS.sel_webView_setStatusText_, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webViewFocus_, proc3, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webViewUnfocus_, proc3, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame_, proc5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runJavaScriptAlertPanelWithMessage_, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runJavaScriptAlertPanelWithMessage_initiatedByFrame_, proc5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runJavaScriptConfirmPanelWithMessage_, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runJavaScriptConfirmPanelWithMessage_initiatedByFrame_, proc5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_runOpenPanelForFileButtonWithResultListener_, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_mouseDidMoveOverElement_modifierFlags_, proc5, "@:@@I");
            OS.class_addMethod(delegateClass, OS.sel_webView_printFrameView_, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_decidePolicyForMIMEType_request_frame_decisionListener_, proc7, "@:@@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_decidePolicyForNavigationAction_request_frame_decisionListener_, proc7, "@:@@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener_, proc7, "@:@@@@@");
            OS.class_addMethod(delegateClass, OS.sel_webView_unableToImplementPolicyWithError_frame_, proc5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_download_decideDestinationWithSuggestedFilename_, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_handleEvent_, proc3, "@:@");
            OS.class_addMethod(delegateClass, OS.sel_webView_setFrame_, setFrameProc, "@:@{NSRect}");
            OS.class_addMethod(delegateClass, OS.sel_webView_windowScriptObjectAvailable_, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_callJava, proc5, "@:@@@");
            OS.class_addMethod(delegateClass, OS.sel_callRunBeforeUnloadConfirmPanelWithMessage, proc4, "@:@@");
            OS.class_addMethod(delegateClass, OS.sel_createPanelDidEnd, proc5, "@:@@@");
            OS.objc_registerClassPair(delegateClass);
            int metaClass = OS.objc_getMetaClass(className);
            OS.class_addMethod(metaClass, OS.sel_isSelectorExcludedFromWebScript_, proc3, "@:@");
            OS.class_addMethod(metaClass, OS.sel_webScriptNameForSelector_, proc3, "@:@");
        }
        this.browser.setData(WEBKIT_EVENTS_FIX_KEY);
        WebView webView = (WebView)new WebView().alloc();
        if (webView == null) {
            SWT.error(2);
        }
        webView.initWithFrame(this.browser.view.frame(), null, null);
        webView.setAutoresizingMask(18);
        if (webView.respondsToSelector(OS.sel__setDashboardBehavior)) {
            OS.objc_msgSend(webView.id, OS.sel__setDashboardBehavior, 2, 1);
        }
        final SWTWebViewDelegate delegate = (SWTWebViewDelegate)new SWTWebViewDelegate().alloc().init();
        Display display = this.browser.getDisplay();
        display.setData(ADD_WIDGET_KEY, new Object[]{delegate, this.browser});
        this.delegate = delegate;
        this.webView = webView;
        this.browser.view.addSubview(webView);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 15: {
                        WebKit.this.webView.window().makeFirstResponder(WebKit.this.webView);
                        break;
                    }
                    case 12: {
                        if (WebKit.this.ignoreDispose) {
                            WebKit.this.ignoreDispose = false;
                            break;
                        }
                        WebKit.this.ignoreDispose = true;
                        WebKit.this.browser.notifyListeners(e.type, e);
                        e.type = 0;
                        if (!WebKit.this.browser.isDisposed()) {
                            if (!WebKit.this.browser.isClosing) {
                                WebKit.this.close(false);
                            }
                            Object[] objectArray = new Object[2];
                            objectArray[0] = delegate;
                            e.display.setData(WebKit.ADD_WIDGET_KEY, objectArray);
                        }
                        WebKit.this.webView.setFrameLoadDelegate(null);
                        WebKit.this.webView.setResourceLoadDelegate(null);
                        WebKit.this.webView.setUIDelegate(null);
                        WebKit.this.webView.setPolicyDelegate(null);
                        WebKit.this.webView.setDownloadDelegate(null);
                        WebKit.this.webView.release();
                        WebKit.this.webView = null;
                        WebKit.this.delegate.release();
                        WebKit.this.delegate = null;
                        WebKit.this.html = null;
                        WebKit.this.lastNavigateURL = null;
                        WebKit.this.lastHoveredLinkURL = null;
                        Enumeration elements = WebKit.this.functions.elements();
                        while (elements.hasMoreElements()) {
                            ((BrowserFunction)elements.nextElement()).dispose(false);
                        }
                        WebKit.this.functions = null;
                        if (WebKit.this.preferences != null) {
                            WebKit.this.preferences.release();
                        }
                        WebKit.this.preferences = null;
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(15, listener);
        webView.setFrameLoadDelegate(delegate);
        webView.setResourceLoadDelegate(delegate);
        webView.setUIDelegate(delegate);
        webView.setPolicyDelegate(delegate);
        webView.setDownloadDelegate(delegate);
        webView.setApplicationNameForUserAgent(NSString.stringWith(AGENT_STRING));
        if (!Initialized) {
            Initialized = true;
            WebPreferences.standardPreferences().setJavaEnabled(false);
        }
    }

    public boolean back() {
        this.html = null;
        return this.webView.goBack();
    }

    static int browserProc(int id2, int sel, int arg0) {
        Display d;
        if (id2 == delegateClass) {
            if (sel == OS.sel_isSelectorExcludedFromWebScript_) {
                return WebKit.isSelectorExcludedFromWebScript(arg0) ? 1 : 0;
            }
            if (sel == OS.sel_webScriptNameForSelector_) {
                return WebKit.webScriptNameForSelector(arg0);
            }
        }
        if ((d = Display.getCurrent()) == null || d.isDisposed()) {
            return 0;
        }
        Widget widget = d.findWidget(id2);
        if (widget == null) {
            return 0;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (sel == OS.sel_webViewShow_) {
            webKit.webViewShow(arg0);
        } else if (sel == OS.sel_webViewClose_) {
            webKit.webViewClose(arg0);
        } else if (sel == OS.sel_webViewFocus_) {
            webKit.webViewFocus(arg0);
        } else if (sel == OS.sel_webViewUnfocus_) {
            webKit.webViewUnfocus(arg0);
        } else if (sel == OS.sel_handleEvent_) {
            webKit.handleEvent(arg0);
        }
        return 0;
    }

    static int browserProc(int id2, int sel, int arg0, int arg1) {
        Display d = Display.getCurrent();
        if (d == null || d.isDisposed()) {
            return 0;
        }
        Widget widget = d.findWidget(id2);
        if (widget == null) {
            return 0;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (sel == OS.sel_webView_didChangeLocationWithinPageForFrame_) {
            webKit.webView_didChangeLocationWithinPageForFrame(arg0, arg1);
        } else if (sel == OS.sel_webView_didFinishLoadForFrame_) {
            webKit.webView_didFinishLoadForFrame(arg0, arg1);
        } else if (sel == OS.sel_webView_didStartProvisionalLoadForFrame_) {
            webKit.webView_didStartProvisionalLoadForFrame(arg0, arg1);
        } else if (sel == OS.sel_webView_didCommitLoadForFrame_) {
            webKit.webView_didCommitLoadForFrame(arg0, arg1);
        } else if (sel == OS.sel_webView_setFrame_) {
            webKit.webView_setFrame(arg0, arg1);
        } else {
            if (sel == OS.sel_webView_createWebViewWithRequest_) {
                return webKit.webView_createWebViewWithRequest(arg0, arg1);
            }
            if (sel == OS.sel_webView_setStatusBarVisible_) {
                webKit.webView_setStatusBarVisible(arg0, arg1 != 0);
            } else if (sel == OS.sel_webView_setResizable_) {
                webKit.webView_setResizable(arg0, arg1 != 0);
            } else if (sel == OS.sel_webView_setStatusText_) {
                webKit.webView_setStatusText(arg0, arg1);
            } else if (sel == OS.sel_webView_setToolbarsVisible_) {
                webKit.webView_setToolbarsVisible(arg0, arg1 != 0);
            } else if (sel == OS.sel_webView_runJavaScriptAlertPanelWithMessage_) {
                webKit.webView_runJavaScriptAlertPanelWithMessage(arg0, arg1);
            } else {
                if (sel == OS.sel_webView_runJavaScriptConfirmPanelWithMessage_) {
                    return webKit.webView_runJavaScriptConfirmPanelWithMessage(arg0, arg1);
                }
                if (sel == OS.sel_webView_runOpenPanelForFileButtonWithResultListener_) {
                    webKit.webView_runOpenPanelForFileButtonWithResultListener(arg0, arg1);
                } else if (sel == OS.sel_download_decideDestinationWithSuggestedFilename_) {
                    webKit.download_decideDestinationWithSuggestedFilename(arg0, arg1);
                } else if (sel == OS.sel_webView_printFrameView_) {
                    webKit.webView_printFrameView(arg0, arg1);
                } else if (sel == OS.sel_webView_windowScriptObjectAvailable_) {
                    webKit.webView_windowScriptObjectAvailable(arg0, arg1);
                } else if (sel == OS.sel_callRunBeforeUnloadConfirmPanelWithMessage) {
                    return webKit.callRunBeforeUnloadConfirmPanelWithMessage((int)arg0, (int)arg1).id;
                }
            }
        }
        return 0;
    }

    static int browserProc(int id2, int sel, int arg0, int arg1, int arg2) {
        Display d = Display.getCurrent();
        if (d == null || d.isDisposed()) {
            return 0;
        }
        Widget widget = d.findWidget(id2);
        if (widget == null) {
            return 0;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (sel == OS.sel_webView_didFailProvisionalLoadWithError_forFrame_) {
            webKit.webView_didFailProvisionalLoadWithError_forFrame(arg0, arg1, arg2);
        } else if (sel == OS.sel_webView_didReceiveTitle_forFrame_) {
            webKit.webView_didReceiveTitle_forFrame(arg0, arg1, arg2);
        } else if (sel == OS.sel_webView_resource_didFinishLoadingFromDataSource_) {
            webKit.webView_resource_didFinishLoadingFromDataSource(arg0, arg1, arg2);
        } else {
            if (sel == OS.sel_webView_identifierForInitialRequest_fromDataSource_) {
                return webKit.webView_identifierForInitialRequest_fromDataSource(arg0, arg1, arg2);
            }
            if (sel == OS.sel_webView_contextMenuItemsForElement_defaultMenuItems_) {
                return webKit.webView_contextMenuItemsForElement_defaultMenuItems(arg0, arg1, arg2);
            }
            if (sel == OS.sel_webView_mouseDidMoveOverElement_modifierFlags_) {
                webKit.webView_mouseDidMoveOverElement_modifierFlags(arg0, arg1, arg2);
            } else if (sel == OS.sel_webView_unableToImplementPolicyWithError_frame_) {
                webKit.webView_unableToImplementPolicyWithError_frame(arg0, arg1, arg2);
            } else {
                if (sel == OS.sel_webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame_) {
                    return webKit.webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame(arg0, arg1, arg2) ? 1 : 0;
                }
                if (sel == OS.sel_webView_runJavaScriptAlertPanelWithMessage_initiatedByFrame_) {
                    webKit.webView_runJavaScriptAlertPanelWithMessage(arg0, arg1);
                } else {
                    if (sel == OS.sel_webView_runJavaScriptConfirmPanelWithMessage_initiatedByFrame_) {
                        return webKit.webView_runJavaScriptConfirmPanelWithMessage(arg0, arg1);
                    }
                    if (sel == OS.sel_callJava) {
                        NSObject result = webKit.callJava(arg0, arg1, arg2);
                        return result == null ? 0 : result.id;
                    }
                    if (sel == OS.sel_createPanelDidEnd) {
                        webKit.createPanelDidEnd(arg0, arg1, arg2);
                    }
                }
            }
        }
        return 0;
    }

    static int browserProc(int id2, int sel, int arg0, int arg1, int arg2, int arg3) {
        Display d = Display.getCurrent();
        if (d == null || d.isDisposed()) {
            return 0;
        }
        Widget widget = d.findWidget(id2);
        if (widget == null) {
            return 0;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (sel == OS.sel_webView_resource_didFailLoadingWithError_fromDataSource_) {
            webKit.webView_resource_didFailLoadingWithError_fromDataSource(arg0, arg1, arg2, arg3);
        } else if (sel == OS.sel_webView_resource_didReceiveAuthenticationChallenge_fromDataSource_) {
            webKit.webView_resource_didReceiveAuthenticationChallenge_fromDataSource(arg0, arg1, arg2, arg3);
        }
        return 0;
    }

    static int browserProc(int id2, int sel, int arg0, int arg1, int arg2, int arg3, int arg4) {
        Display d = Display.getCurrent();
        if (d == null || d.isDisposed()) {
            return 0;
        }
        Widget widget = d.findWidget(id2);
        if (widget == null) {
            return 0;
        }
        WebKit webKit = (WebKit)((Browser)widget).webBrowser;
        if (sel == OS.sel_webView_resource_willSendRequest_redirectResponse_fromDataSource_) {
            return webKit.webView_resource_willSendRequest_redirectResponse_fromDataSource(arg0, arg1, arg2, arg3, arg4);
        }
        if (sel == OS.sel_webView_decidePolicyForMIMEType_request_frame_decisionListener_) {
            webKit.webView_decidePolicyForMIMEType_request_frame_decisionListener(arg0, arg1, arg2, arg3, arg4);
        } else if (sel == OS.sel_webView_decidePolicyForNavigationAction_request_frame_decisionListener_) {
            webKit.webView_decidePolicyForNavigationAction_request_frame_decisionListener(arg0, arg1, arg2, arg3, arg4);
        } else if (sel == OS.sel_webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener_) {
            webKit.webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener(arg0, arg1, arg2, arg3, arg4);
        }
        return 0;
    }

    static boolean isSelectorExcludedFromWebScript(int aSelector) {
        return aSelector != OS.sel_callJava && aSelector != OS.sel_callRunBeforeUnloadConfirmPanelWithMessage;
    }

    static int webScriptNameForSelector(int aSelector) {
        if (aSelector == OS.sel_callJava) {
            return NSString.stringWith((String)"callJava").id;
        }
        if (aSelector == OS.sel_callRunBeforeUnloadConfirmPanelWithMessage) {
            return NSString.stringWith((String)"callRunBeforeUnloadConfirmPanelWithMessage").id;
        }
        return 0;
    }

    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean showPrompters) {
        if (!this.jsEnabled) {
            return true;
        }
        String functionName = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuffer buffer = new StringBuffer("function ");
        buffer.append(functionName);
        buffer.append("(win) {\n");
        buffer.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (showPrompters) {
            buffer.append("if (str != null) { ");
            buffer.append("var result = window.external.callRunBeforeUnloadConfirmPanelWithMessage(str);");
            buffer.append("if (!result) return false;}");
        }
        buffer.append("} catch (e) {}}");
        buffer.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        buffer.append(functionName);
        buffer.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        buffer.append("\n};");
        this.execute(buffer.toString());
        Boolean result = (Boolean)this.evaluate("return " + functionName + "(window);");
        if (result == null) {
            return false;
        }
        return result;
    }

    public boolean execute(String script) {
        WebFrame frame = this.webView.mainFrame();
        int context = frame.globalContext();
        byte[] bytes = null;
        try {
            bytes = (String.valueOf(script) + '\u0000').getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = (String.valueOf(script) + '\u0000').getBytes();
        }
        int scriptString = OS.JSStringCreateWithUTF8CString(bytes);
        try {
            bytes = (String.valueOf(this.getUrl()) + '\u0000').getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = (String.valueOf(this.getUrl()) + '\u0000').getBytes();
        }
        int urlString = OS.JSStringCreateWithUTF8CString(bytes);
        int result = OS.JSEvaluateScript(context, scriptString, 0, urlString, 0, null);
        OS.JSStringRelease(urlString);
        OS.JSStringRelease(scriptString);
        return result != 0;
    }

    public boolean forward() {
        this.html = null;
        return this.webView.goForward();
    }

    public String getBrowserType() {
        return "webkit";
    }

    public String getText() {
        WebFrame mainFrame = this.webView.mainFrame();
        WebDataSource dataSource = mainFrame.dataSource();
        if (dataSource == null) {
            return "";
        }
        WebDocumentRepresentation representation = dataSource.representation();
        if (representation == null) {
            return "";
        }
        NSString source = representation.documentSource();
        if (source == null) {
            return "";
        }
        return source.getString();
    }

    public String getUrl() {
        if (this.url.length() == 0) {
            return ABOUT_BLANK;
        }
        return this.url;
    }

    public boolean isBackEnabled() {
        return this.webView.canGoBack();
    }

    public boolean isForwardEnabled() {
        return this.webView.canGoForward();
    }

    public void refresh() {
        this.html = null;
        this.webView.reload(null);
    }

    public boolean setText(String html, boolean trusted) {
        boolean blankLoading = this.html != null;
        this.html = html;
        boolean bl = this.untrustedText = !trusted;
        if (blankLoading) {
            return true;
        }
        NSURL inURL = NSURL.URLWithString(NSString.stringWith(ABOUT_BLANK));
        NSURLRequest request = NSURLRequest.requestWithURL(inURL);
        WebFrame mainFrame = this.webView.mainFrame();
        mainFrame.loadRequest(request);
        return true;
    }

    public boolean setUrl(String url, String postData, String[] headers) {
        this.html = null;
        this.lastNavigateURL = url;
        if (url.indexOf(47) == 0) {
            url = PROTOCOL_FILE + url;
        } else if (url.indexOf(58) == -1) {
            url = PROTOCOL_HTTP + url;
        }
        NSString str = NSString.stringWith(url);
        NSString unescapedStr = NSString.stringWith("%#");
        int ptr = OS.CFURLCreateStringByAddingPercentEscapes(0, str.id, unescapedStr.id, 0, 0x8000100);
        NSString escapedString = new NSString(ptr);
        NSURL inURL = NSURL.URLWithString(escapedString);
        OS.CFRelease(ptr);
        NSMutableURLRequest request = (NSMutableURLRequest)NSMutableURLRequest.requestWithURL(inURL);
        if (postData != null) {
            request.setHTTPMethod(NSString.stringWith(POST));
            byte[] bytes = postData.getBytes();
            NSData data = NSData.dataWithBytes(bytes, bytes.length);
            request.setHTTPBody(data);
        }
        if (headers != null) {
            int i = 0;
            while (i < headers.length) {
                int index;
                String current = headers[i];
                if (current != null && (index = current.indexOf(58)) != -1) {
                    String key = current.substring(0, index).trim();
                    String value = current.substring(index + 1).trim();
                    if (key.length() > 0 && value.length() > 0) {
                        if (key.equalsIgnoreCase(USER_AGENT)) {
                            this.webView.setCustomUserAgent(NSString.stringWith(value));
                        } else {
                            request.setValue(NSString.stringWith(value), NSString.stringWith(key));
                        }
                    }
                }
                ++i;
            }
        }
        WebFrame mainFrame = this.webView.mainFrame();
        mainFrame.loadRequest(request);
        this.webView.setCustomUserAgent(null);
        return true;
    }

    public void stop() {
        this.html = null;
        this.webView.stopLoading(null);
    }

    boolean translateMnemonics() {
        return false;
    }

    void webView_didChangeLocationWithinPageForFrame(int sender, int frameID) {
        int i;
        boolean top;
        WebFrame frame = new WebFrame(frameID);
        WebDataSource dataSource = frame.dataSource();
        NSMutableURLRequest request = dataSource.request();
        NSURL url = request.URL();
        NSString s = url.absoluteString();
        int length = s.length();
        if (length == 0) {
            return;
        }
        String url2 = s.getString();
        if (url2.equals(URI_FILEROOT)) {
            url2 = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url2.startsWith(URI_FILEROOT) && url2.charAt(length) == '#') {
                url2 = ABOUT_BLANK + url2.substring(length);
            }
        }
        Display display = this.browser.getDisplay();
        boolean bl = top = frameID == this.webView.mainFrame().id;
        if (top) {
            StatusTextEvent statusText = new StatusTextEvent(this.browser);
            statusText.display = display;
            statusText.widget = this.browser;
            statusText.text = url2;
            i = 0;
            while (i < this.statusTextListeners.length) {
                this.statusTextListeners[i].changed(statusText);
                ++i;
            }
        }
        LocationEvent location = new LocationEvent(this.browser);
        location.display = display;
        location.widget = this.browser;
        location.location = url2;
        location.top = top;
        i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changed(location);
            ++i;
        }
    }

    void webView_didFailProvisionalLoadWithError_forFrame(int sender, int error, int frame) {
        NSString description;
        id id2;
        NSError nserror;
        int errorCode;
        if (frame == this.webView.mainFrame().id) {
            this.identifier = 0;
        }
        if (-1000 < (errorCode = (nserror = new NSError(error)).code())) {
            return;
        }
        NSURL failingURL = null;
        NSDictionary info = nserror.userInfo();
        if (info != null && (id2 = info.valueForKey(NSString.stringWith("NSErrorFailingURLKey"))) != null) {
            failingURL = new NSURL(id2);
        }
        if (failingURL != null && -1204 <= errorCode && errorCode <= -1200) {
            id certificates = info.objectForKey(NSString.stringWith("NSErrorPeerCertificateChainKey"));
            int[] policySearch = new int[1];
            int[] policyRef = new int[1];
            int[] trustRef = new int[1];
            boolean success = false;
            int result = OS.SecPolicySearchCreate(3, 0, 0, policySearch);
            if (result == 0 && policySearch[0] != 0 && (result = OS.SecPolicySearchCopyNext(policySearch[0], policyRef)) == 0 && policyRef[0] != 0 && (result = OS.SecTrustCreateWithCertificates(certificates.id, policyRef[0], trustRef)) == 0 && trustRef[0] != 0) {
                SFCertificateTrustPanel panel = SFCertificateTrustPanel.sharedCertificateTrustPanel();
                String failingUrlString = failingURL.absoluteString().getString();
                String message = Compatibility.getMessage("SWT_InvalidCert_Message", new Object[]{failingUrlString});
                panel.setAlternateButtonTitle(NSString.stringWith(Compatibility.getMessage("SWT_Cancel")));
                panel.setShowsHelp(true);
                failingURL.retain();
                NSWindow window = this.browser.getShell().view.window();
                panel.beginSheetForWindow(window, this.delegate, OS.sel_createPanelDidEnd, failingURL.id, trustRef[0], NSString.stringWith(message));
                success = true;
            }
            if (trustRef[0] != 0) {
                OS.CFRelease(trustRef[0]);
            }
            if (policyRef[0] != 0) {
                OS.CFRelease(policyRef[0]);
            }
            if (policySearch[0] != 0) {
                OS.CFRelease(policySearch[0]);
            }
            if (success) {
                return;
            }
        }
        if ((description = nserror.localizedDescription()) != null) {
            String descriptionString = description.getString();
            String message = failingURL != null ? String.valueOf(failingURL.absoluteString().getString()) + "\n\n" : "";
            message = String.valueOf(message) + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{descriptionString});
            MessageBox messageBox = new MessageBox(this.browser.getShell(), 33);
            messageBox.setMessage(message);
            messageBox.open();
        }
    }

    void createPanelDidEnd(int sheet, int returnCode, int contextInfo) {
        NSURL failingURL = new NSURL(contextInfo);
        failingURL.autorelease();
        if (returnCode != 1) {
            return;
        }
        int method = OS.class_getClassMethod(OS.class_NSURLRequest, OS.sel_setAllowsAnyHTTPSCertificate);
        if (method != 0) {
            OS.objc_msgSend(OS.class_NSURLRequest, OS.sel_setAllowsAnyHTTPSCertificate, 1, failingURL.host().id);
            this.setUrl(failingURL.absoluteString().getString(), null, null);
        }
    }

    void webView_didFinishLoadForFrame(int sender, int frameID) {
        if (frameID == this.webView.mainFrame().id) {
            if (this.html != null && this.getUrl().startsWith(ABOUT_BLANK)) {
                this.loadingText = true;
                NSString string = NSString.stringWith(this.html);
                NSString URLString = this.untrustedText ? NSString.stringWith(ABOUT_BLANK) : NSString.stringWith(URI_FILEROOT);
                NSURL URL2 = NSURL.URLWithString(URLString);
                WebFrame mainFrame = this.webView.mainFrame();
                mainFrame.loadHTMLString(string, URL2);
                this.html = null;
            }
            if (!this.loadingText) {
                NSString title;
                Display display = this.browser.getDisplay();
                WebFrame frame = new WebFrame(frameID);
                WebDataSource dataSource = frame.dataSource();
                if (dataSource != null && (title = dataSource.pageTitle()) == null) {
                    TitleEvent newEvent = new TitleEvent(this.browser);
                    newEvent.display = display;
                    newEvent.widget = this.browser;
                    newEvent.title = this.getUrl();
                    int i = 0;
                    while (i < this.titleListeners.length) {
                        this.titleListeners[i].changed(newEvent);
                        ++i;
                    }
                    if (this.browser.isDisposed()) {
                        return;
                    }
                }
                ProgressEvent progress = new ProgressEvent(this.browser);
                progress.display = display;
                progress.widget = this.browser;
                progress.current = 100;
                progress.total = 100;
                int i = 0;
                while (i < this.progressListeners.length) {
                    this.progressListeners[i].completed(progress);
                    ++i;
                }
            }
            this.loadingText = false;
            if (this.browser.isDisposed()) {
                return;
            }
            this.identifier = 0;
        }
    }

    void hookDOMKeyListeners(int frameID) {
        WebFrame frame = new WebFrame(frameID);
        DOMDocument document = frame.DOMDocument();
        if (document == null) {
            return;
        }
        NSString type = NSString.stringWith(DOMEVENT_KEYDOWN);
        document.addEventListener(type, this.delegate, false);
        type = NSString.stringWith(DOMEVENT_KEYUP);
        document.addEventListener(type, this.delegate, false);
    }

    void hookDOMMouseListeners(int frameID) {
        WebFrame frame = new WebFrame(frameID);
        DOMDocument document = frame.DOMDocument();
        if (document == null) {
            return;
        }
        NSString type = NSString.stringWith(DOMEVENT_MOUSEDOWN);
        document.addEventListener(type, this.delegate, false);
        type = NSString.stringWith(DOMEVENT_MOUSEUP);
        document.addEventListener(type, this.delegate, false);
        type = NSString.stringWith(DOMEVENT_MOUSEMOVE);
        document.addEventListener(type, this.delegate, false);
        type = NSString.stringWith(DOMEVENT_MOUSEWHEEL);
        document.addEventListener(type, this.delegate, false);
    }

    void webView_didReceiveTitle_forFrame(int sender, int titleID, int frameID) {
        if (frameID == this.webView.mainFrame().id) {
            NSString title = new NSString(titleID);
            String newTitle = title.getString();
            TitleEvent newEvent = new TitleEvent(this.browser);
            newEvent.display = this.browser.getDisplay();
            newEvent.widget = this.browser;
            newEvent.title = newTitle;
            int i = 0;
            while (i < this.titleListeners.length) {
                this.titleListeners[i].changed(newEvent);
                ++i;
            }
        }
    }

    void webView_didStartProvisionalLoadForFrame(int sender, int frameID) {
    }

    void webView_didCommitLoadForFrame(int sender, int frameID) {
        boolean top;
        WebFrame frame = new WebFrame(frameID);
        WebDataSource dataSource = frame.dataSource();
        NSMutableURLRequest request = dataSource.request();
        NSURL url = request.URL();
        NSString s = url.absoluteString();
        int length = s.length();
        if (length == 0) {
            return;
        }
        String url2 = s.getString();
        if (url2.equals(URI_FILEROOT)) {
            url2 = ABOUT_BLANK;
        } else {
            length = URI_FILEROOT.length();
            if (url2.startsWith(URI_FILEROOT) && url2.charAt(length) == '#') {
                url2 = ABOUT_BLANK + url2.substring(length);
            }
        }
        Display display = this.browser.getDisplay();
        boolean bl = top = frameID == this.webView.mainFrame().id;
        if (top) {
            this.resourceCount = 0;
            this.url = url2;
            if (url2.startsWith(ABOUT_BLANK) && this.html != null) {
                return;
            }
            Enumeration elements = this.functions.elements();
            while (elements.hasMoreElements()) {
                BrowserFunction function = (BrowserFunction)elements.nextElement();
                this.execute(function.functionString);
            }
            ProgressEvent progress = new ProgressEvent(this.browser);
            progress.display = display;
            progress.widget = this.browser;
            progress.current = 1;
            progress.total = 100;
            int i = 0;
            while (i < this.progressListeners.length) {
                this.progressListeners[i].changed(progress);
                ++i;
            }
            if (this.browser.isDisposed()) {
                return;
            }
            StatusTextEvent statusText = new StatusTextEvent(this.browser);
            statusText.display = display;
            statusText.widget = this.browser;
            statusText.text = url2;
            int i2 = 0;
            while (i2 < this.statusTextListeners.length) {
                this.statusTextListeners[i2].changed(statusText);
                ++i2;
            }
            if (this.browser.isDisposed()) {
                return;
            }
            this.hookDOMKeyListeners(frameID);
        }
        this.hookDOMMouseListeners(frameID);
        LocationEvent location = new LocationEvent(this.browser);
        location.display = display;
        location.widget = this.browser;
        location.location = url2;
        location.top = top;
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changed(location);
            ++i;
        }
    }

    void webView_windowScriptObjectAvailable(int webView, int windowScriptObject) {
        NSObject scriptObject = new NSObject(windowScriptObject);
        NSString key = NSString.stringWith("external");
        scriptObject.setValue(this.delegate, key);
    }

    void webView_resource_didFinishLoadingFromDataSource(int sender, int identifier, int dataSource) {
    }

    void webView_resource_didFailLoadingWithError_fromDataSource(int sender, int identifier, int error, int dataSource) {
    }

    void webView_resource_didReceiveAuthenticationChallenge_fromDataSource(int sender, int identifier, int challenge, int dataSource) {
        String realm;
        NSURLProtectionSpace space;
        String host;
        boolean result;
        int handler;
        int method;
        int cls;
        NSURLAuthenticationChallenge nsChallenge = new NSURLAuthenticationChallenge(challenge);
        if (nsChallenge.previousFailureCount() < 3) {
            int i = 0;
            while (i < this.authenticationListeners.length) {
                AuthenticationEvent event = new AuthenticationEvent(this.browser);
                event.location = this.lastNavigateURL;
                this.authenticationListeners[i].authenticate(event);
                if (!event.doit) {
                    id challengeSender = nsChallenge.sender();
                    OS.objc_msgSend(challengeSender.id, OS.sel_cancelAuthenticationChallenge_, challenge);
                    return;
                }
                if (event.user != null && event.password != null) {
                    id challengeSender = nsChallenge.sender();
                    NSString user = NSString.stringWith(event.user);
                    NSString password = NSString.stringWith(event.password);
                    NSURLCredential credential = NSURLCredential.credentialWithUser(user, password, 1);
                    OS.objc_msgSend(challengeSender.id, OS.sel_useCredential_forAuthenticationChallenge_, credential.id, challenge);
                    return;
                }
                ++i;
            }
        }
        if ((cls = OS.class_WebPanelAuthenticationHandler) != 0 && (method = OS.class_getClassMethod(cls, OS.sel_sharedHandler)) != 0 && (handler = OS.objc_msgSend(cls, OS.sel_sharedHandler)) != 0) {
            OS.objc_msgSend(handler, OS.sel_startAuthentication, challenge, this.webView.window().id);
            return;
        }
        String[] userReturn = new String[1];
        String[] passwordReturn = new String[1];
        NSURLCredential proposedCredential = nsChallenge.proposedCredential();
        if (proposedCredential != null) {
            userReturn[0] = proposedCredential.user().getString();
            if (proposedCredential.hasPassword()) {
                passwordReturn[0] = proposedCredential.password().getString();
            }
        }
        if (!(result = this.showAuthenticationDialog(userReturn, passwordReturn, host = String.valueOf((space = nsChallenge.protectionSpace()).host().getString()) + ':' + space.port(), realm = space.realm().getString()))) {
            id challengeSender = nsChallenge.sender();
            OS.objc_msgSend(challengeSender.id, OS.sel_cancelAuthenticationChallenge_, challenge);
            return;
        }
        id challengeSender = nsChallenge.sender();
        NSString user = NSString.stringWith(userReturn[0]);
        NSString password = NSString.stringWith(passwordReturn[0]);
        NSURLCredential credential = NSURLCredential.credentialWithUser(user, password, 1);
        OS.objc_msgSend(challengeSender.id, OS.sel_useCredential_forAuthenticationChallenge_, credential.id, challenge);
    }

    boolean showAuthenticationDialog(final String[] user, final String[] password, String host, String realm) {
        final Shell shell = new Shell(this.browser.getShell());
        shell.setLayout(new GridLayout());
        String title = SWT.getMessage("SWT_Authentication_Required");
        shell.setText(title);
        Label label = new Label(shell, 64);
        label.setText(Compatibility.getMessage("SWT_Enter_Username_and_Password", new String[]{realm, host}));
        GridData data = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int maxWidth = monitor.getBounds().width * 2 / 3;
        int width = label.computeSize((int)-1, (int)-1).x;
        data.widthHint = Math.min(width, maxWidth);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        label.setLayoutData(data);
        Label userLabel = new Label(shell, 0);
        userLabel.setText(SWT.getMessage("SWT_Username"));
        final Text userText = new Text(shell, 2048);
        if (user[0] != null) {
            userText.setText(user[0]);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        userText.setLayoutData(data);
        Label passwordLabel = new Label(shell, 0);
        passwordLabel.setText(SWT.getMessage("SWT_Password"));
        final Text passwordText = new Text(shell, 0x400800);
        if (password[0] != null) {
            passwordText.setText(password[0]);
        }
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        passwordText.setLayoutData(data);
        final boolean[] result = new boolean[1];
        final Button[] buttons = new Button[2];
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                user[0] = userText.getText();
                password[0] = passwordText.getText();
                result[0] = event.widget == buttons[1];
                shell.close();
            }
        };
        Composite composite = new Composite(shell, 0);
        data = new GridData();
        data.horizontalAlignment = 3;
        composite.setLayoutData(data);
        composite.setLayout(new GridLayout(2, true));
        buttons[0] = new Button(composite, 8);
        buttons[0].setText(SWT.getMessage("SWT_Cancel"));
        buttons[0].setLayoutData(new GridData(768));
        buttons[0].addListener(13, listener);
        buttons[1] = new Button(composite, 8);
        buttons[1].setText(SWT.getMessage("SWT_OK"));
        buttons[1].setLayoutData(new GridData(768));
        buttons[1].addListener(13, listener);
        shell.setDefaultButton(buttons[1]);
        shell.pack();
        shell.open();
        Display display = this.browser.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return result[0];
    }

    int webView_identifierForInitialRequest_fromDataSource(int sender, int request, int dataSourceID) {
        ProgressEvent progress = new ProgressEvent(this.browser);
        progress.display = this.browser.getDisplay();
        progress.widget = this.browser;
        progress.current = this.resourceCount;
        progress.total = Math.max(this.resourceCount, 100);
        int i = 0;
        while (i < this.progressListeners.length) {
            this.progressListeners[i].changed(progress);
            ++i;
        }
        if (this.browser.isDisposed()) {
            return 0;
        }
        NSNumber identifier = NSNumber.numberWithInt(this.resourceCount++);
        if (this.identifier == 0) {
            WebDataSource dataSource = new WebDataSource(dataSourceID);
            WebFrame frame = dataSource.webFrame();
            if (frame.id == this.webView.mainFrame().id) {
                this.identifier = identifier.id;
            }
        }
        return identifier.id;
    }

    int webView_resource_willSendRequest_redirectResponse_fromDataSource(int sender, int identifier, int request, int redirectResponse, int dataSource) {
        NSURLRequest nsRequest = new NSURLRequest(request);
        NSURL url = nsRequest.URL();
        if (url.isFileURL()) {
            NSMutableURLRequest newRequest = new NSMutableURLRequest(nsRequest.mutableCopy());
            newRequest.autorelease();
            newRequest.setCachePolicy(1);
            return newRequest.id;
        }
        return request;
    }

    int webView_createWebViewWithRequest(int sender, int request) {
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.required = true;
        if (this.openWindowListeners != null) {
            int i = 0;
            while (i < this.openWindowListeners.length) {
                this.openWindowListeners[i].open(newEvent);
                ++i;
            }
        }
        WebView result = null;
        Widget browser = null;
        if (newEvent.browser != null && newEvent.browser.webBrowser instanceof WebKit) {
            browser = newEvent.browser;
        }
        if (browser != null && !browser.isDisposed()) {
            result = ((WebKit)((Browser)browser).webBrowser).webView;
            if (request != 0) {
                WebFrame mainFrame = result.mainFrame();
                mainFrame.loadRequest(new NSURLRequest(request));
            }
        }
        return result != null ? result.id : 0;
    }

    void webViewShow(int sender) {
        Shell parent = this.browser.getShell();
        Point pt = parent.getSize();
        parent.setSize(pt.x + 1, pt.y);
        parent.setSize(pt.x, pt.y);
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        if (this.location != null) {
            newEvent.location = this.location;
        }
        if (this.size != null) {
            newEvent.size = this.size;
        }
        newEvent.addressBar = this.toolBar;
        newEvent.menuBar = true;
        newEvent.statusBar = this.statusBar;
        newEvent.toolBar = this.toolBar;
        int i = 0;
        while (i < this.visibilityWindowListeners.length) {
            this.visibilityWindowListeners[i].show(newEvent);
            ++i;
        }
        this.location = null;
        this.size = null;
    }

    void webView_setFrame(int sender, int frame) {
        NSRect rect = new NSRect();
        OS.memmove(rect, frame, NSRect.sizeof);
        Rectangle bounds = this.browser.getDisplay().getBounds();
        this.location = new Point((int)rect.x, bounds.height - (int)rect.y - (int)rect.height);
        this.size = new Point((int)rect.width, (int)rect.height);
    }

    void webViewFocus(int sender) {
    }

    void webViewUnfocus(int sender) {
    }

    NSNumber callRunBeforeUnloadConfirmPanelWithMessage(int messageID, int arg) {
        boolean result = this.webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame(0, messageID, 0);
        return NSNumber.numberWithBool(result);
    }

    boolean webView_runBeforeUnloadConfirmPanelWithMessage_initiatedByFrame(int sender, int messageID, int frame) {
        NSString message = new NSString(messageID);
        StringBuffer text = new StringBuffer(Compatibility.getMessage("SWT_OnBeforeUnload_Message1"));
        text.append("\n\n");
        text.append(message.getString());
        text.append("\n\n");
        text.append(Compatibility.getMessage("SWT_OnBeforeUnload_Message2"));
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 268435748);
        messageBox.setMessage(text.toString());
        return messageBox.open() == 32;
    }

    void webView_runJavaScriptAlertPanelWithMessage(int sender, int messageID) {
        NSString message = new NSString(messageID);
        String text = message.getString();
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 40);
        messageBox.setText("Javascript");
        messageBox.setMessage(text);
        messageBox.open();
    }

    int webView_runJavaScriptConfirmPanelWithMessage(int sender, int messageID) {
        NSString message = new NSString(messageID);
        String text = message.getString();
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 292);
        messageBox.setText("Javascript");
        messageBox.setMessage(text);
        return messageBox.open() == 32 ? 1 : 0;
    }

    void webView_runOpenPanelForFileButtonWithResultListener(int sender, int resultListenerID) {
        FileDialog dialog = new FileDialog(this.browser.getShell(), 0);
        String result = dialog.open();
        WebOpenPanelResultListener resultListener = new WebOpenPanelResultListener(resultListenerID);
        if (result == null) {
            resultListener.cancel();
            return;
        }
        resultListener.chooseFilename(NSString.stringWith(result));
    }

    void webViewClose(int sender) {
        Shell parent = this.browser.getShell();
        WindowEvent newEvent = new WindowEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            this.closeWindowListeners[i].close(newEvent);
            ++i;
        }
        this.browser.dispose();
        if (parent.isDisposed()) {
            return;
        }
        Point pt = parent.getSize();
        parent.setSize(pt.x + 1, pt.y);
        parent.setSize(pt.x, pt.y);
    }

    int webView_contextMenuItemsForElement_defaultMenuItems(int sender, int element, int defaultMenuItems) {
        Point pt = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = pt.x;
        event.y = pt.y;
        this.browser.notifyListeners(35, event);
        Menu menu = this.browser.getMenu();
        if (!event.doit) {
            return 0;
        }
        if (menu != null && !menu.isDisposed()) {
            if (event.x != pt.x || event.y != pt.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0;
        }
        return defaultMenuItems;
    }

    void webView_setStatusBarVisible(int sender, boolean visible) {
        this.statusBar = visible;
    }

    void webView_setStatusText(int sender, int textID) {
        NSString text = new NSString(textID);
        int length = text.length();
        if (length == 0) {
            return;
        }
        StatusTextEvent statusText = new StatusTextEvent(this.browser);
        statusText.display = this.browser.getDisplay();
        statusText.widget = this.browser;
        statusText.text = text.getString();
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(statusText);
            ++i;
        }
    }

    void webView_setResizable(int sender, boolean visible) {
    }

    void webView_setToolbarsVisible(int sender, boolean visible) {
        this.toolBar = visible;
    }

    void webView_mouseDidMoveOverElement_modifierFlags(int sender, int elementInformationID, int modifierFlags) {
        if (elementInformationID == 0) {
            return;
        }
        NSDictionary elementInformation = new NSDictionary(elementInformationID);
        NSString key = NSString.stringWith(WebElementLinkURLKey);
        id value = elementInformation.valueForKey(key);
        if (value == null) {
            if (this.lastHoveredLinkURL == null) {
                return;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusText = new StatusTextEvent(this.browser);
            statusText.display = this.browser.getDisplay();
            statusText.widget = this.browser;
            statusText.text = "";
            int i = 0;
            while (i < this.statusTextListeners.length) {
                this.statusTextListeners[i].changed(statusText);
                ++i;
            }
            return;
        }
        NSString url = new NSURL(value.id).absoluteString();
        int length = url.length();
        String urlString = length == 0 ? "" : url.getString();
        if (urlString.equals(this.lastHoveredLinkURL)) {
            return;
        }
        this.lastHoveredLinkURL = urlString;
        StatusTextEvent statusText = new StatusTextEvent(this.browser);
        statusText.display = this.browser.getDisplay();
        statusText.widget = this.browser;
        statusText.text = urlString;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(statusText);
            ++i;
        }
    }

    void webView_printFrameView(int sender, int frameViewID) {
        WebFrameView view = new WebFrameView(frameViewID);
        boolean viewPrint = view.documentViewShouldHandlePrint();
        if (viewPrint) {
            view.printDocumentView();
            return;
        }
        NSPrintInfo info = NSPrintInfo.sharedPrintInfo();
        NSPrintOperation operation = view.printOperationWithPrintInfo(info);
        if (operation != null) {
            operation.runOperation();
        }
    }

    void webView_decidePolicyForMIMEType_request_frame_decisionListener(int sender, int type, int request, int frame, int listenerID) {
        boolean canShow = WebView.canShowMIMEType(new NSString(type));
        WebPolicyDecisionListener listener = new WebPolicyDecisionListener(listenerID);
        if (canShow) {
            listener.use();
        } else {
            listener.download();
        }
    }

    void webView_decidePolicyForNavigationAction_request_frame_decisionListener(int sender, int actionInformation, int request, int frame, int listenerID) {
        NSURL url = new NSURLRequest(request).URL();
        WebPolicyDecisionListener listener = new WebPolicyDecisionListener(listenerID);
        if (this.loadingText) {
            listener.use();
            return;
        }
        if (url == null) {
            listener.ignore();
            return;
        }
        if (url.isFileURL() && this.getUrl().startsWith(ABOUT_BLANK) && this.untrustedText) {
            listener.ignore();
            return;
        }
        NSString s = url.absoluteString();
        String url2 = s.getString();
        if (url2.equals(URI_FILEROOT)) {
            url2 = ABOUT_BLANK;
        } else {
            int length = URI_FILEROOT.length();
            if (url2.startsWith(URI_FILEROOT) && url2.charAt(length) == '#') {
                url2 = ABOUT_BLANK + url2.substring(length);
            }
        }
        LocationEvent newEvent = new LocationEvent(this.browser);
        newEvent.display = this.browser.getDisplay();
        newEvent.widget = this.browser;
        newEvent.location = url2;
        newEvent.doit = true;
        if (this.locationListeners != null) {
            int i = 0;
            while (i < this.locationListeners.length) {
                this.locationListeners[i].changing(newEvent);
                ++i;
            }
        }
        if (newEvent.doit) {
            if (this.jsEnabledChanged) {
                this.jsEnabledChanged = false;
                if (this.preferences == null) {
                    this.preferences = (WebPreferences)new WebPreferences().alloc().init();
                    this.webView.setPreferences(this.preferences);
                }
                this.preferences.setJavaScriptEnabled(this.jsEnabled);
            }
            listener.use();
            this.lastNavigateURL = url2;
        } else {
            listener.ignore();
        }
    }

    void webView_decidePolicyForNewWindowAction_request_newFrameName_decisionListener(int sender, int actionInformation, int request, int frameName, int listenerID) {
        WebPolicyDecisionListener listener = new WebPolicyDecisionListener(listenerID);
        listener.use();
    }

    void webView_unableToImplementPolicyWithError_frame(int sender, int error, int frame) {
    }

    void download_decideDestinationWithSuggestedFilename(int downloadId, int filename) {
        NSString string = new NSString(filename);
        String name = string.getString();
        FileDialog dialog = new FileDialog(this.browser.getShell(), 8192);
        dialog.setText(SWT.getMessage("SWT_FileDownload"));
        dialog.setFileName(name);
        String path = dialog.open();
        NSURLDownload download = new NSURLDownload(downloadId);
        if (path == null) {
            download.cancel();
            return;
        }
        download.setDestination(NSString.stringWith(path), true);
    }

    void handleEvent(int evtId) {
        NSString string = new NSString(OS.objc_msgSend(evtId, OS.sel_type));
        String type = string.getString();
        if (DOMEVENT_KEYDOWN.equals(type) || DOMEVENT_KEYUP.equals(type)) {
            int stateMask;
            int translatedKey;
            int eventType;
            DOMKeyboardEvent event = new DOMKeyboardEvent(evtId);
            boolean ctrl = event.ctrlKey();
            boolean shift = event.shiftKey();
            boolean alt = event.altKey();
            boolean meta = event.metaKey();
            int keyCode = event.keyCode();
            int charCode = event.charCode();
            Event keyEvent = new Event();
            keyEvent.widget = this.browser;
            keyEvent.type = eventType = DOMEVENT_KEYDOWN.equals(type) ? 1 : 2;
            keyEvent.keyCode = translatedKey = this.translateKey(keyCode);
            keyEvent.character = (char)charCode;
            keyEvent.stateMask = stateMask = (alt ? 65536 : 0) | (ctrl ? 262144 : 0) | (shift ? 131072 : 0) | (meta ? 0x400000 : 0);
            boolean doit = true;
            if (keyEvent.type == 1) {
                doit = this.sendKeyEvent(keyEvent);
            } else {
                this.browser.notifyListeners(keyEvent.type, keyEvent);
                doit = keyEvent.doit;
            }
            if (!doit) {
                event.preventDefault();
            } else if (eventType == 1 && stateMask == 0x400000) {
                if (translatedKey == 118) {
                    this.webView.paste(this.webView);
                    event.preventDefault();
                } else if (translatedKey == 99) {
                    this.webView.copy(this.webView);
                    event.preventDefault();
                } else if (translatedKey == 120) {
                    this.webView.cut(this.webView);
                    event.preventDefault();
                }
            }
            return;
        }
        if (DOMEVENT_MOUSEWHEEL.equals(type)) {
            DOMWheelEvent event = new DOMWheelEvent(evtId);
            int screenX = event.screenX();
            int screenY = event.screenY();
            Point position = new Point(screenX, screenY);
            position = this.browser.getDisplay().map(null, (Control)this.browser, position);
            int delta = event.wheelDelta();
            boolean ctrl = event.ctrlKey();
            boolean shift = event.shiftKey();
            boolean alt = event.altKey();
            boolean meta = event.metaKey();
            Event mouseEvent = new Event();
            mouseEvent.type = 37;
            mouseEvent.widget = this.browser;
            mouseEvent.x = position.x;
            mouseEvent.y = position.y;
            mouseEvent.count = delta / 120;
            mouseEvent.stateMask = (alt ? 65536 : 0) | (ctrl ? 262144 : 0) | (shift ? 131072 : 0) | (meta ? 0x400000 : 0);
            this.browser.notifyListeners(mouseEvent.type, mouseEvent);
            return;
        }
        DOMMouseEvent event = new DOMMouseEvent(evtId);
        int screenX = event.screenX();
        int screenY = event.screenY();
        Point position = new Point(screenX, screenY);
        position = this.browser.getDisplay().map(null, (Control)this.browser, position);
        int detail = event.detail();
        short button = event.button();
        boolean ctrl = event.ctrlKey();
        boolean shift = event.shiftKey();
        boolean alt = event.altKey();
        boolean meta = event.metaKey();
        Event mouseEvent = new Event();
        mouseEvent.widget = this.browser;
        mouseEvent.x = position.x;
        mouseEvent.y = position.y;
        mouseEvent.stateMask = (alt ? 65536 : 0) | (ctrl ? 262144 : 0) | (shift ? 131072 : 0) | (meta ? 0x400000 : 0);
        if (DOMEVENT_MOUSEDOWN.equals(type)) {
            mouseEvent.type = 3;
            mouseEvent.button = button + 1;
            mouseEvent.count = detail;
        } else if (DOMEVENT_MOUSEUP.equals(type)) {
            mouseEvent.type = 4;
            mouseEvent.button = button + 1;
            mouseEvent.count = detail;
            switch (mouseEvent.button) {
                case 1: {
                    mouseEvent.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    mouseEvent.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    mouseEvent.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    mouseEvent.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    mouseEvent.stateMask |= 0x2000000;
                }
            }
        } else if (DOMEVENT_MOUSEMOVE.equals(type)) {
            if (mouseEvent.x == this.lastMouseMoveX && mouseEvent.y == this.lastMouseMoveY) {
                return;
            }
            mouseEvent.type = 5;
            this.lastMouseMoveX = mouseEvent.x;
            this.lastMouseMoveY = mouseEvent.y;
        }
        this.browser.notifyListeners(mouseEvent.type, mouseEvent);
        if (detail == 2 && DOMEVENT_MOUSEDOWN.equals(type)) {
            mouseEvent = new Event();
            mouseEvent.widget = this.browser;
            mouseEvent.x = position.x;
            mouseEvent.y = position.y;
            mouseEvent.stateMask = (alt ? 65536 : 0) | (ctrl ? 262144 : 0) | (shift ? 131072 : 0) | (meta ? 0x400000 : 0);
            mouseEvent.type = 8;
            mouseEvent.button = button + 1;
            mouseEvent.count = detail;
            this.browser.notifyListeners(mouseEvent.type, mouseEvent);
        }
    }

    Object convertToJava(int value) {
        NSObject object = new NSObject(value);
        int clazz = OS.objc_lookUpClass("NSString");
        if (object.isKindOfClass(clazz)) {
            NSString string = new NSString(value);
            return string.getString();
        }
        clazz = OS.objc_lookUpClass("NSNumber");
        if (object.isKindOfClass(clazz)) {
            NSNumber number = new NSNumber(value);
            int ptr = number.objCType();
            byte[] type = new byte[1];
            OS.memmove(type, ptr, 1);
            if (type[0] == 99 || type[0] == 66) {
                return new Boolean(number.boolValue());
            }
            if ("islqISLQfd".indexOf(type[0]) != -1) {
                return new Double(number.doubleValue());
            }
        }
        if (object.isKindOfClass(clazz = OS.objc_lookUpClass("WebScriptObject"))) {
            WebScriptObject script = new WebScriptObject(value);
            id id2 = script.valueForKey(NSString.stringWith("length"));
            if (id2 == null) {
                SWT.error(5);
            }
            int length = new NSNumber(id2).intValue();
            Object[] arguments = new Object[length];
            int i = 0;
            while (i < length) {
                id current = script.webScriptValueAtIndex(i);
                if (current != null) {
                    arguments[i] = this.convertToJava(current.id);
                }
                ++i;
            }
            return arguments;
        }
        clazz = OS.objc_lookUpClass("WebUndefined");
        if (object.isKindOfClass(clazz)) {
            return null;
        }
        SWT.error(5);
        return null;
    }

    NSObject convertToJS(Object value) {
        if (value == null) {
            int result = OS.objc_msgSend(OS.class_NSNull, OS.sel_null);
            return result != 0 ? new NSObject(result) : null;
        }
        if (value instanceof String) {
            return NSString.stringWith((String)value);
        }
        if (value instanceof Boolean) {
            return NSNumber.numberWithBool((Boolean)value);
        }
        if (value instanceof Number) {
            return NSNumber.numberWithDouble(((Number)value).doubleValue());
        }
        if (value instanceof Object[]) {
            Object[] arrayValue = (Object[])value;
            int length = arrayValue.length;
            NSMutableArray array = NSMutableArray.arrayWithCapacity(length);
            int i = 0;
            while (i < length) {
                Object currentObject = arrayValue[i];
                array.addObject(this.convertToJS(currentObject));
                ++i;
            }
            return array;
        }
        SWT.error(51);
        return null;
    }

    NSObject callJava(int index, int args, int arg1) {
        NSNumber number;
        Integer key;
        BrowserFunction function;
        Object returnValue = null;
        NSObject object = new NSObject(index);
        int clazz = OS.objc_lookUpClass("NSNumber");
        if (object.isKindOfClass(clazz) && (function = (BrowserFunction)this.functions.get(key = new Integer((number = new NSNumber(index)).intValue()))) != null) {
            try {
                Object temp = this.convertToJava(args);
                if (temp instanceof Object[]) {
                    Object[] arguments = (Object[])temp;
                    try {
                        returnValue = function.function(arguments);
                    }
                    catch (Exception e) {
                        returnValue = WebBrowser.CreateErrorString(e.getLocalizedMessage());
                    }
                }
            }
            catch (IllegalArgumentException e) {
                if (function.isEvaluate) {
                    function.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                }
                returnValue = WebBrowser.CreateErrorString(e.getLocalizedMessage());
            }
        }
        try {
            return this.convertToJS(returnValue);
        }
        catch (SWTException e) {
            return this.convertToJS(WebBrowser.CreateErrorString(e.getLocalizedMessage()));
        }
    }
}

