/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.URIHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MOpaqueToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimBarLayout;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.internal.provisional.action.CoolBarManager2;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.internal.provisional.action.IToolBarManager2;
import org.eclipse.jface.internal.provisional.action.ToolBarManager2;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPageService;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.IBackgroundSaveListener;
import org.eclipse.ui.internal.PageListenerList;
import org.eclipse.ui.internal.PartService;
import org.eclipse.ui.internal.PerspectiveListenerList;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.e4.compatibility.SelectionService;
import org.eclipse.ui.internal.handlers.ActionCommandMappingService;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.internal.handlers.LegacyHandlerService;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.menus.IActionSetsListener;
import org.eclipse.ui.internal.menus.LegacyActionPersistence;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.internal.menus.WorkbenchMenuService;
import org.eclipse.ui.internal.misc.UIListenerLogging;
import org.eclipse.ui.internal.progress.ProgressRegion;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.provisional.presentations.IActionBarPresentationFactory;
import org.eclipse.ui.internal.registry.UIExtensionTracker;
import org.eclipse.ui.internal.services.EvaluationReference;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IEvaluationService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WorkbenchWindow
implements IWorkbenchWindow {
    private static final String MAIN_TOOLBAR_ID = "org.eclipse.ui.main.toolbar";
    public static final String ACTION_SET_CMD_PREFIX = "AS::";
    @Inject
    private IWorkbench workbench;
    @Inject
    private MTrimmedWindow model;
    @Inject
    private IPresentationEngine engine;
    @Inject
    private IRendererFactory rendererFactory;
    @Inject
    private MApplication application;
    @Inject
    EModelService modelService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private IExtensionRegistry extensionRegistry;
    private WorkbenchPage page;
    private WorkbenchWindowAdvisor windowAdvisor;
    private ActionBarAdvisor actionBarAdvisor;
    private int number;
    private PageListenerList pageListeners = new PageListenerList();
    private PerspectiveListenerList perspectiveListeners = new PerspectiveListenerList();
    private PartService partService = new PartService();
    private WWinActionBars actionBars;
    private boolean updateDisabled = true;
    private boolean closing = false;
    private boolean shellActivated = false;
    ProgressRegion progressRegion = null;
    private List<MTrimElement> workbenchTrimElements = new ArrayList<MTrimElement>();
    private Map<MToolControl, IConfigurationElement> iceMap = new HashMap<MToolControl, IConfigurationElement>();
    private ServiceLocator serviceLocator;
    private int submenus = 0;
    private WorkbenchWindowConfigurer windowConfigurer = null;
    private boolean restarting = false;
    private ListenerList genericPropertyListeners = new ListenerList();
    private IAdaptable input;
    private IPerspectiveDescriptor perspective;
    private EventHandler windowWidgetHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (event.getProperty("ChangedElement") == WorkbenchWindow.this.model && event.getProperty("NewValue") == null) {
                WorkbenchWindow.this.removeTrimContributions();
                WorkbenchWindow.this.removeTopTrimChildren();
                MMenu menu = WorkbenchWindow.this.model.getMainMenu();
                if (menu != null) {
                    WorkbenchWindow.this.engine.removeGui((MUIElement)menu);
                    WorkbenchWindow.this.model.setMainMenu(null);
                }
                WorkbenchWindow.this.eventBroker.unsubscribe(WorkbenchWindow.this.windowWidgetHandler);
            }
        }
    };
    static final String TEXT_DELIMITERS = String.valueOf(TextProcessor.getDefaultDelimiters()) + "-";
    static final String GRP_PAGES = "pages";
    static final String GRP_PERSPECTIVES = "perspectives";
    static final String GRP_FAST_VIEWS = "fastViews";
    static final int VGAP = 0;
    static final int CLIENT_INSET = 3;
    static final int BAR_SIZE = 23;
    public static final String PROP_COOLBAR_VISIBLE = "coolbarVisible";
    public static final String PROP_PERSPECTIVEBAR_VISIBLE = "perspectiveBarVisible";
    public static final String PROP_STATUS_LINE_VISIBLE = "statusLineVisible";
    public static final int SHOW_VIEW_SUBMENU = 1;
    public static final int OPEN_PERSPECTIVE_SUBMENU = 2;
    public static final int NEW_WIZARD_SUBMENU = 4;
    private static final int FILL_ALL_ACTION_BARS = 14;
    private boolean coolBarVisible = true;
    private boolean perspectiveBarVisible = true;
    private boolean fastViewBarVisible = true;
    private boolean statusLineVisible = true;
    private Map globalActionHandlersByCommandId = new HashMap();
    private List handlerActivations = new ArrayList();
    private int largeUpdates = 0;
    private IExtensionTracker tracker;
    private Set menuRestrictions = new HashSet();
    private ListenerList actionSetListeners = null;
    private ListenerList backgroundSaveListeners = new ListenerList(1);
    private ISelectionService selectionService;
    StatusLineManager statusLineManager = null;
    CoolBarManager2 cm2 = new CoolBarManager2();
    MenuManager menuManager = new MenuManager("MenuBar", "org.eclipse.ui.main.menu");
    ToolBarManager2 toolBarManager = new ToolBarManager2();

    public IConfigurationElement getICEFor(MToolControl mtc) {
        return this.iceMap.get(mtc);
    }

    public void addSubmenu(int type) {
        this.submenus |= type;
    }

    public boolean containsSubmenu(int type) {
        return (this.submenus & type) != 0;
    }

    public WorkbenchWindow(IAdaptable input, IPerspectiveDescriptor pers) {
        this.input = input;
        this.perspective = pers;
    }

    @PostConstruct
    public void setup() {
        MPerspectiveStack stack;
        IEclipseContext windowContext = this.model.getContext();
        IServiceLocatorCreator slc = (IServiceLocatorCreator)this.workbench.getService(IServiceLocatorCreator.class);
        this.serviceLocator = (ServiceLocator)slc.createServiceLocator(this.workbench, null, new IDisposable(){

            public void dispose() {
                Shell shell = WorkbenchWindow.this.getShell();
                if (shell != null && !shell.isDisposed()) {
                    WorkbenchWindow.this.close();
                }
            }
        });
        this.serviceLocator.setContext(windowContext);
        windowContext.set(IExtensionTracker.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context) {
                if (WorkbenchWindow.this.tracker == null) {
                    WorkbenchWindow.this.tracker = (IExtensionTracker)new UIExtensionTracker(WorkbenchWindow.this.getWorkbench().getDisplay());
                }
                return WorkbenchWindow.this.tracker;
            }
        });
        windowContext.set(IWindowCloseHandler.class.getName(), (Object)new IWindowCloseHandler(){

            public boolean close(MWindow window) {
                if (WorkbenchWindow.this.restarting) {
                    return WorkbenchWindow.this.close(false);
                }
                return WorkbenchWindow.this.getWindowAdvisor().preWindowShellClose() && WorkbenchWindow.this.close();
            }
        });
        final ISaveHandler defaultSaveHandler = (ISaveHandler)windowContext.get(ISaveHandler.class);
        windowContext.set(ISaveHandler.class, (Object)new ISaveHandler(){

            public ISaveHandler.Save promptToSave(MPart dirtyPart) {
                Object object = dirtyPart.getObject();
                if (object instanceof CompatibilityEditor) {
                    IEditorPart editor = ((CompatibilityEditor)object).getEditor();
                    return SaveableHelper.savePart(editor, editor, WorkbenchWindow.this, true) ? ISaveHandler.Save.NO : ISaveHandler.Save.CANCEL;
                }
                return defaultSaveHandler.promptToSave(dirtyPart);
            }

            public ISaveHandler.Save[] promptToSave(Collection<MPart> dirtyParts) {
                LabelProvider labelProvider = new LabelProvider(){

                    public String getText(Object element) {
                        return ((MPart)element).getLocalizedLabel();
                    }
                };
                ArrayList<MPart> parts = new ArrayList<MPart>(dirtyParts);
                ListSelectionDialog dialog = new ListSelectionDialog(WorkbenchWindow.this.getShell(), parts, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)labelProvider, WorkbenchMessages.EditorManager_saveResourcesMessage);
                dialog.setInitialSelections(parts.toArray());
                dialog.setTitle(WorkbenchMessages.EditorManager_saveResourcesTitle);
                if (dialog.open() == 1) {
                    return new ISaveHandler.Save[]{ISaveHandler.Save.CANCEL};
                }
                Object[] toSave = dialog.getResult();
                Object[] retSaves = new ISaveHandler.Save[parts.size()];
                Arrays.fill(retSaves, ISaveHandler.Save.NO);
                int i = 0;
                while (i < retSaves.length) {
                    MPart part = (MPart)parts.get(i);
                    Object[] objectArray = toSave;
                    int n = toSave.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o == part) {
                            retSaves[i] = ISaveHandler.Save.YES;
                            break;
                        }
                        ++n2;
                    }
                    ++i;
                }
                return retSaves;
            }
        });
        windowContext.set(IWorkbenchWindow.class.getName(), (Object)this);
        windowContext.set(IPageService.class, (Object)this);
        windowContext.set(IPartService.class, (Object)this.partService);
        windowContext.set("activeWorkbenchWindow", (Object)this);
        windowContext.set("activeWorkbenchWindowShell", (Object)this.getShell());
        EContextService cs = (EContextService)windowContext.get(EContextService.class.getName());
        cs.activateContext("org.eclipse.ui.contexts.window");
        cs.getActiveContextIds();
        this.initializeDefaultServices();
        this.fireWindowOpening();
        try {
            this.page = new WorkbenchPage(this, this.input);
        }
        catch (WorkbenchException e) {
            WorkbenchPlugin.log((Throwable)((Object)e));
        }
        ContextInjectionFactory.inject((Object)this.page, (IEclipseContext)this.model.getContext());
        windowContext.set(IWorkbenchPage.class, (Object)this.page);
        this.firePageOpened();
        this.fillActionBars(14);
        List ps = this.modelService.findElements((MUIElement)this.model, null, MPerspectiveStack.class, null);
        MPerspective curPersp = null;
        if (ps.size() > 0 && (stack = (MPerspectiveStack)ps.get(0)).getSelectedElement() != null) {
            curPersp = (MPerspective)stack.getSelectedElement();
            IPerspectiveDescriptor thePersp = this.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(curPersp.getElementId());
            if (thePersp != null) {
                this.perspective = thePersp;
            }
        }
        this.page.setPerspective(this.perspective);
        this.firePageActivated();
        this.populateTopTrimContributions();
        this.populateBottomTrimContributions();
        Shell shell = (Shell)this.model.getWidget();
        MMenu mainMenu = this.model.getMainMenu();
        if (mainMenu == null) {
            mainMenu = MenuFactoryImpl.eINSTANCE.createMenu();
            mainMenu.setElementId("org.eclipse.ui.main.menu");
            MenuManagerRenderer renderer = (MenuManagerRenderer)this.rendererFactory.getRenderer((MUIElement)mainMenu, null);
            renderer.linkModelToManager(mainMenu, this.menuManager);
            this.fill(renderer, mainMenu, (IMenuManager)this.menuManager);
            this.model.setMainMenu(mainMenu);
            Menu menu = (Menu)this.engine.createGui((MUIElement)mainMenu, this.model.getWidget(), this.model.getContext());
            shell.setMenuBar(menu);
        }
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"widget"), this.windowWidgetHandler);
        this.partService.setPage(this.page);
        this.trackShellActivation();
    }

    private void removeTrimContributions() {
        MTrimBar trimBar = this.getTopTrim();
        for (MTrimElement trimElement : this.workbenchTrimElements) {
            trimElement.setToBeRendered(false);
            trimBar.getChildren().remove(trimElement);
        }
        this.workbenchTrimElements.clear();
    }

    private void removeTopTrimChildren() {
        MTrimBar trimBar = null;
        List trimBars = this.model.getTrimBars();
        for (MTrimBar bar : trimBars) {
            if (!MAIN_TOOLBAR_ID.equals(bar.getElementId())) continue;
            trimBar = bar;
            break;
        }
        if (trimBar == null) {
            return;
        }
        this.engine.removeGui(trimBar);
        trimBars.remove(trimBar);
    }

    void populateTopTrimContributions() {
        if (this.getTopTrim() != null) {
            throw new IllegalStateException("The top trim is already set");
        }
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        trimBar.setElementId(MAIN_TOOLBAR_ID);
        this.fill(trimBar, (IContributionManager)this.getCoolBarManager2());
        MToolControl spacerControl = MenuFactoryImpl.eINSTANCE.createToolControl();
        spacerControl.setElementId("PerspectiveSpacer");
        spacerControl.setContributionURI("platform:/plugin/org.eclipse.e4.ui.workbench.renderers.swt/org.eclipse.e4.ui.workbench.renderers.swt.LayoutModifierToolControl");
        spacerControl.getTags().add(TrimBarLayout.SPACER);
        MToolControl searchControl = MenuFactoryImpl.eINSTANCE.createToolControl();
        searchControl.setElementId("SearchField");
        searchControl.setContributionURI("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.quickaccess.SearchField");
        MToolControl glueControl = MenuFactoryImpl.eINSTANCE.createToolControl();
        glueControl.setElementId("Search-PS Glue");
        glueControl.setContributionURI("platform:/plugin/org.eclipse.e4.ui.workbench.renderers.swt/org.eclipse.e4.ui.workbench.renderers.swt.LayoutModifierToolControl");
        glueControl.getTags().add(TrimBarLayout.GLUE);
        MToolControl switcherControl = MenuFactoryImpl.eINSTANCE.createToolControl();
        switcherControl.setToBeRendered(this.getWindowConfigurer().getShowPerspectiveBar());
        switcherControl.setElementId("PerspectiveSwitcher");
        switcherControl.setContributionURI("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.e4.ui.workbench.addons.perspectiveswitcher.PerspectiveSwitcher");
        trimBar.getChildren().add(spacerControl);
        trimBar.getChildren().add(searchControl);
        trimBar.getChildren().add(glueControl);
        trimBar.getChildren().add(switcherControl);
        trimBar.setToBeRendered(true);
        this.workbenchTrimElements.add((MTrimElement)spacerControl);
        this.workbenchTrimElements.add((MTrimElement)searchControl);
        this.workbenchTrimElements.add((MTrimElement)glueControl);
        this.workbenchTrimElements.add((MTrimElement)switcherControl);
        List trimBars = this.model.getTrimBars();
        trimBars.add(0, trimBar);
    }

    private void populateStandardTrim(MTrimBar bottomTrim) {
        MToolControl slElement = (MToolControl)this.modelService.find("org.eclipse.ui.StatusLine", (MUIElement)bottomTrim);
        if (slElement == null) {
            slElement = MenuFactoryImpl.eINSTANCE.createToolControl();
            slElement.setElementId("org.eclipse.ui.StatusLine");
            slElement.setContributionURI("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.StandardTrim");
            bottomTrim.getChildren().add(slElement);
        }
        slElement.setToBeRendered(this.statusLineVisible);
        slElement.getTags().add(TrimBarLayout.SPACER);
        MToolControl hsElement = (MToolControl)this.modelService.find("org.eclipse.ui.HeapStatus", (MUIElement)bottomTrim);
        if (hsElement == null) {
            hsElement = MenuFactoryImpl.eINSTANCE.createToolControl();
            hsElement.setElementId("org.eclipse.ui.HeapStatus");
            hsElement.setContributionURI("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.StandardTrim");
            bottomTrim.getChildren().add(hsElement);
        }
        hsElement.setToBeRendered(this.getShowHeapStatus());
        MToolControl pbElement = (MToolControl)this.modelService.find("org.eclipse.ui.ProgressBar", (MUIElement)bottomTrim);
        if (pbElement == null) {
            pbElement = MenuFactoryImpl.eINSTANCE.createToolControl();
            pbElement.setElementId("org.eclipse.ui.ProgressBar");
            pbElement.setContributionURI("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.StandardTrim");
            bottomTrim.getChildren().add(pbElement);
        }
        pbElement.setToBeRendered(this.getWindowConfigurer().getShowProgressIndicator());
    }

    private void populateTrimContributions(MTrimBar bottomTrim) {
        IConfigurationElement[] exts = this.extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.menus");
        ArrayList<IConfigurationElement> items = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ice = iConfigurationElementArray[n2];
            if ("group".equals(ice.getName()) || "widget".equals(ice.getName())) {
                items.add(ice);
            }
            ++n2;
        }
        if (items.size() == 0) {
            return;
        }
        ArrayList<IConfigurationElement> handledElements = new ArrayList<IConfigurationElement>();
        handledElements.add((IConfigurationElement)items.get(0));
        MToolControl createdTrim = null;
        while (items.size() > 0 && handledElements.size() > 0) {
            handledElements.clear();
            for (IConfigurationElement item : items) {
                IConfigurationElement[] locs;
                String id = item.getAttribute("id");
                String classSpec = item.getAttribute("class");
                IConfigurationElement[] iConfigurationElementArray2 = locs = item.getChildren("location");
                int n3 = locs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement bar;
                    boolean isTrim;
                    IConfigurationElement loc = iConfigurationElementArray2[n4];
                    IConfigurationElement[] bars = loc.getChildren("bar");
                    if (bars.length > 0 && (isTrim = "trim".equals((bar = bars[0]).getAttribute("type")))) {
                        String path = bar.getAttribute("path");
                        if (path != null && path.length() > 0) {
                            createdTrim = this.addTrimElement(bottomTrim, item, id, false, path, classSpec);
                        } else {
                            IConfigurationElement[] orders = loc.getChildren("order");
                            if (orders.length > 0) {
                                boolean isBefore = "before".equals(orders[0].getAttribute("position"));
                                String relTo = orders[0].getAttribute("relativeTo");
                                if ("status".equals(relTo)) {
                                    relTo = "org.eclipse.ui.StatusLine";
                                }
                                createdTrim = this.addTrimElement(bottomTrim, item, id, isBefore, relTo, classSpec);
                            }
                        }
                        if (createdTrim != null) {
                            handledElements.add(item);
                        }
                    }
                    ++n4;
                }
            }
            items.removeAll(handledElements);
        }
    }

    private MToolControl addTrimElement(MTrimBar bottomTrim, IConfigurationElement ice, String id, boolean isBefore, String relTo, String classSpec) {
        MUIElement existingTrim = this.modelService.find(id, (MUIElement)bottomTrim);
        if (existingTrim != null) {
            this.iceMap.put((MToolControl)existingTrim, ice);
            return (MToolControl)existingTrim;
        }
        int insertIndex = bottomTrim.getChildren().size();
        if (relTo != null) {
            MUIElement foundRel = this.modelService.find(relTo, (MUIElement)bottomTrim);
            if (foundRel == null) {
                return null;
            }
            insertIndex = bottomTrim.getChildren().indexOf(foundRel);
            if (!isBefore) {
                ++insertIndex;
            }
        }
        MToolControl newTrimElement = MenuFactoryImpl.eINSTANCE.createToolControl();
        newTrimElement.setElementId(id);
        newTrimElement.setToBeRendered(classSpec != null);
        if (classSpec != null) {
            newTrimElement.setContributionURI("platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.LegacyTrim");
        }
        newTrimElement.setContributorURI(URIHelper.constructPlatformURI((IContributor)ice.getContributor()));
        this.iceMap.put(newTrimElement, ice);
        bottomTrim.getChildren().add(insertIndex, newTrimElement);
        return newTrimElement;
    }

    void populateBottomTrimContributions() {
        MTrimBar bottomTrim = this.modelService.getTrim(this.model, SideValue.BOTTOM);
        this.populateStandardTrim(bottomTrim);
        this.populateTrimContributions(bottomTrim);
    }

    private MTrimBar getTopTrim() {
        List trimBars = this.model.getTrimBars();
        for (MTrimBar bar : trimBars) {
            if (!MAIN_TOOLBAR_ID.equals(bar.getElementId())) continue;
            return bar;
        }
        return null;
    }

    private void fill(MenuManagerRenderer renderer, MMenu menu, IMenuManager manager) {
        IContributionItem[] iContributionItemArray = manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MMenuItem menuItem;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof MenuManager) {
                MenuManager menuManager = (MenuManager)item;
                MMenu subMenu = MenuHelper.createMenu(menuManager);
                if (subMenu != null) {
                    renderer.linkModelToContribution((MMenuElement)subMenu, item);
                    renderer.linkModelToManager(subMenu, menuManager);
                    this.fill(renderer, subMenu, (IMenuManager)menuManager);
                    menu.getChildren().add(subMenu);
                }
            } else if (item instanceof CommandContributionItem) {
                CommandContributionItem cci = (CommandContributionItem)item;
                MMenuItem menuItem2 = MenuHelper.createItem(this.application, cci);
                manager.remove(item);
                if (menuItem2 != null) {
                    menu.getChildren().add(menuItem2);
                }
            } else if (item instanceof ActionContributionItem) {
                menuItem = MenuHelper.createItem(this.application, (ActionContributionItem)item);
                manager.remove(item);
                if (menuItem != null) {
                    menu.getChildren().add(menuItem);
                }
            } else if (item instanceof AbstractGroupMarker) {
                MMenuSeparator separator = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
                separator.setVisible(item.isVisible());
                separator.setElementId(item.getId());
                menu.getChildren().add(separator);
                manager.remove(item);
            } else {
                menuItem = MenuFactoryImpl.eINSTANCE.createOpaqueMenuItem();
                menuItem.setElementId(item.getId());
                menu.getChildren().add(menuItem);
                renderer.linkModelToContribution((MMenuElement)menuItem, item);
            }
            ++n2;
        }
    }

    private void fill(MTrimBar container, IContributionManager manager) {
        IContributionItem[] iContributionItemArray = manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MToolBar toolBar;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof IToolBarContributionItem) {
                IToolBarManager manager2 = ((IToolBarContributionItem)item).getToolBarManager();
                toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
                toolBar.setElementId(item.getId());
                this.fill(toolBar, (IContributionManager)manager2);
                toolBar.setToBeRendered(this.shouldBeRendered(toolBar));
                container.getChildren().add(toolBar);
                this.workbenchTrimElements.add((MTrimElement)toolBar);
            } else if (item instanceof IContributionManager) {
                MToolBar toolBar2 = MenuFactoryImpl.eINSTANCE.createToolBar();
                toolBar2.setElementId(item.getId());
                this.fill(toolBar2, (IContributionManager)item);
                toolBar2.setToBeRendered(this.shouldBeRendered(toolBar2));
                container.getChildren().add(toolBar2);
                this.workbenchTrimElements.add((MTrimElement)toolBar2);
            } else if (item instanceof AbstractGroupMarker) {
                MToolBarSeparator separator = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
                separator.setToBeRendered(item.isVisible());
                separator.setElementId(item.getId());
                toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
                toolBar.setElementId(item.getId());
                toolBar.getChildren().add(separator);
                toolBar.setToBeRendered(this.shouldBeRendered(toolBar));
                container.getChildren().add(toolBar);
                this.workbenchTrimElements.add((MTrimElement)toolBar);
            }
            ++n2;
        }
    }

    private boolean shouldBeRendered(MToolBar toolBar) {
        for (MUIElement tbElement : toolBar.getChildren()) {
            if (tbElement instanceof MToolBarSeparator || !tbElement.isToBeRendered()) continue;
            return true;
        }
        return false;
    }

    private void fill(MToolBar container, IContributionManager manager) {
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)container, null);
        if (manager instanceof ToolBarManager) {
            renderer.linkModelToManager(container, (ToolBarManager)manager);
        }
        IContributionItem[] iContributionItemArray = manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MToolItem toolItem;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof IToolBarContributionItem) {
                IToolBarManager manager2 = ((IToolBarContributionItem)item).getToolBarManager();
                this.fill(container, (IContributionManager)manager2);
            } else if (item instanceof IContributionManager) {
                this.fill(container, (IContributionManager)item);
            } else if (item instanceof CommandContributionItem) {
                CommandContributionItem cci = (CommandContributionItem)item;
                toolItem = MenuHelper.createToolItem(this.application, cci);
                manager.remove(item);
                if (toolItem != null) {
                    container.getChildren().add(toolItem);
                }
            } else if (item instanceof AbstractGroupMarker) {
                MToolBarSeparator separator = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
                separator.setToBeRendered(item.isVisible());
                separator.setVisible(item.isVisible());
                separator.setElementId(item.getId());
                container.getChildren().add(separator);
                manager.remove(item);
            } else if (item instanceof ActionContributionItem) {
                IAction action = ((ActionContributionItem)item).getAction();
                if (action.getStyle() == 4) {
                    toolItem = MenuFactoryImpl.eINSTANCE.createOpaqueToolItem();
                    toolItem.setElementId(item.getId());
                    container.getChildren().add(toolItem);
                    renderer.linkModelToContribution((MToolBarElement)toolItem, item);
                } else {
                    toolItem = MenuHelper.createToolItem(this.application, (ActionContributionItem)item);
                    manager.remove(item);
                    if (toolItem != null) {
                        container.getChildren().add(toolItem);
                    }
                }
            } else {
                MOpaqueToolItem toolItem2 = MenuFactoryImpl.eINSTANCE.createOpaqueToolItem();
                toolItem2.setElementId(item.getId());
                container.getChildren().add(toolItem2);
                renderer.linkModelToContribution((MToolBarElement)toolItem2, item);
            }
            ++n2;
        }
    }

    public static String getId(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.length() == 0) {
            id = WorkbenchWindow.getCommandId(element);
        }
        if (id == null || id.length() == 0) {
            id = element.toString();
        }
        return id;
    }

    public static String getCommandId(IConfigurationElement element) {
        return element.getAttribute("commandId");
    }

    public static String getActionSetCommandId(IConfigurationElement element) {
        String id = WorkbenchWindow.getDefinitionId(element);
        if (id != null) {
            return id;
        }
        id = WorkbenchWindow.getId(element);
        String actionSetId = null;
        Object obj = element.getParent();
        while (obj instanceof IConfigurationElement && actionSetId == null) {
            IConfigurationElement parent = (IConfigurationElement)obj;
            if (parent.getName().equals("actionSet")) {
                actionSetId = WorkbenchWindow.getId(parent);
            }
            obj = parent.getParent();
        }
        return ACTION_SET_CMD_PREFIX + actionSetId + '/' + id;
    }

    public static String getDefinitionId(IConfigurationElement element) {
        return element.getAttribute("definitionId");
    }

    public static boolean getRetarget(IConfigurationElement element) {
        String r = element.getAttribute("retarget");
        return Boolean.valueOf(r);
    }

    protected int perspectiveBarStyle() {
        return 8520000;
    }

    private void firePageClosed() {
        this.pageListeners.firePageClosed(this.page);
    }

    private void firePageOpened() {
        this.pageListeners.firePageOpened(this.page);
    }

    private void firePageActivated() {
        this.pageListeners.firePageActivated(this.page);
    }

    void registerGlobalAction(IAction globalAction) {
        String commandId = globalAction.getActionDefinitionId();
        if (commandId != null) {
            Object value = this.globalActionHandlersByCommandId.get(commandId);
            if (value instanceof ActionHandler) {
                ActionHandler handler = (ActionHandler)value;
                handler.dispose();
            }
            if (globalAction instanceof CommandAction) {
                String actionId = globalAction.getId();
                if (actionId != null) {
                    IActionCommandMappingService mappingService = (IActionCommandMappingService)this.serviceLocator.getService(IActionCommandMappingService.class);
                    mappingService.map(actionId, commandId);
                }
            } else {
                this.globalActionHandlersByCommandId.put(commandId, new ActionHandler(globalAction));
            }
        }
        this.submitGlobalActions();
    }

    void submitGlobalActions() {
        IHandlerService handlerService = (IHandlerService)this.getService(IHandlerService.class);
        HashMap handlersByCommandId = new HashMap();
        handlersByCommandId.putAll(this.globalActionHandlersByCommandId);
        ArrayList<IHandlerActivation> newHandlers = new ArrayList<IHandlerActivation>(handlersByCommandId.size());
        for (IHandlerActivation next : this.handlerActivations) {
            String cmdId = next.getCommandId();
            Object handler = handlersByCommandId.get(cmdId);
            if (handler == next.getHandler()) {
                handlersByCommandId.remove(cmdId);
                newHandlers.add(next);
                continue;
            }
            handlerService.deactivateHandler(next);
        }
        Shell shell = this.getShell();
        if (shell != null) {
            ActiveShellExpression expression = new ActiveShellExpression(shell);
            for (Map.Entry entry : handlersByCommandId.entrySet()) {
                String commandId = (String)entry.getKey();
                IHandler handler = (IHandler)entry.getValue();
                newHandlers.add(handlerService.activateHandler(commandId, handler, expression));
            }
        }
        this.handlerActivations = newHandlers;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.genericPropertyListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.genericPropertyListeners.remove((Object)listener);
    }

    private void firePropertyChanged(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
        Object[] listeners = this.genericPropertyListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            listener.propertyChange(event);
            ++i;
        }
    }

    public void addPageListener(IPageListener l) {
        this.pageListeners.addPageListener(l);
    }

    public void addPerspectiveListener(IPerspectiveListener l) {
        this.perspectiveListeners.addPerspectiveListener(l);
    }

    private boolean busyClose(boolean remove) {
        boolean windowClosed = false;
        this.closing = true;
        this.updateDisabled = true;
        try {
            Workbench workbench = this.getWorkbenchImpl();
            int count = workbench.getWorkbenchWindowCount();
            if (!workbench.isStarting() && !workbench.isClosing() && count <= 1 && workbench.getWorkbenchConfigurer().getExitOnLastWindowClose()) {
                windowClosed = workbench.close();
            } else if (this.okToClose()) {
                windowClosed = this.hardClose(remove);
            }
        }
        finally {
            if (!windowClosed) {
                this.closing = false;
                this.updateDisabled = false;
            }
        }
        if (windowClosed && this.tracker != null) {
            this.tracker.close();
        }
        return windowClosed;
    }

    public Shell getShell() {
        return (Shell)this.model.getWidget();
    }

    public boolean close(final boolean remove) {
        final boolean[] ret = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ret[0] = WorkbenchWindow.this.busyClose(remove);
            }
        });
        return ret[0];
    }

    void setRestarting(boolean restarting) {
        this.restarting = restarting;
    }

    public boolean close() {
        return this.close(true);
    }

    protected boolean isClosing() {
        return this.closing || this.getWorkbenchImpl().isClosing();
    }

    private void fireWindowOpening() {
        this.getWindowAdvisor().preWindowOpen();
    }

    void fireWindowOpened() {
        this.getWindowAdvisor().postWindowOpen();
    }

    void fireWindowRestored() throws WorkbenchException {
        StartupThreading.runWithWorkbenchExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() throws Throwable {
                WorkbenchWindow.this.getWindowAdvisor().postWindowRestore();
            }
        });
    }

    private void fireWindowClosed() {
        this.getWindowAdvisor().postWindowClose();
        this.getWorkbenchImpl().fireWindowClosed(this);
    }

    void firePerspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectiveActivated");
        this.perspectiveListeners.firePerspectiveActivated(page, perspective);
    }

    void firePerspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectivePreDeactivate");
        this.perspectiveListeners.firePerspectivePreDeactivate(page, perspective);
    }

    void firePerspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectiveDeactivated");
        this.perspectiveListeners.firePerspectiveDeactivated(page, perspective);
    }

    public void firePerspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (perspective != null) {
            UIListenerLogging.logPerspectiveChangedEvent(this, page, perspective, null, changeId);
            this.perspectiveListeners.firePerspectiveChanged(page, perspective, changeId);
        }
    }

    public void firePerspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        if (perspective != null) {
            UIListenerLogging.logPerspectiveChangedEvent(this, page, perspective, partRef, changeId);
            this.perspectiveListeners.firePerspectiveChanged(page, perspective, partRef, changeId);
        }
    }

    void firePerspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectiveClosed");
        this.perspectiveListeners.firePerspectiveClosed(page, perspective);
    }

    void firePerspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectiveOpened");
        this.perspectiveListeners.firePerspectiveOpened(page, perspective);
    }

    void firePerspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
        UIListenerLogging.logPerspectiveSavedAs(this, page, oldPerspective, newPerspective);
        this.perspectiveListeners.firePerspectiveSavedAs(page, oldPerspective, newPerspective);
    }

    public WWinActionBars getActionBars() {
        if (this.actionBars == null) {
            this.actionBars = new WWinActionBars(this);
        }
        return this.actionBars;
    }

    public IWorkbenchPage getActivePage() {
        return this.page;
    }

    public int getNumber() {
        return this.number;
    }

    public IWorkbenchPage[] getPages() {
        IWorkbenchPage[] iWorkbenchPageArray;
        if (this.page == null) {
            iWorkbenchPageArray = new IWorkbenchPage[]{};
        } else {
            IWorkbenchPage[] iWorkbenchPageArray2 = new IWorkbenchPage[1];
            iWorkbenchPageArray = iWorkbenchPageArray2;
            iWorkbenchPageArray2[0] = this.page;
        }
        return iWorkbenchPageArray;
    }

    public IPartService getPartService() {
        return this.partService;
    }

    protected Layout getLayout() {
        return null;
    }

    public ISelectionService getSelectionService() {
        return this.selectionService;
    }

    public boolean getShellActivated() {
        return this.shellActivated;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    private boolean hardClose(boolean remove) {
        try {
            IWorkbench workbench = this.getWorkbench();
            IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
            handlerService.deactivateHandlers(this.handlerActivations);
            for (IHandlerActivation activation : this.handlerActivations) {
                activation.getHandler().dispose();
            }
            this.handlerActivations.clear();
            this.globalActionHandlersByCommandId.clear();
            IContextService contextService = (IContextService)workbench.getService(IContextService.class);
            contextService.unregisterShell(this.getShell());
            this.firePageClosed();
            this.fireWindowClosed();
            IMenuService menuService = (IMenuService)workbench.getService(IMenuService.class);
            menuService.releaseContributions((ContributionManager)this.getActionBars().getMenuManager());
            ICoolBarManager coolbar = this.getActionBars().getCoolBarManager();
            if (coolbar != null) {
                menuService.releaseContributions((ContributionManager)coolbar);
            }
            this.getActionBarAdvisor().dispose();
            this.getWindowAdvisor().dispose();
            this.progressRegion = null;
            MTrimmedWindow window = this.model;
            this.engine.removeGui((MUIElement)this.model);
            MElementContainer parent = window.getParent();
            if (remove) {
                parent.getChildren().remove(window);
                if (parent.getSelectedElement() == window && !parent.getChildren().isEmpty()) {
                    parent.setSelectedElement((MUIElement)parent.getChildren().get(0));
                }
            }
        }
        finally {
            try {
                this.serviceLocator.dispose();
            }
            catch (Exception ex) {
                WorkbenchPlugin.log(ex);
            }
            this.menuRestrictions.clear();
        }
        return true;
    }

    public boolean isApplicationMenu(String menuID) {
        return this.getActionBarAdvisor().isApplicationMenu(menuID);
    }

    private boolean okToClose() {
        IWorkbenchPage page;
        if (!this.getWorkbenchImpl().isClosing() && (page = this.getActivePage()) != null) {
            return ((WorkbenchPage)page).saveAllEditors(true, true);
        }
        return true;
    }

    public IWorkbenchPage openPage(String perspectiveId, IAdaptable input) throws WorkbenchException {
        IPerspectiveDescriptor descriptor = this.workbench.getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (descriptor == null) {
            throw new WorkbenchException(NLS.bind((String)WorkbenchMessages.WorkbenchPage_ErrorCreatingPerspective, (Object)perspectiveId));
        }
        if (this.page == null) {
            this.page = new WorkbenchPage(this, input);
            this.model.getContext().set(IWorkbenchPage.class.getName(), (Object)this.page);
            try {
                ContextInjectionFactory.inject((Object)this.page, (IEclipseContext)this.model.getContext());
            }
            catch (InjectionException e) {
                throw new WorkbenchException(e.getMessage(), e);
            }
            this.firePageOpened();
            this.partService.setPage(this.page);
        }
        this.perspective = descriptor;
        this.page.setPerspective(this.perspective);
        this.firePageActivated();
        return this.page;
    }

    public IWorkbenchPage openPage(IAdaptable input) throws WorkbenchException {
        return this.openPage(this.workbench.getPerspectiveRegistry().getDefaultPerspective(), input);
    }

    public void removePageListener(IPageListener l) {
        this.pageListeners.removePageListener(l);
    }

    public void removePerspectiveListener(IPerspectiveListener l) {
        this.perspectiveListeners.removePerspectiveListener(l);
    }

    public void run(final boolean fork, boolean cancelable, final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        boolean progressHack;
        final StatusLineManager manager = this.getStatusLineManager();
        boolean bl = progressHack = manager.getControl() == null;
        if (manager == null || progressHack) {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        } else {
            boolean wasCancelEnabled = manager.isCancelEnabled();
            try {
                manager.setCancelEnabled(cancelable);
                final InvocationTargetException[] ite = new InvocationTargetException[1];
                final InterruptedException[] ie = new InterruptedException[1];
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            try {
                                ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)manager.getProgressMonitor(), (Display)WorkbenchWindow.this.getShell().getDisplay());
                            }
                            catch (InvocationTargetException e) {
                                ite[0] = e;
                                manager.getProgressMonitor().done();
                            }
                            catch (InterruptedException e) {
                                ie[0] = e;
                                manager.getProgressMonitor().done();
                            }
                        }
                        finally {
                            manager.getProgressMonitor().done();
                        }
                    }
                });
                if (ite[0] != null) {
                    throw ite[0];
                }
                if (ie[0] != null) {
                    throw ie[0];
                }
            }
            finally {
                manager.setCancelEnabled(wasCancelEnabled);
            }
        }
    }

    public void setActivePage(IWorkbenchPage in) {
        if (this.getActivePage() != in) {
            if (in == null) {
                this.firePageClosed();
            }
            this.page = (WorkbenchPage)in;
            this.model.getContext().set(IWorkbenchPage.class, (Object)this.page);
            this.partService.setPage(this.page);
        }
    }

    private Boolean valueOf(boolean result) {
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public Set getMenuRestrictions() {
        return this.menuRestrictions;
    }

    void liftRestrictions() {
        IMenuService ms;
        if (this.menuRestrictions.isEmpty()) {
            return;
        }
        EvaluationReference[] refs = this.menuRestrictions.toArray(new EvaluationReference[this.menuRestrictions.size()]);
        IEvaluationService es = (IEvaluationService)this.serviceLocator.getService(IEvaluationService.class);
        IEvaluationContext currentState = es.getCurrentState();
        boolean changeDetected = false;
        int i = 0;
        while (i < refs.length) {
            EvaluationReference reference = refs[i];
            reference.setPostingChanges(true);
            boolean os = reference.evaluate(currentState);
            reference.clearResult();
            boolean ns = reference.evaluate(currentState);
            if (os != ns) {
                changeDetected = true;
                reference.getListener().propertyChange(new PropertyChangeEvent((Object)reference, reference.getProperty(), (Object)this.valueOf(os), (Object)this.valueOf(ns)));
            }
            ++i;
        }
        if (changeDetected && (ms = (IMenuService)this.getWorkbench().getService(IMenuService.class)) instanceof WorkbenchMenuService) {
            ((WorkbenchMenuService)ms).updateManagers();
        }
    }

    void imposeRestrictions() {
        for (EvaluationReference ref : this.menuRestrictions) {
            ref.setPostingChanges(false);
        }
    }

    private void trackShellActivation() {
        this.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent event) {
                WorkbenchWindow.this.shellActivated = true;
                WorkbenchWindow.this.serviceLocator.activate();
                if (WorkbenchWindow.this.getActivePage() != null) {
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowActivated(WorkbenchWindow.this);
                }
                WorkbenchWindow.this.liftRestrictions();
            }

            public void shellDeactivated(ShellEvent event) {
                WorkbenchWindow.this.shellActivated = false;
                WorkbenchWindow.this.imposeRestrictions();
                WorkbenchWindow.this.serviceLocator.deactivate();
                if (WorkbenchWindow.this.getActivePage() != null) {
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowDeactivated(WorkbenchWindow.this);
                }
            }
        });
    }

    public void updateActionBars() {
        if (this.updateDisabled || this.updatesDeferred()) {
            return;
        }
    }

    private boolean updatesDeferred() {
        return this.largeUpdates > 0;
    }

    public final void largeUpdateStart() {
        ++this.largeUpdates;
    }

    public final void largeUpdateEnd() {
        if (--this.largeUpdates == 0) {
            this.updateActionBars();
        }
    }

    public void updateActionSets() {
        if (this.updateDisabled) {
            return;
        }
    }

    final void addActionSetsListener(IActionSetsListener listener) {
        if (this.actionSetListeners == null) {
            this.actionSetListeners = new ListenerList();
        }
        this.actionSetListeners.add((Object)listener);
    }

    final void removeActionSetsListener(IActionSetsListener listener) {
        if (this.actionSetListeners != null) {
            this.actionSetListeners.remove((Object)listener);
            if (this.actionSetListeners.isEmpty()) {
                this.actionSetListeners = null;
            }
        }
    }

    private boolean getShowHeapStatus() {
        return PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_MEMORY_MONITOR") || Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.ui/perf/showHeapStatus")) != false;
    }

    public void showHeapStatus(boolean show) {
        MUIElement hsElement = this.modelService.find("org.eclipse.ui.HeapStatus", (MUIElement)this.modelService.getTrim(this.model, SideValue.BOTTOM));
        if (hsElement != null && hsElement.isToBeRendered() != show) {
            hsElement.setToBeRendered(show);
            this.getShell().layout(null, 7);
        }
    }

    WorkbenchWindowConfigurer getWindowConfigurer() {
        if (this.windowConfigurer == null) {
            this.windowConfigurer = new WorkbenchWindowConfigurer(this);
        }
        return this.windowConfigurer;
    }

    private WorkbenchAdvisor getAdvisor() {
        return this.getWorkbenchImpl().getAdvisor();
    }

    WorkbenchWindowAdvisor getWindowAdvisor() {
        if (this.windowAdvisor == null) {
            this.windowAdvisor = this.getAdvisor().createWorkbenchWindowAdvisor(this.getWindowConfigurer());
            Assert.isNotNull((Object)this.windowAdvisor);
        }
        return this.windowAdvisor;
    }

    private ActionBarAdvisor getActionBarAdvisor() {
        if (this.actionBarAdvisor == null) {
            this.actionBarAdvisor = this.getWindowAdvisor().createActionBarAdvisor(this.getWindowConfigurer().getActionBarConfigurer());
            Assert.isNotNull((Object)this.actionBarAdvisor);
        }
        return this.actionBarAdvisor;
    }

    private Workbench getWorkbenchImpl() {
        return Workbench.getInstance();
    }

    public void fillActionBars(int flags) {
        Workbench workbench = this.getWorkbenchImpl();
        workbench.largeUpdateStart();
        try {
            this.getActionBarAdvisor().fillActionBars(flags);
            IMenuService menuService = (IMenuService)this.serviceLocator.getService(IMenuService.class);
            menuService.populateContributionManager((ContributionManager)this.getActionBars().getMenuManager(), "menu:org.eclipse.ui.main.menu");
            ICoolBarManager coolbar = this.getActionBars().getCoolBarManager();
            if (coolbar != null) {
                menuService.populateContributionManager((ContributionManager)coolbar, "toolbar:org.eclipse.ui.main.toolbar");
            }
        }
        finally {
            workbench.largeUpdateEnd();
        }
    }

    public void fillActionBars(IActionBarConfigurer2 proxyBars, int flags) {
        Assert.isNotNull((Object)proxyBars);
        WorkbenchWindowConfigurer.WindowActionBarConfigurer wab = (WorkbenchWindowConfigurer.WindowActionBarConfigurer)this.getWindowConfigurer().getActionBarConfigurer();
        wab.setProxy(proxyBars);
        try {
            this.getActionBarAdvisor().fillActionBars(flags | 1);
        }
        finally {
            wab.setProxy(null);
        }
    }

    public void setCoolBarVisible(boolean visible) {
        boolean oldValue = this.coolBarVisible;
        this.coolBarVisible = visible;
        if (oldValue != this.coolBarVisible) {
            this.firePropertyChanged(PROP_COOLBAR_VISIBLE, oldValue ? Boolean.TRUE : Boolean.FALSE, this.coolBarVisible ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getCoolBarVisible() {
        return this.getWindowConfigurer().getShowCoolBar() && this.coolBarVisible;
    }

    public void setPerspectiveBarVisible(boolean visible) {
        boolean oldValue = this.perspectiveBarVisible;
        this.perspectiveBarVisible = visible;
        if (oldValue != this.perspectiveBarVisible) {
            this.firePropertyChanged(PROP_PERSPECTIVEBAR_VISIBLE, oldValue ? Boolean.TRUE : Boolean.FALSE, this.perspectiveBarVisible ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getPerspectiveBarVisible() {
        return this.getWindowConfigurer().getShowPerspectiveBar() && this.perspectiveBarVisible;
    }

    public void setFastViewBarVisible(boolean visible) {
        boolean oldValue = this.fastViewBarVisible;
        this.fastViewBarVisible = visible;
    }

    public boolean getFastViewBarVisible() {
        return this.fastViewBarVisible;
    }

    public void setStatusLineVisible(boolean visible) {
        boolean oldValue = this.statusLineVisible;
        this.statusLineVisible = visible;
        if (oldValue != this.statusLineVisible) {
            this.firePropertyChanged(PROP_STATUS_LINE_VISIBLE, oldValue ? Boolean.TRUE : Boolean.FALSE, this.statusLineVisible ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getStatusLineVisible() {
        return this.statusLineVisible;
    }

    public boolean getShowFastViewBars() {
        return this.getWindowConfigurer().getShowFastViewBars();
    }

    public IActionBarPresentationFactory getActionBarPresentationFactory() {
        E4Util.unsupported("getActionBarPresentationFactory: doesn't do anything useful, should cause NPE");
        IActionBarPresentationFactory actionBarPresentation = null;
        AbstractPresentationFactory presentationFactory = this.getWindowConfigurer().getPresentationFactory();
        if (presentationFactory instanceof IActionBarPresentationFactory) {
            actionBarPresentation = (IActionBarPresentationFactory)((Object)presentationFactory);
        }
        return actionBarPresentation;
    }

    protected boolean showTopSeperator() {
        return false;
    }

    public ProgressRegion getProgressRegion() {
        return this.progressRegion;
    }

    public IExtensionTracker getExtensionTracker() {
        return (IExtensionTracker)this.model.getContext().get(IExtensionTracker.class.getName());
    }

    IAdaptable getDefaultPageInput() {
        return this.getWorkbenchImpl().getDefaultPageInput();
    }

    public ITrimManager getTrimManager() {
        return null;
    }

    private final void initializeDefaultServices() {
        IEclipseContext windowContext = this.model.getContext();
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.IWorkbenchWindow", this.getWorkbench(), this, null, null, null, 1));
        this.serviceLocator.registerService(IWorkbenchWindow.class, this);
        ActionCommandMappingService mappingService = new ActionCommandMappingService();
        this.serviceLocator.registerService(IActionCommandMappingService.class, mappingService);
        this.selectionService = (ISelectionService)ContextInjectionFactory.make(SelectionService.class, (IEclipseContext)this.model.getContext());
        this.serviceLocator.registerService(ISelectionService.class, this.selectionService);
        LegacyHandlerService hs = new LegacyHandlerService(windowContext);
        windowContext.set(IHandlerService.class.getName(), (Object)hs);
        LegacyActionPersistence actionPersistence = new LegacyActionPersistence(this);
        this.serviceLocator.registerService(LegacyActionPersistence.class, actionPersistence);
        actionPersistence.read();
    }

    public final Object getService(Class key) {
        return this.serviceLocator.getService(key);
    }

    public final boolean hasService(Class key) {
        return this.serviceLocator.hasService(key);
    }

    public void toggleToolbarVisibility() {
        MTrimBar topTrim = this.getTopTrim();
        if (topTrim != null) {
            if (topTrim.isToBeRendered()) {
                IPresentationEngine presentationEngine = (IPresentationEngine)this.model.getContext().get(IPresentationEngine.class);
                topTrim.setToBeRendered(false);
                presentationEngine.removeGui((MUIElement)topTrim);
            } else {
                IPresentationEngine presentationEngine = (IPresentationEngine)this.model.getContext().get(IPresentationEngine.class);
                topTrim.setToBeRendered(true);
                presentationEngine.createGui((MUIElement)topTrim, this.model.getWidget(), this.model.getContext());
            }
            this.getShell().layout();
        }
    }

    void addBackgroundSaveListener(IBackgroundSaveListener listener) {
        this.backgroundSaveListeners.add((Object)listener);
    }

    void fireBackgroundSaveStarted() {
        Object[] listeners = this.backgroundSaveListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IBackgroundSaveListener listener = (IBackgroundSaveListener)listeners[i];
            listener.handleBackgroundSaveStarted();
            ++i;
        }
    }

    void removeBackgroundSaveListener(IBackgroundSaveListener listener) {
        this.backgroundSaveListeners.remove((Object)listener);
    }

    public MWindow getModel() {
        return this.model;
    }

    public StatusLineManager getStatusLineManager() {
        if (this.statusLineManager == null) {
            this.statusLineManager = new StatusLineManager();
        }
        return this.statusLineManager;
    }

    public ICoolBarManager getCoolBarManager2() {
        return this.cm2;
    }

    public CoolBarManager getCoolBarManager() {
        return this.cm2;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public IMenuManager getMenuBarManager() {
        return this.menuManager;
    }

    public IToolBarManager2 getToolBarManager2() {
        return this.toolBarManager;
    }

    public IToolBarManager getToolBarManager() {
        return this.getToolBarManager2();
    }
}

