/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.internal.ContentChangeNotifier;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.runtime.CoreException;

public abstract class BufferedContent
implements IContentChangeNotifier,
IStreamContentAccessor {
    byte[] fContent;
    private ContentChangeNotifier fChangeNotifier;

    protected BufferedContent() {
    }

    public InputStream getContents() throws CoreException {
        if (this.fContent != null) {
            return new ByteArrayInputStream(this.fContent);
        }
        return this.createStream();
    }

    protected abstract InputStream createStream() throws CoreException;

    public void setContent(byte[] contents) {
        this.fContent = contents;
        this.fireContentChanged();
    }

    public byte[] getContent() {
        if (this.fContent == null) {
            try {
                InputStream is = this.createStream();
                this.fContent = Utilities.readBytes(is);
            }
            catch (CoreException coreException) {}
        }
        return this.fContent;
    }

    public void discardBuffer() {
        this.fContent = null;
    }

    public void addContentChangeListener(IContentChangeListener listener) {
        if (this.fChangeNotifier == null) {
            this.fChangeNotifier = new ContentChangeNotifier(this);
        }
        this.fChangeNotifier.addContentChangeListener(listener);
    }

    public void removeContentChangeListener(IContentChangeListener listener) {
        if (this.fChangeNotifier != null) {
            this.fChangeNotifier.removeContentChangeListener(listener);
            if (this.fChangeNotifier.isEmpty()) {
                this.fChangeNotifier = null;
            }
        }
    }

    protected void fireContentChanged() {
        if (this.fChangeNotifier == null || this.fChangeNotifier.isEmpty()) {
            return;
        }
        this.fChangeNotifier.fireContentChanged();
    }
}

