/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.keys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.KeyAssistDialog;
import org.eclipse.e4.ui.bindings.keys.OutOfOrderListener;
import org.eclipse.e4.ui.bindings.keys.OutOfOrderVerifyListener;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyBindingDispatcher {
    private KeyAssistDialog keyAssistDialog = null;
    static KeySequence outOfOrderKeys;
    private static final int DELAY = 1000;
    private EBindingService bindingService;
    private IEclipseContext context;
    private EHandlerService handlerService;
    private final KeyDownFilter keyDownFilter = new KeyDownFilter();
    private final OutOfOrderListener outOfOrderListener = new OutOfOrderListener(this);
    private final OutOfOrderVerifyListener outOfOrderVerifyListener = new OutOfOrderVerifyListener(this.outOfOrderListener);
    private KeySequence state = KeySequence.getInstance();
    private long startTime;
    @Inject
    @Optional
    private Logger logger;

    static {
        try {
            outOfOrderKeys = KeySequence.getInstance((String)"ESC DEL");
        }
        catch (ParseException parseException) {
            outOfOrderKeys = KeySequence.getInstance();
        }
    }

    public static List<KeyStroke> generatePossibleKeyStrokes(Event event) {
        int thirdAccelerator;
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(3);
        if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
            return keyStrokes;
        }
        int firstAccelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event);
        keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)firstAccelerator));
        if (event.character == '\u007f') {
            return keyStrokes;
        }
        int secondAccelerator = SWTKeySupport.convertEventToUnshiftedModifiedAccelerator((Event)event);
        if (secondAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)secondAccelerator));
        }
        if ((thirdAccelerator = SWTKeySupport.convertEventToModifiedAccelerator((Event)event)) != secondAccelerator && thirdAccelerator != firstAccelerator) {
            keyStrokes.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)thirdAccelerator));
        }
        return keyStrokes;
    }

    private static boolean isOutOfOrderKey(List<KeyStroke> keyStrokes) {
        KeyStroke[] outOfOrderKeyStrokes = outOfOrderKeys.getKeyStrokes();
        int outOfOrderKeyStrokesLength = outOfOrderKeyStrokes.length;
        int i = 0;
        while (i < outOfOrderKeyStrokesLength) {
            if (keyStrokes.contains(outOfOrderKeyStrokes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean executeCommand(ParameterizedCommand parameterizedCommand, Event trigger) throws CommandException {
        boolean commandHandled;
        this.resetState(false);
        EHandlerService handlerService = this.getHandlerService();
        Command command = parameterizedCommand.getCommand();
        boolean commandDefined = command.isDefined();
        boolean commandEnabled = handlerService.canExecute(parameterizedCommand);
        boolean bl = commandHandled = HandlerServiceImpl.lookUpHandler((IEclipseContext)this.context, (String)command.getId()) != null;
        if (!commandEnabled && commandHandled && commandDefined) {
            if (this.keyAssistDialog != null) {
                this.keyAssistDialog.clearRememberedState();
            }
            return true;
        }
        if (commandEnabled) {
            block6: {
                try {
                    handlerService.executeHandler(parameterizedCommand);
                }
                catch (Exception e) {
                    commandHandled = false;
                    if (this.logger == null) break block6;
                    this.logger.error((Throwable)e);
                }
            }
            if (this.keyAssistDialog != null) {
                this.keyAssistDialog.clearRememberedState();
            }
        }
        return commandDefined && commandHandled;
    }

    private void filterKeySequenceBindings(Event event) {
        if ((event.keyCode & SWT.MODIFIER_MASK) != 0) {
            return;
        }
        List<KeyStroke> keyStrokes = KeyBindingDispatcher.generatePossibleKeyStrokes(event);
        if (KeyBindingDispatcher.isOutOfOrderKey(keyStrokes)) {
            Widget widget = event.widget;
            if (event.character == '\u007f' && (event.stateMask & SWT.MODIFIER_MASK) == 0 && (widget instanceof Text || widget instanceof Combo || widget instanceof Browser)) {
                return;
            }
            if (widget instanceof StyledText) {
                if (event.type == 1 && !this.outOfOrderVerifyListener.isActive(event.time)) {
                    ((StyledText)widget).addVerifyKeyListener((VerifyKeyListener)this.outOfOrderVerifyListener);
                    this.outOfOrderVerifyListener.setActive(event.time);
                }
            } else if (!this.outOfOrderListener.isActive(event.time)) {
                widget.addListener(1, (Listener)this.outOfOrderListener);
                this.outOfOrderListener.setActive(event.time);
            }
        } else {
            this.processKeyEvent(keyStrokes, event);
        }
    }

    private EBindingService getBindingService() {
        if (this.bindingService == null) {
            this.bindingService = (EBindingService)this.context.get(EBindingService.class.getName());
        }
        return this.bindingService;
    }

    private EHandlerService getHandlerService() {
        if (this.handlerService == null) {
            this.handlerService = (EHandlerService)this.context.get(EHandlerService.class.getName());
        }
        return this.handlerService;
    }

    private Display getDisplay() {
        return Display.getCurrent();
    }

    public KeyDownFilter getKeyDownFilter() {
        return this.keyDownFilter;
    }

    private ParameterizedCommand getPerfectMatch(KeySequence keySequence) {
        Binding perfectMatch = this.getBindingService().getPerfectMatch((TriggerSequence)keySequence);
        return perfectMatch == null ? null : perfectMatch.getParameterizedCommand();
    }

    private void incrementState(final KeySequence sequence) {
        this.state = sequence;
        final long myStartTime = this.startTime = System.currentTimeMillis();
        Display display = this.getDisplay();
        display.timerExec(1000, new Runnable(){

            public void run() {
                if (System.currentTimeMillis() > myStartTime - 1000L && KeyBindingDispatcher.this.startTime == myStartTime) {
                    Collection<Binding> partialMatches = KeyBindingDispatcher.this.bindingService.getPartialMatches((TriggerSequence)sequence);
                    KeyBindingDispatcher.this.openKeyAssistShell(partialMatches);
                }
            }
        });
    }

    public final void openMultiKeyAssistShell() {
        if (this.keyAssistDialog == null) {
            this.keyAssistDialog = new KeyAssistDialog(this.context, this, this.state);
        }
        if (this.keyAssistDialog.getShell() == null) {
            this.keyAssistDialog.setParentShell(this.getDisplay().getActiveShell());
        }
        this.keyAssistDialog.open();
    }

    public final void openKeyAssistShell(Collection<Binding> bindings) {
        if (this.keyAssistDialog == null) {
            this.keyAssistDialog = new KeyAssistDialog(this.context, this, this.state);
        }
        if (this.keyAssistDialog.getShell() == null) {
            this.keyAssistDialog.setParentShell(this.getDisplay().getActiveShell());
        }
        this.keyAssistDialog.open(bindings);
    }

    private boolean isPartialMatch(KeySequence keySequence) {
        return this.getBindingService().isPartialMatch((TriggerSequence)keySequence);
    }

    private boolean isPerfectMatch(KeySequence keySequence) {
        return this.getBindingService().isPerfectMatch((TriggerSequence)keySequence);
    }

    public boolean press(List<KeyStroke> potentialKeyStrokes, Event event) {
        KeySequence errorSequence = null;
        Collection<Binding> errorMatch = null;
        KeySequence sequenceBeforeKeyStroke = this.state;
        Iterator<KeyStroke> iterator = potentialKeyStrokes.iterator();
        while (iterator.hasNext()) {
            KeySequence sequenceAfterKeyStroke = KeySequence.getInstance((KeySequence)sequenceBeforeKeyStroke, (KeyStroke)iterator.next());
            if (this.isPartialMatch(sequenceAfterKeyStroke)) {
                this.incrementState(sequenceAfterKeyStroke);
                return true;
            }
            if (this.isPerfectMatch(sequenceAfterKeyStroke)) {
                ParameterizedCommand cmd = this.getPerfectMatch(sequenceAfterKeyStroke);
                try {
                    return this.executeCommand(cmd, event) || !sequenceBeforeKeyStroke.isEmpty();
                }
                catch (CommandException commandException) {
                    return true;
                }
            }
            if (this.keyAssistDialog != null && this.keyAssistDialog.getShell() != null && (event.keyCode == 0x1000002 || event.keyCode == 0x1000001 || event.keyCode == 0x1000003 || event.keyCode == 0x1000004 || event.keyCode == 13 || event.keyCode == 0x1000005 || event.keyCode == 0x1000006)) {
                return false;
            }
            Collection<Binding> matches = this.getBindingService().getConflictsFor((TriggerSequence)sequenceAfterKeyStroke);
            if (matches == null || matches.isEmpty()) continue;
            errorSequence = sequenceAfterKeyStroke;
            errorMatch = matches;
        }
        this.resetState(true);
        if (sequenceBeforeKeyStroke.isEmpty() && errorSequence != null) {
            this.openKeyAssistShell(errorMatch);
        }
        return !sequenceBeforeKeyStroke.isEmpty();
    }

    void processKeyEvent(List<KeyStroke> keyStrokes, Event event) {
        boolean eatKey = false;
        if (!keyStrokes.isEmpty()) {
            eatKey = this.press(keyStrokes, event);
        }
        if (eatKey) {
            switch (event.type) {
                case 1: {
                    event.doit = false;
                    break;
                }
                case 31: {
                    event.detail = 0;
                    event.doit = true;
                }
            }
            event.type = 0;
        }
    }

    private void resetState(boolean clearRememberedState) {
        this.startTime = Long.MAX_VALUE;
        this.state = KeySequence.getInstance();
        this.closeMultiKeyAssistShell();
        if (this.keyAssistDialog != null && clearRememberedState) {
            this.keyAssistDialog.clearRememberedState();
        }
    }

    public final KeySequence getBuffer() {
        return this.state;
    }

    @Inject
    public void setContext(IEclipseContext context) {
        this.context = context;
    }

    private void closeMultiKeyAssistShell() {
        Shell shell;
        if (this.keyAssistDialog != null && (shell = this.keyAssistDialog.getShell()) != null && !shell.isDisposed() && shell.isVisible()) {
            this.keyAssistDialog.close(true);
        }
    }

    public final class KeyDownFilter
    implements Listener {
        private transient boolean enabled = true;

        public final void handleEvent(Event event) {
            if (!this.enabled) {
                return;
            }
            KeyBindingDispatcher.this.filterKeySequenceBindings(event);
        }

        public final boolean isEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

