/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyStackRenderer
extends SWTPartRenderer {
    public static final String TAG_VIEW_MENU = "ViewMenu";
    static final String TOOL_BAR_MANAGER_RENDERER_VIEW_MENU = "StackRenderer.viewMenu";
    static final String TOOL_BAR_INTERMEDIATE = "StackRenderer.intermediate";
    private EventHandler lazyLoader = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            Object element = event.getProperty("ChangedElement");
            if (!(element instanceof MGenericStack)) {
                return;
            }
            MGenericStack stack = (MGenericStack)element;
            if (stack.getRenderer() != LazyStackRenderer.this) {
                return;
            }
            LazyStackRenderer lsr = (LazyStackRenderer)((Object)stack.getRenderer());
            MUIElement oldSel = (MUIElement)event.getProperty("OldValue");
            if (oldSel != null) {
                ArrayList goingHidden = new ArrayList();
                LazyStackRenderer.this.hideElementRecursive(oldSel, goingHidden);
            }
            if (stack.getSelectedElement() != null) {
                lsr.showTab(stack.getSelectedElement());
            }
        }
    };
    Image viewMenuImage;
    @Inject
    IPresentationEngine renderer;

    public void init(IEventBroker eventBroker) {
        eventBroker.unsubscribe(this.lazyLoader);
        eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement"), this.lazyLoader);
    }

    public void contextDisposed(IEventBroker eventBroker) {
        eventBroker.unsubscribe(this.lazyLoader);
    }

    public void postProcess(MUIElement element) {
        if (!(element instanceof MGenericStack)) {
            return;
        }
        MGenericStack stack = (MGenericStack)element;
        MUIElement selPart = stack.getSelectedElement();
        if (selPart != null) {
            this.showTab(selPart);
        } else if (stack.getChildren().size() > 0) {
            for (MUIElement kid : stack.getChildren()) {
                if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                stack.setSelectedElement(kid);
                break;
            }
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> me) {
        for (MUIElement part : me.getChildren()) {
            if (!part.isToBeRendered() || !part.isVisible()) continue;
            this.createTab(me, part);
        }
    }

    protected void createTab(MElementContainer<MUIElement> me, MUIElement part) {
    }

    protected void showTab(MUIElement element) {
        ArrayList<MUIElement> becomingVisible = new ArrayList<MUIElement>();
        MUIElement curSel = element.getParent().getSelectedElement();
        if (curSel != null) {
            this.showElementRecursive(curSel, becomingVisible);
        }
    }

    private void hideElementRecursive(MUIElement element, List<MUIElement> goingHidden) {
        block11: {
            block12: {
                MGenericStack container;
                block10: {
                    if (element == null || element.getWidget() == null) {
                        return;
                    }
                    if (element instanceof MPlaceholder) {
                        CTabFolder ctf;
                        MPlaceholder ph = (MPlaceholder)element;
                        MUIElement ref = ph.getRef();
                        if (ref instanceof MPart && ph.getParent() != null && ph.getParent().getWidget() instanceof CTabFolder && (ctf = (CTabFolder)ph.getParent().getWidget()).getTopRight() != null) {
                            Control curTB = ctf.getTopRight();
                            ctf.setTopRight(null);
                            if (!curTB.isDisposed()) {
                                MUIElement tbME = (MUIElement)curTB.getData("modelElement");
                                if (tbME instanceof MToolBar) {
                                    curTB.setVisible(false);
                                    curTB.moveBelow(null);
                                } else {
                                    curTB.dispose();
                                }
                            }
                        }
                        element = ((MPlaceholder)element).getRef();
                    }
                    if (element instanceof MWindow && element.getWidget() != null) {
                        element.setVisible(false);
                    }
                    goingHidden.add(element);
                    if (!(element instanceof MGenericStack)) break block10;
                    container = (MGenericStack)element;
                    MUIElement curSel = container.getSelectedElement();
                    this.hideElementRecursive(curSel, goingHidden);
                    break block11;
                }
                if (!(element instanceof MElementContainer)) break block11;
                container = (MElementContainer)element;
                for (MUIElement childElement : container.getChildren()) {
                    this.hideElementRecursive(childElement, goingHidden);
                }
                if (!(element instanceof MWindow)) break block12;
                for (MWindow w : ((MWindow)element).getWindows()) {
                    this.hideElementRecursive((MUIElement)w, goingHidden);
                }
                break block11;
            }
            if (!(element instanceof MPerspective)) break block11;
            for (MWindow w : ((MPerspective)element).getWindows()) {
                this.hideElementRecursive((MUIElement)w, goingHidden);
            }
        }
    }

    private void showElementRecursive(MUIElement element, List<MUIElement> becomingVisible) {
        block23: {
            block22: {
                IEclipseContext context;
                if (!element.isToBeRendered()) {
                    return;
                }
                if (element instanceof MPlaceholder && element.getWidget() != null) {
                    MPlaceholder ph = (MPlaceholder)element;
                    MUIElement ref = ph.getRef();
                    ref.setCurSharedRef(ph);
                    Composite phComp = (Composite)ph.getWidget();
                    Control refCtrl = (Control)ph.getRef().getWidget();
                    refCtrl.setParent(phComp);
                    phComp.layout(new Control[]{refCtrl}, 4);
                    if (ref instanceof MPart && ph.getParent().getWidget() instanceof CTabFolder) {
                        MPart part = (MPart)ref;
                        CTabFolder ctf = (CTabFolder)ph.getParent().getWidget();
                        MToolBar tbModel = part.getToolbar();
                        if (ctf.getTopRight() != null) {
                            Control curTB = ctf.getTopRight();
                            ctf.setTopRight(null);
                            if (!curTB.isDisposed()) {
                                MUIElement tbME = (MUIElement)curTB.getData("modelElement");
                                if (tbME instanceof MToolBar) {
                                    curTB.setVisible(false);
                                    curTB.moveBelow(null);
                                } else {
                                    curTB.dispose();
                                }
                            }
                        }
                        if (tbModel != null) {
                            tbModel.setVisible(true);
                            MMenu viewMenu = this.getViewMenu(part);
                            Composite intermediate = this.createIntermediate(part, (MUIElement)tbModel, viewMenu, (Composite)ctf);
                            if (intermediate != null && !intermediate.isDisposed()) {
                                intermediate.setVisible(true);
                                intermediate.moveAbove(null);
                                intermediate.pack();
                                ctf.setTopRight((Control)intermediate, 131136);
                                ctf.layout();
                            }
                        }
                    }
                    element = ref;
                }
                if (element instanceof MContext && (context = ((MContext)element).getContext()) != null) {
                    IEclipseContext newParentContext = this.modelService.getContainingContext(element);
                    if (context.getParent() != newParentContext) {
                        context.setParent(newParentContext);
                    }
                }
                if (element instanceof MWindow && element.getWidget() != null) {
                    int visCount = 0;
                    for (MUIElement kid : ((MWindow)element).getChildren()) {
                        if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                        ++visCount;
                    }
                    if (visCount > 0) {
                        element.setVisible(true);
                    }
                }
                becomingVisible.add(element);
                if (!(element instanceof MGenericStack)) break block22;
                MGenericStack container = (MGenericStack)element;
                MUIElement curSel = container.getSelectedElement();
                if (curSel == null && container.getChildren().size() > 0) {
                    curSel = (MUIElement)container.getChildren().get(0);
                }
                if (curSel == null) break block23;
                this.showElementRecursive(curSel, becomingVisible);
                break block23;
            }
            if (element instanceof MElementContainer) {
                MElementContainer container = (MElementContainer)element;
                ArrayList kids = new ArrayList(container.getChildren());
                for (MUIElement childElement : kids) {
                    this.showElementRecursive(childElement, becomingVisible);
                }
                if (element instanceof MWindow) {
                    for (MWindow w : ((MWindow)element).getWindows()) {
                        this.showElementRecursive((MUIElement)w, becomingVisible);
                    }
                } else if (element instanceof MPerspective) {
                    for (MWindow w : ((MPerspective)element).getWindows()) {
                        this.showElementRecursive((MUIElement)w, becomingVisible);
                    }
                }
            }
        }
    }

    protected Composite createIntermediate(MPart part, MUIElement tbModel, MMenu viewMenu, Composite parent) {
        Composite tbi = (Composite)tbModel.getTransientData().get(TOOL_BAR_INTERMEDIATE);
        if (tbi != null && !tbi.isDisposed()) {
            tbi.setParent(parent);
            return tbi;
        }
        final Composite intermediate = new Composite(parent, 0);
        intermediate.setData("modelElement", (Object)tbModel);
        int orientation = 256;
        RowLayout layout = RowLayoutFactory.fillDefaults().wrap(false).spacing(0).type(orientation).create();
        layout.marginLeft = 3;
        layout.center = true;
        intermediate.setLayout((Layout)layout);
        tbModel.getTransientData().put(TOOL_BAR_INTERMEDIATE, intermediate);
        Control c = (Control)this.renderer.createGui(tbModel, (Object)intermediate, part.getContext());
        if (c == null) {
            intermediate.dispose();
        } else {
            c.addListener(12, new Listener(){

                public void handleEvent(Event event) {
                    intermediate.dispose();
                }
            });
            if (viewMenu != null) {
                this.addMenuButton(part, intermediate, viewMenu);
            }
        }
        return intermediate;
    }

    protected MMenu getViewMenu(MPart part) {
        if (part.getMenus() == null) {
            return null;
        }
        for (MMenu menu : part.getMenus()) {
            if (!menu.getTags().contains(TAG_VIEW_MENU) || !menu.isToBeRendered()) continue;
            return menu;
        }
        return null;
    }

    protected void addMenuButton(MPart part, Composite intermediate, MMenu menu) {
        ToolBar tb = new ToolBar(intermediate, 0x820000);
        tb.setData((Object)TOOL_BAR_MANAGER_RENDERER_VIEW_MENU);
        ToolItem ti = new ToolItem(tb, 8);
        ti.setImage(this.getViewMenuImage());
        ti.setHotImage(null);
        ti.setToolTipText("View Menu");
        ti.setData("theMenu", (Object)menu);
        ti.setData("thePart", (Object)part);
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LazyStackRenderer.this.showMenu((ToolItem)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LazyStackRenderer.this.showMenu((ToolItem)e.widget);
            }
        });
    }

    protected void showMenu(ToolItem item) {
        MMenu menuModel = (MMenu)item.getData("theMenu");
        Menu menu = null;
        Object obj = menuModel.getWidget();
        if (obj instanceof Menu) {
            menu = (Menu)obj;
        }
        if (menu == null || menu.isDisposed()) {
            Menu tmpMenu;
            MPart part = (MPart)item.getData("thePart");
            Control ctrl = (Control)part.getWidget();
            menu = tmpMenu = (Menu)this.renderer.createGui((MUIElement)menuModel, (Object)ctrl.getShell(), part.getContext());
            if (tmpMenu != null) {
                ctrl.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (!tmpMenu.isDisposed()) {
                            tmpMenu.dispose();
                        }
                    }
                });
            }
        }
        if (menu == null) {
            return;
        }
        Rectangle ib = item.getBounds();
        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
        menu.setLocation(displayAt);
        menu.setVisible(true);
        Display display = Display.getCurrent();
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (menu.getData() instanceof MenuManager) {
            MenuManager manager = (MenuManager)menu.getData();
            manager.dispose();
        } else {
            menu.dispose();
        }
    }

    private Image getViewMenuImage() {
        if (this.viewMenuImage == null) {
            Display d = Display.getCurrent();
            Image viewMenu = new Image((Device)d, 16, 16);
            Image viewMenuMask = new Image((Device)d, 16, 16);
            Display display = Display.getCurrent();
            GC gc = new GC((Drawable)viewMenu);
            GC maskgc = new GC((Drawable)viewMenuMask);
            gc.setForeground(display.getSystemColor(17));
            gc.setBackground(display.getSystemColor(25));
            int[] shapeArray = new int[]{6, 1, 15, 1, 11, 5, 10, 5};
            gc.fillPolygon(shapeArray);
            gc.drawPolygon(shapeArray);
            Color black = display.getSystemColor(2);
            Color white = display.getSystemColor(1);
            maskgc.setBackground(black);
            maskgc.fillRectangle(0, 0, 16, 16);
            maskgc.setBackground(white);
            maskgc.setForeground(white);
            maskgc.fillPolygon(shapeArray);
            maskgc.drawPolygon(shapeArray);
            gc.dispose();
            maskgc.dispose();
            ImageData data = viewMenu.getImageData();
            data.transparentPixel = data.getPixel(0, 0);
            this.viewMenuImage = new Image((Device)d, viewMenu.getImageData(), viewMenuMask.getImageData());
            viewMenu.dispose();
            viewMenuMask.dispose();
        }
        return this.viewMenuImage;
    }
}

