/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    long jniRef;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int HOT = 32;
    static final int MOVED = 64;
    static final int RESIZED = 128;
    static final int EXPANDING = 256;
    static final int IGNORE_WHEEL = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int THEME_BACKGROUND = 2048;
    static final int LAYOUT_NEEDED = 4096;
    static final int LAYOUT_CHANGED = 8192;
    static final int LAYOUT_CHILD = 16384;
    static final int RELEASED = 32768;
    static final int DISPOSE_SENT = 65536;
    static final int FOREIGN_HANDLE = 131072;
    static final int DRAG_DETECT = 262144;
    static final int WEBKIT_EVENTS_FIX = 524288;
    static final String WEBKIT_EVENTS_FIX_KEY = "org.eclipse.swt.internal.webKitEventsFix";
    static final String GLCONTEXT_KEY = "org.eclipse.swt.internal.cocoa.glcontext";
    static final String IS_ACTIVE = "org.eclipse.swt.internal.isActive";
    static final int SKIN_NEEDED = 0x100000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
        this.display = parent.display;
        this.reskinWidget();
    }

    long accessibleHandle() {
        return 0L;
    }

    long accessibilityActionDescription(long id2, long sel, long arg0) {
        return this.callSuperObject(id2, sel, arg0);
    }

    long accessibilityActionNames(long id2, long sel) {
        return this.callSuperObject(id2, sel);
    }

    long accessibilityAttributeNames(long id2, long sel) {
        return this.callSuperObject(id2, sel);
    }

    long accessibilityAttributeValue(long id2, long sel, long arg0) {
        return this.callSuperObject(id2, sel, arg0);
    }

    long accessibilityAttributeValue_forParameter(long id2, long sel, long arg0, long arg1) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, arg0, arg1);
    }

    long accessibilityFocusedUIElement(long id2, long sel) {
        return this.callSuperObject(id2, sel);
    }

    long accessibilityHitTest(long id2, long sel, NSPoint point) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, point);
    }

    boolean accessibilityIsAttributeSettable(long id2, long sel, long arg0) {
        return this.callSuperBoolean(id2, sel, arg0);
    }

    boolean accessibilityIsIgnored(long id2, long sel) {
        return this.callSuperBoolean(id2, sel);
    }

    long accessibilityParameterizedAttributeNames(long id2, long sel) {
        return this.callSuperObject(id2, sel);
    }

    void accessibilityPerformAction(long id2, long sel, long arg0) {
        this.callSuper(id2, sel, arg0);
    }

    void accessibilitySetValue_forAttribute(long id2, long sel, long arg0, long arg1) {
        this.callSuper(id2, sel, arg0, arg1);
    }

    String getClipboardText() {
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        if (pasteboard == null) {
            return "";
        }
        NSString string = pasteboard.stringForType(OS.NSStringPboardType);
        return string != null ? string.getString() : null;
    }

    void setClipRegion(NSView view) {
    }

    long attributedSubstringFromRange(long id2, long sel, long range) {
        return 0L;
    }

    void callSuper(long id2, long sel) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel);
    }

    void callSuper(long id2, long sel, long arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, arg0);
    }

    void callSuper(long id2, long sel, NSRect arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, arg0);
    }

    void callSuper(long id2, long sel, long arg0, long arg1) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, arg0, arg1);
    }

    void callSuper(long id2, long sel, NSRect arg0, long arg1) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, arg0, arg1);
    }

    long callSuper(long id2, long sel, long arg0, NSRect arg1, long arg2) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, arg0, arg1, arg2);
    }

    boolean callSuperBoolean(long id2, long sel) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel) != 0L;
    }

    boolean canBecomeKeyWindow(long id2, long sel) {
        return this.callSuperBoolean(id2, sel);
    }

    void cancelOperation(long id2, long sel, long arg0) {
    }

    NSSize cellSize(long id2, long sel) {
        NSSize result = new NSSize();
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper_stret(result, super_struct, sel);
        return result;
    }

    NSSize cellSizeForBounds(long id2, long sel, NSRect cellFrame) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        NSSize result = new NSSize();
        OS.objc_msgSendSuper_stret(result, super_struct, sel, cellFrame);
        return result;
    }

    boolean callSuperBoolean(long id2, long sel, long arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, arg0) != 0L;
    }

    boolean callSuperBoolean(long id2, long sel, NSRange range, long arg1) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper_bool(super_struct, sel, range, arg1);
    }

    long callSuperObject(long id2, long sel) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel);
    }

    long callSuperObject(long id2, long sel, long arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, arg0);
    }

    long callSuperObject(long id2, long sel, long arg0, long arg1) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, arg0, arg1);
    }

    NSRect callSuperRect(long id2, long sel, long arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        NSRect result = new NSRect();
        OS.objc_msgSendSuper_stret(result, super_struct, sel, arg0);
        return result;
    }

    boolean canDragRowsWithIndexes_atPoint(long id2, long sel, long rowIndexes, NSPoint mouseDownPoint) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper_bool(super_struct, sel, rowIndexes, mouseDownPoint);
    }

    long characterIndexForPoint(long id2, long sel, long point) {
        return Integer.MAX_VALUE;
    }

    long columnAtPoint(long id2, long sel, NSPoint point) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, point);
    }

    boolean acceptsFirstMouse(long id2, long sel, long theEvent) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, theEvent) != 0L;
    }

    boolean acceptsFirstResponder(long id2, long sel) {
        return this.callSuperBoolean(id2, sel);
    }

    boolean becomeFirstResponder(long id2, long sel) {
        return this.callSuperBoolean(id2, sel);
    }

    void becomeKeyWindow(long id2, long sel) {
        this.callSuper(id2, sel);
    }

    public void reskin(int flags) {
        this.checkWidget();
        this.reskinWidget();
        if ((flags & 1) != 0) {
            this.reskinChildren(flags);
        }
    }

    void reskinChildren(int flags) {
    }

    void reskinWidget() {
        if ((this.state & 0x100000) != 0x100000) {
            this.state |= 0x100000;
            this.display.addSkinnableWidget(this);
        }
    }

    boolean resignFirstResponder(long id2, long sel) {
        return this.callSuperBoolean(id2, sel);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(eventType, listener);
    }

    void _addListener(int eventType, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    boolean canBecomeKeyView(long id2, long sel) {
        return true;
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    void checkOpen() {
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        parent.checkWidget();
        parent.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void clearDeferFlushing(long id2, long sel) {
    }

    boolean textView_clickOnLink_atIndex(long id2, long sel, long textView, long link, long charIndex) {
        return true;
    }

    void collapseItem_collapseChildren(long id2, long sel, long item, boolean children) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, item, children);
    }

    void copyToClipboard(char[] buffer) {
        if (buffer.length == 0) {
            return;
        }
        NSPasteboard pasteboard = NSPasteboard.generalPasteboard();
        if (pasteboard == null) {
            return;
        }
        pasteboard.declareTypes(NSArray.arrayWithObject(OS.NSStringPboardType), null);
        pasteboard.setString(NSString.stringWithCharacters(buffer, buffer.length), OS.NSStringPboardType);
    }

    void createHandle() {
    }

    void createJNIRef() {
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0L) {
            this.error(2);
        }
    }

    void createWidget() {
        this.createJNIRef();
        this.createHandle();
        this.setOrientation();
        this.register();
    }

    void comboBoxSelectionDidChange(long id2, long sel, long notification) {
    }

    void comboBoxWillDismiss(long id2, long sel, long notification) {
    }

    void comboBoxWillPopUp(long id2, long sel, long notification) {
    }

    void deregister() {
    }

    void destroyJNIRef() {
        if (this.jniRef != 0L) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        this.jniRef = 0L;
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void deselectAll(long id2, long sel, long sender) {
        this.callSuper(id2, sel, sender);
    }

    void deselectRow(long id2, long sel, long index) {
        this.callSuper(id2, sel, index);
    }

    void doCommandBySelector(long id2, long sel, long aSelector) {
        this.callSuper(id2, sel, aSelector);
    }

    boolean dragSelectionWithEvent(long id2, long sel, long arg0, long arg1, long arg2) {
        return false;
    }

    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
    }

    void drawBackgroundInClipRect(long id2, long sel, NSRect rect) {
        this.callSuper(id2, sel, rect);
    }

    void drawImageWithFrameInView(long id2, long sel, long image, NSRect rect, long view) {
        this.callSuper(id2, sel, image, rect, view);
    }

    NSRect drawTitleWithFrameInView(long id2, long sel, long title, NSRect rect, long view) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        NSRect result = new NSRect();
        OS.objc_msgSendSuper_stret(result, super_struct, sel, title, rect, view);
        return result;
    }

    void drawInteriorWithFrame_inView(long id2, long sel, NSRect cellFrame, long view) {
        this.callSuper(id2, sel, cellFrame, view);
    }

    void drawLabelInRect(long id2, long sel, boolean shouldTruncateLabel, NSRect rect) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, shouldTruncateLabel, rect);
    }

    void drawViewBackgroundInRect(long id2, long sel, NSRect rect) {
        this.callSuper(id2, sel, rect);
    }

    void drawWithExpansionFrame_inView(long id2, long sel, NSRect cellFrame, long view) {
        this.callSuper(id2, sel, cellFrame, view);
    }

    void drawRect(long id2, long sel, NSRect rect) {
        if (!this.isDrawing()) {
            return;
        }
        Display display = this.display;
        NSView view = new NSView(id2);
        display.isPainting.addObject(view);
        NSGraphicsContext context = NSGraphicsContext.currentContext();
        context.saveGraphicsState();
        this.setClipRegion(view);
        this.drawBackground(id2, context, rect);
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, rect);
        if (!this.isDisposed()) {
            this.drawWidget(id2, context, rect);
        }
        context.restoreGraphicsState();
        display.isPainting.removeObjectIdenticalTo(view);
    }

    void _drawThemeProgressArea(long id2, long sel, long arg0) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, arg0);
    }

    void drawWidget(long id2, NSGraphicsContext context, NSRect rect) {
    }

    long imageView() {
        return 0L;
    }

    void redrawWidget(NSView view, boolean children) {
        view.setNeedsDisplay(true);
    }

    void redrawWidget(NSView view, long x, long y, long width, long height, boolean children) {
        NSRect rect = new NSRect();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        view.setNeedsDisplayInRect(rect);
    }

    void error(int code) {
        SWT.error(code);
    }

    void expandItem_expandChildren(long id2, long sel, long item, boolean children) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, item, children);
    }

    NSRect expansionFrameWithFrame_inView(long id2, long sel, NSRect cellRect, long view) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        NSRect result = new NSRect();
        OS.objc_msgSendSuper_stret(result, super_struct, sel, cellRect, view);
        return result;
    }

    boolean filters(int eventType) {
        return this.display.filters(eventType);
    }

    NSRect firstRectForCharacterRange(long id2, long sel, long range) {
        return new NSRect();
    }

    int fixMnemonic(char[] buffer) {
        int i = 0;
        int j = 0;
        while (i < buffer.length) {
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            --j;
        }
        return j;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(IS_ACTIVE)) {
            return new Boolean(this.isActive());
        }
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (i < table.length) {
                if (key.equals(table[i])) {
                    return table[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    boolean getDrawing() {
        return true;
    }

    public Listener[] getListeners(int eventType) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(eventType);
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    boolean hasMarkedText(long id2, long sel) {
        return false;
    }

    NSRect headerRectOfColumn(long id2, long sel, long column) {
        return this.callSuperRect(id2, sel, column);
    }

    void helpRequested(long id2, long sel, long theEvent) {
    }

    void highlightSelectionInClipRect(long id2, long sel, long rect) {
    }

    long hitTest(long id2, long sel, NSPoint point) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, point);
    }

    long hitTestForEvent(long id2, long sel, long event, NSRect rect, long controlView) {
        return 0L;
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    long image(long id2, long sel) {
        return 0L;
    }

    NSRect imageRectForBounds(long id2, long sel, NSRect cellFrame) {
        return new NSRect();
    }

    boolean insertText(long id2, long sel, long string) {
        this.callSuper(id2, sel, string);
        return true;
    }

    boolean isActive() {
        return true;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    boolean isDrawing() {
        return true;
    }

    boolean isFlipped(long id2, long sel) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel) != 0L;
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isOpaque(long id2, long sel) {
        return false;
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void flagsChanged(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void keyDown(long id2, long sel, long theEvent) {
        this.superKeyDown(id2, sel, theEvent);
    }

    void keyUp(long id2, long sel, long theEvent) {
        this.superKeyUp(id2, sel, theEvent);
    }

    void mouseDown(long id2, long sel, long theEvent) {
        this.mouseDownSuper(id2, sel, theEvent);
    }

    boolean mouseDownCanMoveWindow(long id2, long sel) {
        return this.callSuperBoolean(id2, sel);
    }

    void mouseDownSuper(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void mouseUp(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void mouseMoved(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void mouseDragged(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void mouseEntered(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void mouseExited(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void cursorUpdate(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void rightMouseDown(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void rightMouseUp(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void rightMouseDragged(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void otherMouseDown(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void otherMouseUp(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void otherMouseDragged(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    boolean shouldDelayWindowOrderingForEvent(long id2, long sel, long theEvent) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, theEvent) != 0L;
    }

    boolean menuHasKeyEquivalent_forEvent_target_action(long id2, long sel, long menu, long event, long target, long action) {
        return true;
    }

    long menuForEvent(long id2, long sel, long theEvent) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        return OS.objc_msgSendSuper(super_struct, sel, theEvent);
    }

    void menuNeedsUpdate(long id2, long sel, long menu) {
    }

    boolean makeFirstResponder(long id2, long sel, long notification) {
        return this.callSuperBoolean(id2, sel, notification);
    }

    NSRange markedRange(long id2, long sel) {
        return new NSRange();
    }

    void menu_willHighlightItem(long id2, long sel, long menu, long item) {
    }

    void menuDidClose(long id2, long sel, long menu) {
    }

    void menuWillOpen(long id2, long sel, long menu) {
    }

    void noResponderFor(long id2, long sel, long selector) {
        this.callSuper(id2, sel, selector);
    }

    long numberOfRowsInTableView(long id2, long sel, long aTableView) {
        return 0L;
    }

    long outlineView_child_ofItem(long id2, long sel, long outlineView, long index, long item) {
        return 0L;
    }

    void outlineView_didClickTableColumn(long id2, long sel, long outlineView, long tableColumn) {
    }

    long outlineView_objectValueForTableColumn_byItem(long id2, long sel, long outlineView, long tableColumn, long item) {
        return 0L;
    }

    boolean outlineView_isItemExpandable(long id2, long sel, long outlineView, long item) {
        return false;
    }

    long outlineView_numberOfChildrenOfItem(long id2, long sel, long outlineView, long item) {
        return 0L;
    }

    boolean outlineView_shouldExpandItem_item(long id2, long sel, long outlineView, long item) {
        return true;
    }

    boolean outlineView_shouldReorderColumn_toColumn(long id2, long sel, long aTableView, long columnIndex, long newColumnIndex) {
        return true;
    }

    boolean outlineView_shouldEditTableColumn_row(long id2, long sel, long aTableView, long aTableColumn, long item) {
        return false;
    }

    void outlineView_willDisplayCell_forTableColumn_item(long id2, long sel, long outlineView, long cell, long tableColumn, long item) {
    }

    void outlineViewColumnDidMove(long id2, long sel, long aNotification) {
    }

    void outlineViewColumnDidResize(long id2, long sel, long aNotification) {
    }

    void outlineViewSelectionDidChange(long id2, long sel, long notification) {
    }

    void outlineViewSelectionIsChanging(long id2, long sel, long notification) {
    }

    void outlineView_setObjectValue_forTableColumn_byItem(long id2, long sel, long outlineView, long object, long tableColumn, long item) {
    }

    boolean outlineView_writeItems_toPasteboard(long id2, long sel, long arg0, long arg1, long arg2) {
        return false;
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(eventType, event);
    }

    void pageDown(long id2, long sel, long sender) {
        this.callSuper(id2, sel, sender);
    }

    void pageUp(long id2, long sel, long sender) {
        this.callSuper(id2, sel, sender);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void reflectScrolledClipView(long id2, long sel, long aClipView) {
        this.callSuper(id2, sel, aClipView);
    }

    void register() {
    }

    void release(boolean destroy) {
        if ((this.state & 0x10000) == 0) {
            this.state |= 0x10000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(destroy);
        }
        if ((this.state & 0x8000) == 0) {
            this.state |= 0x8000;
            if (destroy) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean destroy) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
        this.destroyJNIRef();
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        if (this.display.tooltipTarget == this) {
            this.display.tooltipTarget = null;
        }
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    protected void removeListener(int eventType, SWTEventListener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    void scrollClipViewToPoint(long id2, long sel, long clipView, NSPoint point) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, clipView, point);
    }

    void selectRowIndexes_byExtendingSelection(long id2, long sel, long indexes, boolean extend) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, indexes, extend);
    }

    void scrollWheel(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    NSRange selectedRange(long id2, long sel) {
        return new NSRange();
    }

    long nextValidKeyView(long id2, long sel) {
        return this.callSuperObject(id2, sel);
    }

    long previousValidKeyView(long id2, long sel) {
        return this.callSuperObject(id2, sel);
    }

    void sendDoubleSelection() {
    }

    void sendEvent(Event event) {
        this.display.sendEvent(this.eventTable, event);
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        if ((this.state & 0x80000) != 0) {
            return true;
        }
        Event event = new Event();
        if (!this.setKeyState(event, type, nsEvent)) {
            return true;
        }
        return this.sendKeyEvent(type, event);
    }

    boolean sendKeyEvent(int type, Event event) {
        this.sendEvent(type, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendHorizontalSelection() {
    }

    void sendCancelSelection() {
    }

    void sendSearchSelection() {
    }

    void sendSelection() {
    }

    void sendSelectionEvent(int eventType) {
        this.sendSelectionEvent(eventType, null, false);
    }

    void sendSelectionEvent(int eventType, Event event, boolean send) {
        NSEvent nsEvent;
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        if ((nsEvent = NSApplication.sharedApplication().currentEvent()) != null) {
            this.setInputState(event, nsEvent, 0);
        }
        this.sendEvent(eventType, event, send);
    }

    void sendVerticalSelection() {
    }

    public void setData(Object data) {
        this.checkWidget();
        if (WEBKIT_EVENTS_FIX_KEY.equals(data)) {
            this.state |= 0x80000;
            return;
        }
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (GLCONTEXT_KEY.equals(key)) {
            this.setOpenGLContext(value);
            return;
        }
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
        if (key.equals("org.eclipse.swt.skin.class") || key.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    void setOpenGLContext(Object value) {
    }

    void setOrientation() {
    }

    void setFrameOrigin(long id2, long sel, NSPoint point) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, point);
    }

    void setFrameSize(long id2, long sel, NSSize size) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, size);
    }

    void setImage(long id2, long sel, long arg0) {
    }

    boolean setInputState(Event event, NSEvent nsEvent, int type) {
        int state;
        if (nsEvent == null) {
            return true;
        }
        long modifierFlags = nsEvent.modifierFlags();
        if ((modifierFlags & 0x80000L) != 0L) {
            event.stateMask |= 0x10000;
        }
        if ((modifierFlags & 0x20000L) != 0L) {
            event.stateMask |= 0x20000;
        }
        if ((modifierFlags & 0x40000L) != 0L) {
            event.stateMask |= 0x40000;
        }
        if ((modifierFlags & 0x100000L) != 0L) {
            event.stateMask |= 0x400000;
        }
        if (((state = OS.GetCurrentEventButtonState()) & 1) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((state & 2) != 0) {
            event.stateMask |= 0x200000;
        }
        if ((state & 4) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((state & 8) != 0) {
            event.stateMask |= 0x800000;
        }
        if ((state & 0x10) != 0) {
            event.stateMask |= 0x2000000;
        }
        switch (type) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode == 262144) {
                    event.stateMask &= 0xFFFBFFFF;
                }
                if (event.keyCode != 0x400000) break;
                event.stateMask &= 0xFFBFFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode == 262144) {
                    event.stateMask |= 0x40000;
                }
                if (event.keyCode != 0x400000) break;
                event.stateMask |= 0x400000;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int type, NSEvent nsEvent) {
        boolean isNull = false;
        short keyCode = nsEvent.keyCode();
        event.keyCode = Display.translateKey(keyCode);
        switch (event.keyCode) {
            case 10: {
                event.keyCode = 0x1000050;
                event.character = (char)13;
                break;
            }
            case 8: {
                event.character = (char)8;
                break;
            }
            case 13: {
                event.character = (char)13;
                break;
            }
            case 127: {
                event.character = (char)127;
                break;
            }
            case 27: {
                event.character = (char)27;
                break;
            }
            case 9: {
                event.character = (char)9;
                break;
            }
            default: {
                NSString chars;
                if ((event.keyCode == 0 || 16777258 <= event.keyCode && event.keyCode <= 0x1000050) && (chars = nsEvent.characters()).length() > 0L) {
                    event.character = (char)chars.characterAtIndex(0L);
                }
                if (event.keyCode != 0) break;
                long uchrPtr = 0L;
                long currentKbd = OS.TISCopyCurrentKeyboardInputSource();
                long uchrCFData = OS.TISGetInputSourceProperty(currentKbd, OS.kTISPropertyUnicodeKeyLayoutData());
                if (uchrCFData != 0L) {
                    uchrPtr = OS.CFDataGetBytePtr(uchrCFData);
                    if (uchrPtr != 0L && OS.CFDataGetLength(uchrCFData) > 0L) {
                        long cgEvent = nsEvent.CGEvent();
                        long keyboardType = OS.CGEventGetIntegerValueField(cgEvent, 10);
                        int maxStringLength = 256;
                        char[] output = new char[maxStringLength];
                        int[] actualStringLength = new int[1];
                        int[] deadKeyState = new int[1];
                        OS.UCKeyTranslate(uchrPtr, keyCode, (short)(event.type != 1 ? 1 : 0), 0, (int)keyboardType, 0, deadKeyState, maxStringLength, actualStringLength, output);
                        event.keyCode = actualStringLength[0] < 1 ? 0 : output[0];
                    }
                } else {
                    NSString unmodifiedChars = nsEvent.charactersIgnoringModifiers().lowercaseString();
                    if (unmodifiedChars.length() > 0L) {
                        event.keyCode = (char)unmodifiedChars.characterAtIndex(0L);
                    }
                }
                if (currentKbd == 0L) break;
                OS.CFRelease(currentKbd);
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !isNull) {
            return false;
        }
        this.setLocationMask(event, nsEvent);
        this.setInputState(event, nsEvent, type);
        return true;
    }

    void setLocationMask(Event event, NSEvent nsEvent) {
        switch (nsEvent.keyCode()) {
            case 55: 
            case 56: 
            case 58: 
            case 59: {
                event.keyLocation = 16384;
                break;
            }
            case 54: 
            case 60: 
            case 61: 
            case 62: {
                event.keyLocation = 131072;
                break;
            }
            case 65: 
            case 67: 
            case 69: 
            case 75: 
            case 76: 
            case 78: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: {
                event.keyLocation = 2;
            }
        }
    }

    boolean setMarkedText_selectedRange(long id2, long sel, long string, long range) {
        return true;
    }

    void setNeedsDisplay(long id2, long sel, boolean flag) {
        if (flag && !this.isDrawing()) {
            return;
        }
        NSView view = new NSView(id2);
        if (flag && this.display.isPainting.containsObject(view)) {
            NSMutableArray needsDisplay = this.display.needsDisplay;
            if (needsDisplay == null) {
                needsDisplay = (NSMutableArray)new NSMutableArray().alloc();
                this.display.needsDisplay = needsDisplay = needsDisplay.initWithCapacity(12L);
            }
            needsDisplay.addObject(view);
            return;
        }
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, flag);
    }

    void setNeedsDisplayInRect(long id2, long sel, long arg0) {
        if (!this.isDrawing()) {
            return;
        }
        NSRect rect = new NSRect();
        OS.memmove(rect, arg0, (long)NSRect.sizeof);
        NSView view = new NSView(id2);
        if (this.display.isPainting.containsObject(view)) {
            NSMutableArray needsDisplayInRect = this.display.needsDisplayInRect;
            if (needsDisplayInRect == null) {
                needsDisplayInRect = (NSMutableArray)new NSMutableArray().alloc();
                this.display.needsDisplayInRect = needsDisplayInRect = needsDisplayInRect.initWithCapacity(12L);
            }
            needsDisplayInRect.addObject(view);
            needsDisplayInRect.addObject(NSValue.valueWithRect(rect));
            return;
        }
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        OS.objc_msgSendSuper(super_struct, sel, rect);
    }

    void setObjectValue(long id2, long sel, long arg0) {
        this.callSuper(id2, sel, arg0);
    }

    void setShouldExpandItem(long id2, long sel, boolean shouldExpand) {
    }

    void setShouldScrollClipView(long id2, long sel, boolean shouldScroll) {
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        return false;
    }

    boolean shouldChangeTextInRange_replacementString(long id2, long sel, long arg0, long arg1) {
        return true;
    }

    NSSize sizeOfLabel(long id2, long sel, boolean shouldTruncateLabel) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        NSSize result = new NSSize();
        OS.objc_msgSendSuper_stret(result, super_struct, sel, shouldTruncateLabel);
        return result;
    }

    void superKeyDown(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void superKeyUp(long id2, long sel, long theEvent) {
        this.callSuper(id2, sel, theEvent);
    }

    void tableViewColumnDidMove(long id2, long sel, long aNotification) {
    }

    void tableViewColumnDidResize(long id2, long sel, long aNotification) {
    }

    void tableViewSelectionDidChange(long id2, long sel, long aNotification) {
    }

    void tableViewSelectionIsChanging(long id2, long sel, long aNotification) {
    }

    void tableView_didClickTableColumn(long id2, long sel, long tableView, long tableColumn) {
    }

    long tableView_objectValueForTableColumn_row(long id2, long sel, long aTableView, long aTableColumn, long rowIndex) {
        return 0L;
    }

    boolean tableView_shouldSelectRow(long id2, long sel, long tableView, long index) {
        return true;
    }

    void tableView_setObjectValue_forTableColumn_row(long id2, long sel, long aTableView, long anObject, long aTableColumn, long rowIndex) {
    }

    boolean tableView_shouldReorderColumn_toColumn(long id2, long sel, long aTableView, long columnIndex, long newColumnIndex) {
        return true;
    }

    boolean tableView_shouldEditTableColumn_row(long id2, long sel, long aTableView, long aTableColumn, long rowIndex) {
        return false;
    }

    void tableView_willDisplayCell_forTableColumn_row(long id2, long sel, long aTableView, long aCell, long aTableColumn, long rowIndex) {
    }

    void textViewDidChangeSelection(long id2, long sel, long aNotification) {
    }

    void textDidChange(long id2, long sel, long aNotification) {
        this.callSuper(id2, sel, aNotification);
    }

    void textDidEndEditing(long id2, long sel, long aNotification) {
        this.callSuper(id2, sel, aNotification);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(long id2, long sel, long aTextView, long oldSelectedCharRange, long newSelectedCharRange) {
        return new NSRange();
    }

    NSRect titleRectForBounds(long id2, long sel, NSRect cellFrame) {
        objc_super super_struct = new objc_super();
        super_struct.receiver = id2;
        super_struct.super_class = OS.objc_msgSend(id2, OS.sel_superclass);
        NSRect result = new NSRect();
        OS.objc_msgSendSuper_stret(result, super_struct, sel, cellFrame);
        return result;
    }

    long toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(long id2, long sel, long toolbar, long itemID, boolean flag) {
        return 0L;
    }

    long toolbarAllowedItemIdentifiers(long id2, long sel, long toolbar) {
        return 0L;
    }

    long toolbarDefaultItemIdentifiers(long id2, long sel, long toolbar) {
        return 0L;
    }

    long toolbarSelectableItemIdentifiers(long id2, long sel, long toolbar) {
        return 0L;
    }

    String tooltipText() {
        return null;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    void touchesBeganWithEvent(long id2, long sel, long event) {
        this.callSuper(id2, sel, event);
    }

    void touchesCancelledWithEvent(long id2, long sel, long event) {
        this.callSuper(id2, sel, event);
    }

    void touchesEndedWithEvent(long id2, long sel, long event) {
        this.callSuper(id2, sel, event);
    }

    void touchesMovedWithEvent(long id2, long sel, long event) {
        this.callSuper(id2, sel, event);
    }

    void beginGestureWithEvent(long id2, long sel, long event) {
        this.callSuper(id2, sel, event);
    }

    void endGestureWithEvent(long id2, long sel, long event) {
        this.callSuper(id2, sel, event);
    }

    void magnifyWithEvent(long id2, long sel, long event) {
        this.callSuper(id2, sel, event);
    }

    void rotateWithEvent(long id2, long sel, long event) {
        this.callSuper(id2, sel, event);
    }

    void swipeWithEvent(long id2, long sel, long event) {
        this.callSuper(id2, sel, event);
    }

    void resetCursorRects(long id2, long sel) {
        this.callSuper(id2, sel);
    }

    void updateTrackingAreas(long id2, long sel) {
        this.callSuper(id2, sel);
    }

    long validAttributesForMarkedText(long id2, long sel) {
        return 0L;
    }

    void tabView_didSelectTabViewItem(long id2, long sel, long tabView, long tabViewItem) {
    }

    void tabView_willSelectTabViewItem(long id2, long sel, long tabView, long tabViewItem) {
    }

    boolean tableView_writeRowsWithIndexes_toPasteboard(long id2, long sel, long arg0, long arg1, long arg2) {
        return false;
    }

    boolean validateMenuItem(long id2, long sel, long menuItem) {
        return true;
    }

    long view_stringForToolTip_point_userData(long id2, long sel, long view, long tag, long point, long userData) {
        return 0L;
    }

    void viewDidMoveToWindow(long id2, long sel) {
    }

    void viewWillMoveToWindow(long id2, long sel, long arg0) {
    }

    void windowDidMove(long id2, long sel, long notification) {
    }

    void windowDidResize(long id2, long sel, long notification) {
    }

    void windowDidResignKey(long id2, long sel, long notification) {
    }

    void windowDidBecomeKey(long id2, long sel, long notification) {
    }

    void windowDidMiniturize(long id2, long sel, long notification) {
    }

    void windowDidDeminiturize(long id2, long sel, long notification) {
    }

    void windowSendEvent(long id2, long sel, long event) {
        this.callSuper(id2, sel, event);
    }

    boolean windowShouldClose(long id2, long sel, long window) {
        return false;
    }

    void windowWillClose(long id2, long sel, long notification) {
    }

    long nextState(long id2, long sel) {
        return this.callSuperObject(id2, sel);
    }

    void updateOpenGLContext(long id2, long sel, long notification) {
    }

    boolean shouldDrawInsertionPoint(long id2, long sel) {
        return this.callSuperBoolean(id2, sel);
    }

    boolean readSelectionFromPasteboard(long id2, long sel, long pasteboard) {
        return false;
    }

    long validRequestorForSendType(long id2, long sel, long sendType, long returnType) {
        return this.callSuperObject(id2, sel, sendType, returnType);
    }

    boolean writeSelectionToPasteboard(long id2, long sel, long pasteboard, long types) {
        return false;
    }
}

