/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.launching.launchConfigurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.internal.launching.launchConfigurations.AntStreamsProxy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;

public class AntProcess
extends PlatformObject
implements IProcess,
IProgressMonitor {
    private AntStreamsProxy fProxy;
    private String fLabel = null;
    private ILaunch fLaunch = null;
    private Map fAttributes = null;
    private boolean fTerminated = false;
    private boolean fCancelled = false;
    private IProgressMonitor fMonitor;

    public AntProcess(String label, ILaunch launch, Map attributes) {
        this.fLabel = label;
        this.fLaunch = launch;
        this.fAttributes = attributes == null ? new HashMap() : attributes;
        String captureOutput = launch.getAttribute("org.eclipse.debug.core.capture_output");
        if (!"false".equals(captureOutput)) {
            this.fProxy = new AntStreamsProxy();
        }
        launch.addProcess((IProcess)this);
    }

    public String getLabel() {
        return this.fLabel;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fProxy;
    }

    public void setAttribute(String key, String value) {
        this.fAttributes.put(key, value);
    }

    public String getAttribute(String key) {
        return (String)this.fAttributes.get(key);
    }

    public int getExitValue() {
        return 0;
    }

    public boolean canTerminate() {
        return !this.isCanceled() && !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    protected void terminated() {
        if (!this.fTerminated) {
            this.fTerminated = true;
            if (DebugPlugin.getDefault() != null) {
                DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
            }
        }
    }

    public void terminate() {
        this.setCanceled(true);
    }

    public void beginTask(String name, int totalWork) {
        if (this.fMonitor != null) {
            this.fMonitor.beginTask(name, totalWork);
        }
    }

    public void done() {
        if (this.fMonitor != null) {
            this.fMonitor.done();
        }
    }

    public void internalWorked(double work) {
        if (this.fMonitor != null) {
            this.fMonitor.internalWorked(work);
        }
    }

    public boolean isCanceled() {
        return this.fCancelled;
    }

    public void setCanceled(boolean value) {
        this.fCancelled = value;
        if (this.fMonitor != null) {
            this.fMonitor.setCanceled(value);
        }
    }

    public void setTaskName(String name) {
        if (this.fMonitor != null) {
            this.fMonitor.setTaskName(name);
        }
    }

    public void subTask(String name) {
        if (this.fMonitor != null) {
            this.fMonitor.subTask(name);
        }
    }

    public void worked(int work) {
        if (this.fMonitor != null) {
            this.fMonitor.worked(work);
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fMonitor = monitor;
    }
}

