/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contexts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.internal.ui.contexts.DebugModelContextBindingManager;
import org.eclipse.debug.internal.ui.contexts.DebugWindowContextService;
import org.eclipse.debug.internal.ui.views.ViewContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DebugContextManager
implements IDebugContextManager {
    private static DebugContextManager fgDefault;
    private Map fServices = new HashMap();
    private ListenerList fGlobalListeners = new ListenerList();
    private static IDebugContextService NULL_SERVICE;

    static {
        NULL_SERVICE = new IDebugContextService(){

            public void removePostDebugContextListener(IDebugContextListener listener, String partId) {
            }

            public void removePostDebugContextListener(IDebugContextListener listener) {
            }

            public void removeDebugContextProvider(IDebugContextProvider provider) {
            }

            public void removeDebugContextListener(IDebugContextListener listener, String partId) {
            }

            public void removeDebugContextListener(IDebugContextListener listener) {
            }

            public ISelection getActiveContext(String partId) {
                return null;
            }

            public ISelection getActiveContext() {
                return null;
            }

            public void addPostDebugContextListener(IDebugContextListener listener, String partId) {
            }

            public void addPostDebugContextListener(IDebugContextListener listener) {
            }

            public void addDebugContextProvider(IDebugContextProvider provider) {
            }

            public void addDebugContextListener(IDebugContextListener listener, String partId) {
            }

            public void addDebugContextListener(IDebugContextListener listener) {
            }

            public void addDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
            }

            public void removeDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
            }

            public ISelection getActiveContext(String partId, String partSecondaryId) {
                return null;
            }

            public void addPostDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
            }

            public void removePostDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
            }
        };
    }

    private DebugContextManager() {
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)new WindowListener());
    }

    public static IDebugContextManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new DebugContextManager();
            DebugModelContextBindingManager.getDefault();
            ViewContextManager.getDefault();
        }
        return fgDefault;
    }

    protected IDebugContextService createService(IWorkbenchWindow window) {
        DebugWindowContextService service = (DebugWindowContextService)this.fServices.get(window);
        if (service == null) {
            if (window.getShell() == null) {
                return NULL_SERVICE;
            }
            service = new DebugWindowContextService(window);
            this.fServices.put(window, service);
            Object[] listeners = this.fGlobalListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IDebugContextListener listener = (IDebugContextListener)listeners[i];
                service.addDebugContextListener(listener);
                ++i;
            }
        }
        return service;
    }

    protected IDebugContextService getService(IWorkbenchWindow window) {
        return (DebugWindowContextService)this.fServices.get(window);
    }

    public void addDebugContextListener(IDebugContextListener listener) {
        this.fGlobalListeners.add((Object)listener);
        DebugWindowContextService[] services = this.getServices();
        int i = 0;
        while (i < services.length) {
            DebugWindowContextService service = services[i];
            service.addDebugContextListener(listener);
            ++i;
        }
    }

    public void removeDebugContextListener(IDebugContextListener listener) {
        this.fGlobalListeners.remove((Object)listener);
        DebugWindowContextService[] services = this.getServices();
        int i = 0;
        while (i < services.length) {
            DebugWindowContextService service = services[i];
            service.removeDebugContextListener(listener);
            ++i;
        }
    }

    private DebugWindowContextService[] getServices() {
        Collection sevices = this.fServices.values();
        return sevices.toArray(new DebugWindowContextService[sevices.size()]);
    }

    public IDebugContextService getContextService(IWorkbenchWindow window) {
        return this.createService(window);
    }

    private class WindowListener
    implements IWindowListener {
        private WindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            DebugWindowContextService service = (DebugWindowContextService)DebugContextManager.this.fServices.get(window);
            if (service != null) {
                DebugContextManager.this.fServices.remove(window);
                service.dispose();
            }
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

