/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts.debug.ui;

import java.util.Set;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.debug.ui.ContextMessages;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ContextLinks {
    private final TabFolder folder;
    private TreeViewer dataViewer;
    private TabItem tabData;

    public ContextLinks(TabFolder folder) {
        this.folder = folder;
    }

    public TreeViewer createControls() {
        this.tabData = new TabItem(this.folder, 0, 2);
        this.tabData.setText(ContextMessages.linksTab);
        Composite pageData = new Composite((Composite)this.folder, 0);
        this.tabData.setControl((Control)pageData);
        new Label(pageData, 0).setText(ContextMessages.linksLabel);
        GridLayout rightPaneLayout = new GridLayout();
        rightPaneLayout.marginHeight = 0;
        rightPaneLayout.marginWidth = 0;
        pageData.setLayout((Layout)rightPaneLayout);
        FilteredTree dataTree = new FilteredTree(pageData, 772, new PatternFilter(), true);
        GridData gridData = new GridData(4, 4, true, true);
        dataTree.setLayoutData((Object)gridData);
        this.dataViewer = dataTree.getViewer();
        LinksContentProvider contentProvider = new LinksContentProvider();
        this.dataViewer.setContentProvider((IContentProvider)contentProvider);
        this.dataViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        dataTree.getPatternFilter().setIncludeLeadingWildcard(true);
        return this.dataViewer;
    }

    private static class LinksContentProvider
    implements ITreeContentProvider {
        private EclipseContext selectedContext;

        public void dispose() {
            this.selectedContext = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.selectedContext = (EclipseContext)newInput;
        }

        public Object[] getElements(Object inputElement) {
            if (this.selectedContext == null) {
                return new Object[0];
            }
            Set listeners = this.selectedContext.getRawListenerNames();
            return listeners.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                Set tmp = this.selectedContext.getListeners((String)parentElement);
                return tmp.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof String) {
                Set tmp = this.selectedContext.getListeners((String)element);
                return !tmp.isEmpty();
            }
            return false;
        }
    }
}

