/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.dom;

import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ControlElement
extends WidgetElement {
    protected boolean hasFocus = false;
    protected boolean hasMouseHover = false;
    private FocusListener focusListener = new FocusAdapter(){

        public void focusGained(FocusEvent e) {
            ControlElement.this.hasFocus = true;
            ControlElement.this.doApplyStyles();
        }

        public void focusLost(FocusEvent e) {
            ControlElement.this.hasFocus = false;
            ControlElement.this.doApplyStyles();
        }
    };
    private MouseTrackListener mouseHoverListener = new MouseTrackAdapter(){

        public void mouseEnter(MouseEvent e) {
            ControlElement.this.hasMouseHover = true;
            ControlElement.this.doApplyStyles();
        }

        public void mouseExit(MouseEvent e) {
            ControlElement.this.hasMouseHover = false;
            ControlElement.this.doApplyStyles();
        }
    };

    public ControlElement(Control control, CSSEngine engine) {
        super((Widget)control, engine);
    }

    public void initialize() {
        super.initialize();
        if (!this.dynamicEnabled) {
            return;
        }
        Control control = this.getControl();
        control.addFocusListener(this.focusListener);
        control.addMouseTrackListener(this.mouseHoverListener);
    }

    public void dispose() {
        super.dispose();
        if (!this.dynamicEnabled) {
            return;
        }
        Control control = this.getControl();
        control.removeFocusListener(this.focusListener);
        control.removeMouseTrackListener(this.mouseHoverListener);
    }

    public boolean isPseudoInstanceOf(String s) {
        if ("focus".equals(s)) {
            return this.hasFocus;
        }
        if ("hover".equals(s)) {
            return this.hasMouseHover;
        }
        if ("enabled".equals(s)) {
            return this.getControl().getEnabled();
        }
        if ("disabled".equals(s)) {
            return this.getControl().getEnabled();
        }
        if ("visible".equals(s)) {
            return this.getControl().getVisible();
        }
        return super.isPseudoInstanceOf(s);
    }

    public Node getParentNode() {
        Control control = this.getControl();
        Composite parent = control.getParent();
        if (parent != null) {
            Element element = this.getElement(parent);
            return element;
        }
        return null;
    }

    protected Control getControl() {
        return (Control)this.getNativeWidget();
    }
}

