/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.ContributionRecord;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.e4.ui.workbench.swt.modeling.MenuService;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class MenuManagerRendererFilter
implements Listener {
    private static final String MMRF_STATIC_CONTEXT = "HCI-staticContext";
    public static final String NUL_MENU_ITEM = "(None Applicable)";
    private static final String TMP_ORIGINAL_CONTEXT = "MenuServiceFilter.original.context";
    private static Method aboutToShow;
    private static Method aboutToHide;
    @Inject
    private Logger logger;
    @Inject
    private EModelService modelService;
    @Inject
    private IRendererFactory rendererFactory;
    @Inject
    private MenuManagerRenderer renderer;
    @Inject
    private EHandlerService handlerService;
    private HashMap<Menu, Runnable> pendingCleanup = new HashMap();
    private SafeWrapper safeWrapper = new SafeWrapper();

    private static void trace(String msg, Widget menu, MMenu menuModel) {
        WorkbenchSWTActivator.trace((String)"/trace/menus", (String)(String.valueOf(msg) + ": " + menu + ": " + menuModel), null);
    }

    public static Method getAboutToShow() {
        if (aboutToShow == null) {
            try {
                aboutToShow = MenuManager.class.getDeclaredMethod("handleAboutToShow", new Class[0]);
                aboutToShow.setAccessible(true);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return aboutToShow;
    }

    public static Method getAboutToHide() {
        if (aboutToHide == null) {
            try {
                aboutToHide = MenuManager.class.getDeclaredMethod("handleAboutToHide", new Class[0]);
                aboutToHide.setAccessible(true);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return aboutToHide;
    }

    public void handleEvent(Event event) {
        this.safeWrapper.event = event;
        SafeRunner.run((ISafeRunnable)this.safeWrapper);
    }

    private void safeHandleEvent(Event event) {
        MenuManager tmpManager;
        Object tmp;
        if (!(event.widget instanceof Menu)) {
            return;
        }
        Menu menu = (Menu)event.widget;
        if ((menu.getStyle() & 2) != 0) {
            return;
        }
        if (event.type == 12) {
            MenuManagerRendererFilter.trace("handleMenu.Dispose", (Widget)menu, null);
            this.cleanUp(menu, null, null);
            return;
        }
        MMenu menuModel = null;
        MenuManager menuManager = null;
        Object obj = menu.getData("modelElement");
        if (obj == null && (tmp = menu.getData("org.eclipse.jface.action.MenuManager.managerKey")) instanceof MenuManager) {
            MUIElement container;
            MPopupMenu popupMenu;
            menuManager = tmpManager = (MenuManager)tmp;
            obj = this.renderer.getMenuModel(tmpManager);
            if (obj instanceof MPopupMenu && (popupMenu = (MPopupMenu)obj).getWidget() == null && menuManager.getMenu() != null && (container = this.modelService.getContainer((MUIElement)popupMenu)) instanceof MPart) {
                MenuService.registerMenu((Control)menuManager.getMenu().getParent(), (MPopupMenu)popupMenu, (MPart)((MPart)container));
            }
        }
        if (obj == null && menu.getParentItem() != null && (obj = menu.getParentItem().getData("modelElement")) == null && (tmp = menu.getParentItem().getData()) instanceof MenuManager && menu == (tmpManager = (MenuManager)tmp).getMenu()) {
            menuManager = tmpManager;
            obj = this.renderer.getMenuModel(tmpManager);
        }
        if (obj instanceof MMenu) {
            menuModel = (MMenu)obj;
        }
        if (menuManager == null && menuModel != null) {
            menuManager = this.renderer.getManager(menuModel);
        }
        switch (event.type) {
            case 22: {
                this.handleShow(event, menu, menuModel, menuManager);
                break;
            }
            case 23: {
                this.handleHide(event, menu, menuModel, menuManager);
            }
        }
    }

    private void handleShow(Event event, Menu menu, MMenu menuModel, MenuManager menuManager) {
        if (menuModel != null && menuManager != null) {
            this.cleanUp(menu, menuModel, menuManager);
        }
        if (menuModel instanceof MPopupMenu) {
            this.showPopup(event, menu, (MPopupMenu)menuModel, menuManager);
        }
        if (menuModel != null) {
            this.showMenu(event, menu, menuModel, menuManager);
        } else {
            MenuManagerRendererFilter.trace("Incorrect menu model to work with " + menuManager, (Widget)menu, menuModel);
        }
    }

    private void handleHide(Event event, Menu menu, MMenu menuModel, MenuManager menuManager) {
        if (menuModel instanceof MPopupMenu) {
            this.hidePopup(event, menu, (MPopupMenu)menuModel, menuManager);
        }
    }

    public void showMenu(Event event, Menu menu, MMenu menuModel, MenuManager menuManager) {
        AbstractPartRenderer obj = this.rendererFactory.getRenderer((MUIElement)menuModel, (Object)menu.getParent());
        if (!(obj instanceof MenuManagerRenderer)) {
            MenuManagerRendererFilter.trace("Not the correct renderer: " + obj, (Widget)menu, menuModel);
            return;
        }
        MenuManagerRenderer renderer = (MenuManagerRenderer)obj;
        if (menuModel.getWidget() == null) {
            renderer.bindWidget((MUIElement)menuModel, menuManager.getMenu());
        }
        Method handleAboutToShow = MenuManagerRendererFilter.getAboutToShow();
        try {
            handleAboutToShow.invoke((Object)menuManager, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        IEclipseContext evalContext = menuModel instanceof MContext ? ((MContext)menuModel).getContext() : this.modelService.getContainingContext((MUIElement)menuModel);
        this.updateElementVisibility(menuModel, renderer, menuManager, evalContext, true);
        event.type = 0;
        event.doit = false;
        menuManager.update(false);
    }

    private void updateElementVisibility(MMenu menuModel, MenuManagerRenderer renderer, MenuManager menuManager, IEclipseContext evalContext, boolean recurse) {
        ExpressionContext exprContext = new ExpressionContext(evalContext);
        HashSet<ContributionRecord> records = new HashSet<ContributionRecord>();
        for (MMenuElement element : menuModel.getChildren()) {
            MDirectMenuItem contrib;
            IEclipseContext staticContext;
            MHandledMenuItem item;
            MMenu childMenu;
            MenuManager childManager;
            ContributionRecord record = renderer.getContributionRecord(element);
            if (record != null) {
                if (records.add(record)) {
                    record.updateVisibility(evalContext);
                }
            } else {
                MenuManagerRenderer.updateVisibility(menuManager, element, exprContext);
            }
            if (recurse && element.isVisible() && element instanceof MMenu && (childManager = renderer.getManager(childMenu = (MMenu)element)) != null) {
                this.updateElementVisibility(childMenu, renderer, childManager, evalContext, false);
            }
            if (element instanceof MHandledMenuItem) {
                ParameterizedCommand cmd = ((MHandledMenuItem)element).getWbCommand();
                if (cmd == null) continue;
                item = (MHandledMenuItem)element;
                staticContext = EclipseContextFactory.create((String)MMRF_STATIC_CONTEXT);
                ContributionsAnalyzer.populateModelInterfaces((Object)item, (IEclipseContext)staticContext, (Class[])item.getClass().getInterfaces());
                try {
                    ((MHandledMenuItem)element).setEnabled(this.handlerService.canExecute(cmd, staticContext));
                    continue;
                }
                finally {
                    staticContext.dispose();
                }
            }
            if (!(element instanceof MDirectMenuItem) || (contrib = (MDirectMenuItem)element).getObject() == null) continue;
            item = (MDirectMenuItem)element;
            staticContext = EclipseContextFactory.create((String)MMRF_STATIC_CONTEXT);
            ContributionsAnalyzer.populateModelInterfaces((Object)item, (IEclipseContext)staticContext, (Class[])item.getClass().getInterfaces());
            try {
                Object rc = ContextInjectionFactory.invoke((Object)contrib.getObject(), CanExecute.class, (IEclipseContext)evalContext, (IEclipseContext)staticContext, (Object)Boolean.TRUE);
                if (!(rc instanceof Boolean)) continue;
                contrib.setEnabled(((Boolean)rc).booleanValue());
            }
            finally {
                staticContext.dispose();
            }
        }
    }

    public void hidePopup(Event event, Menu menu, MPopupMenu menuModel, MenuManager menuManager) {
        final IEclipseContext popupContext = menuModel.getContext();
        final IEclipseContext originalChild = (IEclipseContext)popupContext.get(TMP_ORIGINAL_CONTEXT);
        popupContext.remove(TMP_ORIGINAL_CONTEXT);
        if (!menu.isDisposed()) {
            menu.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (originalChild == null) {
                        popupContext.deactivate();
                    } else {
                        originalChild.activate();
                    }
                }
            });
        }
    }

    public void showPopup(Event event, Menu menu, MPopupMenu menuModel, MenuManager menuManager) {
        IEclipseContext popupContext = menuModel.getContext();
        IEclipseContext parentContext = popupContext.getParent();
        IEclipseContext originalChild = parentContext.getActiveChild();
        popupContext.activate();
        popupContext.set(TMP_ORIGINAL_CONTEXT, (Object)originalChild);
    }

    void setEnabled(MHandledMenuItem item) {
        if (!item.isToBeRendered() || !item.isVisible() || item.getWidget() == null) {
            return;
        }
        ParameterizedCommand cmd = item.getWbCommand();
        if (cmd == null) {
            return;
        }
        IEclipseContext lclContext = this.modelService.getContainingContext((MUIElement)item);
        EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class);
        IEclipseContext staticContext = EclipseContextFactory.create((String)MMRF_STATIC_CONTEXT);
        ContributionsAnalyzer.populateModelInterfaces((Object)item, (IEclipseContext)staticContext, (Class[])item.getClass().getInterfaces());
        try {
            item.setEnabled(service.canExecute(cmd, staticContext));
        }
        finally {
            staticContext.dispose();
        }
    }

    public void cleanUp(Menu menu, MMenu menuModel, MenuManager menuManager) {
        MenuManagerRendererFilter.trace("cleanUp", (Widget)menu, null);
        if (this.pendingCleanup.isEmpty()) {
            return;
        }
        Runnable cleanUp = this.pendingCleanup.remove(menu);
        if (cleanUp != null) {
            MenuManagerRendererFilter.trace("cleanUp.run()", (Widget)menu, null);
            cleanUp.run();
        }
    }

    public void dispose() {
        Menu[] keys;
        Menu[] menuArray = keys = this.pendingCleanup.keySet().toArray(new Menu[this.pendingCleanup.size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Menu menu = menuArray[n2];
            this.cleanUp(menu, null, null);
            ++n2;
        }
    }

    private class SafeWrapper
    implements ISafeRunnable {
        Event event;

        private SafeWrapper() {
        }

        public void handleException(Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (MenuManagerRendererFilter.this.logger != null) {
                MenuManagerRendererFilter.this.logger.error(e);
            }
        }

        public void run() throws Exception {
            MenuManagerRendererFilter.this.safeHandleEvent(this.event);
        }
    }
}

