/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ShellActivationListener
implements Listener {
    public static final String DIALOG_IGNORE_KEY = "org.eclipse.e4.ui.ignoreDialog";
    private static final String ECLIPSE_CONTEXT_SHELL_CONTEXT = "org.eclipse.e4.ui.shellContext";
    private MApplication application;

    ShellActivationListener(MApplication application) {
        this.application = application;
    }

    public void handleEvent(Event event) {
        if (!(event.widget instanceof Shell)) {
            return;
        }
        Shell shell = (Shell)event.widget;
        Object obj = shell.getData("modelElement");
        if (obj instanceof MWindow) {
            this.processWindow(event, shell, (MWindow)obj);
            return;
        }
        obj = shell.getData(DIALOG_IGNORE_KEY);
        if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            return;
        }
        switch (event.type) {
            case 26: {
                this.activate(shell);
                break;
            }
            case 27: {
                this.deactivate(shell);
            }
        }
    }

    private void processWindow(Event event, Shell shell, MWindow window) {
        switch (event.type) {
            case 26: {
                final IEclipseContext local = window.getContext();
                WorkbenchSWTActivator.trace("/trace/workbench", "setting mwindow context " + local, null);
                shell.setData(ECLIPSE_CONTEXT_SHELL_CONTEXT, (Object)local);
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        local.activateBranch();
                    }

                    public void handleException(Throwable exception) {
                        WorkbenchSWTActivator.trace("/trace/workbench", "failed correcting context chain", exception);
                    }
                });
                break;
            }
            case 27: {
                IEclipseContext context = window.getContext();
                WorkbenchSWTActivator.trace("/trace/workbench", "setting mwindow context " + context, null);
                shell.setData(ECLIPSE_CONTEXT_SHELL_CONTEXT, (Object)context);
            }
        }
    }

    private void activate(Shell shell) {
        IEclipseContext parentContext = this.application.getContext();
        final IEclipseContext shellContext = this.getShellContext(shell, parentContext);
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                shellContext.activate();
            }

            public void handleException(Throwable exception) {
                WorkbenchSWTActivator.trace("/trace/workbench", "failed setting dialog child", exception);
            }
        });
    }

    private void deactivate(Shell shell) {
        Shell parent;
        Shell shell2 = parent = shell.isDisposed() ? null : (Shell)shell.getParent();
        if (parent == null) {
            IEclipseContext currentlyActive = this.application.getContext().getActiveChild();
            if (currentlyActive != null) {
                currentlyActive.deactivate();
            }
            return;
        }
        final IEclipseContext prevChild = (IEclipseContext)parent.getData(ECLIPSE_CONTEXT_SHELL_CONTEXT);
        final IEclipseContext parentContext = this.application.getContext();
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                if (prevChild == null) {
                    IEclipseContext activeChild = parentContext.getActiveChild();
                    if (activeChild != null) {
                        activeChild.deactivate();
                    }
                } else {
                    prevChild.activate();
                }
            }

            public void handleException(Throwable exception) {
                WorkbenchSWTActivator.trace("/trace/workbench", "failed resetting previous child", exception);
            }
        });
    }

    private IEclipseContext getShellContext(final Shell shell, IEclipseContext parentContext) {
        IEclipseContext shellContext = (IEclipseContext)shell.getData(ECLIPSE_CONTEXT_SHELL_CONTEXT);
        if (shellContext != null) {
            return shellContext;
        }
        final IEclipseContext context = parentContext.createChild("org.eclipse.ui.contexts.dialog");
        context.set("localActiveShell", (Object)shell);
        shell.setData(ECLIPSE_CONTEXT_SHELL_CONTEXT, (Object)context);
        EContextService contextService = (EContextService)context.get(EContextService.class);
        contextService.activateContext("org.eclipse.ui.contexts.dialog");
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ShellActivationListener.this.deactivate(shell);
                context.dispose();
            }
        });
        return context;
    }
}

