/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;

public class ApplicationSelectionServiceImpl
implements ESelectionService {
    private MApplication application;

    @Inject
    ApplicationSelectionServiceImpl(MApplication application) {
        this.application = application;
    }

    private ESelectionService getActiveWindowService() {
        IEclipseContext activeWindowContext = this.application.getContext().getActiveChild();
        if (activeWindowContext == null) {
            throw new IllegalStateException("Application does not have an active window");
        }
        ESelectionService activeWindowSelectionService = (ESelectionService)activeWindowContext.get(ESelectionService.class);
        if (activeWindowSelectionService == null) {
            throw new IllegalStateException("Active window context is invalid");
        }
        return activeWindowSelectionService;
    }

    public void setSelection(Object selection) {
        throw new UnsupportedOperationException("Cannot set the selection of an application");
    }

    public Object getSelection() {
        return this.getActiveWindowService().getSelection();
    }

    public Object getSelection(String partId) {
        throw new UnsupportedOperationException("Cannot retrieve the selection of a given part from the application");
    }

    public void addSelectionListener(ISelectionListener listener) {
        throw new UnsupportedOperationException("Cannot add global listeners to the application");
    }

    public void removeSelectionListener(ISelectionListener listener) {
        throw new UnsupportedOperationException("Cannot remove global listeners to the application");
    }

    public void addSelectionListener(String partId, ISelectionListener listener) {
        throw new UnsupportedOperationException("Cannot add global listeners to the application");
    }

    public void removeSelectionListener(String partId, ISelectionListener listener) {
        throw new UnsupportedOperationException("Cannot remove global listeners to the application");
    }
}

