/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.SelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.WizardWithLicenses;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreselectedIUInstallWizard
extends WizardWithLicenses {
    QueryableMetadataRepositoryManager manager;

    public PreselectedIUInstallWizard(ProvisioningUI ui, InstallOperation operation, Collection<IInstallableUnit> initialSelections, LoadMetadataRepositoryJob job) {
        super(ui, (ProfileChangeOperation)operation, initialSelections.toArray(), job);
        this.setWindowTitle(ProvUIMessages.InstallIUOperationLabel);
        this.setDefaultPageImageDescriptor(ProvUIImages.getImageDescriptor("wizban/install_wiz.gif"));
    }

    @Override
    protected ISelectableIUsPage createMainPage(IUElementListRoot input, Object[] selections) {
        this.mainPage = new SelectableIUsPage(this.ui, this, input, selections);
        this.mainPage.setTitle(ProvUIMessages.PreselectedIUInstallWizard_Title);
        this.mainPage.setDescription(ProvUIMessages.PreselectedIUInstallWizard_Description);
        ((SelectableIUsPage)this.mainPage).updateStatus(input, this.operation);
        return this.mainPage;
    }

    @Override
    protected ResolutionResultsWizardPage createResolutionPage() {
        return new InstallWizardPage(this.ui, (ProvisioningOperationWizard)this, this.root, (InstallOperation)this.operation);
    }

    @Override
    protected void initializeResolutionModelElements(Object[] selectedElements) {
        this.root = new IUElementListRoot();
        ArrayList<AvailableIUElement> list = new ArrayList<AvailableIUElement>(selectedElements.length);
        ArrayList<AvailableIUElement> selected = new ArrayList<AvailableIUElement>(selectedElements.length);
        int i = 0;
        while (i < selectedElements.length) {
            IInstallableUnit iu = ElementUtils.getIU(selectedElements[i]);
            if (iu != null) {
                AvailableIUElement element = new AvailableIUElement(this.root, iu, this.getProfileId(), this.shouldShowProvisioningPlanChildren());
                list.add(element);
                selected.add(element);
            }
            ++i;
        }
        this.root.setChildren(list.toArray());
        this.planSelections = selected.toArray();
    }

    @Override
    protected IResolutionErrorReportingPage createErrorReportingPage() {
        return (IResolutionErrorReportingPage)this.mainPage;
    }

    @Override
    protected ProfileChangeOperation getProfileChangeOperation(Object[] elements) {
        InstallOperation op = new InstallOperation(this.ui.getSession(), ElementUtils.elementsToIUs(elements));
        op.setProfileId(this.getProfileId());
        return op;
    }
}

