/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.DeleteBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.MethodBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

public class MethodBreakpointMethodChange
extends MethodBreakpointChange {
    private IMethod fDestMethod;

    public MethodBreakpointMethodChange(IJavaMethodBreakpoint breakpoint, IMethod destMethod) throws CoreException {
        super(breakpoint);
        this.fDestMethod = destMethod;
    }

    public String getName() {
        return MessageFormat.format((String)RefactoringMessages.MethodBreakpointMethodChange_0, (Object[])new String[]{this.getBreakpointLabel((IBreakpoint)this.getOriginalBreakpoint()), this.fDestMethod.getElementName()});
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        HashMap map = new HashMap();
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)this.fDestMethod);
        IResource resource = BreakpointUtils.getBreakpointResource((IMember)this.fDestMethod);
        int[] range = this.getNewLineNumberAndRange((IMember)this.fDestMethod);
        IJavaMethodBreakpoint breakpoint = JDIDebugModel.createMethodBreakpoint((IResource)resource, (String)this.fDestMethod.getDeclaringType().getFullyQualifiedName(), (String)this.fDestMethod.getElementName(), (String)this.fDestMethod.getSignature(), (boolean)this.isEntry(), (boolean)this.isExit(), (boolean)this.isNativeOnly(), (int)-1, (int)range[1], (int)range[2], (int)this.getHitCount(), (boolean)true, map);
        this.apply(breakpoint);
        this.getOriginalBreakpoint().delete();
        return new DeleteBreakpointChange((IJavaBreakpoint)breakpoint);
    }
}

