/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.AEDesc;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.NavCBRec;
import org.eclipse.swt.internal.carbon.NavDialogCreationOptions;
import org.eclipse.swt.internal.carbon.NavFileOrFolderInfo;
import org.eclipse.swt.internal.carbon.NavMenuItemSpec;
import org.eclipse.swt.internal.carbon.NavReplyRecord;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    int dialog;
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    int filterIndex = 0;
    boolean overwrite = false;
    static final char EXTENSION_SEPARATOR = ';';

    public FileDialog(Shell parent) {
        this(parent, 65536);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, FileDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    int eventProc(int callBackSelector, int callBackParms, int callBackUD) {
        switch (callBackSelector) {
            case 8: {
                NavCBRec cbRec = new NavCBRec();
                OS.memmove(cbRec, callBackParms, 254);
                if (cbRec.eventData.eventDataParms.param == 0) break;
                NavMenuItemSpec spec = new NavMenuItemSpec();
                OS.memmove(spec, cbRec.eventData.eventDataParms.param, 512);
                int index = spec.menuType;
                if (index < 0 || index >= this.filterExtensions.length) break;
                this.filterIndex = index;
            }
        }
        return 0;
    }

    int filterProc(int theItem, int infoPtr, int callBackUD, int filterMode) {
        int result = 1;
        if (filterMode == 0 && this.filterExtensions != null && this.filterIndex >= 0 && this.filterIndex < this.filterExtensions.length) {
            NavFileOrFolderInfo info = new NavFileOrFolderInfo();
            OS.memmove(info, infoPtr, 268);
            if (!info.isFolder) {
                int url;
                AEDesc desc = new AEDesc();
                OS.AECoerceDesc(theItem, 1718841958, desc);
                byte[] fsRef = new byte[80];
                if (OS.AEGetDescData(desc, fsRef, fsRef.length) == 0 && (url = OS.CFURLCreateFromFSRef(0, fsRef)) != 0) {
                    int fName = OS.CFURLCopyLastPathComponent(url);
                    OS.CFRelease(url);
                    if (fName != 0) {
                        char[] buffer = new char[OS.CFStringGetLength(fName)];
                        if (buffer.length > 0) {
                            CFRange range = new CFRange();
                            range.length = buffer.length;
                            OS.CFStringGetCharacters(fName, range, buffer);
                        }
                        OS.CFRelease(fName);
                        String fileName = new String(buffer);
                        String extensions = this.filterExtensions[this.filterIndex];
                        int start = 0;
                        int length = extensions.length();
                        result = 0;
                        while (start < length) {
                            String filter;
                            int index = extensions.indexOf(59, start);
                            if (index == -1) {
                                index = length;
                            }
                            if ((filter = extensions.substring(start, index).trim()).equals("*") || filter.equals("*.*")) {
                                result = 1;
                                break;
                            }
                            if (filter.startsWith("*.")) {
                                filter = filter.substring(2);
                            }
                            if (fileName.toLowerCase().endsWith("." + filter.toLowerCase())) {
                                result = 1;
                                break;
                            }
                            start = index + 1;
                        }
                    }
                }
                OS.AEDisposeDesc(desc);
            }
        }
        return result;
    }

    String getString(int cfString) {
        if (cfString == 0) {
            return "";
        }
        int length = OS.CFStringGetLength(cfString);
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(cfString, range, buffer);
        return new String(buffer);
    }

    public String open() {
        String fullPath = null;
        this.fileNames = new String[0];
        int titlePtr = 0;
        if (this.title != null) {
            char[] buffer = new char[this.title.length()];
            this.title.getChars(0, buffer.length, buffer, 0);
            titlePtr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        }
        int fileNamePtr = 0;
        if (this.fileName != null) {
            char[] buffer = new char[this.fileName.length()];
            this.fileName.getChars(0, buffer.length, buffer, 0);
            fileNamePtr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        }
        NavDialogCreationOptions options = new NavDialogCreationOptions();
        options.windowTitle = options.clientName = titlePtr;
        options.parentWindow = OS.GetControlOwner(this.parent.handle);
        options.optionFlags = 4352;
        options.location_h = (short)-1;
        options.location_v = (short)-1;
        options.saveFileName = fileNamePtr;
        options.modality = 2;
        int extensions = 0;
        Callback filterCallback = null;
        Callback eventCallback = null;
        int[] outDialog = new int[1];
        int filterProc = 0;
        int eventProc = 0;
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            extensions = options.popupExtension = OS.CFArrayCreateMutable(0, this.filterExtensions.length, OS.kCFTypeArrayCallBacks());
            int i = 0;
            while (i < this.filterExtensions.length) {
                String str = this.filterExtensions[i];
                if (this.filterNames != null && this.filterNames.length > i) {
                    str = this.filterNames[i];
                }
                char[] chars = new char[str.length()];
                str.getChars(0, chars.length, chars, 0);
                int ptr = OS.CFStringCreateWithCharacters(0, chars, chars.length);
                if (ptr != 0) {
                    OS.CFArrayAppendValue(extensions, ptr);
                    OS.CFRelease(ptr);
                }
                ++i;
            }
            if ((this.style & 0x2000) == 0 && (filterProc = (filterCallback = new Callback(this, "filterProc", 4)).getAddress()) == 0) {
                SWT.error(3);
            }
            if ((eventProc = (eventCallback = new Callback(this, "eventProc", 3)).getAddress()) == 0) {
                SWT.error(3);
            }
        }
        if ((this.style & 0x2000) != 0) {
            if (!this.overwrite) {
                options.optionFlags |= 0x10000;
            }
            OS.NavCreatePutFileDialog(options, 0, 0, eventProc, 0, outDialog);
        } else {
            if ((this.style & 2) != 0) {
                options.optionFlags |= 0x80;
            }
            OS.NavCreateGetFileDialog(options, 0, eventProc, 0, filterProc, 0, outDialog);
        }
        if (outDialog[0] != 0) {
            if (this.filterPath != null && this.filterPath.length() > 0) {
                char[] chars = new char[this.filterPath.length()];
                this.filterPath.getChars(0, chars.length, chars, 0);
                int str = OS.CFStringCreateWithCharacters(0, chars, chars.length);
                if (str != 0) {
                    int url = OS.CFURLCreateWithFileSystemPath(0, str, 0, false);
                    if (url != 0) {
                        AEDesc params;
                        byte[] fsRef = new byte[80];
                        if (OS.CFURLGetFSRef(url, fsRef) && OS.AECreateDesc(1718841958, fsRef, fsRef.length, params = new AEDesc()) == 0) {
                            OS.NavCustomControl(outDialog[0], 8, params);
                            OS.AEDisposeDesc(params);
                        }
                        OS.CFRelease(url);
                    }
                    OS.CFRelease(str);
                }
            }
            if (this.filterExtensions != null && this.filterIndex >= 0 && this.filterIndex < this.filterExtensions.length) {
                NavMenuItemSpec spec = new NavMenuItemSpec();
                spec.menuType = this.filterIndex;
                OS.NavCustomControl(outDialog[0], 21, spec);
            }
            Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
            this.dialog = outDialog[0];
            display.setModalDialog(this);
            OS.NavDialogRun(outDialog[0]);
            display.setModalDialog(null);
            this.dialog = 0;
            int action = OS.NavDialogGetUserAction(outDialog[0]);
            switch (action) {
                case 2: 
                case 3: 
                case 4: {
                    NavReplyRecord record = new NavReplyRecord();
                    OS.NavDialogGetReply(outDialog[0], record);
                    AEDesc selection = new AEDesc();
                    selection.descriptorType = record.selection_descriptorType;
                    selection.dataHandle = record.selection_dataHandle;
                    int[] count = new int[1];
                    OS.AECountItems(selection, count);
                    if (count[0] > 0) {
                        this.fileNames = new String[count[0]];
                        int maximumSize = 80;
                        int dataPtr = OS.NewPtr(maximumSize);
                        int[] aeKeyword = new int[1];
                        int[] typeCode = new int[1];
                        int[] actualSize = new int[1];
                        if ((this.style & 0x2000) != 0) {
                            if (OS.AEGetNthPtr(selection, 1, 1718841958, aeKeyword, typeCode, dataPtr, maximumSize, actualSize) == 0) {
                                byte[] fsRef = new byte[actualSize[0]];
                                OS.memmove(fsRef, dataPtr, actualSize[0]);
                                int pathUrl = OS.CFURLCreateFromFSRef(0, fsRef);
                                int pathString = OS.CFURLCopyFileSystemPath(pathUrl, 0);
                                this.filterPath = this.getString(pathString);
                                OS.CFRelease(pathString);
                                int fullUrl = OS.CFURLCreateCopyAppendingPathComponent(0, pathUrl, record.saveFileName, false);
                                if (this.filterExtensions != null && this.filterExtensions.length != 0 && this.filterIndex >= 0 && this.filterIndex < this.filterExtensions.length) {
                                    int ext = OS.CFURLCopyPathExtension(fullUrl);
                                    if (ext == 0) {
                                        String filter;
                                        String exts = this.filterExtensions[this.filterIndex];
                                        int length = exts.length();
                                        int index = exts.indexOf(59);
                                        if (index == -1) {
                                            index = length;
                                        }
                                        if (!(filter = exts.substring(0, index).trim()).equals("*") && !filter.equals("*.*")) {
                                            if (filter.startsWith("*.")) {
                                                filter = filter.substring(2);
                                            }
                                            char[] buffer = new char[filter.length()];
                                            filter.getChars(0, buffer.length, buffer, 0);
                                            ext = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                                            int fullUrlWithExt = OS.CFURLCreateCopyAppendingPathExtension(0, fullUrl, ext);
                                            OS.CFRelease(fullUrl);
                                            fullUrl = fullUrlWithExt;
                                        }
                                    }
                                    if (ext != 0) {
                                        OS.CFRelease(ext);
                                    }
                                }
                                int fullString = OS.CFURLCopyFileSystemPath(fullUrl, 0);
                                fullPath = this.getString(fullString);
                                OS.CFRelease(fullString);
                                int file = OS.CFURLCopyLastPathComponent(fullUrl);
                                this.fileName = this.fileNames[0] = this.getString(file);
                                OS.CFRelease(file);
                                OS.CFRelease(fullUrl);
                                OS.CFRelease(pathUrl);
                            }
                        } else {
                            int i = 0;
                            while (i < count[0]) {
                                if (OS.AEGetNthPtr(selection, i + 1, 1718841958, aeKeyword, typeCode, dataPtr, maximumSize, actualSize) == 0) {
                                    int fileString;
                                    byte[] fsRef = new byte[actualSize[0]];
                                    OS.memmove(fsRef, dataPtr, actualSize[0]);
                                    int url = OS.CFURLCreateFromFSRef(0, fsRef);
                                    int fullString = OS.CFURLCopyFileSystemPath(url, 0);
                                    int pathUrl = OS.CFURLCreateCopyDeletingLastPathComponent(0, url);
                                    int pathString = OS.CFURLCopyFileSystemPath(pathUrl, 0);
                                    String path = this.getString(pathString);
                                    OS.CFRelease(pathString);
                                    OS.CFRelease(pathUrl);
                                    if (i == 0) {
                                        fullPath = this.getString(fullString);
                                        this.filterPath = path;
                                        fileString = OS.CFURLCopyLastPathComponent(url);
                                        this.fileName = this.fileNames[0] = this.getString(fileString);
                                        OS.CFRelease(fileString);
                                    } else if (path.equals(this.filterPath)) {
                                        fileString = OS.CFURLCopyLastPathComponent(url);
                                        this.fileNames[i] = this.getString(fileString);
                                        OS.CFRelease(fileString);
                                    } else {
                                        this.fileNames[i] = this.getString(fullString);
                                    }
                                    OS.CFRelease(fullString);
                                    OS.CFRelease(url);
                                }
                                ++i;
                            }
                        }
                        OS.DisposePtr(dataPtr);
                    }
                    OS.NavDisposeReply(record);
                }
            }
        }
        if (titlePtr != 0) {
            OS.CFRelease(titlePtr);
        }
        if (fileNamePtr != 0) {
            OS.CFRelease(fileNamePtr);
        }
        if (outDialog[0] != 0) {
            OS.NavDialogDispose(outDialog[0]);
        }
        if (extensions != 0) {
            OS.CFRelease(extensions);
        }
        if (filterCallback != null) {
            filterCallback.dispose();
        }
        if (eventCallback != null) {
            eventCallback.dispose();
        }
        return fullPath;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterIndex(int index) {
        this.filterIndex = index;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

