/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    ToolTip toolTip;
    String toolTipText;
    boolean visible = true;
    boolean highlight;
    int handle;
    int nsImage;
    int view;
    int jniRef;
    static final float BORDER = 8.0f;

    public TrayItem(Tray parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
        this.createWidget();
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget() {
        int statusBar = Cocoa.objc_msgSend(Cocoa.C_NSStatusBar, Cocoa.S_systemStatusBar);
        this.handle = Cocoa.objc_msgSend(statusBar, Cocoa.S_statusItemWithLength, 0.0f);
        if (this.handle == 0) {
            this.error(2);
        }
        Cocoa.objc_msgSend(this.handle, Cocoa.S_retain);
        Cocoa.objc_msgSend(this.handle, Cocoa.S_setHighlightMode, 1);
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            SWT.error(2);
        }
        NSRect rect = new NSRect();
        this.view = Cocoa.objc_msgSend(Cocoa.C_NSStatusItemImageView, Cocoa.S_alloc);
        if (this.view == 0) {
            this.error(2);
        }
        this.view = Cocoa.objc_msgSend(this.view, Cocoa.S_initWithProc_frame_user_data, this.display.trayItemProc, rect, this.jniRef);
        Cocoa.objc_msgSend(this.handle, Cocoa.S_setView, this.view);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    Point getLocation() {
        NSRect rect = new NSRect();
        Cocoa.objc_msgSend_stret(rect, this.view, Cocoa.S_frame);
        NSRect windowRect = new NSRect();
        Cocoa.objc_msgSend_stret(windowRect, Cocoa.objc_msgSend(this.view, Cocoa.S_window), Cocoa.S_frame);
        rect.x += rect.width / 2.0f;
        rect.y += rect.height;
        Cocoa.objc_msgSend_stret(rect, this.view, Cocoa.S_convertRect_toView, rect, 0);
        rect.x += windowRect.x;
        return new Point((int)rect.x, (int)rect.y);
    }

    Point getMenuLocation() {
        NSRect rect = new NSRect();
        Cocoa.objc_msgSend_stret(rect, this.view, Cocoa.S_frame);
        NSRect windowRect = new NSRect();
        Cocoa.objc_msgSend_stret(windowRect, Cocoa.objc_msgSend(this.view, Cocoa.S_window), Cocoa.S_frame);
        rect.y += rect.height;
        Cocoa.objc_msgSend_stret(rect, this.view, Cocoa.S_convertRect_toView, rect, 0);
        rect.x += windowRect.x;
        return new Point((int)rect.x, (int)rect.y + 4);
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.handle = 0;
    }

    void releaseWidget() {
        int statusBar = Cocoa.objc_msgSend(Cocoa.C_NSStatusBar, Cocoa.S_systemStatusBar);
        Cocoa.objc_msgSend(statusBar, Cocoa.S_removeStatusItem, this.handle);
        Cocoa.objc_msgSend(this.handle, Cocoa.S_release);
        if (this.nsImage != 0) {
            Cocoa.objc_msgSend(this.nsImage, Cocoa.S_release);
        }
        if (this.view != 0) {
            Cocoa.objc_msgSend(this.view, Cocoa.S_setUserData, 0);
            Cocoa.objc_msgSend(this.view, Cocoa.S_setProc, 0);
            Cocoa.objc_msgSend(this.view, Cocoa.S_release);
        }
        if (this.jniRef != 0) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        this.jniRef = 0;
        this.view = 0;
        this.nsImage = 0;
        this.handle = 0;
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (this.nsImage != 0) {
            Cocoa.objc_msgSend(this.nsImage, Cocoa.S_release, this.nsImage);
        }
        this.nsImage = 0;
        if (image != null) {
            CGRect rect = new CGRect();
            rect.width = OS.CGImageGetWidth(image.handle);
            rect.height = OS.CGImageGetHeight(image.handle);
            NSSize size = new NSSize();
            size.width = rect.width;
            size.height = rect.height;
            this.nsImage = Cocoa.objc_msgSend(Cocoa.C_NSImage, Cocoa.S_alloc);
            this.nsImage = Cocoa.objc_msgSend(this.nsImage, Cocoa.S_initWithSize, size);
            Cocoa.objc_msgSend(this.nsImage, Cocoa.S_lockFocus);
            int imageContext = Cocoa.objc_msgSend(Cocoa.C_NSGraphicsContext, Cocoa.S_currentContext);
            imageContext = Cocoa.objc_msgSend(imageContext, Cocoa.S_graphicsPort);
            OS.CGContextDrawImage(imageContext, rect, image.handle);
            Cocoa.objc_msgSend(this.nsImage, Cocoa.S_unlockFocus);
        }
        Cocoa.objc_msgSend(this.view, Cocoa.S_setImage, this.nsImage);
        float width = image != null && this.visible ? (float)OS.CGImageGetWidth(image.handle) + 8.0f : 0.0f;
        Cocoa.objc_msgSend(this.handle, Cocoa.S_setLength, width);
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip oldTip = this.toolTip;
        ToolTip newTip = toolTip;
        if (oldTip != null) {
            oldTip.item = null;
        }
        this.toolTip = newTip;
        if (newTip != null) {
            newTip.item = this;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this._setToolTipText(string);
    }

    void _setToolTipText(String string) {
        int ptr = 0;
        if (string != null) {
            char[] chars = new char[string.length()];
            string.getChars(0, chars.length, chars, 0);
            ptr = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        }
        Cocoa.objc_msgSend(this.view, Cocoa.S_setToolTip, ptr);
        if (ptr != 0) {
            OS.CFRelease(ptr);
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.visible == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        this.visible = visible;
        float width = this.image != null && visible ? (float)OS.CGImageGetWidth(this.image.handle) + 8.0f : 0.0f;
        Cocoa.objc_msgSend(this.handle, Cocoa.S_setLength, width);
        if (!visible) {
            this.sendEvent(23);
        }
    }

    void displayMenu() {
        if (this.highlight) {
            Cocoa.objc_msgSend(this.view, Cocoa.S_display);
            Display display = this.display;
            display.trayItemMenu = null;
            this.showMenu();
            if (display.trayItemMenu != null) {
                display.trayItemMenu = null;
                this.highlight = false;
                Cocoa.objc_msgSend(this.view, Cocoa.S_setNeedsDisplay, 1);
            }
        }
    }

    boolean shouldShowMenu(int event) {
        if (!this.hooks(35)) {
            return false;
        }
        switch (Cocoa.objc_msgSend(event, Cocoa.S_type)) {
            case 3: {
                return true;
            }
            case 1: {
                if (!this.hooks(13) && !this.hooks(14)) {
                    return true;
                }
                return (Cocoa.objc_msgSend(event, Cocoa.S_modifierFlags) & 0xFFFF0000) == 262144;
            }
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    void showMenu() {
        this._setToolTipText(null);
        Display display = this.display;
        display.currentTrayItem = this;
        this.sendEvent(35);
        if (!this.isDisposed()) {
            display.runPopups();
        }
        display.currentTrayItem = null;
        if (this.isDisposed()) {
            return;
        }
        this._setToolTipText(this.toolTipText);
    }

    int trayItemProc(int target, int userData, int selector, int arg0) {
        switch (selector) {
            case 0: 
            case 2: {
                this.highlight = true;
                Cocoa.objc_msgSend(this.view, Cocoa.S_setNeedsDisplay, 1);
                if (!this.shouldShowMenu(arg0)) break;
                this.displayMenu();
                break;
            }
            case 1: 
            case 4: {
                if (this.highlight && Cocoa.objc_msgSend(arg0, Cocoa.S_type) == 2) {
                    this.sendSelectionEvent(Cocoa.objc_msgSend(arg0, Cocoa.S_clickCount) == 2 ? 14 : 13);
                }
                this.highlight = false;
                Cocoa.objc_msgSend(this.view, Cocoa.S_setNeedsDisplay, 1);
                break;
            }
            case 3: {
                NSRect rect = new NSRect();
                Cocoa.memcpy(rect, arg0, 16);
                Cocoa.objc_msgSend(this.handle, Cocoa.S_drawStatusBarBackgroundInRect_withHighlight, rect, this.highlight ? 1 : 0);
                break;
            }
            case 5: 
            case 6: {
                NSRect frame = new NSRect();
                Cocoa.objc_msgSend_stret(frame, this.view, Cocoa.S_frame);
                NSPoint pt = new NSPoint();
                Cocoa.objc_msgSend_stret(pt, arg0, Cocoa.S_locationInWindow);
                this.highlight = Cocoa.NSPointInRect(pt, frame);
                Cocoa.objc_msgSend(this.view, Cocoa.S_setNeedsDisplay, 1);
                if (!this.shouldShowMenu(arg0)) break;
                this.displayMenu();
            }
        }
        return 0;
    }
}

