/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class BookmarkFilter
extends MarkerFilter {
    private static final String TAG_CONTAINS = "contains";
    private static final String TAG_DESCRIPTION = "description";
    static final boolean DEFAULT_CONTAINS = true;
    static final String DEFAULT_DESCRIPTION = "";
    private boolean contains;
    private String description;

    public BookmarkFilter() {
        this(MarkerMessages.MarkerFilter_defaultFilterName);
    }

    public BookmarkFilter(String filterName) {
        super(filterName, new String[]{"org.eclipse.core.resources.bookmark"});
    }

    public boolean selectMarker(ConcreteMarker marker) {
        return !this.isEnabled() || super.selectMarker(marker) && this.selectByDescription(marker);
    }

    private boolean selectByDescription(ConcreteMarker marker) {
        if (this.description == null || this.description.equals(DEFAULT_DESCRIPTION)) {
            return true;
        }
        String markerDescription = marker.getDescription();
        int index = markerDescription.indexOf(this.description);
        return this.contains ? index >= 0 : index < 0;
    }

    boolean getContains() {
        return this.contains;
    }

    String getDescription() {
        return this.description;
    }

    void setContains(boolean contains) {
        this.contains = contains;
    }

    void setDescription(String description) {
        this.description = description;
    }

    void resetState() {
        super.resetState();
        this.contains = true;
        this.description = DEFAULT_DESCRIPTION;
    }

    public void restoreFilterSettings(IDialogSettings settings) {
        super.restoreFilterSettings(settings);
        String setting = settings.get(TAG_CONTAINS);
        if (setting != null) {
            this.contains = Boolean.valueOf(setting);
        }
        if ((setting = settings.get(TAG_DESCRIPTION)) != null) {
            this.description = new String(setting);
        }
    }

    protected void restoreFilterSettings(IMemento memento) {
        super.restoreFilterSettings(memento);
        String setting = memento.getString(TAG_CONTAINS);
        if (setting != null) {
            this.contains = Boolean.valueOf(setting);
        }
        if ((setting = memento.getString(TAG_DESCRIPTION)) != null) {
            this.description = new String(setting);
        }
    }

    public void saveFilterSettings(IMemento memento) {
        super.saveFilterSettings(memento);
        memento.putString(TAG_CONTAINS, String.valueOf(this.contains));
        memento.putString(TAG_DESCRIPTION, this.description);
    }
}

