/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.expressions.AndExpression;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;
import org.eclipse.ui.internal.handlers.E4HandlerProxy;
import org.eclipse.ui.internal.handlers.HandlerActivation;
import org.eclipse.ui.internal.handlers.HandlerProxy;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.ISourceProviderService;

public class LegacyHandlerService
implements IHandlerService {
    private static final String[] SELECTION_VARIABLES = new String[]{"selection", "activeFocusControlId", "activeFocusControl", "activeMenuEditorInput", "activeMenu", "activeMenuSelection"};
    public static final String LEGACY_H_ID = "legacy::handler::";
    private IEclipseContext eclipseContext;
    private IEvaluationContext evalContext;
    private Expression defaultExpression = null;

    public static IHandlerActivation registerLegacyHandler(IEclipseContext context, String id, String cmdId, IHandler handler, Expression activeWhen) {
        ECommandService cs = (ECommandService)context.get(ECommandService.class.getName());
        Command command = cs.getCommand(cmdId);
        E4HandlerProxy handlerProxy = new E4HandlerProxy(command, handler);
        HandlerActivation activation = new HandlerActivation(context, cmdId, handler, handlerProxy, activeWhen);
        LegacyHandlerService.addHandlerActivation(activation);
        EHandlerService hs = (EHandlerService)context.get(EHandlerService.class);
        hs.activateHandler(cmdId, (Object)new HandlerSelectionFunction(cmdId));
        return activation;
    }

    static void addHandlerActivation(HandlerActivation eActivation) {
        ArrayList<HandlerActivation> handlerActivations = (ArrayList<HandlerActivation>)eActivation.context.getLocal(LEGACY_H_ID + eActivation.getCommandId());
        handlerActivations = handlerActivations == null ? new ArrayList<HandlerActivation>() : new ArrayList(handlerActivations);
        handlerActivations.add(eActivation);
        eActivation.context.set(LEGACY_H_ID + eActivation.getCommandId(), handlerActivations);
    }

    static void removeHandlerActivation(HandlerActivation eActivation) {
        ArrayList handlerActivations = (ArrayList)eActivation.context.getLocal(LEGACY_H_ID + eActivation.getCommandId());
        handlerActivations = handlerActivations == null ? new ArrayList() : new ArrayList(handlerActivations);
        handlerActivations.remove(eActivation);
        eActivation.context.set(LEGACY_H_ID + eActivation.getCommandId(), handlerActivations);
    }

    public LegacyHandlerService(IEclipseContext context) {
        this.eclipseContext = context;
        this.evalContext = new ExpressionContext(this.eclipseContext);
        IWorkbenchWindow window = (IWorkbenchWindow)this.eclipseContext.get(IWorkbenchWindow.class.getName());
        if (window != null) {
            this.defaultExpression = new WorkbenchWindowExpression(window);
        }
    }

    public void addSourceProvider(ISourceProvider provider) {
    }

    public void removeSourceProvider(ISourceProvider provider) {
    }

    public void dispose() {
        E4Util.message("LegacyHandlerService.dispose: should it do something?");
    }

    public IHandlerActivation activateHandler(IHandlerActivation activation) {
        HandlerActivation handlerActivation = (HandlerActivation)activation;
        handlerActivation.participating = true;
        LegacyHandlerService.addHandlerActivation(handlerActivation);
        return activation;
    }

    public IHandlerActivation activateHandler(String commandId, IHandler handler) {
        return this.activateHandler(commandId, handler, this.defaultExpression, false);
    }

    public IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression) {
        return this.activateHandler(commandId, handler, expression, false);
    }

    public IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression, boolean global) {
        if (global || this.defaultExpression == null) {
            return LegacyHandlerService.registerLegacyHandler(this.eclipseContext, commandId, commandId, handler, expression);
        }
        AndExpression andExpr = new AndExpression();
        andExpr.add(expression);
        andExpr.add(this.defaultExpression);
        return LegacyHandlerService.registerLegacyHandler(this.eclipseContext, commandId, commandId, handler, andExpr);
    }

    public IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression, int sourcePriorities) {
        return this.activateHandler(commandId, handler, expression, false);
    }

    public ExecutionEvent createExecutionEvent(Command command, Event event) {
        ExpressionContext legacy = new ExpressionContext(this.eclipseContext);
        ExecutionEvent e = new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)event, (Object)legacy);
        return e;
    }

    public ExecutionEvent createExecutionEvent(ParameterizedCommand command, Event event) {
        ExpressionContext legacy = new ExpressionContext(this.eclipseContext);
        ExecutionEvent e = new ExecutionEvent(command.getCommand(), command.getParameterMap(), (Object)event, (Object)legacy);
        return e;
    }

    public void deactivateHandler(IHandlerActivation activation) {
        if (activation != null) {
            HandlerActivation eActivation = (HandlerActivation)activation;
            eActivation.participating = false;
            LegacyHandlerService.removeHandlerActivation(eActivation);
        }
    }

    public void deactivateHandlers(Collection activations) {
        Object[] array = activations.toArray();
        int i = 0;
        while (i < array.length) {
            ((HandlerActivation)array[i]).participating = false;
            ++i;
        }
        i = 0;
        while (i < array.length) {
            this.deactivateHandler((IHandlerActivation)array[i]);
            ++i;
        }
    }

    public Object executeCommand(String commandId, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        ECommandService cs = (ECommandService)this.eclipseContext.get(ECommandService.class);
        Command command = cs.getCommand(commandId);
        return this.executeCommand(ParameterizedCommand.generateCommand((Command)command, null), event);
    }

    public Object executeCommand(ParameterizedCommand command, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        EHandlerService hs = (EHandlerService)this.eclipseContext.get(EHandlerService.class);
        IEclipseContext staticContext = EclipseContextFactory.create();
        if (event != null) {
            staticContext.set(Event.class, (Object)event);
        }
        try {
            Object object = hs.executeHandler(command, staticContext);
            return object;
        }
        finally {
            staticContext.dispose();
        }
    }

    public Object executeCommandInContext(ParameterizedCommand command, Event event, IEvaluationContext context) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        IEclipseContext staticContext = null;
        boolean disposeContext = false;
        if (context instanceof ExpressionContext) {
            staticContext = ((ExpressionContext)context).eclipseContext.createChild();
        } else {
            staticContext = EclipseContextFactory.create();
            disposeContext = true;
            if (event != null) {
                staticContext.set(Event.class, (Object)event);
            }
            staticContext.set(IEvaluationContext.class, (Object)context);
        }
        EHandlerService hs = (EHandlerService)this.eclipseContext.get(EHandlerService.class);
        try {
            Object object = hs.executeHandler(command, staticContext);
            return object;
        }
        finally {
            if (disposeContext) {
                staticContext.dispose();
            }
        }
    }

    public IEvaluationContext createContextSnapshot(boolean includeSelection) {
        int n;
        IEclipseContext targetContext = this.eclipseContext.getActiveLeaf();
        IEvaluationContext tmpContext = this.getCurrentState();
        ExpressionContext context = new ExpressionContext(targetContext.createChild());
        if (includeSelection) {
            String[] stringArray = SELECTION_VARIABLES;
            n = SELECTION_VARIABLES.length;
            int n2 = 0;
            while (n2 < n) {
                String variable = stringArray[n2];
                this.copyVariable((IEvaluationContext)context, tmpContext, variable);
                ++n2;
            }
        }
        ISourceProviderService sp = (ISourceProviderService)this.eclipseContext.get(ISourceProviderService.class);
        ISourceProvider[] iSourceProviderArray = sp.getSourceProviders();
        int n3 = iSourceProviderArray.length;
        n = 0;
        while (n < n3) {
            String[] names;
            ISourceProvider provider = iSourceProviderArray[n];
            String[] stringArray = names = provider.getProvidedSourceNames();
            int n4 = names.length;
            int n5 = 0;
            while (n5 < n4) {
                String name = stringArray[n5];
                if (!this.isSelectionVariable(name)) {
                    this.copyVariable((IEvaluationContext)context, tmpContext, name);
                }
                ++n5;
            }
            ++n;
        }
        return context;
    }

    private boolean isSelectionVariable(String name) {
        String[] stringArray = SELECTION_VARIABLES;
        int n = SELECTION_VARIABLES.length;
        int n2 = 0;
        while (n2 < n) {
            String variable = stringArray[n2];
            if (variable.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void copyVariable(IEvaluationContext context, IEvaluationContext tmpContext, String var) {
        Object o = tmpContext.getVariable(var);
        if (o != null) {
            context.addVariable(var, o);
        }
    }

    public IEvaluationContext getCurrentState() {
        return this.evalContext;
    }

    public void readRegistry() {
        this.readDefaultHandlers();
        this.readHandlers();
    }

    /*
     * Unable to fully structure code
     */
    private void readHandlers() {
        registry = (IExtensionRegistry)this.eclipseContext.get(IExtensionRegistry.class.getName());
        extPoint = registry.getExtensionPoint("org.eclipse.ui.handlers");
        var7_4 = elements = extPoint.getConfigurationElements();
        var6_5 = elements.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block7: {
                block8: {
                    block9: {
                        configElement = var7_4[var5_6];
                        commandId = configElement.getAttribute("commandId");
                        if (commandId == null || commandId.length() == 0 || (defaultHandler = configElement.getAttribute("class")) == null && configElement.getChildren("class").length == 0) break block7;
                        activeWhen = null;
                        awChildren = configElement.getChildren("activeWhen");
                        if (awChildren.length <= 0) break block8;
                        subChildren = awChildren[0].getChildren();
                        if (subChildren.length == 1) break block9;
                        Activator.trace((String)"/trace/commands", (String)("Incorrect activeWhen element " + commandId), null);
                        break block7;
                    }
                    elementHandler = ElementHandler.getDefault();
                    converter = ExpressionConverter.getDefault();
                    try {
                        activeWhen = elementHandler.create(converter, subChildren[0]);
                    }
                    catch (CoreException e) {
                        Activator.trace((String)"/trace/commands", (String)("Incorrect activeWhen element " + commandId), (Throwable)e);
                    }
                }
                enabledWhen = null;
                ewChildren = configElement.getChildren("enabledWhen");
                if (ewChildren.length <= 0) ** GOTO lbl40
                subChildren = ewChildren[0].getChildren();
                if (subChildren.length != 1) {
                    Activator.trace((String)"/trace/commands", (String)("Incorrect enableWhen element " + commandId), null);
                } else {
                    elementHandler = ElementHandler.getDefault();
                    converter = ExpressionConverter.getDefault();
                    try {
                        enabledWhen = elementHandler.create(converter, subChildren[0]);
                    }
                    catch (CoreException e) {
                        Activator.trace((String)"/trace/commands", (String)("Incorrect enableWhen element " + commandId), (Throwable)e);
                    }
lbl40:
                    // 3 sources

                    LegacyHandlerService.registerLegacyHandler(this.eclipseContext, commandId, commandId, (IHandler)new HandlerProxy(commandId, configElement, "class", enabledWhen, (IEvaluationService)this.eclipseContext.get(IEvaluationService.class)), activeWhen);
                }
            }
            ++var5_6;
        }
    }

    private void readDefaultHandlers() {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = (IExtensionRegistry)this.eclipseContext.get(IExtensionRegistry.class.getName());
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.ui.commands");
        IConfigurationElement[] iConfigurationElementArray = elements = extPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultHandler;
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String id = configElement.getAttribute("id");
            if (id != null && id.length() != 0 && ((defaultHandler = configElement.getAttribute("defaultHandler")) != null || configElement.getChildren("defaultHandler").length != 0)) {
                LegacyHandlerService.registerLegacyHandler(this.eclipseContext, id, id, (IHandler)new HandlerProxy(id, configElement, "defaultHandler"), null);
            }
            ++n2;
        }
    }

    public void setHelpContextId(IHandler handler, String helpContextId) {
    }

    static class HandlerSelectionFunction
    extends ContextFunction {
        private final String commandId;

        public HandlerSelectionFunction(String commandId) {
            this.commandId = commandId;
        }

        public Object compute(IEclipseContext context) {
            HashSet activationSet = new HashSet();
            IEclipseContext current = context;
            while (current != null) {
                List handlerActivations = (List)current.getLocal(LegacyHandlerService.LEGACY_H_ID + this.commandId);
                if (handlerActivations != null) {
                    activationSet.addAll(handlerActivations);
                }
                current = current.getParent();
            }
            if (activationSet.isEmpty()) {
                return null;
            }
            HandlerActivation bestActivation = null;
            ExpressionContext legacyEvalContext = new ExpressionContext(context);
            for (HandlerActivation handlerActivation : activationSet) {
                if (!handlerActivation.participating || !handlerActivation.evaluate((IEvaluationContext)legacyEvalContext)) continue;
                if (bestActivation == null) {
                    bestActivation = handlerActivation;
                    continue;
                }
                int comparison = bestActivation.compareTo(handlerActivation);
                if (comparison >= 0) continue;
                bestActivation = handlerActivation;
            }
            if (bestActivation != null) {
                return bestActivation.proxy;
            }
            IEclipseContext parent = context.getParent();
            if (parent == null) {
                return null;
            }
            return parent.get("handler::" + this.commandId);
        }
    }
}

