/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

public class DoublyLinkedList {
    private Node head = null;
    private int size = 0;

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized void empty() {
        while (this.size > 0) {
            this.pop();
        }
    }

    public Node getHead() {
        return this.head;
    }

    public Node getTail() {
        return this.head.getPrev();
    }

    public void touch(Node node) {
        if (node == null) {
            return;
        }
        node.insertBefore(this.head);
        this.head = node;
    }

    public void add(int n, Node node) {
        if (node == null) {
            return;
        }
        if (n == 0) {
            node.insertBefore(this.head);
            this.head = node;
        } else if (n == this.size) {
            node.insertBefore(this.head);
        } else {
            Node node2 = this.head;
            while (n != 0) {
                node2 = node2.getNext();
                --n;
            }
            node.insertBefore(node2);
        }
        ++this.size;
    }

    public void add(Node node) {
        if (node == null) {
            return;
        }
        node.insertBefore(this.head);
        this.head = node;
        ++this.size;
    }

    public void remove(Node node) {
        if (node == null) {
            return;
        }
        if (node == this.head) {
            this.head = this.head.getNext() == this.head ? null : this.head.getNext();
        }
        node.unlink();
        --this.size;
    }

    public Node pop() {
        if (this.head == null) {
            return null;
        }
        Node node = this.head;
        this.remove(node);
        return node;
    }

    public Node unpush() {
        if (this.head == null) {
            return null;
        }
        Node node = this.getTail();
        this.remove(node);
        return node;
    }

    public void push(Node node) {
        node.insertBefore(this.head);
        if (this.head == null) {
            this.head = node;
        }
        ++this.size;
    }

    public void unpop(Node node) {
        node.insertBefore(this.head);
        this.head = node;
        ++this.size;
    }

    public static class Node {
        private Node next = null;
        private Node prev = null;

        public final Node getNext() {
            return this.next;
        }

        public final Node getPrev() {
            return this.prev;
        }

        protected final void setNext(Node node) {
            this.next = node;
        }

        protected final void setPrev(Node node) {
            this.prev = node;
        }

        protected final void unlink() {
            if (this.getNext() != null) {
                this.getNext().setPrev(this.getPrev());
            }
            if (this.getPrev() != null) {
                this.getPrev().setNext(this.getNext());
            }
            this.setNext(null);
            this.setPrev(null);
        }

        protected final void insertBefore(Node node) {
            if (this == node) {
                return;
            }
            if (this.getPrev() != null) {
                this.unlink();
            }
            if (node == null) {
                this.setNext(this);
                this.setPrev(this);
            } else {
                this.setNext(node);
                this.setPrev(node.getPrev());
                node.setPrev(this);
                if (this.getPrev() != null) {
                    this.getPrev().setNext(this);
                }
            }
        }
    }
}

