/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.server.bespin;

import java.math.BigDecimal;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JSONUtil {
    private static final String EMPTY_STRING = "";
    private static final String NULL = "null";

    public static Object read(String jsonString) {
        return JSONUtil.parse(new StringCharacterIterator(jsonString));
    }

    public static String write(Object jsonObject) {
        StringBuffer buffer = new StringBuffer();
        JSONUtil.writeValue(jsonObject, buffer);
        return buffer.toString();
    }

    private static RuntimeException error(String message, CharacterIterator it) {
        return new IllegalStateException("[" + it.getIndex() + "] " + message);
    }

    private static RuntimeException error(String message) {
        return new IllegalStateException(message);
    }

    private static Object parse(CharacterIterator it) {
        JSONUtil.parseWhitespace(it);
        Object result = JSONUtil.parseValue(it);
        JSONUtil.parseWhitespace(it);
        if (it.current() != '\uffff') {
            throw JSONUtil.error("should be done", it);
        }
        return result;
    }

    private static void parseWhitespace(CharacterIterator it) {
        char c = it.current();
        while (Character.isWhitespace(c)) {
            c = it.next();
        }
    }

    private static Object parseValue(CharacterIterator it) {
        switch (it.current()) {
            case '{': {
                return JSONUtil.parseObject(it);
            }
            case '[': {
                return JSONUtil.parseArray(it);
            }
            case '\"': {
                return JSONUtil.parseString(it);
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return JSONUtil.parseNumber(it);
            }
            case 't': {
                JSONUtil.parseText(Boolean.TRUE.toString(), it);
                return Boolean.TRUE;
            }
            case 'f': {
                JSONUtil.parseText(Boolean.FALSE.toString(), it);
                return Boolean.FALSE;
            }
            case 'n': {
                JSONUtil.parseText(NULL, it);
                return null;
            }
        }
        throw JSONUtil.error("Bad JSON starting character '" + it.current() + "'", it);
    }

    private static Map parseObject(CharacterIterator it) {
        it.next();
        JSONUtil.parseWhitespace(it);
        if (it.current() == '}') {
            it.next();
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (true) {
            if (it.current() != '\"') {
                throw JSONUtil.error("expected a string start '\"' but was '" + it.current() + "'", it);
            }
            String key = JSONUtil.parseString(it);
            if (map.containsKey(key)) {
                throw JSONUtil.error("' already definedkey '" + key, it);
            }
            JSONUtil.parseWhitespace(it);
            if (it.current() != ':') {
                throw JSONUtil.error("expected a pair separator ':' but was '" + it.current() + "'", it);
            }
            it.next();
            JSONUtil.parseWhitespace(it);
            Object value = JSONUtil.parseValue(it);
            map.put(key, value);
            JSONUtil.parseWhitespace(it);
            if (it.current() != ',') break;
            it.next();
            JSONUtil.parseWhitespace(it);
        }
        if (it.current() != '}') {
            throw JSONUtil.error("expected an object close '}' but was '" + it.current() + "'", it);
        }
        it.next();
        return map;
    }

    private static List parseArray(CharacterIterator it) {
        it.next();
        JSONUtil.parseWhitespace(it);
        if (it.current() == ']') {
            it.next();
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        while (true) {
            Object value = JSONUtil.parseValue(it);
            list.add(value);
            JSONUtil.parseWhitespace(it);
            if (it.current() != ',') break;
            it.next();
            JSONUtil.parseWhitespace(it);
        }
        if (it.current() != ']') {
            throw JSONUtil.error("expected an array close ']' but was '" + it.current() + "'", it);
        }
        it.next();
        return list;
    }

    private static void parseText(String string, CharacterIterator it) {
        int length = string.length();
        char c = it.current();
        int i = 0;
        while (i < length) {
            if (c != string.charAt(i)) {
                throw JSONUtil.error("expected to parse '" + string + "' but character " + (i + 1) + " was '" + c + "'", it);
            }
            c = it.next();
            ++i;
        }
    }

    private static Object parseNumber(CharacterIterator it) {
        StringBuffer buffer = new StringBuffer();
        char c = it.current();
        while (Character.isDigit(c) || c == '-' || c == '+' || c == '.' || c == 'e' || c == 'E') {
            buffer.append(c);
            c = it.next();
        }
        try {
            return new BigDecimal(buffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw JSONUtil.error("expected a number but was '" + buffer.toString() + "'", it);
        }
    }

    private static String parseString(CharacterIterator it) {
        char c = it.next();
        if (c == '\"') {
            it.next();
            return EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer();
        while (c != '\"') {
            block15: {
                block16: {
                    if (Character.isISOControl(c)) {
                        throw JSONUtil.error("illegal iso control character: '" + Integer.toHexString(c) + "'", it);
                    }
                    if (c != '\\') break block16;
                    c = it.next();
                    switch (c) {
                        case '\"': 
                        case '/': 
                        case '\\': {
                            buffer.append(c);
                            break block15;
                        }
                        case 'b': {
                            buffer.append('\b');
                            break block15;
                        }
                        case 'f': {
                            buffer.append('\f');
                            break block15;
                        }
                        case 'n': {
                            buffer.append('\n');
                            break block15;
                        }
                        case 'r': {
                            buffer.append('\r');
                            break block15;
                        }
                        case 't': {
                            buffer.append('\t');
                            break block15;
                        }
                        case 'u': {
                            StringBuffer unicode = new StringBuffer(4);
                            int i = 0;
                            while (i < 4) {
                                unicode.append(it.next());
                                ++i;
                            }
                            try {
                                buffer.append((char)Integer.parseInt(unicode.toString(), 16));
                                break block15;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw JSONUtil.error("expected a unicode hex number but was '" + unicode.toString() + "'", it);
                            }
                        }
                        default: {
                            throw JSONUtil.error("illegal escape character '" + c + "'", it);
                        }
                    }
                }
                buffer.append(c);
            }
            c = it.next();
        }
        c = it.next();
        return buffer.toString();
    }

    private static void writeValue(Object value, StringBuffer buffer) {
        if (value == null) {
            buffer.append(NULL);
        } else if (value instanceof Boolean || value instanceof Number) {
            buffer.append(value.toString());
        } else if (value instanceof String) {
            JSONUtil.writeString((String)value, buffer);
        } else if (value instanceof Collection) {
            JSONUtil.writeArray((Collection)value, buffer);
        } else if (value instanceof Map) {
            JSONUtil.writeObject((Map)value, buffer);
        } else {
            throw JSONUtil.error("Unexpected object instance type was '" + value.getClass().getName() + "'");
        }
    }

    private static void writeObject(Map map, StringBuffer buffer) {
        buffer.append('{');
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            if (!(key instanceof String)) {
                throw JSONUtil.error("Map keys must be an instance of String but was '" + key.getClass().getName() + "'");
            }
            JSONUtil.writeString((String)key, buffer);
            buffer.append(':');
            JSONUtil.writeValue(map.get(key), buffer);
            buffer.append(',');
        }
        if (buffer.charAt(buffer.length() - 1) == ',') {
            buffer.setCharAt(buffer.length() - 1, '}');
        } else {
            buffer.append('}');
        }
    }

    private static void writeArray(Collection collection, StringBuffer buffer) {
        buffer.append('[');
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JSONUtil.writeValue(iterator.next(), buffer);
            buffer.append(',');
        }
        if (buffer.charAt(buffer.length() - 1) == ',') {
            buffer.setCharAt(buffer.length() - 1, ']');
        } else {
            buffer.append(']');
        }
    }

    private static void writeString(String string, StringBuffer buffer) {
        buffer.append('\"');
        int length = string.length();
        int i = 0;
        while (i < length) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    buffer.append('\\');
                    buffer.append(c);
                    break;
                }
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        buffer.append("\\u");
                        String hexString = Integer.toHexString(c);
                        int j = hexString.length();
                        while (j < 4) {
                            buffer.append('0');
                            ++j;
                        }
                        buffer.append(hexString);
                        break;
                    }
                    buffer.append(c);
                }
            }
            ++i;
        }
        buffer.append('\"');
    }
}

