/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MTrimContribution;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.TrimmedPartLayout;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimBarRenderer
extends SWTPartRenderer {
    private MApplication application;
    private LayoutJob layoutJob = null;
    private HashMap<MTrimBar, ArrayList<ArrayList<MTrimElement>>> pendingCleanup = new HashMap();
    static final String TRIM_BAR_MANAGER_RENDERER_DRAG_HANDLE = "TrimBarRenderer.dragHandle";

    private synchronized void layoutTrim(MTrimBar trimBar) {
        Composite comp = (Composite)trimBar.getWidget();
        if (comp == null || comp.isDisposed()) {
            return;
        }
        if (this.layoutJob == null) {
            this.layoutJob = new LayoutJob();
            this.layoutJob.barsToLayout.add(trimBar);
            comp.getDisplay().asyncExec((Runnable)this.layoutJob);
        } else if (!this.layoutJob.barsToLayout.contains(trimBar)) {
            this.layoutJob.barsToLayout.add(trimBar);
        }
    }

    @Override
    public void init(IEclipseContext context) {
        super.init(context);
        this.application = (MApplication)context.get(MApplication.class);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MTrimBar) || !(parent instanceof Composite)) {
            return null;
        }
        Composite parentComp = (Composite)parent;
        if (!(parentComp.getLayout() instanceof TrimmedPartLayout)) {
            return null;
        }
        final MTrimBar trimModel = (MTrimBar)element;
        TrimmedPartLayout tpl = (TrimmedPartLayout)parentComp.getLayout();
        Composite result = null;
        switch (trimModel.getSide().getValue()) {
            case 0: {
                result = tpl.getTrimComposite(parentComp, 128);
                break;
            }
            case 1: {
                result = tpl.getTrimComposite(parentComp, 1024);
                break;
            }
            case 2: {
                result = tpl.getTrimComposite(parentComp, 16384);
                break;
            }
            case 3: {
                result = tpl.getTrimComposite(parentComp, 131072);
                break;
            }
            default: {
                return null;
            }
        }
        this.processContents(trimModel);
        result.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TrimBarRenderer.this.cleanUp(trimModel);
            }
        });
        return result;
    }

    private void processContents(MTrimBar trimModel) {
        IEclipseContext ctx = this.getContext((MUIElement)trimModel);
        ExpressionContext eContext = new ExpressionContext(ctx);
        ArrayList<MTrimContribution> toContribute = new ArrayList<MTrimContribution>();
        ContributionsAnalyzer.gatherTrimContributions((MTrimBar)trimModel, (List)this.application.getTrimContributions(), (String)trimModel.getElementId(), toContribute, (ExpressionContext)eContext);
        this.addTrimContributions(trimModel, toContribute, ctx, eContext);
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        MElementContainer<MUIElement> downCast = parentElement;
        this.layoutTrim((MTrimBar)downCast);
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        MElementContainer<MUIElement> downCast = parentElement;
        this.layoutTrim((MTrimBar)downCast);
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        if (!(container instanceof MTrimBar)) {
            return;
        }
        List parts = container.getChildren();
        Composite parent = (Composite)container.getWidget();
        if (parts != null) {
            IPresentationEngine renderer = (IPresentationEngine)this.context.get(IPresentationEngine.class.getName());
            MUIElement[] plist = parts.toArray(new MUIElement[parts.size()]);
            int i = 0;
            while (i < plist.length) {
                MUIElement childME = plist[i];
                final Composite intermediate = this.createIntermediate(childME, parent);
                Object newObj = renderer.createGui(childME, (Object)intermediate, null);
                if (newObj == null) {
                    intermediate.dispose();
                } else {
                    ((Widget)newObj).addListener(12, new Listener(){

                        public void handleEvent(Event event) {
                            intermediate.dispose();
                        }
                    });
                }
                ++i;
            }
        }
    }

    private Composite createIntermediate(MUIElement toolbarModel, Composite parent) {
        Composite intermediate = new Composite(parent, 0);
        intermediate.setData("modelElement", (Object)toolbarModel);
        int orientation = this.getOrientation(toolbarModel);
        RowLayout layout = RowLayoutFactory.fillDefaults().wrap(false).spacing(0).type(orientation).create();
        layout.marginLeft = 3;
        layout.center = true;
        intermediate.setLayout((Layout)layout);
        ToolBar separatorToolBar = new ToolBar(intermediate, orientation | 0x40 | 0x800000 | 0x20000);
        separatorToolBar.setData((Object)TRIM_BAR_MANAGER_RENDERER_DRAG_HANDLE);
        new ToolItem(separatorToolBar, 2);
        return intermediate;
    }

    private int getOrientation(MUIElement element) {
        MTrimBar trimContainer;
        SideValue side;
        MElementContainer theParent = element.getParent();
        if (theParent instanceof MTrimBar && ((side = (trimContainer = (MTrimBar)theParent).getSide()).getValue() == 2 || side.getValue() == 3)) {
            return 512;
        }
        return 256;
    }

    private void addTrimContributions(final MTrimBar trimModel, ArrayList<MTrimContribution> toContribute, IEclipseContext ctx, final ExpressionContext eContext) {
        HashSet<String> existingToolbarIds = new HashSet<String>();
        for (MTrimElement item : trimModel.getChildren()) {
            String id = item.getElementId();
            if (!(item instanceof MToolBar) || id == null) continue;
            existingToolbarIds.add(id);
        }
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MTrimContribution> curList = new ArrayList<MTrimContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (final MTrimContribution contribution : curList) {
                ArrayList<ArrayList<Object>> lists;
                ArrayList toRemove;
                if (!ContributionsAnalyzer.processAddition((MTrimBar)trimModel, (MTrimContribution)contribution, toRemove = new ArrayList(), existingToolbarIds)) {
                    toContribute.add(contribution);
                    continue;
                }
                if (contribution.getVisibleWhen() != null) {
                    ctx.runAndTrack(new RunAndTrack(){

                        public boolean changed(IEclipseContext context) {
                            if (!trimModel.isToBeRendered() || !trimModel.isVisible() || trimModel.getWidget() == null) {
                                return false;
                            }
                            boolean rc = ContributionsAnalyzer.isVisible((MTrimContribution)contribution, (ExpressionContext)eContext);
                            for (MTrimElement child : toRemove) {
                                child.setToBeRendered(rc);
                            }
                            TrimBarRenderer.this.layoutTrim(trimModel);
                            return true;
                        }
                    });
                }
                if ((lists = this.pendingCleanup.get(trimModel)) == null) {
                    lists = new ArrayList();
                    this.pendingCleanup.put(trimModel, lists);
                }
                lists.add(toRemove);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    protected void cleanUp(MTrimBar element) {
        ArrayList<ArrayList<MTrimElement>> lists = this.pendingCleanup.remove(element);
        if (lists == null) {
            return;
        }
        for (ArrayList<MTrimElement> list : lists) {
            for (MTrimElement child : list) {
                element.getChildren().remove(child);
            }
        }
    }

    private class LayoutJob
    implements Runnable {
        public List<MTrimBar> barsToLayout = new ArrayList<MTrimBar>();

        private LayoutJob() {
        }

        public void run() {
            TrimBarRenderer.this.layoutJob = null;
            if (this.barsToLayout.size() == 0) {
                return;
            }
            for (MTrimBar bar : this.barsToLayout) {
                Composite trimCtrl = (Composite)bar.getWidget();
                if (trimCtrl == null || trimCtrl.isDisposed()) continue;
                trimCtrl.layout();
            }
        }
    }
}

