/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples;

import java.net.URI;
import java.util.List;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.resources.semantic.provider.DefaultContentProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.semantic.examples.providers.RemoteStoreContentProvider;
import org.eclipse.core.resources.semantic.examples.providers.SampleCompositeResourceContentProvider;
import org.eclipse.core.resources.semantic.examples.providers.SampleWSDLXSDContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class ExamplesContribution
extends AbstractContributionFactory {
    static ImageDescriptor ADDIMAGE = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD");
    static final ImageDescriptor CREATEIMAGE;

    static {
        if (ADDIMAGE == null) {
            ADDIMAGE = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY");
        }
        CREATEIMAGE = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD");
    }

    public ExamplesContribution() {
        super("popup:org.eclipse.ui.popup.any?after=additions", null);
    }

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        this.contributeRemoteStoreActions(serviceLocator, additions);
        this.contributeAddRestResource(serviceLocator, additions);
        this.contributeWebServiceAddFile(serviceLocator, additions);
        this.contributeAddFileActions(serviceLocator, additions);
    }

    private void contributeWebServiceAddFile(IServiceLocator serviceLocator, IContributionRoot additions) {
        CommandContributionItemParameter param = new CommandContributionItemParameter(serviceLocator, "org.eclipse.core.resources.semantic.examples_addWSDLResource", "org.eclipse.core.resources.semantic.examples_addWSDLResource", 8);
        param.icon = ADDIMAGE;
        CommandContributionItem citem = new CommandContributionItem(param);
        MyExpression myExp = new MyExpression(SampleWSDLXSDContentProvider.class.getName(), 2);
        additions.addContributionItem((IContributionItem)citem, (Expression)myExp);
    }

    private void contributeRemoteStoreActions(IServiceLocator serviceLocator, IContributionRoot additions) {
        CommandContributionItemParameter param = new CommandContributionItemParameter(serviceLocator, "org.eclipse.core.resources.semantic.examples_addFromRemote", "org.eclipse.core.resources.semantic.examples_addFromRemote", 8);
        param.icon = ADDIMAGE;
        CommandContributionItem citem = new CommandContributionItem(param);
        MyExpression myExp = new MyExpression(RemoteStoreContentProvider.class.getName(), 2);
        additions.addContributionItem((IContributionItem)citem, (Expression)myExp);
        param = new CommandContributionItemParameter(serviceLocator, "org.eclipse.core.resources.semantic.examples_createRemote", "org.eclipse.core.resources.semantic.examples_createRemote", 8);
        param.icon = CREATEIMAGE;
        citem = new CommandContributionItem(param);
        myExp = new MyExpression(RemoteStoreContentProvider.class.getName(), 2);
        additions.addContributionItem((IContributionItem)citem, (Expression)myExp);
    }

    private void contributeAddRestResource(IServiceLocator serviceLocator, IContributionRoot additions) {
        CommandContributionItemParameter param = new CommandContributionItemParameter(serviceLocator, "org.eclipse.core.resources.semantic.examples_addRESTResource", "org.eclipse.core.resources.semantic.examples_addRESTResource", 8);
        param.icon = ADDIMAGE;
        CommandContributionItem citem = new CommandContributionItem(param);
        MyExpression myExp = new MyExpression(DefaultContentProvider.class.getName(), 2);
        additions.addContributionItem((IContributionItem)citem, (Expression)myExp);
    }

    private void contributeAddFileActions(IServiceLocator serviceLocator, IContributionRoot additions) {
        CommandContributionItemParameter param = new CommandContributionItemParameter(serviceLocator, "org.eclipse.core.resources.semantic.examples_addFileFromRemote", "org.eclipse.core.resources.semantic.examples_addFileFromRemote", 8);
        param.icon = ADDIMAGE;
        CommandContributionItem citem = new CommandContributionItem(param);
        MyExpression myExp = new MyExpression(DefaultContentProvider.class.getName(), 2);
        myExp.addProviderClass(SampleCompositeResourceContentProvider.class.getName());
        myExp.addProviderClass(SampleWSDLXSDContentProvider.class.getName());
        additions.addContributionItem((IContributionItem)citem, (Expression)myExp);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MyExpression
    extends Expression {
        private final int[] types;
        private String[] providerClasses;

        MyExpression(String providerClass, int ... types) {
            this.types = types;
            this.providerClasses = new String[]{providerClass};
        }

        void addProviderClass(String classString) {
            String[] oldArray = this.providerClasses;
            this.providerClasses = new String[oldArray.length + 1];
            System.arraycopy(oldArray, 0, this.providerClasses, 0, oldArray.length);
            this.providerClasses[this.providerClasses.length - 1] = classString;
        }

        public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
            IResource res;
            Object var = context.getDefaultVariable();
            IResource selected = (IResource)this.getSelectedObject(context, IResource.class, false);
            if (selected != null && (res = (IResource)((List)var).get(0)).getProject().hasNature("org.eclipse.core.resources.semantic.examples.nature")) {
                ISemanticFileStore store = (ISemanticFileStore)EFS.getStore((URI)res.getLocationURI());
                boolean typeFound = false;
                int[] nArray = this.types;
                int n = this.types.length;
                int n2 = 0;
                while (n2 < n) {
                    int type = nArray[n2];
                    if (type == store.getType()) {
                        typeFound = true;
                    }
                    ++n2;
                }
                if (!typeFound) {
                    return EvaluationResult.FALSE;
                }
                boolean classFound = false;
                String providerClass = store.getEffectiveContentProvider().getClass().getName();
                String[] stringArray = this.providerClasses;
                int n3 = this.providerClasses.length;
                int n4 = 0;
                while (n4 < n3) {
                    String classString = stringArray[n4];
                    if (classString.equals(providerClass)) {
                        classFound = true;
                    }
                    ++n4;
                }
                if (classFound) {
                    return EvaluationResult.TRUE;
                }
            }
            return EvaluationResult.FALSE;
        }

        private <T> T getSelectedObject(IEvaluationContext ctx, Class T, boolean adapt) {
            Object selection = ctx.getVariable("selection");
            if (!(selection instanceof IStructuredSelection)) {
                return null;
            }
            IStructuredSelection ssel = (IStructuredSelection)selection;
            if (ssel.size() != 1) {
                return null;
            }
            if (!(ssel.getFirstElement() instanceof IResource)) {
                return null;
            }
            IResource r = (IResource)ssel.getFirstElement();
            if (adapt) {
                Object adapted = r.getAdapter(T);
                try {
                    return (T)adapted;
                }
                catch (ClassCastException classCastException) {
                    return null;
                }
            }
            try {
                return (T)r;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
    }
}

