/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.tm.ui.editor.IPostProcessor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.e4.tm.ui";
    private static Activator plugin;
    private List<IPostProcessor> postProcessors = null;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private void processPostProcessModelExtensionPoint() {
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(this.getBundle().getSymbolicName(), "postProcessor");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = extensions[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ces = iConfigurationElementArray[n2];
                String name = ces.getName();
                if ("postProcessor".equals(name)) {
                    this.processPostProcessModelElement(ces);
                }
                ++n2;
            }
            ++i;
        }
    }

    private void processPostProcessModelElement(IConfigurationElement ces) {
        try {
            IPostProcessor postModelProcessor = (IPostProcessor)ces.createExecutableExtension("postProcessorClass");
            this.postProcessors.add(postModelProcessor);
        }
        catch (CoreException coreException) {
            System.err.println("Couldn't create a IPostProcessModel for " + ces.getAttribute("postProcessorClass"));
        }
    }

    public IPostProcessor[] getPostProcessors() {
        if (this.postProcessors == null) {
            this.postProcessors = new ArrayList<IPostProcessor>();
            this.processPostProcessModelExtensionPoint();
        }
        return this.postProcessors.toArray(new IPostProcessor[this.postProcessors.size()]);
    }
}

